/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.io;

import java.io.File;
import java.io.IOException;
import org.ujac.util.io.FileUtils;
import org.ujac.util.io.ResourceLoader;

public class FileResourceLoader
implements ResourceLoader {
    public static final int IO_BUFFER_SIZE = 2048;
    private File rootDirectory = null;

    public FileResourceLoader(String rootPath) throws IOException {
        this(new File(rootPath));
    }

    public FileResourceLoader(File rootDirectory) throws IOException {
        if (rootDirectory == null) {
            throw new IOException("The root directory mustn't be null.");
        }
        if (!rootDirectory.exists()) {
            throw new IOException("The root directory '" + rootDirectory.getCanonicalPath() + "' doesn't exist.");
        }
        if (!rootDirectory.isDirectory()) {
            throw new IOException("The root directory '" + rootDirectory.getCanonicalPath() + "' is no directory.");
        }
        this.rootDirectory = rootDirectory;
    }

    public byte[] loadResource(String location) throws IOException {
        if (location == null || location.length() == 0) {
            throw new IOException("The given resource location must not be null and non empty.");
        }
        String absolutePath = null;
        absolutePath = location.charAt(0) == '/' ? this.rootDirectory.getCanonicalPath() + location : this.rootDirectory.getCanonicalPath() + "/" + location;
        return FileUtils.loadFile(new File(absolutePath));
    }

    public boolean resourceExists(String location) {
        if (location == null || location.length() == 0) {
            return false;
        }
        String absolutePath = null;
        try {
            absolutePath = location.charAt(0) == '/' ? this.rootDirectory.getCanonicalPath() + location : this.rootDirectory.getCanonicalPath() + "/" + location;
        }
        catch (IOException ex) {
            return false;
        }
        return new File(absolutePath).exists();
    }
}

