/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class FileUtils {
    public static final int IO_BUFFER_SIZE = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] loadFile(File file) throws IOException {
        if (file == null) {
            throw new IOException("The given file must not be null.");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(fis, 2048);
            byte[] buffer = new byte[2048];
            int numRead = is.read(buffer, 0, 2048);
            while (numRead > 0) {
                bos.write(buffer, 0, numRead);
                numRead = is.read(buffer, 0, 2048);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int copyFile(File src, File dst) throws IOException {
        if (src == null) {
            throw new IOException("The given source file must not be null.");
        }
        if (dst == null) {
            throw new IOException("The given destination file must not be null.");
        }
        FileOutputStream os = new FileOutputStream(dst);
        try {
            int n = FileUtils.copyToStream(src, os);
            return n;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int copyToStream(File src, OutputStream os) throws IOException {
        if (src == null) {
            throw new IOException("The given source file must not be null.");
        }
        if (os == null) {
            throw new IOException("The given output stream must not be null.");
        }
        int numCopied = 0;
        FileInputStream is = new FileInputStream(src);
        try {
            byte[] buffer = new byte[2048];
            int numRead = is.read(buffer, 0, 2048);
            while (numRead != -1) {
                os.write(buffer, 0, numRead);
                numCopied += numRead;
                numRead = is.read(buffer, 0, 2048);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return numCopied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int copyFromBytes(byte[] bytes, File dest) throws IOException {
        if (dest == null) {
            throw new IOException("The given destination file must not be null.");
        }
        if (bytes == null) {
            throw new IOException("The given byte array must not be null.");
        }
        int numCopied = 0;
        FileOutputStream os = new FileOutputStream(dest);
        try {
            ((OutputStream)os).write(bytes, 0, bytes.length);
            numCopied = bytes.length;
        }
        finally {
            ((OutputStream)os).close();
        }
        return numCopied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int copyFromStream(InputStream is, File dest) throws IOException {
        if (dest == null) {
            throw new IOException("The given destination file must not be null.");
        }
        if (is == null) {
            throw new IOException("The given input stream must not be null.");
        }
        int numCopied = 0;
        FileOutputStream os = new FileOutputStream(dest);
        try {
            byte[] buffer = new byte[2048];
            int numRead = is.read(buffer, 0, 2048);
            while (numRead != -1) {
                ((OutputStream)os).write(buffer, 0, numRead);
                numCopied += numRead;
                numRead = is.read(buffer, 0, 2048);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            ((OutputStream)os).close();
        }
        return numCopied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int copyStreamToStream(InputStream is, OutputStream os, boolean closeOs) throws IOException {
        if (os == null) {
            throw new IOException("The given destination stream must not be null.");
        }
        if (is == null) {
            throw new IOException("The given input stream must not be null.");
        }
        int numCopied = 0;
        try {
            byte[] buffer = new byte[2048];
            int numRead = is.read(buffer, 0, 2048);
            while (numRead != -1) {
                os.write(buffer, 0, numRead);
                numCopied += numRead;
                numRead = is.read(buffer, 0, 2048);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (closeOs) {
                os.close();
            }
        }
        return numCopied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int copyFromReader(Reader reader, File dest) throws IOException {
        if (dest == null) {
            throw new IOException("The given destination file must not be null.");
        }
        if (reader == null) {
            throw new IOException("The given reader must not be null.");
        }
        int numCopied = 0;
        FileWriter out = new FileWriter(dest);
        try {
            char[] buffer = new char[2048];
            int numRead = reader.read(buffer, 0, 2048);
            while (numRead != -1) {
                ((Writer)out).write(buffer, 0, numRead);
                numCopied += numRead;
                numRead = reader.read(buffer, 0, 2048);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            ((Writer)out).close();
        }
        return numCopied;
    }
}

