/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ujac.util.table.DataTable;

public class DataTableIterator
implements Iterator {
    private DataTable table;
    private int currentRow = -1;

    protected DataTableIterator(DataTable table) {
        this.table = table;
    }

    public boolean hasNext() {
        int tableSize = this.table.getRowCount();
        return this.currentRow < tableSize - 1;
    }

    public Object next() {
        try {
            return this.table.getRow(++this.currentRow);
        }
        catch (Exception ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }

    public void remove() {
        if (this.currentRow < 0) {
            throw new IllegalStateException("The the next method has not yet been called.");
        }
        try {
            this.table.removeRow(this.currentRow);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }
}

