/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.table.Row;
import org.ujac.util.table.RowFilterRule;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;

public class ExpressionRowFilterRule
implements RowFilterRule {
    private ExpressionInterpreter exi = null;
    private String expression = null;
    private ExpressionTuple expressionTuple = null;
    private ExpressionContext ctx = null;

    public ExpressionRowFilterRule(ExpressionInterpreter exi, String expression) {
        this.exi = exi;
        this.expression = expression;
    }

    public void setup(Table table) throws TableException {
        try {
            this.expressionTuple = this.exi.parseExpr(this.expression);
            this.ctx = new ExpressionContext();
        }
        catch (ExpressionException ex) {
            throw new TableException("Failed to parse filter rule '" + this.expression + "': " + ex.getMessage(), ex);
        }
    }

    public boolean test(Row row) throws TableException {
        this.ctx.setProperty("row", row);
        Object result = null;
        try {
            result = this.exi.evalExpr(this.expressionTuple, this.ctx);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new TableException("Expression '" + this.expression + "' didn't evaluate to a boolean, was '" + result + "'.");
        }
        catch (ExpressionException ex) {
            throw new TableException("Failed to evaluate filter rule '" + this.expression + "': " + ex.getMessage(), ex);
        }
    }
}

