/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import org.ujac.util.db.DataTypeMapper;
import org.ujac.util.db.DefaultDataTypeMapper;
import org.ujac.util.table.Column;
import org.ujac.util.table.DataTable;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Row;
import org.ujac.util.table.TableException;

public class ResultSetReader {
    public static final DataTable readTable(ResultSet rs) throws SQLException, TableException {
        return ResultSetReader.readTable(rs, new DefaultDataTypeMapper());
    }

    public static final DataTable readTable(ResultSet rs, DataTypeMapper dataTypeMapper) throws SQLException, TableException {
        DataTable table = new DataTable();
        ResultSetMetaData meta = rs.getMetaData();
        int numColumns = meta.getColumnCount();
        int[] columnTypes = new int[numColumns];
        int columnType = 0;
        String columnName = null;
        for (int i = 1; i <= numColumns; ++i) {
            columnName = meta.getColumnName(i);
            int javaType = dataTypeMapper.getJavaType(meta.getColumnType(i), meta.getScale(i), meta.getPrecision(i));
            int alignment = 0;
            switch (javaType) {
                case 11: {
                    columnType = 11;
                    break;
                }
                case 2: {
                    columnType = 2;
                    alignment = 2;
                    break;
                }
                case 4: {
                    columnType = 4;
                    alignment = 2;
                    break;
                }
                case 5: {
                    columnType = 5;
                    alignment = 2;
                    break;
                }
                case 6: {
                    columnType = 6;
                    alignment = 2;
                    break;
                }
                case 7: {
                    columnType = 7;
                    break;
                }
                case 1: {
                    columnType = 1;
                    break;
                }
                case 8: {
                    columnType = 8;
                    break;
                }
                case 9: {
                    columnType = 9;
                    break;
                }
                case 10: {
                    columnType = 10;
                    break;
                }
                default: {
                    throw new TableException("Unsupported SQL type '" + meta.getColumnTypeName(i) + "' at column '" + columnName + "'.");
                }
            }
            columnTypes[i - 1] = columnType;
            Column col = table.addColumn(columnName, columnType);
            col.setLayoutHints(new LayoutHints(10.0f, meta.getColumnName(i), alignment, true));
        }
        while (rs.next()) {
            Row row = table.addRow();
            block25: for (int i = 0; i < numColumns; ++i) {
                switch (columnTypes[i]) {
                    case 7: {
                        row.setBoolean(i, rs.getBoolean(i + 1));
                        continue block25;
                    }
                    case 2: {
                        row.setInt(i, rs.getInt(i + 1));
                        continue block25;
                    }
                    case 4: {
                        row.setLong(i, rs.getLong(i + 1));
                        continue block25;
                    }
                    case 5: {
                        row.setFloat(i, rs.getFloat(i + 1));
                        continue block25;
                    }
                    case 6: {
                        row.setDouble(i, rs.getDouble(i + 1));
                        continue block25;
                    }
                    case 1: {
                        row.setString(i, rs.getString(i + 1));
                        continue block25;
                    }
                    case 8: {
                        row.setDate(i, (Date)rs.getDate(i + 1));
                        continue block25;
                    }
                    case 9: {
                        row.setTime(i, (Date)rs.getTime(i + 1));
                        continue block25;
                    }
                    case 10: {
                        row.setTimestamp(i, (Date)rs.getTimestamp(i + 1));
                        continue block25;
                    }
                    default: {
                        row.setObject(i, rs.getObject(i + 1));
                    }
                }
            }
        }
        return table;
    }
}

