/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.util.ArrayList;
import java.util.List;
import org.ujac.util.table.Row;
import org.ujac.util.table.RowFilterRule;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;

public class RowFilterRuleSet
implements RowFilterRule {
    public static final Integer AND = new Integer(1);
    public static final Integer OR = new Integer(2);
    private List rules = new ArrayList();

    public RowFilterRuleSet(RowFilterRule firstRule) {
        this.rules.add(firstRule);
    }

    public RowFilterRuleSet add(Integer connector, RowFilterRule rule) {
        this.rules.add(connector);
        this.rules.add(rule);
        return this;
    }

    public void setup(Table table) throws TableException {
        int numRules = this.rules.size();
        for (int i = 0; i < numRules; ++i) {
            RowFilterRule nextRule = (RowFilterRule)this.rules.get(i);
            nextRule.setup(table);
            ++i;
        }
    }

    public boolean test(Row row) throws TableException {
        int numRules = this.rules.size();
        boolean result = ((RowFilterRule)this.rules.get(0)).test(row);
        for (int i = 1; i < numRules; ++i) {
            Integer connector = (Integer)this.rules.get(i++);
            RowFilterRule nextRule = (RowFilterRule)this.rules.get(i);
            if (AND.equals(connector)) {
                result = result && nextRule.test(row);
                continue;
            }
            if (!OR.equals(connector)) continue;
            result = result || nextRule.test(row);
        }
        return result;
    }
}

