/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import org.ujac.util.table.FunctionExecutor;
import org.ujac.util.table.TypeMismatchException;

public class SumFunctionExecutor
implements FunctionExecutor {
    static final long serialVersionUID = -6914557080802474766L;

    public double execute(double currentValue, Object operand) throws TypeMismatchException {
        double val = currentValue;
        if (Double.isNaN(val)) {
            val = 0.0;
        }
        if (operand == null) {
            return val;
        }
        if (operand instanceof Number) {
            double operandVal = ((Number)operand).doubleValue();
            if (Double.isNaN(operandVal)) {
                return val;
            }
            return val += operandVal;
        }
        throw new TypeMismatchException("The SumFunctionExecutor can get only applied to numeric values.");
    }

    public boolean integersGuaranteed() {
        return false;
    }
}

