/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import org.ujac.util.UjacTypeHelper;
import org.ujac.util.table.TableException;

public class TableHelper {
    public static final int getColumnTypeId(String columnTypeName) throws TableException {
        int typeId = UjacTypeHelper.getTypeId(columnTypeName);
        if (typeId == -1) {
            throw new TableException("Invalid column type '" + columnTypeName + "'.");
        }
        return typeId;
    }

    public static final String getColumnTypeName(int columnTypeId) throws TableException {
        String typeName = UjacTypeHelper.getTypeName(columnTypeId);
        if (typeName == null) {
            throw new TableException("Invalid column type ID " + columnTypeId + ".");
        }
        return typeName;
    }

    public static final int getAlignmentId(String align) {
        if (align == null) {
            return 0;
        }
        String alignLower = align.toLowerCase();
        if ("left".equals(alignLower)) {
            return 0;
        }
        if ("right".equals(alignLower)) {
            return 2;
        }
        if ("center".equals(alignLower)) {
            return 1;
        }
        return 0;
    }

    public static final String getAlignmentName(int align) {
        switch (align) {
            case 0: {
                return "left";
            }
            case 2: {
                return "right";
            }
            case 1: {
                return "center";
            }
        }
        return "left";
    }
}

