/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.Writer;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.Operand;
import org.ujac.util.template.AssertionException;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.StatementException;
import org.ujac.util.template.StaticToken;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;

public class AssertToken
extends TemplateToken {
    private static final long serialVersionUID = 3257562897587450673L;
    private Operand assertionCheck = null;

    public String getTokenName() {
        return "assert";
    }

    public void initialize(BaseTemplateInterpreter interpreter, char[] source, int position, int length) throws TemplateException {
        super.initialize(interpreter, source, position, length);
        int endPos = this.parseArguments();
        this.setLength(endPos - position);
    }

    public int parseArguments() throws StatementException {
        String tokenName = this.getTokenName();
        if (tokenName == null) {
            return this.position;
        }
        int curPos = this.position + tokenName.length() + 2;
        int endPos = this.position + this.getLength();
        char[] source = this.source;
        boolean inside = false;
        int argStart = -1;
        block6: for (int i = curPos; i <= endPos; ++i) {
            char c = source[i];
            switch (c) {
                case '(': {
                    inside = true;
                    continue block6;
                }
                case ')': {
                    if (inside) {
                        if (argStart != -1) {
                            StringBuffer eb = new StringBuffer("${").append(source, argStart, i - argStart).append("}");
                            try {
                                ExpressionTuple et = this.interpreter.parseExpr(eb.toString());
                                this.setArgument(et, 0);
                                argStart = -1;
                            }
                            catch (ExpressionException ex) {
                                throw new StatementException("Syntax error at position " + i + ": invalid condition statement.", ex);
                            }
                        }
                        return i;
                    }
                    throw new StatementException("Syntax error at position " + i + ": unbalanced parethesis.");
                }
                default: {
                    if (Character.isWhitespace(c) || argStart >= 0) continue block6;
                    argStart = i;
                }
            }
        }
        throw new StatementException("Syntax error at position " + endPos + ": unbalanced parethesis.");
    }

    public void setArgument(Operand argument, int idx) throws StatementException {
        switch (idx) {
            case 0: {
                this.assertionCheck = argument;
                break;
            }
            default: {
                throw new StatementException("The assert statement may take one argument only.");
            }
        }
    }

    public void execute(Writer writer, TemplateContext ctx) throws ExpressionException {
        if (!this.interpreter.evalBooleanExpr(this.assertionCheck, ctx)) {
            throw new AssertionException("Assertion failed: " + this.assertionCheck + "!");
        }
    }

    public String toString() {
        return this.getIndention() + "_assert_(" + this.getArgumentsAsString() + ")\n";
    }

    protected TemplateToken cloneToken(BaseTemplateInterpreter interpreter, TemplateTokenContainer parent) {
        StaticToken clone = (StaticToken)this.clone();
        clone.interpreter = interpreter;
        clone.parent = parent;
        return clone;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone template token: " + ex.getMessage(), ex);
        }
    }
}

