/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.Writer;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.Operand;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.StatementException;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;

public class DefineToken
extends TemplateToken {
    private static final long serialVersionUID = 3256441421497250873L;
    private String propertyName = null;
    private Operand value = null;
    private boolean global = false;

    public String getTokenName() {
        return "define";
    }

    public void initialize(BaseTemplateInterpreter interpreter, char[] source, int position, int length) throws TemplateException {
        super.initialize(interpreter, source, position, length);
        int endPos = this.parseArguments();
        this.setLength(endPos - position);
    }

    public void setArgument(Operand argument, int idx) throws StatementException {
        switch (idx) {
            case 0: {
                this.propertyName = argument.getValue().toString();
                break;
            }
            case 1: {
                this.value = argument;
                break;
            }
            case 2: {
                this.global = "global".equals(argument.getValue());
                break;
            }
            default: {
                throw new StatementException("The log statement may take maximum three argument only.");
            }
        }
    }

    public void execute(Writer writer, TemplateContext ctx) throws ExpressionException {
        if (this.global) {
            ctx.setGlobalProperty(this.propertyName, this.interpreter.evalObjectExpr(this.value, ctx));
        } else {
            ctx.setProperty(this.propertyName, this.interpreter.evalObjectExpr(this.value, ctx));
        }
    }

    public String toString() {
        return this.getIndention() + "_define_(" + this.getArgumentsAsString() + ")\n";
    }

    protected TemplateToken cloneToken(BaseTemplateInterpreter interpreter, TemplateTokenContainer parent) {
        DefineToken clone = (DefineToken)this.clone();
        clone.interpreter = interpreter;
        clone.parent = parent;
        clone.value = (Operand)this.value.clone();
        return clone;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone template token: " + ex.getMessage(), ex);
        }
    }
}

