/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.IOException;
import java.io.Writer;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.Operand;
import org.ujac.util.template.BaseConditionToken;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;
import org.ujac.util.template.TokenAncestor;

public class IfToken
extends BaseConditionToken {
    private static final long serialVersionUID = 4050482317929690416L;
    public static final TokenAncestor[] ancestorRules = new TokenAncestor[]{new TokenAncestor("elseif", true, true), new TokenAncestor("else", true), new TokenAncestor("endif")};
    private ExpressionTuple condition = null;
    private boolean resolved = false;

    public String getTokenName() {
        return "if";
    }

    public TokenAncestor[] getAncestorRules() {
        return ancestorRules;
    }

    public void initialize(BaseTemplateInterpreter interpreter, char[] source, int position, int length) throws TemplateException {
        super.initialize(interpreter, source, position, length);
        this.setBodyStart(this.parseArguments() + 1);
    }

    public void setArgument(Operand argument, int idx) {
        this.condition = (ExpressionTuple)argument;
    }

    public void execute(Writer writer, TemplateContext ctx) throws TemplateException, IOException {
        this.resolved = false;
        super.execute(writer, ctx);
    }

    public boolean isTrue(TemplateContext ctx) throws ExpressionException {
        boolean cond = this.interpreter.evalBooleanExpr(this.condition, ctx);
        this.setResolved(cond);
        return cond;
    }

    public String toString() {
        return this.getIndention() + "_if_(" + this.getArgumentsAsString() + ")\n" + super.toString();
    }

    protected String getArgumentsAsString() {
        return this.condition.toString();
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public BaseConditionToken getRootCondition() {
        return this;
    }

    protected TemplateToken cloneToken(BaseTemplateInterpreter interpreter, TemplateTokenContainer parent) {
        IfToken clone = null;
        try {
            clone = (IfToken)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone template token: " + ex.getMessage(), ex);
        }
        clone.interpreter = interpreter;
        clone.parent = parent;
        clone.condition = (ExpressionTuple)this.condition.clone();
        clone.resolved = false;
        clone.cloneChildTokens(this.procedureRegistry, this);
        return clone;
    }
}

