/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ujac.util.CollectionUtils;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.text.FormatHelper;

public class TemplateContext
extends ExpressionContext {
    private static final long serialVersionUID = 3257285816496567609L;
    private Map globalProperties = null;

    public TemplateContext(Map properties) {
        super(properties);
        this.globalProperties = new HashMap();
    }

    public TemplateContext(Map properties, FormatHelper formatHelper) {
        super(properties, formatHelper);
        this.globalProperties = new HashMap();
    }

    public TemplateContext(Map properties, Object bean, FormatHelper formatHelper) {
        super(properties, bean, formatHelper);
        this.globalProperties = new HashMap();
    }

    public TemplateContext(TemplateContext ctx) {
        super(ctx);
        this.globalProperties = ctx.globalProperties;
    }

    public Object getProperty(Object name) {
        Object value = this.globalProperties.get(name);
        if (value != null) {
            return value;
        }
        return super.getProperty(name);
    }

    public Object setProperty(Object name, Object value) {
        if (this.globalProperties.containsKey(name)) {
            return this.globalProperties.put(name, value);
        }
        return super.setProperty(name, value);
    }

    public void setGlobalProperty(Object name, Object value) {
        this.globalProperties.put(name, value);
    }

    public int size() {
        return super.size() + CollectionUtils.getSize(this.globalProperties);
    }

    public boolean isEmpty() {
        return super.isEmpty() && CollectionUtils.isEmpty(this.globalProperties);
    }

    public boolean containsKey(Object key) {
        return super.containsKey(key) || CollectionUtils.containsKey(this.globalProperties, key);
    }

    public boolean containsValue(Object value) {
        return super.containsValue(value) || CollectionUtils.containsValue(this.globalProperties, value);
    }

    public Object get(Object key) {
        return this.getProperty(key);
    }

    public Object put(Object key, Object value) {
        return this.setProperty(key, value);
    }

    public Object remove(Object key) {
        Object removed = this.globalProperties.remove(key);
        if (removed != null) {
            return removed;
        }
        return super.remove(key);
    }

    public void clear() {
        super.clear();
        CollectionUtils.clear(this.globalProperties);
    }

    public Set keySet() {
        if (this.globalProperties == null) {
            return super.keySet();
        }
        HashSet keySet = new HashSet(super.keySet());
        keySet.addAll(this.globalProperties.keySet());
        return keySet;
    }

    public Collection values() {
        if (this.globalProperties == null) {
            return super.values();
        }
        ArrayList values = new ArrayList(super.values());
        values.addAll(this.globalProperties.values());
        return values;
    }

    public Set entrySet() {
        if (this.globalProperties == null) {
            return super.entrySet();
        }
        HashSet entrySet = new HashSet(super.entrySet());
        entrySet.addAll(this.globalProperties.entrySet());
        return entrySet;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        super.writeData(s);
        s.writeObject(this.globalProperties);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        super.readData(s);
        this.globalProperties = (Map)s.readObject();
    }
}

