/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.ujac.util.text.SmartDecimalFormat;

public class FormatHelper
implements Serializable {
    private static final long serialVersionUID = 4050204120063750192L;
    public static final String ATTRIBUTE_NAME = "org.ujac.format.helper";
    public static final String ISO_DATE_PATTERN = "yyyy-MM-dd";
    public static final String ISO_TIME_PATTERN = "HH:mm:ss";
    public static final String ISO_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static FormatHelper prototype = null;
    protected Locale locale = null;
    protected DateFormat dateFormat = null;
    protected DateFormat timeFormat = null;
    protected DateFormat timestampFormat = null;
    protected NumberFormat integerFormat = null;
    protected NumberFormat doubleFormat = null;
    private Map formatMap = new HashMap();

    public static FormatHelper createInstance() {
        return FormatHelper.createInstance(Locale.getDefault());
    }

    public static FormatHelper createIsoInstance() {
        FormatHelper fh = FormatHelper.createInstance(Locale.US);
        fh.setDateFormat(ISO_DATE_PATTERN);
        fh.setTimeFormat(ISO_TIME_PATTERN);
        fh.setTimestampFormat(ISO_TIMESTAMP_PATTERN);
        fh.setIntegerFormat("");
        fh.setDoubleFormat("");
        return fh;
    }

    public static FormatHelper createInstance(Locale locale) {
        if (prototype == null) {
            String clazzName = System.getProperty(ATTRIBUTE_NAME);
            if (clazzName != null) {
                try {
                    FormatHelper fh = (FormatHelper)Class.forName(clazzName).newInstance();
                    if (locale.equals(Locale.getDefault())) {
                        return fh;
                    }
                    return fh.getInstance(locale);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException("Unable to create FormatHelper instance from class '" + clazzName + "': " + ex.getMessage());
                }
                catch (InstantiationException ex) {
                    throw new RuntimeException("Unable to create FormatHelper instance from class '" + clazzName + "': " + ex.getMessage());
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Unable to create FormatHelper instance from class '" + clazzName + "': " + ex.getMessage());
                }
                catch (ClassCastException ex) {
                    throw new RuntimeException("Unable to create FormatHelper instance from class '" + clazzName + "': " + ex.getMessage());
                }
            }
            return new FormatHelper(locale);
        }
        return prototype.getInstance(locale);
    }

    public static void setPrototype(FormatHelper prototype) {
        FormatHelper.prototype = prototype;
    }

    public FormatHelper() {
        this.locale = Locale.getDefault();
    }

    public FormatHelper(Locale locale) {
        this.locale = locale;
    }

    public FormatHelper getInstance(Locale locale) {
        return new FormatHelper(locale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public NumberFormat getIntegerFormat() {
        if (this.integerFormat == null) {
            this.integerFormat = this.getDefaultIntegerFormat(this.locale);
        }
        return this.integerFormat;
    }

    public void setIntegerFormat(NumberFormat integerFormat) {
        this.integerFormat = integerFormat;
    }

    public NumberFormat setIntegerFormat(String formatPattern) {
        NumberFormat format = (NumberFormat)this.lookupFormat(formatPattern);
        if (format == null) {
            format = this.createNumberFormat(formatPattern);
            this.registerFormat(formatPattern, format);
        }
        this.integerFormat = format;
        return this.integerFormat;
    }

    public NumberFormat getDoubleFormat() {
        if (this.doubleFormat == null) {
            this.doubleFormat = this.getDefaultDoubleFormat(this.locale);
        }
        return this.doubleFormat;
    }

    public void setDoubleFormat(NumberFormat doubleFormat) {
        this.doubleFormat = doubleFormat;
    }

    public NumberFormat setDoubleFormat(String formatPattern) {
        NumberFormat format = (NumberFormat)this.lookupFormat(formatPattern);
        if (format == null) {
            format = this.createNumberFormat(formatPattern);
            this.registerFormat(formatPattern, format);
        }
        this.doubleFormat = format;
        return this.doubleFormat;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = this.getDefaultDateFormat(this.locale);
        }
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DateFormat setDateFormat(String formatPattern) {
        DateFormat format = (DateFormat)this.lookupFormat(formatPattern);
        if (format == null) {
            format = this.createDateFormat(formatPattern);
            this.registerFormat(formatPattern, format);
        }
        this.dateFormat = format;
        return this.dateFormat;
    }

    public DateFormat getTimeFormat() {
        if (this.timeFormat == null) {
            this.timeFormat = this.getDefaultTimeFormat(this.locale);
        }
        return this.timeFormat;
    }

    public void setTimeFormat(DateFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    public DateFormat setTimeFormat(String formatPattern) {
        DateFormat format = (DateFormat)this.lookupFormat(formatPattern);
        if (format == null) {
            format = this.createDateFormat(formatPattern);
            this.registerFormat(formatPattern, format);
        }
        this.timeFormat = format;
        return this.timeFormat;
    }

    public DateFormat getTimestampFormat() {
        if (this.timestampFormat == null) {
            this.timestampFormat = this.getDefaultTimestampFormat(this.locale);
        }
        return this.timestampFormat;
    }

    public void setTimestampFormat(DateFormat timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public DateFormat setTimestampFormat(String formatPattern) {
        DateFormat format = (DateFormat)this.lookupFormat(formatPattern);
        if (format == null) {
            format = this.createDateFormat(formatPattern);
            this.registerFormat(formatPattern, format);
        }
        this.timestampFormat = format;
        return this.timestampFormat;
    }

    public NumberFormat createNumberFormat(String formatPattern) {
        SmartDecimalFormat format = new SmartDecimalFormat(formatPattern, new DecimalFormatSymbols(this.locale));
        this.registerFormat(formatPattern, format);
        return format;
    }

    public DateFormat createDateFormat(String formatPattern) {
        SimpleDateFormat format = new SimpleDateFormat(formatPattern, this.locale);
        this.registerFormat(formatPattern, format);
        return format;
    }

    public NumberFormat getDefaultIntegerFormat(Locale locale) {
        return new SmartDecimalFormat("###,###", new DecimalFormatSymbols(locale));
    }

    public NumberFormat getDefaultDoubleFormat(Locale locale) {
        return new SmartDecimalFormat("###,##0.00", new DecimalFormatSymbols(locale));
    }

    public DateFormat getDefaultDateFormat(Locale locale) {
        return DateFormat.getDateInstance(2, locale);
    }

    public DateFormat getDefaultTimeFormat(Locale locale) {
        return DateFormat.getTimeInstance(2, locale);
    }

    public DateFormat getDefaultTimestampFormat(Locale locale) {
        return DateFormat.getDateTimeInstance(2, 2, locale);
    }

    public DateFormat getIsoDateFormat() {
        DateFormat format = (DateFormat)this.lookupFormat(ISO_DATE_PATTERN);
        if (format == null) {
            format = this.createDateFormat(ISO_DATE_PATTERN);
            this.registerFormat(ISO_DATE_PATTERN, format);
        }
        return format;
    }

    public DateFormat getIsoTimeFormat() {
        DateFormat format = (DateFormat)this.lookupFormat(ISO_TIME_PATTERN);
        if (format == null) {
            format = this.createDateFormat(ISO_TIME_PATTERN);
            this.registerFormat(ISO_TIME_PATTERN, format);
        }
        return format;
    }

    public DateFormat getIsoTimestampFormat() {
        DateFormat format = (DateFormat)this.lookupFormat(ISO_TIMESTAMP_PATTERN);
        if (format == null) {
            format = this.createDateFormat(ISO_TIMESTAMP_PATTERN);
            this.registerFormat(ISO_TIMESTAMP_PATTERN, format);
        }
        return format;
    }

    public void registerFormat(String formatString, Format formatInstance) {
        this.formatMap.put(formatString, formatInstance);
    }

    public Format lookupFormat(String formatString) {
        return (Format)this.formatMap.get(formatString);
    }

    public int parseInt(String text) throws ParseException {
        NumberFormat nf = this.getIntegerFormat();
        return nf.parse(text).intValue();
    }

    public String formatInt(int value) {
        NumberFormat nf = this.getIntegerFormat();
        return nf.format(value);
    }

    public long parseLong(String text) throws ParseException {
        NumberFormat nf = this.getIntegerFormat();
        return nf.parse(text).longValue();
    }

    public String formatLong(long value) {
        NumberFormat nf = this.getIntegerFormat();
        return nf.format(value);
    }

    public short parseShort(String text) throws ParseException {
        NumberFormat nf = this.getIntegerFormat();
        return nf.parse(text).shortValue();
    }

    public String formatShort(short value) {
        NumberFormat nf = this.getIntegerFormat();
        return nf.format(value);
    }

    public long parseDouble(String text) throws ParseException {
        NumberFormat nf = this.getDoubleFormat();
        return nf.parse(text).longValue();
    }

    public String formatDouble(double value) {
        NumberFormat nf = this.getDoubleFormat();
        return nf.format(value);
    }

    public long parseFloat(String text) throws ParseException {
        NumberFormat nf = this.getDoubleFormat();
        return nf.parse(text).longValue();
    }

    public String formatFloat(float value) {
        NumberFormat nf = this.getDoubleFormat();
        return nf.format(value);
    }

    public Date parseDate(String text) throws ParseException {
        DateFormat df = this.getDateFormat();
        return df.parse(text);
    }

    public String formatDate(Date date) {
        DateFormat df = this.getDateFormat();
        return df.format(date);
    }

    public Time parseTime(String text) throws ParseException {
        DateFormat df = this.getTimeFormat();
        return new Time(df.parse(text).getTime());
    }

    public String formatTime(Date date) {
        DateFormat df = this.getTimeFormat();
        return df.format(date);
    }

    public Timestamp parseTimestamp(String text) throws ParseException {
        DateFormat df = this.getTimestampFormat();
        return new Timestamp(df.parse(text).getTime());
    }

    public String formatTimestamp(Date date) {
        DateFormat df = this.getTimestampFormat();
        return df.format(date);
    }

    public Object clone() {
        FormatHelper clone = null;
        try {
            clone = (FormatHelper)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone Operand instance: " + ex.getMessage(), ex);
        }
        clone.formatMap = new HashMap();
        return clone;
    }

    protected void writeData(ObjectOutputStream s) throws IOException {
        s.writeObject(this.locale);
        s.writeObject(this.dateFormat);
        s.writeObject(this.timeFormat);
        s.writeObject(this.timestampFormat);
        s.writeObject(this.integerFormat);
        s.writeObject(this.doubleFormat);
        s.writeObject(this.formatMap);
    }

    protected void readData(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.locale = (Locale)s.readObject();
        this.dateFormat = (DateFormat)s.readObject();
        this.timeFormat = (DateFormat)s.readObject();
        this.timestampFormat = (DateFormat)s.readObject();
        this.integerFormat = (NumberFormat)s.readObject();
        this.doubleFormat = (NumberFormat)s.readObject();
        this.formatMap = (Map)s.readObject();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeData(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.readData(s);
    }
}

