/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.text;

import java.util.StringTokenizer;
import org.ujac.util.BeanUtils;
import org.ujac.util.text.PatternMatcher;

public class SimplePatternMatcher
implements PatternMatcher {
    public static final int MODE_EXACT = 0;
    public static final int MODE_ENDS_WITH = 1;
    public static final int MODE_STARTS_WITH = 2;
    public static final int MODE_INBETWEEN = 3;
    private PatternDefinition[] patterns = null;

    public SimplePatternMatcher(String pattern) {
        StringTokenizer tkn = new StringTokenizer(pattern, "|");
        int numPatterns = tkn.countTokens();
        this.patterns = new PatternDefinition[numPatterns];
        for (int i = 0; i < numPatterns; ++i) {
            String t = tkn.nextToken();
            if (BeanUtils.isEmpty(t)) {
                this.patterns[i] = new PatternDefinition(3, null);
                continue;
            }
            if (t.startsWith("*")) {
                if (t.endsWith("*")) {
                    if (t.length() > 1) {
                        this.patterns[i] = new PatternDefinition(3, t.substring(1, t.length() - 1));
                        continue;
                    }
                    this.patterns[i] = new PatternDefinition(3, null);
                    continue;
                }
                this.patterns[i] = new PatternDefinition(1, t.substring(1));
                continue;
            }
            this.patterns[i] = t.endsWith("*") ? new PatternDefinition(2, t.substring(0, t.length() - 1)) : new PatternDefinition(0, t);
        }
    }

    public boolean matches(String text) {
        if (text == null || this.patterns == null) {
            return false;
        }
        block6: for (int i = 0; i < this.patterns.length; ++i) {
            PatternDefinition pd = this.patterns[i];
            String pattern = pd.getPattern();
            switch (pd.getMatchMode()) {
                case 0: {
                    if (!text.equals(pattern)) continue block6;
                    return true;
                }
                case 1: {
                    if (!text.endsWith(pattern)) continue block6;
                    return true;
                }
                case 2: {
                    if (!text.startsWith(pattern)) continue block6;
                    return true;
                }
                case 3: {
                    if (pattern == null) {
                        return true;
                    }
                    if (text.indexOf(pattern) == -1) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    public class PatternDefinition {
        private int matchMode = 0;
        private String pattern = null;

        public PatternDefinition(int matchMode, String pattern) {
            this.matchMode = matchMode;
            this.pattern = pattern;
        }

        public int getMatchMode() {
            return this.matchMode;
        }

        public void setMatchMode(int matchMode) {
            this.matchMode = matchMode;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

