/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.types;

import org.ujac.util.BeanUtils;
import org.ujac.util.TypeConverterException;
import org.ujac.util.text.FormatHelper;
import org.ujac.util.types.DataType;

public class IntegerType
implements DataType {
    public int getTypeId() {
        return 2;
    }

    public Object convertObject(Object value, FormatHelper formatHelper) throws TypeConverterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Number) {
            return new Integer(((Number)value).intValue());
        }
        String strVal = value.toString();
        try {
            int val = Integer.parseInt(strVal);
            return new Integer(val);
        }
        catch (NumberFormatException ex) {
            throw new TypeConverterException("Failed to parse int value out of given value '" + strVal + "'.", ex);
        }
    }

    public String formatValue(Object value, FormatHelper formatHelper) throws TypeConverterException {
        return BeanUtils.toString(this.convertObject(value, formatHelper));
    }
}

