/*
 * Decompiled with CFR 0.152.
 */
package er.jquery.widgets;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.appserver.ERXResponseRewriter;
import er.extensions.appserver.ERXWOContext;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUploader
extends WOComponent {
    private static Logger log = Logger.getLogger(FileUploader.class);
    private static boolean useUnobtrusively = ERXProperties.booleanForKeyWithDefault((String)"er.jquery.useUnobtrusively", (boolean)true);
    private RuntimeException exception;

    public FileUploader(WOContext aContext) {
        super(aContext);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public String id() {
        return this._id() == null ? "fu" + ERXStringUtilities.safeIdentifierName((String)this.context().elementID()) : this._id();
    }

    private String _id() {
        return (String)this.valueForBinding("id");
    }

    private String _script() {
        return "new qq.FileUploader({" + this.options() + "});";
    }

    public String script() {
        return this.isAjax() ? this._script() : "jQuery(function(){ " + this._script() + " });";
    }

    private boolean isAjax() {
        return ERXAjaxApplication.isAjaxRequest((WORequest)this.context().request());
    }

    private String finalFilePath() {
        return (String)this.valueForBinding("finalFilePath");
    }

    public static Integer maxFileSize() {
        return Integer.getInteger("WOFileUpload.sizeLimit", 0x6400000);
    }

    protected NSArray<String> _options() {
        NSMutableArray _options = new NSMutableArray((Object)("action:'" + this.href() + "'"));
        _options.add((Object)("element: $('#" + this.id() + "')[0]"));
        _options.add((Object)("params: { _forceFormSubmitted: '" + this.id() + "'}"));
        _options.add((Object)("sizeLimit: " + FileUploader.maxFileSize()));
        if (this.hasBinding("onChange")) {
            _options.add((Object)("onChange:" + this.valueForBinding("onChange")));
        }
        if (this.hasBinding("onComplete")) {
            _options.add((Object)("onComplete:" + this.valueForBinding("onComplete")));
        }
        if (this.hasBinding("onSubmit")) {
            _options.add((Object)("onSubmit:" + this.valueForBinding("onSubmit")));
        }
        if (this.hasBinding("allowedExtensions")) {
            _options.add((Object)("allowedExtensions:" + this.valueForBinding("allowedExtensions")));
        }
        return _options.immutableClone();
    }

    public String options() {
        return this._options().componentsJoinedByString(", ");
    }

    protected void setFilePath(String aPath) {
        this.setValueForBinding(aPath, "filePath");
    }

    protected void setData(NSData data) {
        this.setValueForBinding(data, "data");
    }

    private String href() {
        return ERXWOContext.ajaxActionUrl((WOContext)this.context());
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        super.appendToResponse(response, context);
        if (!useUnobtrusively) {
            ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)context, (String)"ERJQuery", (String)"jquery-1.4.2.min.js");
            ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)context, (String)"ERJQuery", (String)"fileuploader.js");
        }
    }

    public WOActionResults invokeAction(WORequest request, WOContext context) {
        if (context.senderID().equals(context.elementID())) {
            WOResponse response = WOApplication.application().createResponseInContext(context);
            if (this.exception != null) {
                response.appendContentString("{\"error\":" + this.exception.getMessage() + "}");
            } else {
                response.appendContentString("{\"success\":true}");
            }
            return response;
        }
        return super.invokeAction(request, context);
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        super.takeValuesFromRequest(request, context);
        if (context.senderID().equals(context.elementID())) {
            InputStream anInputStream;
            String aFileName;
            if (request.formValueForKey("qqfile.filename") != null) {
                aFileName = (String)request.formValueForKey("qqfile.filename");
                NSData data = (NSData)request.formValueForKey("qqfile");
                anInputStream = data.stream();
            } else if (request.formValueForKey("qqfile") != null) {
                aFileName = (String)request.formValueForKey("qqfile");
                anInputStream = request.contentInputStream() != null ? request.contentInputStream() : request.content().stream();
            } else {
                log.error((Object)("Unable to obtain filename from form values: " + request.formValueKeys()));
                return;
            }
            if (this.hasBinding("filePath")) {
                this.setFilePath(aFileName);
            }
            if (this.hasBinding("data")) {
                if (this.hasBinding("filePath")) {
                    this.setData(request.content());
                }
            } else if (aFileName != null && aFileName.length() > 0) {
                if (this.hasBinding("inputStream")) {
                    this.setValueForBinding(anInputStream, "inputStream");
                } else {
                    String localFilePath = null;
                    File tempFile = null;
                    if (this.hasBinding("outputStream")) {
                        OutputStream anOutputStream = (OutputStream)this.valueForBinding("outputStream");
                        try {
                            ERXFileUtilities.writeInputStreamToOutputStream((InputStream)anInputStream, (OutputStream)anOutputStream);
                        }
                        catch (IOException e) {
                            this.exception = new RuntimeException("Couldn't write input stream to output stream: " + e);
                            throw this.exception;
                        }
                    }
                    if (this.hasBinding("finalFilePath")) {
                        localFilePath = this.finalFilePath();
                        this.setValueForBinding(null, "finalFilePath");
                    }
                    try {
                        tempFile = ERXFileUtilities.writeInputStreamToTempFile((InputStream)anInputStream, (String)context.session().sessionID(), (String)".tmp");
                    }
                    catch (IOException e) {
                        this.exception = new RuntimeException("Couldn't write input stream to temp file: " + e);
                        throw this.exception;
                    }
                    if (this.hasBinding("streamToFilePath")) {
                        if (localFilePath == null) {
                            localFilePath = (String)this.valueForBinding("streamToFilePath");
                        }
                        try {
                            ERXFileUtilities.renameTo((File)tempFile, (File)new File(localFilePath));
                            this.setValueForBinding(localFilePath, "finalFilePath");
                        }
                        catch (Exception e) {
                            this.setValueForBinding(tempFile.getPath(), "finalFilePath");
                            this.exception = new RuntimeException("Couldn't rename temp file: " + e);
                            throw this.exception;
                        }
                    }
                }
            } else {
                if (this.hasBinding("inputStream")) {
                    this.setValueForBinding(null, "inputStream");
                }
                if (this.hasBinding("finalFilePath")) {
                    this.setValueForBinding(null, "finalFilePath");
                }
                byte[] buffer = new byte[128];
                try {
                    while (anInputStream.read(buffer) != -1) {
                    }
                }
                catch (IOException e) {
                    this.exception = new RuntimeException("Error skipping empty file upload: " + e);
                    throw this.exception;
                }
            }
        }
    }

    public static interface FormKeys {
        public static final String qqfile = "qqfile";
        public static final String qqfilename = "qqfile.filename";
        public static final String _forceFormSubmitted = "_forceFormSubmitted";
    }

    public static interface Bindings {
        public static final String id = "id";
        public static final String onChange = "onChange";
        public static final String onSubmit = "onSubmit";
        public static final String onComplete = "onComplete";
        public static final String filePath = "filePath";
        public static final String data = "data";
        public static final String inputStream = "inputStream";
        public static final String outputStream = "outputStream";
        public static final String finalFilePath = "finalFilePath";
        public static final String streamToFilePath = "streamToFilePath";
        public static final String allowedExtensions = "allowedExtensions";
    }
}

