/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAccessGenericFaultHandler;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.foundation.NSForwardException;

public class EOAccessFaultHandler
extends EOAccessGenericFaultHandler {
    protected EOKeyGlobalID _gid;

    public EOAccessFaultHandler(EOKeyGlobalID globalID, EODatabaseContext dbcontext, EOEditingContext ec) {
        this._gid = (EOKeyGlobalID)globalID.clone();
        this.setContext(dbcontext, ec);
    }

    public EOKeyGlobalID globalID() {
        return this._gid;
    }

    public String toString() {
        return "<" + this.targetClass().getClass().getName() + "(" + this._gid + ")>";
    }

    public String descriptionForObject(Object object) {
        return "<" + this.targetClass().getClass().getName() + "(" + Integer.toHexString(System.identityHashCode(object)) + ") Fault " + this._gid + ">";
    }

    public void completeInitializationOfObject(Object object) {
        EOEnterpriseObject eo = (EOEnterpriseObject)object;
        EOEditingContext ec = eo.editingContext();
        this._lockResources(ec);
        try {
            this._databaseContext._fireFault(eo);
            eo.clearFault();
        }
        catch (Exception e) {
            EODatabaseContext._EOAssertSafeMultiThreadedAccess(this._databaseContext);
            if (this._databaseContext.availableChannel() == null) {
                throw new IllegalStateException("A fault was fired while another fetch was in progress and no other channels were available to process the fault.  Either make sure not to touch faults while fetching, or register more channels with the EODatabaseContext (perhaps in response to the EODatabaseChannelNeededNotification). Original Exception:" + e);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        finally {
            this._unlockResources(ec);
        }
    }
}

