/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EOAdaptorOperation;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol._EOMutableKnownKeyDictionary;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSDelegate;

public abstract class EOAdaptorChannel {
    public static final String AdaptorOperationsKey = "EOAdaptorOperationsKey";
    public static final String FailedAdaptorOperationKey = "EOFailedAdaptorOperationKey";
    public static final String AdaptorFailureKey = "EOAdaptorFailureKey";
    public static final String AdaptorOptimisticLockingFailure = "EOAdaptorOptimisticLockingFailure";
    protected boolean _debug;
    protected EOAdaptorContext _context;
    protected _NSDelegate _delegate = new _NSDelegate(Delegate.class);
    protected Object _rawAttributesCache;
    protected _EOMutableKnownKeyDictionary.Initializer _rawDictionaryInitializer;
    protected boolean _delegateRespondsTo_willPerformOperations;
    protected boolean _delegateRespondsTo_didPerformOperations;
    protected boolean _delegateRespondsTo_shouldSelectAttributes;
    protected boolean _delegateRespondsTo_didSelectAttributes;
    protected boolean _delegateRespondsTo_willFetchRow;
    protected boolean _delegateRespondsTo_didFetchRow;
    protected boolean _delegateRespondsTo_didChangeResultSet;
    protected boolean _delegateRespondsTo_didFinishFetching;
    protected boolean _delegateRespondsTo_shouldEvaluateExpression;
    protected boolean _delegateRespondsTo_didEvaluateExpression;
    protected boolean _delegateRespondsTo_shouldExecuteStoredProcedure;
    protected boolean _delegateRespondsTo_didExecuteStoredProcedure;
    protected boolean _delegateRespondsTo_shouldConstructStoredProcedureReturnValues;
    protected boolean _delegateRespondsTo_shouldReturnValuesForStoredProcedure;

    protected void _raiseOptimisticLockingExceptionWithReason(String reason) {
        NSDictionary userInfo = new NSDictionary(new Object[]{AdaptorOptimisticLockingFailure}, new Object[]{AdaptorFailureKey});
        throw new EOGeneralAdaptorException(reason, userInfo);
    }

    public EOAdaptorChannel(EOAdaptorContext context) {
        this.setDelegate(null);
        context._registerAdaptorChannel(this);
        this._context = context;
    }

    public abstract boolean isOpen();

    public abstract void openChannel();

    public abstract void closeChannel();

    public EOAdaptorContext adaptorContext() {
        return this._context;
    }

    public abstract void insertRow(NSDictionary var1, EOEntity var2);

    public void updateValuesInRowDescribedByQualifier(NSDictionary row, EOQualifier qualifier, EOEntity entity) {
        int count = this.updateValuesInRowsDescribedByQualifier(row, qualifier, entity);
        if (count != 1) {
            if (count > 1) {
                throw new EOGeneralAdaptorException("updateValuesInRowDescribedByQualifier", this.getClass().getName(), "method updated " + count + " rows, it is only permitted to update 1 row");
            }
            String reason = "updateValuesInRowDescribedByQualifier -- " + this.getClass().getName() + " method failed to update row in database";
            this._raiseOptimisticLockingExceptionWithReason(reason);
        }
    }

    public abstract int updateValuesInRowsDescribedByQualifier(NSDictionary var1, EOQualifier var2, EOEntity var3);

    public void deleteRowDescribedByQualifier(EOQualifier qualifier, EOEntity entity) {
        int count = this.deleteRowsDescribedByQualifier(qualifier, entity);
        if (count != 1) {
            if (count > 1) {
                throw new EOGeneralAdaptorException("deleteRowDescribedByQualifierEntity", this.getClass().getName(), "method deleted " + count + " rows, it is only permitted to update 1 row");
            }
            String reason = "deleteRowDescribedByQualifierEntity -- " + this.getClass().getName() + ": method failed to delete row in database";
            this._raiseOptimisticLockingExceptionWithReason(reason);
        }
    }

    public abstract int deleteRowsDescribedByQualifier(EOQualifier var1, EOEntity var2);

    public abstract void selectAttributes(NSArray var1, EOFetchSpecification var2, boolean var3, EOEntity var4);

    public void lockRowComparingAttributes(NSArray atts, EOEntity entity, EOQualifier qualifier, NSDictionary snapshot) {
        NSMutableDictionary row2;
        String reason;
        EOAdaptorContext context = this.adaptorContext();
        if (!context.hasOpenTransaction()) {
            context.beginTransaction();
        }
        EOFetchSpecification fetchSpec = new EOFetchSpecification(entity.name(), qualifier, null);
        if (atts == null || atts.count() == 0) {
            atts = entity.primaryKeyAttributes();
        }
        this.selectAttributes(atts, fetchSpec, true, entity);
        NSMutableDictionary row = this.fetchRow();
        if (row == null) {
            reason = "lockRowComparingAttributes -- " + this.getClass().getName() + ": lock operation failed to select any rows";
            this._raiseOptimisticLockingExceptionWithReason(reason);
        }
        if ((row2 = this.fetchRow()) != null) {
            this.cancelFetch();
            throw new EOGeneralAdaptorException("lockRowComparingAttributes", this.getClass().getName(), "lock operation locked more than one row");
        }
        for (int i = atts.count() - 1; i >= 0; --i) {
            String snapshotKey;
            Object obj2;
            String key = ((EOAttribute)atts.objectAtIndex(i)).name();
            Object obj1 = row.objectForKey((Object)key);
            if (obj1.equals(obj2 = snapshot.objectForKey((Object)(snapshotKey = entity.snapshotKeyForAttributeName(key))))) continue;
            reason = "lockRowComparingAttributes -- " + this.getClass().getName() + ": lock operation fetched row with different values than snapshot";
            this._raiseOptimisticLockingExceptionWithReason(reason);
        }
    }

    public abstract void evaluateExpression(EOSQLExpression var1);

    public abstract boolean isFetchInProgress();

    public abstract NSArray describeResults();

    public abstract NSMutableDictionary fetchRow();

    public abstract void setAttributesToFetch(NSArray var1);

    public abstract NSArray attributesToFetch();

    public abstract void cancelFetch();

    public NSDictionary primaryKeyForNewRowWithEntity(EOEntity entity) {
        return null;
    }

    public NSArray primaryKeysForNewRowsWithEntity(int count, EOEntity entity) {
        NSMutableArray keys = new NSMutableArray(count);
        for (int i = 0; i < count; ++i) {
            NSDictionary key = this.primaryKeyForNewRowWithEntity(entity);
            if (key == null) {
                return null;
            }
            keys.addObject((Object)key);
        }
        return keys;
    }

    public NSArray describeStoredProcedureNames() {
        return NSArray.EmptyArray;
    }

    public void addStoredProceduresNamed(NSArray storedProcedureNames, EOModel model) {
    }

    public NSArray describeTableNames() {
        return NSArray.EmptyArray;
    }

    public EOModel describeModelWithTableNames(NSArray tableNames) {
        return null;
    }

    public Object delegate() {
        return this._delegate.delegate();
    }

    public void setDelegate(Object delegate) {
        boolean b;
        this._delegate.setDelegate(delegate);
        this._delegateRespondsTo_willPerformOperations = b = this._delegate.respondsTo("adaptorChannelWillPerformOperations");
        this._delegateRespondsTo_didPerformOperations = b = this._delegate.respondsTo("adaptorChannelDidPerformOperations");
        this._delegateRespondsTo_shouldSelectAttributes = b = this._delegate.respondsTo("adaptorChannelShouldSelectAttributes");
        this._delegateRespondsTo_didSelectAttributes = b = this._delegate.respondsTo("adaptorChannelDidSelectAttributes");
        this._delegateRespondsTo_willFetchRow = b = this._delegate.respondsTo("adaptorChannelWillFetchRow");
        this._delegateRespondsTo_didFetchRow = b = this._delegate.respondsTo("adaptorChannelDidFetchRow");
        this._delegateRespondsTo_didChangeResultSet = b = this._delegate.respondsTo("adaptorChannelDidChangeResultSet");
        this._delegateRespondsTo_didFinishFetching = b = this._delegate.respondsTo("adaptorChannelDidFinishFetching");
        this._delegateRespondsTo_shouldEvaluateExpression = b = this._delegate.respondsTo("adaptorChannelShouldEvaluateExpression");
        this._delegateRespondsTo_didEvaluateExpression = b = this._delegate.respondsTo("adaptorChannelDidEvaluateExpression");
        this._delegateRespondsTo_shouldExecuteStoredProcedure = b = this._delegate.respondsTo("adaptorChannelShouldExecuteStoredProcedure");
        this._delegateRespondsTo_didExecuteStoredProcedure = b = this._delegate.respondsTo("adaptorChannelDidExecuteStoredProcedure");
        this._delegateRespondsTo_shouldConstructStoredProcedureReturnValues = b = this._delegate.respondsTo("adaptorChannelShouldConstructStoredProcedureReturnValues");
        this._delegateRespondsTo_shouldReturnValuesForStoredProcedure = b = this._delegate.respondsTo("adaptorChannelShouldReturnValuesForStoredProcedure");
    }

    protected void _setRawDictionaryInitializerForAttributes(NSArray attributes) {
        if (this._rawAttributesCache == attributes) {
            return;
        }
        this._rawAttributesCache = attributes;
        if (attributes == null) {
            this._rawDictionaryInitializer = null;
            return;
        }
        int count = attributes.count();
        NSMutableArray names = new NSMutableArray(count);
        for (int i = 0; i < count; ++i) {
            names.addObject((Object)((EOAttribute)attributes.objectAtIndex(i)).name());
        }
        this._rawDictionaryInitializer = new _EOMutableKnownKeyDictionary.Initializer((NSArray)names);
    }

    public NSMutableDictionary dictionaryWithObjectsForAttributes(Object[] objects, NSArray attributes) {
        EOAttribute anAttribute = (EOAttribute)attributes.objectAtIndex(0);
        EOEntity entity = anAttribute.entity();
        if (entity != null && entity._attributesToFetch() == attributes) {
            return new _EOMutableKnownKeyDictionary(entity._adaptorDictionaryInitializer(), objects);
        }
        if (this._rawAttributesCache == attributes) {
            return new _EOMutableKnownKeyDictionary(this._rawDictionaryInitializer, objects);
        }
        if (entity != null) {
            for (EOEntity singleEntity = entity.parentEntity(); singleEntity != null && singleEntity._isSingleTableEntity(); singleEntity = singleEntity.parentEntity()) {
                if (singleEntity._attributesToFetch() != attributes) continue;
                return new _EOMutableKnownKeyDictionary(singleEntity._adaptorDictionaryInitializer(), objects);
            }
        }
        int count = attributes.count();
        Object result = entity != null && (EOAttribute)entity.attributes().objectAtIndex(0) == anAttribute ? new _EOMutableKnownKeyDictionary(entity._adaptorDictionaryInitializer()) : new NSMutableDictionary(count);
        for (int i = 0; i < count; ++i) {
            Object object = objects[i];
            if (object == null) continue;
            result.setObjectForKey(object, (Object)((EOAttribute)attributes.objectAtIndex(i)).name());
        }
        return result;
    }

    public abstract void executeStoredProcedure(EOStoredProcedure var1, NSDictionary var2);

    public abstract NSDictionary returnValuesForLastStoredProcedureInvocation();

    public void performAdaptorOperation(EOAdaptorOperation adaptorOp) {
        if (!this.adaptorContext().hasOpenTransaction()) {
            this.adaptorContext().beginTransaction();
        }
        EOEntity entity = adaptorOp.entity();
        switch (adaptorOp.adaptorOperator()) {
            case 0: {
                this.lockRowComparingAttributes(adaptorOp.attributes(), entity, adaptorOp.qualifier(), adaptorOp.changedValues());
                break;
            }
            case 1: {
                NSDictionary changedValues = adaptorOp.changedValues();
                this.insertRow(changedValues, entity);
                break;
            }
            case 2: {
                NSDictionary changedValues = adaptorOp.changedValues();
                this.updateValuesInRowDescribedByQualifier(changedValues, adaptorOp.qualifier(), entity);
                break;
            }
            case 3: {
                this.deleteRowDescribedByQualifier(adaptorOp.qualifier(), entity);
                break;
            }
            case 4: {
                NSDictionary changedValues = adaptorOp.changedValues();
                this.executeStoredProcedure(adaptorOp.storedProcedure(), changedValues);
                this.returnValuesForLastStoredProcedureInvocation();
            }
        }
    }

    public void performAdaptorOperations(NSArray adaptorOps) {
        Throwable exception = null;
        if (this._delegateRespondsTo_willPerformOperations) {
            adaptorOps = (NSArray)this._delegate.perform("adaptorChannelWillPerformOperations", (Object)this, (Object)adaptorOps);
        }
        int iCount = adaptorOps.count();
        for (int i = 0; i < iCount; ++i) {
            EOAdaptorOperation adaptorOp = (EOAdaptorOperation)adaptorOps.objectAtIndex(i);
            try {
                this.performAdaptorOperation(adaptorOp);
                continue;
            }
            catch (EOGeneralAdaptorException localException) {
                adaptorOp.setException(localException);
                NSDictionary oldInfo = localException.userInfo();
                NSMutableDictionary info = oldInfo != null ? new NSMutableDictionary(oldInfo) : new NSMutableDictionary(2);
                info.setObjectForKey((Object)adaptorOps, (Object)AdaptorOperationsKey);
                info.setObjectForKey((Object)adaptorOp, (Object)FailedAdaptorOperationKey);
                exception = new EOGeneralAdaptorException(localException.getMessage(), (NSDictionary)info);
                break;
            }
            catch (Exception localException) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
            }
        }
        Throwable newException = exception;
        if (this._delegateRespondsTo_didPerformOperations) {
            newException = (Throwable)this._delegate.perform("adaptorChannelDidPerformOperations", (Object)this, (Object)adaptorOps, exception);
        }
        if (newException != null) {
            throw NSForwardException._runtimeExceptionForThrowable(newException);
        }
    }

    public static interface Delegate {
        public NSArray adaptorChannelWillPerformOperations(EOAdaptorChannel var1, NSArray var2);

        public Throwable adaptorChannelDidPerformOperations(EOAdaptorChannel var1, NSArray var2, Throwable var3);

        public boolean adaptorChannelShouldSelectAttributes(EOAdaptorChannel var1, NSArray var2, EOFetchSpecification var3, boolean var4, EOEntity var5);

        public void adaptorChannelDidSelectAttributes(EOAdaptorChannel var1, NSArray var2, EOFetchSpecification var3, boolean var4, EOEntity var5);

        public void adaptorChannelWillFetchRow(EOAdaptorChannel var1);

        public void adaptorChannelDidFetchRow(EOAdaptorChannel var1, NSMutableDictionary var2);

        public void adaptorChannelDidChangeResultSet(EOAdaptorChannel var1);

        public void adaptorChannelDidFinishFetching(EOAdaptorChannel var1);

        public boolean adaptorChannelShouldEvaluateExpression(EOAdaptorChannel var1, EOSQLExpression var2);

        public void adaptorChannelDidEvaluateExpression(EOAdaptorChannel var1, EOSQLExpression var2);

        public NSDictionary adaptorChannelShouldExecuteStoredProcedure(EOAdaptorChannel var1, EOStoredProcedure var2, NSDictionary var3);

        public void adaptorChannelDidExecuteStoredProcedure(EOAdaptorChannel var1, EOStoredProcedure var2, NSDictionary var3);

        public NSDictionary adaptorChannelShouldConstructStoredProcedureReturnValues(EOAdaptorChannel var1);

        public NSDictionary adaptorChannelShouldReturnValuesForStoredProcedure(EOAdaptorChannel var1, NSDictionary var2);
    }
}

