/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class NSBundle {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSBundle");
    public static final String BundleDidLoadNotification = "NSBundleDidLoadNotification";
    public static final String LoadedClassesNotification = "NSLoadedClassesNotification";
    private static final String userDirPath;
    private static final String JSUFFIX;
    private static final String LPROJSUFFIX = ".lproj";
    private static final String MAIN_BUNDLE_NAME = "MainBundle";
    private static final String NONLOCALIZED_LOCALE = "Nonlocalized.lproj";
    private static final String NONLOCALIZED_LOCALE_PREFIX;
    private static final String RESOURCES = "Resources";
    private static final String RSUFFIX;
    private static final String RJSUFFIX;
    private static final String RPSUFFIX;
    private static final String CONTENTS = "Contents";
    private static final String CSUFFIX;
    private static final String CRSUFFIX;
    private static final String CRJSUFFIX;
    private static final String CRPSUFFIX;
    private static final int NSBUNDLE = 1;
    private static final int CFBUNDLE = 2;
    private static final NSMutableArray AllBundles;
    private static final NSMutableArray AllBundlesReally;
    private static final NSMutableArray AllFrameworks;
    private static final NSMutableDictionary BundlesClassesTable;
    private static final NSArray ClassPath;
    private static final NSMutableDictionary BundlesNamesTable;
    private static final NSMutableDictionary AppBundlesNamesTable;
    private static NSBundle MainBundle;
    private static final _NSThreadsafeMutableDictionary OldResourceFilters;
    private static boolean PrincipalClassLookupAllowed;
    private static boolean PrincipalClassWarningSuppressed;
    private static final _NSThreadsafeMutableDictionary ResourceDirectoryFilters;
    private static final _NSThreadsafeMutableDictionary ResourceFilters;
    private static final DirectoryFilter TheDirectoryFilter;
    private static final FilesFilter TheFilesFilter;
    private static final InfoDictFilter TheInfoDictFilter;
    private static final _NSUtilities.JavaArchiveFilter TheJavaArchiveFilter;
    private static final _NSUtilities.JavaClassFilter TheJavaClassFilter;
    private static String ResourcesInfoPlist;
    private static String JarResourcesInfoPlist;
    private static String ResourcesProperties;
    private static NSMutableDictionary TheFileDict;
    private static boolean safeInvokeDeprecatedJarBundleAPI;
    private boolean isJar;
    private JarFile jarFile;
    private NSMutableArray jarFileEntries;
    private NSDictionary jarFileLayout;
    private String _bundleURLPrefix;
    private String bundlePath;
    private int bundleType;
    private boolean classesHaveBeenLoaded;
    private NSArray classNames;
    private NSDictionary infoDictionary;
    private boolean isFramework;
    private Properties properties;
    private String name;
    private NSArray packages;
    private Class principalClass;
    private NSMutableArray resourceBuckets;
    private String resourcePath;
    private String contentsPath;
    private String _resourceLocation;

    private NSBundle() {
    }

    public static synchronized NSArray allBundles() {
        return AllBundles.immutableClone();
    }

    public static NSArray allFrameworks() {
        return NSBundle.frameworkBundles();
    }

    public static synchronized NSBundle bundleForClass(Class aClass) {
        NSBundle bundle = null;
        if (aClass != null) {
            bundle = (NSBundle)BundlesClassesTable.objectForKey(aClass.getName());
        }
        return bundle;
    }

    public static NSBundle bundleWithPath(String aPath) {
        return NSBundle._bundleWithPathShouldCreateIsJar(aPath, false, false);
    }

    public static NSBundle _bundleWithPathShouldCreateIsJar(String aPath, boolean shouldCreateBundle, boolean newIsJar) {
        NSBundle bundle = null;
        String normalizedPath = null;
        String cleanedPath = null;
        normalizedPath = NSBundle.NormalizeExistingBundlePath(aPath);
        bundle = NSBundle.LookupBundleWithPath(normalizedPath);
        if (bundle == null) {
            cleanedPath = NSBundle.CleanNormalizedBundlePath(normalizedPath);
            bundle = NSBundle.LookupBundleWithPath(cleanedPath);
        }
        if (bundle == null && shouldCreateBundle) {
            bundle = NSBundle.CreateBundleWithPath(newIsJar ? normalizedPath : cleanedPath, newIsJar);
        }
        return bundle;
    }

    public static synchronized NSBundle bundleForName(String aName) {
        NSBundle bundle = null;
        if (aName != null) {
            String fixedName = aName.endsWith(".framework") ? NSPathUtilities.stringByDeletingPathExtension(aName) : aName;
            bundle = (NSBundle)BundlesNamesTable.objectForKey(fixedName);
        }
        return bundle;
    }

    public static synchronized NSBundle _appBundleForName(String aName) {
        NSBundle bundle = null;
        if (aName != null) {
            String fixedName = aName.endsWith(".woa") ? NSPathUtilities.stringByDeletingPathExtension(aName) : aName;
            bundle = (NSBundle)AppBundlesNamesTable.objectForKey(fixedName);
        }
        return bundle;
    }

    public static synchronized NSArray frameworkBundles() {
        return AllFrameworks.immutableClone();
    }

    public static void _setMainBundle(NSBundle bundle) {
        MainBundle = bundle;
    }

    public static NSBundle mainBundle() {
        return MainBundle;
    }

    private static boolean couldBeABundle(String aPath) {
        boolean isBundle = false;
        NSMutableArray resourcesSubdirs = new NSMutableArray();
        int index = aPath.lastIndexOf(RSUFFIX);
        if (index == -1) {
            resourcesSubdirs.addObject(aPath.concat(RSUFFIX));
            resourcesSubdirs.addObject(aPath.concat(CSUFFIX));
        } else {
            resourcesSubdirs.addObject(aPath.substring(0, index + RSUFFIX.length()));
        }
        for (int i = 0; i < resourcesSubdirs.count(); ++i) {
            String[] files;
            File file = new File((String)resourcesSubdirs.objectAtIndex(i));
            if (file == null || !file.exists() || !file.isDirectory() || (files = file.list(TheInfoDictFilter)).length <= 0) continue;
            isBundle = true;
            break;
        }
        return isBundle;
    }

    private static void transferPropertiesFromSourceToDest(Properties sourceProps, Properties destProps) {
        if (sourceProps != null) {
            destProps.putAll((Map<?, ?>)sourceProps);
        }
    }

    private static void LoadUserAndBundleProperties() {
        Properties nextProps;
        NSArray allBundles = NSBundle.allFrameworks();
        Enumeration bundleEn = allBundles.objectEnumerator();
        Properties bundleProps = new Properties();
        Properties userProps = null;
        Properties oldSysProps = NSProperties._getProperties();
        String userhome = System.getProperty("user.home");
        while (bundleEn.hasMoreElements()) {
            NSBundle nextBundle = (NSBundle)bundleEn.nextElement();
            nextProps = nextBundle.properties();
            NSBundle.transferPropertiesFromSourceToDest(nextProps, bundleProps);
        }
        nextProps = NSBundle.mainBundle().properties();
        NSBundle.transferPropertiesFromSourceToDest(nextProps, bundleProps);
        nextProps = bundleProps;
        if (userhome != null && userhome.length() > 0) {
            File propertiesFile = new File(userhome, "WebObjects.properties");
            if (propertiesFile != null) {
                try {
                    InputStream is = propertiesFile.toURL().openStream();
                    if (is != null) {
                        userProps = NSBundle.initPropertiesFromInputStreamWithParent(is, bundleProps);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (userProps != null) {
                nextProps = userProps;
            }
        }
        Properties sysProps = new Properties(nextProps);
        NSBundle.transferPropertiesFromSourceToDest(oldSysProps, sysProps);
        NSProperties._setProperties(sysProps);
    }

    private static void InitMainBundle() {
        try {
            String mainBundleName = NSProperties._mainBundleName();
            if (mainBundleName != null) {
                MainBundle = NSBundle.bundleForName(mainBundleName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (MainBundle == null && NSBundle.couldBeABundle(userDirPath)) {
            MainBundle = NSBundle._bundleWithPathShouldCreateIsJar(userDirPath, true, false);
        }
        if (MainBundle == null) {
            MainBundle = NSBundle.bundleForName("JavaFoundation");
        }
        if (MainBundle != null && (NSBundle.MainBundle.infoDictionary == null || NSBundle.MainBundle.name != (String)NSBundle.MainBundle.infoDictionary.objectForKey("NSExecutable"))) {
            NSBundle.MainBundle.name = MAIN_BUNDLE_NAME;
        }
    }

    public static void _setPrincipalClassWarningSuppressed(boolean flag) {
        PrincipalClassWarningSuppressed = flag;
    }

    private static void InitPrincipalClasses() {
        int count = AllBundlesReally.count();
        for (int i = 0; i < count; ++i) {
            ((NSBundle)AllBundlesReally.objectAtIndex(i)).initPrincipalClass();
        }
        PrincipalClassLookupAllowed = true;
    }

    private static void LoadBundlesFromJars(NSArray array) {
        Enumeration en = array.objectEnumerator();
        while (en.hasMoreElements()) {
            NSBundle b = NSBundle._bundleWithPathShouldCreateIsJar(en.nextElement().toString(), true, true);
            if (b == null) continue;
            b.postNotification();
        }
    }

    private static void LoadBundlesFromClassPath(NSArray array) {
        Enumeration en = array.objectEnumerator();
        while (en.hasMoreElements()) {
            NSBundle b = null;
            Object nextElement = en.nextElement();
            String nextPathComponent = nextElement.toString();
            if (NSBundle.couldBeABundle(nextPathComponent)) {
                b = NSBundle._bundleWithPathShouldCreateIsJar(nextPathComponent, true, false);
            }
            if (b == null) continue;
            super.postNotification();
        }
    }

    private static String DefaultLocalePrefix() {
        String defaultLang = "English";
        String defaultLocaleLang = Locale.getDefault().getLanguage();
        if (defaultLocaleLang.equals("de")) {
            defaultLang = "German";
        } else if (defaultLocaleLang.equals("es")) {
            defaultLang = "Spanish";
        } else if (defaultLocaleLang.equals("fr")) {
            defaultLang = "French";
        } else if (defaultLocaleLang.equals("ja")) {
            defaultLang = "Japanese";
        }
        return defaultLang.concat(LPROJSUFFIX);
    }

    private static synchronized NSBundle LookupBundleWithPath(String aPath) {
        NSBundle bundle = null;
        if (aPath == null) {
            return null;
        }
        Enumeration en = AllBundlesReally.objectEnumerator();
        while (en.hasMoreElements() && bundle == null) {
            NSBundle nextBundle = (NSBundle)en.nextElement();
            if (!nextBundle.bundlePath().equals(aPath)) continue;
            bundle = nextBundle;
        }
        return bundle;
    }

    public static NSArray _allBundlesReally() {
        return AllBundlesReally;
    }

    private static synchronized NSBundle CreateBundleWithPath(String aPath, boolean newIsJar) {
        NSBundle bundle = null;
        if (aPath == null) {
            return null;
        }
        bundle = new NSBundle();
        AllBundlesReally.addObject(bundle);
        bundle.initIsJar(newIsJar);
        bundle.initBundlePath(aPath);
        bundle.initBundleURLPrefix();
        bundle.initBundleType();
        bundle.initJarFileLayout();
        bundle.initContentsPath();
        bundle.initResourcePath();
        bundle.initResourceBuckets();
        bundle.initInfoDictionary();
        bundle.initName();
        if (bundle.couldBeAFramework()) {
            NSBundle possibleBundle = NSBundle.bundleForName(bundle.name);
            if (possibleBundle != null) {
                throw new IllegalStateException("<" + _CLASS.getName() + "> warning: There is already a unique instance for Bundle named '" + bundle.name + "'.  Use NSBundle.bundleForName(" + bundle.name + ") to access it: " + possibleBundle.toString());
            }
            BundlesNamesTable.setObjectForKey(bundle, bundle.name);
            bundle.isFramework = true;
            AllFrameworks.addObject(bundle);
        } else {
            AppBundlesNamesTable.setObjectForKey(bundle, bundle.name);
            MainBundle = bundle;
            bundle.isFramework = false;
            AllBundles.addObject(bundle);
        }
        bundle.initProperties();
        bundle.initClassNames();
        bundle.initPackages();
        if (PrincipalClassLookupAllowed) {
            bundle.initPrincipalClass();
        }
        return bundle;
    }

    private static String NormalizeExistingBundlePath(String aPath) {
        File fileAtPath;
        String standardizedPath = null;
        if (aPath != null && (fileAtPath = new File(aPath)) != null && fileAtPath.exists()) {
            standardizedPath = NSPathUtilities.stringByNormalizingExistingPath(aPath);
        }
        return standardizedPath;
    }

    private static String CleanNormalizedBundlePath(String standardizedPath) {
        if (standardizedPath != null) {
            String allDirectoriesInPath = null;
            Object bundlePath = null;
            int i = -1;
            File fileAtPath = new File(standardizedPath);
            allDirectoriesInPath = !fileAtPath.isDirectory() ? _NSStringUtilities.stringByDeletingLastComponent(standardizedPath, File.separatorChar) : standardizedPath;
            if (allDirectoriesInPath != null) {
                i = allDirectoriesInPath.lastIndexOf(RJSUFFIX);
                if (i == -1 || i == 0) {
                    i = allDirectoriesInPath.lastIndexOf(RSUFFIX);
                }
                if (i == -1 || i == 0) {
                    standardizedPath = allDirectoriesInPath;
                } else {
                    standardizedPath = allDirectoriesInPath.substring(0, i);
                    if (NSPathUtilities.lastPathComponent(NSPathUtilities.stringByDeletingLastPathComponent(standardizedPath)).equals("Versions")) {
                        standardizedPath = NSPathUtilities.stringByDeletingLastPathComponent(NSPathUtilities.stringByDeletingLastPathComponent(standardizedPath));
                    }
                }
            }
        }
        return standardizedPath;
    }

    private static OldResourceFilter OldResourceFilterForExtension(String anExtension) {
        OldResourceFilter rf = null;
        if (anExtension == null) {
            throw new IllegalArgumentException("Illegal resource search: cannot search using a null extension");
        }
        String correctedExtension = anExtension.startsWith(".") ? anExtension.substring(1) : anExtension;
        rf = (OldResourceFilter)OldResourceFilters.objectForKey(correctedExtension);
        if (rf == null) {
            rf = new OldResourceFilter(correctedExtension);
            OldResourceFilters.setObjectForKey(rf, correctedExtension);
        }
        return rf;
    }

    private static ResourceDirectoryFilter ResourceDirectoryFilterForExtension(String anExtension) {
        ResourceDirectoryFilter rdf = null;
        if (anExtension == null) {
            throw new IllegalArgumentException("Illegal resource search: cannot search using a null extension");
        }
        String correctedExtension = anExtension.startsWith(".") ? anExtension.substring(1) : anExtension;
        rdf = (ResourceDirectoryFilter)ResourceDirectoryFilters.objectForKey(correctedExtension);
        if (rdf == null) {
            rdf = new ResourceDirectoryFilter(correctedExtension);
            ResourceDirectoryFilters.setObjectForKey(rdf, correctedExtension);
        }
        return rdf;
    }

    private static ResourceFilter ResourceFilterForExtension(String anExtension) {
        ResourceFilter rf = null;
        if (anExtension == null) {
            throw new IllegalArgumentException("Illegal resource search: cannot search using a null extension");
        }
        String correctedExtension = anExtension.startsWith(".") ? anExtension.substring(1) : anExtension;
        rf = (ResourceFilter)ResourceFilters.objectForKey(correctedExtension);
        if (rf == null) {
            rf = new ResourceFilter(correctedExtension);
            ResourceFilters.setObjectForKey(rf, correctedExtension);
        }
        return rf;
    }

    private static Class searchAllBundlesForClassWithName(String className) {
        if (NSLog._debugLoggingAllowedForLevelAndGroups(2, 32L)) {
            NSLog.debug.appendln("NSBundle.searchAllBundlesForClassWithName(\"" + className + "\") was invoked.\n\t**This affects performance very badly.**");
            if (NSLog.allowedDebugLevel() > 2) {
                NSLog.debug.appendln(new RuntimeException("NSBundle.searchAllBundlesForClassWithName was invoked."));
            }
        }
        Class result = null;
        Object b = null;
        result = NSBundle.searchForClassInBundles(className, NSBundle.allBundles(), true);
        if (result == null) {
            result = NSBundle.searchForClassInBundles(className, NSBundle.allFrameworks(), true);
        }
        return result;
    }

    private static Class searchForClassInBundles(String className, NSArray bundles, boolean registerPackageOnHit) {
        int count = bundles.count();
        for (int i = 0; i < count; ++i) {
            NSArray packages = ((NSBundle)bundles.objectAtIndex(i)).bundleClassPackageNames();
            Class result = _NSUtilities._searchForClassInPackages(className, packages, registerPackageOnHit, false);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public NSArray bundleClassPackageNames() {
        return this.packages;
    }

    public String bundlePath() {
        return this.bundlePath;
    }

    public URL bundlePathURL() {
        return NSPathUtilities._URLWithPath(this.bundlePath);
    }

    public String _bundleURLPrefix() {
        return this._bundleURLPrefix;
    }

    public byte[] bytesForResourcePath(String aResourcePath) {
        InputStream is = this.inputStreamForResourcePath(aResourcePath);
        byte[] b = null;
        if (is == null) {
            b = new byte[]{};
        } else {
            try {
                b = _NSStringUtilities.bytesFromInputStream(is);
            }
            catch (Exception e) {
                throw NSForwardException._runtimeExceptionForThrowable(e);
            }
        }
        return b;
    }

    public NSArray bundleClassNames() {
        return this.classNames;
    }

    public NSDictionary infoDictionary() {
        return this.infoDictionary;
    }

    public NSDictionary _infoDictionary() {
        return this.infoDictionary;
    }

    public URL pathURLForResourcePath(String aResourcePath) {
        return this._pathURLForResourcePath(aResourcePath, true);
    }

    public URL _pathURLForResourcePath(String aResourcePath, boolean returnDirectories) {
        URL url = null;
        if (aResourcePath != null && aResourcePath.length() > 0 && this.resourceBuckets.indexOfIdenticalObject(this._resourceLocation) != -1) {
            boolean isLocalized = true;
            if (aResourcePath.startsWith(NONLOCALIZED_LOCALE)) {
                isLocalized = false;
            }
            String realPath = isLocalized ? aResourcePath : aResourcePath.substring(NONLOCALIZED_LOCALE.length());
            if (this.isJar) {
                ZipEntry ze;
                if (!realPath.startsWith("/")) {
                    realPath = "/".concat(realPath);
                }
                if ((ze = this.jarFile.getEntry(this._resourceLocation.concat(realPath))) != null && (returnDirectories || !ze.isDirectory())) {
                    try {
                        url = new URL(this._bundleURLPrefix.concat(ze.getName()));
                    }
                    catch (Exception e) {
                        throw NSForwardException._runtimeExceptionForThrowable(e);
                    }
                }
            } else {
                File f;
                if (!realPath.startsWith(File.separator)) {
                    realPath = File.separator.concat(realPath);
                }
                if ((f = new File(this.resourcePath.concat(realPath))) != null && f.exists() && (f.isFile() || returnDirectories)) {
                    try {
                        url = NSPathUtilities._URLWithPath(f.getCanonicalPath());
                    }
                    catch (Exception e) {
                        throw NSForwardException._runtimeExceptionForThrowable(e);
                    }
                }
            }
        }
        return url;
    }

    public InputStream inputStreamForResourcePath(String aResourcePath) {
        InputStream is = null;
        URL url = this._pathURLForResourcePath(aResourcePath, false);
        if (url != null) {
            try {
                is = url.openStream();
            }
            catch (IOException ioe) {
                throw NSForwardException._runtimeExceptionForThrowable(ioe);
            }
        }
        return is;
    }

    public boolean isFramework() {
        return this.isFramework;
    }

    public boolean _isCFBundle() {
        return this.bundleType == 2;
    }

    public boolean isJar() {
        return this.isJar;
    }

    public JarFile _jarFile() {
        return this.jarFile;
    }

    public NSDictionary _jarFileLayout() {
        return this.jarFileLayout;
    }

    public boolean load() {
        return this.classesHaveBeenLoaded;
    }

    public String name() {
        return this.name;
    }

    public boolean _directoryExistsInJar(String path) {
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return true;
        }
        if (this.isJar) {
            if (!path.endsWith("/")) {
                path = path.concat("/");
            }
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            return this.jarFile.getEntry(path) != null;
        }
        return false;
    }

    public String pathForResource(String aName, String anExtension) {
        return this.pathForResource(aName, anExtension, null);
    }

    public String pathForResource(String aName, String anExtension, String aSubDirPath) {
        if (this.isJar) {
            if (safeInvokeDeprecatedJarBundleAPI) {
                return null;
            }
            throw new IllegalStateException("pathsForResoures cannot be invoked on a jar-based NSBundle");
        }
        String path = null;
        if (aName != null) {
            String possiblePath;
            int i;
            String nextDir;
            Enumeration en = this.resourceBuckets.objectEnumerator();
            String localePrefix = NSBundle.DefaultLocalePrefix();
            String[] pathFragments = new String[2];
            String pathPrefix = null;
            String fileName = anExtension == null ? aName : (anExtension.startsWith(".") || aName.endsWith(".") ? aName + anExtension : aName + "." + anExtension);
            if (aSubDirPath == null) {
                pathFragments[0] = "";
                pathFragments[1] = localePrefix;
            } else {
                pathFragments[0] = aSubDirPath;
                pathFragments[1] = aSubDirPath + File.separator + localePrefix;
            }
            while (en.hasMoreElements() && path == null) {
                nextDir = (String)en.nextElement();
                pathPrefix = nextDir.equals("") ? this.bundlePath : this.bundlePath + File.separator + nextDir;
                for (i = 0; i < pathFragments.length && path == null; ++i) {
                    possiblePath = pathFragments[i].equals("") ? pathPrefix + File.separator + fileName : pathPrefix + File.separator + pathFragments[i] + File.separator + fileName;
                    File possibleResource = new File(possiblePath);
                    if (possibleResource == null || !possibleResource.exists()) continue;
                    try {
                        path = possibleResource.getCanonicalPath();
                        continue;
                    }
                    catch (IOException e) {
                        throw NSForwardException._runtimeExceptionForThrowable(e);
                    }
                }
            }
            if (path == null && anExtension == null) {
                SpecificResourceFilter srf = new SpecificResourceFilter(aName);
                en = this.resourceBuckets.objectEnumerator();
                while (en.hasMoreElements() && path == null) {
                    nextDir = (String)en.nextElement();
                    pathPrefix = nextDir.equals("") ? this.bundlePath : this.bundlePath + File.separator + nextDir;
                    for (i = 0; i < pathFragments.length && path == null; ++i) {
                        String[] fileNames;
                        possiblePath = pathFragments[i].equals("") ? pathPrefix : pathPrefix + pathFragments[i];
                        File possibleResourceDir = new File(possiblePath);
                        if (possibleResourceDir == null || !possibleResourceDir.exists() || !possibleResourceDir.isDirectory() || (fileNames = possibleResourceDir.list(srf)).length <= 0) continue;
                        try {
                            path = possibleResourceDir.getCanonicalPath() + File.separator + fileNames[0];
                            continue;
                        }
                        catch (IOException e) {
                            throw NSForwardException._runtimeExceptionForThrowable(e);
                        }
                    }
                }
            }
        }
        return path;
    }

    public NSArray pathsForResources(String anExtension, String aSubDirPath) {
        if (this.isJar) {
            if (safeInvokeDeprecatedJarBundleAPI) {
                return NSArray.EmptyArray;
            }
            throw new IllegalStateException("pathsForResources cannot be invoked on a jar-based NSBundle");
        }
        Enumeration en = this.resourceBuckets.objectEnumerator();
        NSMutableArray fileArray = new NSMutableArray();
        String localePrefix = NSBundle.DefaultLocalePrefix();
        String[] pathFragments = new String[2];
        OldResourceFilter rf = null;
        if (anExtension != null && !anExtension.equals("")) {
            rf = NSBundle.OldResourceFilterForExtension(anExtension);
        }
        if (aSubDirPath == null) {
            pathFragments[0] = "";
            pathFragments[1] = localePrefix;
        } else {
            pathFragments[0] = aSubDirPath;
            pathFragments[1] = aSubDirPath + File.separator + localePrefix;
        }
        while (en.hasMoreElements()) {
            String nextDir = (String)en.nextElement();
            String pathPrefix = nextDir.equals("") ? this.bundlePath : this.bundlePath + File.separator + nextDir;
            for (int i = 0; i < pathFragments.length; ++i) {
                String basePath;
                String[] resourceNames;
                String possiblePath = pathFragments[i].equals("") ? pathPrefix : pathPrefix + File.separator + pathFragments[i];
                File possibleResourceDir = new File(possiblePath);
                if (possibleResourceDir == null || !possibleResourceDir.exists() || !possibleResourceDir.isDirectory() || (resourceNames = rf == null ? possibleResourceDir.list() : possibleResourceDir.list(rf)).length <= 0) continue;
                try {
                    basePath = possibleResourceDir.getCanonicalPath();
                }
                catch (IOException e) {
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
                for (int j = 0; j < resourceNames.length; ++j) {
                    fileArray.addObject(basePath + File.separator + resourceNames[j]);
                }
            }
        }
        return fileArray;
    }

    public Class principalClass() {
        return this.principalClass;
    }

    public Properties properties() {
        return this.properties;
    }

    public String resourcePath() {
        return this.resourcePath;
    }

    public URL _urlForRelativePath(String aPath) {
        URL retVal = null;
        if (aPath != null && aPath.length() > 0) {
            if (this.isJar) {
                ZipEntry ze;
                if (aPath.startsWith("/")) {
                    aPath = aPath.substring(1, aPath.length());
                }
                if ((ze = this.jarFile.getEntry(aPath)) == null && !aPath.endsWith("/")) {
                    aPath = aPath.concat("/");
                    ze = this.jarFile.getEntry(aPath);
                }
                if (ze != null) {
                    try {
                        retVal = new URL(this._bundleURLPrefix.concat(aPath));
                    }
                    catch (MalformedURLException mue) {}
                }
            } else {
                String path = _NSStringUtilities.concat(this.bundlePath(), File.separator, aPath);
                File f = new File(path);
                if (f.exists()) {
                    try {
                        retVal = f.toURL();
                    }
                    catch (MalformedURLException mue) {
                        // empty catch block
                    }
                }
            }
        }
        return retVal;
    }

    public String resourcePathForLocalizedResourceNamed(String aName, String aSubDirPath) {
        String path = null;
        if (aName != null) {
            String FileSeparator = this.isJar ? "/" : File.separator;
            String JarSeparator = this.isJar ? "!" : "";
            Enumeration en = this.resourceBuckets.objectEnumerator();
            String localePrefix = NSBundle.DefaultLocalePrefix().concat(FileSeparator);
            String[] pathFragments = new String[2];
            if (aSubDirPath == null || aSubDirPath.length() == 0) {
                pathFragments[0] = localePrefix;
                pathFragments[1] = "";
            } else {
                pathFragments[0] = _NSStringUtilities.concat(localePrefix, aSubDirPath, FileSeparator);
                pathFragments[1] = aSubDirPath.concat(FileSeparator);
            }
            while (en.hasMoreElements() && path == null) {
                String nextDir = (String)en.nextElement();
                String pathPrefix = nextDir.equals("") ? this.bundlePath.concat(FileSeparator) : _NSStringUtilities.concat(this.bundlePath, FileSeparator, nextDir, FileSeparator);
                for (int i = 0; i < pathFragments.length && path == null; ++i) {
                    String possiblePath;
                    if (this.isJar) {
                        possiblePath = _NSStringUtilities.concat(FileSeparator, pathFragments[i], aName);
                        String comparisonPath = nextDir.concat(possiblePath);
                        ZipEntry ze = this.jarFile.getEntry(comparisonPath);
                        if (ze == null) continue;
                        path = pathFragments[i].concat(aName);
                        if (pathFragments[i].startsWith(NSBundle.DefaultLocalePrefix())) continue;
                        path = NONLOCALIZED_LOCALE.concat(possiblePath);
                        continue;
                    }
                    possiblePath = pathFragments[i].equals("") ? pathPrefix.concat(aName) : _NSStringUtilities.concat(pathPrefix, pathFragments[i], aName);
                    File possibleResource = new File(possiblePath);
                    File possibleResourcePrefix = new File(pathPrefix);
                    if (possibleResource == null || !possibleResource.exists() || possibleResourcePrefix == null || !possibleResourcePrefix.exists() || !possibleResourcePrefix.isDirectory()) continue;
                    try {
                        path = possibleResource.getCanonicalPath();
                        String absolutePathPrefix = possibleResourcePrefix.getCanonicalPath();
                        if (!absolutePathPrefix.endsWith(File.separator)) {
                            absolutePathPrefix = absolutePathPrefix + File.separator;
                        }
                        if (path.startsWith(absolutePathPrefix)) {
                            path = path.substring(absolutePathPrefix.length());
                            if (!pathFragments[i].startsWith(NSBundle.DefaultLocalePrefix())) {
                                path = NONLOCALIZED_LOCALE_PREFIX.concat(path);
                            }
                            continue;
                        }
                        throw new IllegalArgumentException("<" + NSBundle.class.getName() + "> May not pass relative paths that reference resources outside of the bundle! (" + aName + "," + aSubDirPath + ")");
                    }
                    catch (IOException e) {
                        throw NSForwardException._runtimeExceptionForThrowable(e);
                    }
                }
            }
        }
        return path;
    }

    public NSArray resourcePathsForDirectories(String anExtension, String aSubDirPath) {
        NSArray list = null;
        if (this.resourceBuckets.indexOfIdenticalObject(this._resourceLocation) != -1) {
            if (this.isJar) {
                NSMutableArray entryList = new NSMutableArray();
                anExtension = this.fixExtension(anExtension);
                if (aSubDirPath == null || aSubDirPath.length() == 0) {
                    NSMutableArray allPaths = new NSMutableArray(this.resourcePathsForDirectoriesInDirectoryInJar(this._resourceLocation, anExtension, false));
                    NSArray lProjDirs = this.resourcePathsForDirectoriesInDirectoryInJar(this._resourceLocation, LPROJSUFFIX, false);
                    int count = lProjDirs.count();
                    for (int i = 0; i < count; ++i) {
                        String lProjDir = (String)lProjDirs.objectAtIndex(i);
                        allPaths.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectoryInJar(_NSStringUtilities.concat(this._resourceLocation, "/", lProjDir), anExtension, false));
                    }
                    list = allPaths;
                } else {
                    String startPath = _NSStringUtilities.concat(this._resourceLocation, "/", aSubDirPath);
                    list = this.resourcePathsForDirectoriesInDirectoryInJar(startPath, anExtension, false);
                }
            } else {
                FilenameFilter rdf = anExtension == null ? TheDirectoryFilter : NSBundle.ResourceDirectoryFilterForExtension(anExtension);
                if (aSubDirPath == null) {
                    NSMutableArray allPaths = new NSMutableArray(this.resourcePathsForDirectoriesInDirectory(this.resourcePath, rdf, false));
                    NSArray lProjDirs = this.resourcePathsForDirectoriesInDirectory(this.resourcePath, NSBundle.ResourceDirectoryFilterForExtension(LPROJSUFFIX), false);
                    int count = lProjDirs.count();
                    for (int i = 0; i < count; ++i) {
                        String lProjDir = (String)lProjDirs.objectAtIndex(i);
                        allPaths.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectory(_NSStringUtilities.concat(this.resourcePath, File.separator, lProjDir), rdf, false));
                    }
                    list = allPaths;
                } else {
                    String absolutePath = NSPathUtilities.stringByNormalizingExistingPath(_NSStringUtilities.concat(this.resourcePath, File.separator, aSubDirPath));
                    if (absolutePath.startsWith(this.resourcePath.concat(File.separator))) {
                        list = this.resourcePathsForDirectoriesInDirectory(absolutePath, rdf, false);
                    }
                }
            }
        }
        if (list == null || list.count() == 0) {
            return NSArray.EmptyArray;
        }
        return list;
    }

    public NSArray resourcePathsForLocalizedResources(String anExtension, String aSubDirPath) {
        NSMutableArray localizedPaths = null;
        NSArray returnPaths = null;
        if (this.resourceBuckets.indexOfIdenticalObject(this._resourceLocation) != -1) {
            if (this.isJar) {
                String localePrefix = NSBundle.DefaultLocalePrefix();
                String lpSuffix = "/".concat(localePrefix);
                anExtension = this.fixExtension(anExtension);
                if (aSubDirPath == null || aSubDirPath.length() == 0) {
                    localizedPaths = new NSMutableArray(this.resourcePathsForResourcesInDirectoryInJar(_NSStringUtilities.concat(this._resourceLocation, lpSuffix), anExtension, false));
                } else {
                    String startPath = _NSStringUtilities.concat(this._resourceLocation, lpSuffix, "/", aSubDirPath);
                    localizedPaths = new NSMutableArray(this.resourcePathsForResourcesInDirectoryInJar(startPath, anExtension, false));
                }
                if (aSubDirPath == null || aSubDirPath.length() == 0) {
                    String nextName;
                    boolean identicalPath;
                    int i;
                    NSMutableArray dirNames = new NSMutableArray();
                    NSMutableArray fileNames = new NSMutableArray();
                    this._simplePathsInDirectoryInJar(this._resourceLocation, "", dirNames, anExtension, fileNames);
                    int dirNamesCount = dirNames.count();
                    int fileNamesCount = fileNames.count();
                    NSMutableArray nlPaths = new NSMutableArray();
                    for (i = 0; i < fileNamesCount; ++i) {
                        identicalPath = false;
                        nextName = _NSStringUtilities.concat(localePrefix, "/", (String)fileNames.objectAtIndex(i));
                        if (localizedPaths.indexOfObject(nextName) != -1) {
                            identicalPath = true;
                        }
                        if (identicalPath) continue;
                        localizedPaths.addObject(_NSStringUtilities.concat(NONLOCALIZED_LOCALE, "/", (String)fileNames.objectAtIndex(i)));
                    }
                    for (i = 0; i < dirNamesCount; ++i) {
                        boolean useThisDir;
                        boolean bl = useThisDir = !dirNames.objectAtIndex(i).toString().endsWith(LPROJSUFFIX);
                        if (!useThisDir) continue;
                        nlPaths.addObjectsFromArray(this.resourcePathsForResourcesInDirectoryInJar(_NSStringUtilities.concat(this._resourceLocation, "/", (String)dirNames.objectAtIndex(i)), anExtension, true));
                    }
                    int nlPathsCount = nlPaths.count();
                    for (i = 0; i < nlPathsCount; ++i) {
                        identicalPath = false;
                        nextName = localePrefix.concat(((String)nlPaths.objectAtIndex(i)).substring(NONLOCALIZED_LOCALE.length()));
                        if (localizedPaths.indexOfObject(nextName) != -1) {
                            identicalPath = true;
                        }
                        if (identicalPath) continue;
                        localizedPaths.addObject(nlPaths.objectAtIndex(i));
                    }
                }
            } else {
                String localePrefix = NSBundle.DefaultLocalePrefix();
                String lpSuffix = File.separator.concat(localePrefix);
                FilenameFilter rf = anExtension == null ? TheFilesFilter : NSBundle.ResourceFilterForExtension(anExtension);
                if (aSubDirPath == null) {
                    localizedPaths = new NSMutableArray(this.resourcePathsForResourcesInDirectory(this.resourcePath.concat(lpSuffix), rf, false));
                } else {
                    String absolutePath = NSPathUtilities.stringByNormalizingExistingPath(_NSStringUtilities.concat(this.resourcePath, lpSuffix, File.separator, aSubDirPath));
                    if (absolutePath.startsWith(this.resourcePath.concat(File.separator))) {
                        localizedPaths = new NSMutableArray(this.resourcePathsForDirectoriesInDirectory(absolutePath, rf, false));
                    }
                }
                File nlSubdir = new File(this.resourcePath);
                if (aSubDirPath == null && nlSubdir != null && nlSubdir.exists() && nlSubdir.isDirectory()) {
                    String nextName;
                    boolean identicalPath;
                    int i;
                    String[] dirNames = nlSubdir.list(TheDirectoryFilter);
                    int dirNamesCount = dirNames.length;
                    String[] fileNames = nlSubdir.list(rf);
                    int fileNamesCount = fileNames.length;
                    NSMutableArray nlPaths = new NSMutableArray();
                    for (i = 0; i < fileNamesCount; ++i) {
                        identicalPath = false;
                        nextName = _NSStringUtilities.concat(localePrefix, File.separator, fileNames[i]);
                        if (localizedPaths.indexOfObject(nextName) != -1) {
                            identicalPath = true;
                        }
                        if (identicalPath) continue;
                        localizedPaths.addObject(NONLOCALIZED_LOCALE_PREFIX.concat(fileNames[i]));
                    }
                    for (i = 0; i < dirNamesCount; ++i) {
                        boolean useThisDir;
                        boolean bl = useThisDir = !dirNames[i].endsWith(LPROJSUFFIX);
                        if (!useThisDir) continue;
                        nlPaths.addObjectsFromArray(this.resourcePathsForResourcesInDirectory(_NSStringUtilities.concat(this.resourcePath, File.separator, dirNames[i]), rf, true));
                    }
                    int nlPathsCount = nlPaths.count();
                    for (i = 0; i < nlPathsCount; ++i) {
                        identicalPath = false;
                        nextName = localePrefix.concat(((String)nlPaths.objectAtIndex(i)).substring(NONLOCALIZED_LOCALE.length()));
                        if (localizedPaths.indexOfObject(nextName) != -1) {
                            identicalPath = true;
                        }
                        if (identicalPath) continue;
                        localizedPaths.addObject(nlPaths.objectAtIndex(i));
                    }
                }
            }
            returnPaths = localizedPaths == null || localizedPaths.count() == 0 ? NSArray.EmptyArray : localizedPaths;
        }
        return returnPaths;
    }

    public NSArray resourcePathsForResources(String anExtension, String aSubDirPath) {
        NSArray list = null;
        if (this.resourceBuckets.indexOfIdenticalObject(this._resourceLocation) != -1) {
            if (this.isJar) {
                anExtension = this.fixExtension(anExtension);
                if (aSubDirPath == null || aSubDirPath.length() == 0) {
                    list = this.resourcePathsForResourcesInDirectoryInJar(this._resourceLocation, anExtension, false);
                } else {
                    String startPath = _NSStringUtilities.concat(this._resourceLocation, "/", aSubDirPath);
                    boolean prependNonLocalizedLproj = aSubDirPath.indexOf(LPROJSUFFIX) == -1;
                    list = this.resourcePathsForResourcesInDirectoryInJar(startPath, anExtension, prependNonLocalizedLproj);
                }
            } else {
                FilenameFilter rf = anExtension == null ? TheFilesFilter : NSBundle.ResourceFilterForExtension(anExtension);
                if (aSubDirPath == null) {
                    list = this.resourcePathsForResourcesInDirectory(this.resourcePath, rf, false);
                } else {
                    String absolutePath = NSPathUtilities.stringByNormalizingExistingPath(_NSStringUtilities.concat(this.resourcePath, File.separator, aSubDirPath));
                    if (absolutePath.startsWith(this.resourcePath.concat(File.separator))) {
                        boolean prependNonLocalizedLproj = aSubDirPath.indexOf(LPROJSUFFIX) == -1;
                        list = this.resourcePathsForResourcesInDirectory(absolutePath, rf, prependNonLocalizedLproj);
                    }
                }
            }
        }
        if (list == null || list.count() == 0) {
            return NSArray.EmptyArray;
        }
        return list;
    }

    public String toString() {
        int count = 0;
        if (this.classNames != null) {
            count = this.classNames.count();
        }
        return "<" + this.getClass().getName() + " name:'" + this.name + "' bundlePath:'" + this.bundlePath + "' packages:'" + this.packages + "' " + count + " classes >";
    }

    private void addResourceBucket(String aBundleSubDirPath) {
        if (aBundleSubDirPath != null && this.resourceBuckets.indexOfObject(aBundleSubDirPath) == -1) {
            if (this.isJar) {
                ZipEntry ze = this.jarFile.getEntry(aBundleSubDirPath.concat("/"));
                if (ze != null && ze.isDirectory()) {
                    this.resourceBuckets.addObject(aBundleSubDirPath);
                }
                if (aBundleSubDirPath.length() == 0) {
                    this.resourceBuckets.addObject(aBundleSubDirPath);
                }
            } else {
                String resourceDirPath = _NSStringUtilities.concat(this.bundlePath, File.separator, aBundleSubDirPath);
                File resourceDir = new File(resourceDirPath);
                if (resourceDir != null && resourceDir.exists() && resourceDir.isDirectory()) {
                    this.resourceBuckets.addObject(aBundleSubDirPath);
                }
            }
        }
    }

    public Class _classWithName(String className) {
        Class objectClass = null;
        if (className == null) {
            throw new IllegalArgumentException("Class name cannot be null.");
        }
        objectClass = _NSUtilities._classWithPartialName(className, false);
        if (objectClass != null) {
            return objectClass;
        }
        NSArray packages = this.bundleClassPackageNames();
        objectClass = _NSUtilities._searchForClassInPackages(className, packages, true, false);
        return objectClass != null ? objectClass : _NSUtilities._classWithPartialName(className, true);
    }

    private NSArray classNamesFromDirectory(File aDirectory) {
        int i;
        int l;
        String[] classes = aDirectory.list(TheJavaClassFilter);
        NSMutableArray classNames = new NSMutableArray();
        String[] directories = aDirectory.list(TheDirectoryFilter);
        if (classes != null) {
            l = classes.length;
            for (i = 0; i < l; ++i) {
                String className;
                try {
                    className = _NSStringUtilities.concat(aDirectory.getCanonicalPath(), File.separator, classes[i]);
                }
                catch (IOException e) {
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
                className = this.resourcePath == this.bundlePath ? className.substring(this.resourcePath.length() + 1, className.lastIndexOf(46)) : className.substring(this.resourcePath.length() + JSUFFIX.length() + 1, className.lastIndexOf(46));
                classNames.addObject(className.replace(File.separatorChar, '.'));
            }
        }
        if (directories != null) {
            l = directories.length;
            for (i = 0; i < l; ++i) {
                File f;
                try {
                    f = new File(_NSStringUtilities.concat(aDirectory.getCanonicalPath(), File.separator, directories[i]));
                }
                catch (IOException e) {
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
                classNames.addObjectsFromArray(this.classNamesFromDirectory(f));
            }
        }
        if (classNames.count() == 0) {
            return NSArray.EmptyArray;
        }
        return classNames;
    }

    private boolean couldBeAFramework() {
        boolean isFramework = false;
        if (this.infoDictionary != null) {
            if (this.infoDictionary.objectForKey("Has_WOComponents") != null) {
                isFramework = true;
            } else {
                String value = (String)this.infoDictionary.objectForKey("CFBundlePackageType");
                if (value != null && value.equalsIgnoreCase("FMWK")) {
                    isFramework = true;
                }
            }
        }
        return isFramework;
    }

    private void initIsJar(boolean newIsJar) {
        this.isJar = newIsJar;
    }

    private void initBundlePath(String newBundlePath) {
        this.bundlePath = newBundlePath;
    }

    private void initBundleURLPrefix() {
        this._bundleURLPrefix = this.isJar ? _NSStringUtilities.concat("jar:", NSPathUtilities._fileURLPrefix, this.bundlePath, "!/") : _NSStringUtilities.concat(NSPathUtilities._fileURLPrefix, this.bundlePath, "/");
    }

    private void initJarFileLayout() {
        if (!this.isJar) {
            return;
        }
        NSMutableDictionary root = new NSMutableDictionary();
        Enumeration<JarEntry> e = this.jarFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String zePath = ze.getName();
            NSArray zeArray = NSArray.componentsSeparatedByString(zePath, "/");
            NSMutableDictionary currentDict = root;
            Enumeration e2 = zeArray.objectEnumerator();
            while (e2.hasMoreElements()) {
                String element = (String)e2.nextElement();
                if (element.length() <= 0) continue;
                NSMutableDictionary aDict = (NSMutableDictionary)currentDict.objectForKey(element);
                if (aDict == null) {
                    if (e2.hasMoreElements()) {
                        NSMutableDictionary newDict = new NSMutableDictionary();
                        currentDict.setObjectForKey(newDict, element);
                        currentDict = newDict;
                        continue;
                    }
                    currentDict.setObjectForKey(TheFileDict, element);
                    continue;
                }
                if (aDict == TheFileDict) continue;
                currentDict = aDict;
            }
        }
        this.jarFileLayout = root;
    }

    private void initBundleType() {
        if (this.isJar) {
            this.bundleType = 1;
            try {
                URL url = new URL(this._bundleURLPrefix.concat(ResourcesInfoPlist));
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                this.jarFile = jarConnection.getJarFile();
                this.jarFileEntries = new NSMutableArray();
                Enumeration<JarEntry> e = this.jarFile.entries();
                while (e.hasMoreElements()) {
                    this.jarFileEntries.addObject(e.nextElement());
                }
            }
            catch (Exception e) {
                throw NSForwardException._runtimeExceptionForThrowable(e);
            }
        } else {
            File contentsDir = new File(this.bundlePath.concat(CSUFFIX));
            this.bundleType = contentsDir.exists() ? 2 : 1;
            this.jarFile = null;
        }
    }

    private void initClassNames() {
        NSMutableSet classes = new NSMutableSet();
        this.classNames = new NSMutableArray();
        if (this.isJar) {
            if (this.jarFile != null) {
                Enumeration e = this.jarFileEntries.objectEnumerator();
                while (e.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)e.nextElement();
                    String path = entry.getName();
                    if (!path.endsWith(".class") || path.startsWith("WebServerResources") || path.startsWith(RESOURCES)) continue;
                    String nextClassName = path.substring(0, path.lastIndexOf(46));
                    nextClassName = nextClassName.replace('/', '.');
                    nextClassName = nextClassName.intern();
                    classes.addObject(nextClassName);
                }
            }
        } else {
            Enumeration en = ClassPath.objectEnumerator();
            while (en.hasMoreElements()) {
                String nextPath = (String)en.nextElement();
                if (!nextPath.startsWith(this.bundlePath)) continue;
                File f = new File(nextPath);
                if (f.isDirectory()) {
                    try {
                        if (!this.bundlePath.equals(userDirPath) && !f.getCanonicalPath().endsWith(RJSUFFIX)) continue;
                        classes.addObjectsFromArray(this.classNamesFromDirectory(f));
                    }
                    catch (IOException e) {}
                    continue;
                }
                if (!TheJavaArchiveFilter.accept(null, nextPath)) continue;
                classes.addObjectsFromArray(_NSUtilities.classNamesFromArchive(f));
            }
        }
        if (classes == null || classes.count() == 0) {
            this.classesHaveBeenLoaded = false;
            this.classNames = NSArray.EmptyArray;
        } else {
            this.classesHaveBeenLoaded = true;
            this.setClassNames(classes.allObjects());
        }
    }

    private void initInfoDictionary() {
        this.infoDictionary = NSDictionary.EmptyDictionary;
        String infoPlistPath = this._bundleURLPrefix.concat(this.bundleType == 2 ? "Contents/Info.plist" : ResourcesInfoPlist);
        try {
            URL infoDictURL = new URL(infoPlistPath);
            this.infoDictionary = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL(infoDictURL);
        }
        catch (Exception e) {
            NSLog.err.appendln("Failed to load " + infoPlistPath + ". Treating as empty. " + e);
        }
    }

    private void initName() {
        String newName = null;
        if (this.infoDictionary != null) {
            newName = (String)this.infoDictionary.objectForKey("NSExecutable");
        }
        if (newName == null && (newName = NSPathUtilities.lastPathComponent(this.bundlePath)).length() > 3) {
            newName = NSPathUtilities.stringByDeletingPathExtension(newName);
        }
        this.name = newName;
    }

    private void initPackages() {
        Enumeration en = this.classNames.objectEnumerator();
        this.packages = new NSMutableArray();
        while (en.hasMoreElements()) {
            String nextClass = (String)en.nextElement();
            String newPackage = _NSStringUtilities.stringByDeletingLastComponent(nextClass, '.');
            if (this.packages.containsObject(newPackage)) continue;
            ((NSMutableArray)this.packages).addObject(newPackage);
        }
        if (this.packages.count() == 0) {
            this.packages = NSArray.EmptyArray;
        }
    }

    private void initPrincipalClass() {
        String principalClassName = null;
        this.principalClass = null;
        if (this.infoDictionary != null && (principalClassName = (String)this.infoDictionary.objectForKey("NSPrincipalClass")) != null) {
            this.principalClass = _NSUtilities.classWithName(principalClassName);
            if (this.principalClass == null && _NSUtilities._principalClassLoadingWarningsNeeded) {
                NSLog.err.appendln("Principal class '" + principalClassName + "' not found in bundle " + this.name);
                if (NSLog.debugLoggingAllowedForLevelAndGroups(1, 32L)) {
                    NSLog.debug.appendln(new ClassNotFoundException(principalClassName));
                }
            }
        }
    }

    private static Properties initPropertiesFromInputStreamWithParent(InputStream is, Properties parent) throws IOException {
        Properties _prop = new Properties(parent);
        _prop.load(is);
        is.close();
        return _prop;
    }

    private void initProperties() {
        String propertiesPath = this._bundleURLPrefix.concat(this.bundleType == 2 ? "Contents/" + ResourcesProperties : ResourcesProperties);
        try {
            URL propertiesURL = new URL(propertiesPath);
            this.properties = NSBundle.initPropertiesFromInputStreamWithParent(propertiesURL.openStream(), null);
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (Exception e) {
            NSLog.err.appendln("Error reading properties file " + propertiesPath + ". Exception was " + e);
            NSLog.err.appendln("Ignoring this file.");
            this.properties = null;
        }
    }

    private void initResourceBuckets() {
        this.resourceBuckets = new NSMutableArray();
        if (this.isJar) {
            this._resourceLocation = RESOURCES;
            if (this.jarFile.getEntry(this._resourceLocation) != null) {
                this.addResourceBucket(this._resourceLocation);
            }
        } else {
            String resourceLocation;
            switch (this.bundleType) {
                case 1: {
                    resourceLocation = RESOURCES;
                    break;
                }
                case 2: {
                    resourceLocation = _NSStringUtilities.concat(CONTENTS, File.separator, RESOURCES);
                    break;
                }
                default: {
                    throw new IllegalStateException("Inconsistent Bundle type");
                }
            }
            File rlFile = new File(_NSStringUtilities.concat(this.bundlePath, File.separator, resourceLocation));
            if (rlFile.exists()) {
                this._resourceLocation = NSPathUtilities.stringByNormalizingExistingPath(_NSStringUtilities.concat(this.bundlePath, File.separator, resourceLocation)).substring(this.bundlePath.length() + 1);
                this.addResourceBucket(this._resourceLocation);
            } else if (this.bundleType == 2) {
                throw new IllegalStateException("Bundle at path \"" + this.bundlePath + "\" is a CFBundle, but is missing its \"Contents" + File.separator + "Resources\" subdirectory.");
            }
        }
        this.addResourceBucket("");
    }

    private void initContentsPath() {
        if (this.isJar) {
            this.contentsPath = this._bundleURLPrefix;
        } else {
            switch (this.bundleType) {
                case 1: {
                    this.contentsPath = this.bundlePath;
                    break;
                }
                case 2: {
                    File contentsDir = new File(this.bundlePath.concat(CSUFFIX));
                    if (contentsDir.exists()) {
                        try {
                            this.contentsPath = contentsDir.getCanonicalPath();
                            break;
                        }
                        catch (IOException e) {
                            throw NSForwardException._runtimeExceptionForThrowable(e);
                        }
                    }
                    this.contentsPath = this.bundlePath;
                    break;
                }
                default: {
                    throw new IllegalStateException("Inconsistent Bundle type");
                }
            }
        }
    }

    private void initResourcePath() {
        if (this.isJar) {
            this.resourcePath = this.contentsPath.concat(RESOURCES);
        } else {
            switch (this.bundleType) {
                case 1: {
                    File resourceDir = new File(this.bundlePath.concat(RSUFFIX));
                    if (resourceDir.exists()) {
                        try {
                            this.resourcePath = resourceDir.getCanonicalPath();
                            break;
                        }
                        catch (IOException e) {
                            throw NSForwardException._runtimeExceptionForThrowable(e);
                        }
                    }
                    this.resourcePath = this.bundlePath;
                    break;
                }
                case 2: {
                    File resourceDir = new File(this.bundlePath.concat(CRSUFFIX));
                    if (resourceDir.exists()) {
                        try {
                            this.resourcePath = resourceDir.getCanonicalPath();
                            break;
                        }
                        catch (IOException e) {
                            throw NSForwardException._runtimeExceptionForThrowable(e);
                        }
                    }
                    this.resourcePath = this.bundlePath;
                    break;
                }
                default: {
                    throw new IllegalStateException("Inconsistent Bundle type");
                }
            }
        }
    }

    private void postNotification() {
        NSNotificationCenter.defaultCenter().postNotification(BundleDidLoadNotification, this, new NSDictionary((Object)this.classNames, LoadedClassesNotification));
    }

    private boolean _prefixPathWithNonLocalizedPrefix(String aPath) {
        return aPath.equals(this.resourcePath);
    }

    private boolean _prefixPathWithNonLocalizedPrefixJar(String aPath) {
        return aPath.equals(this._resourceLocation);
    }

    private String fixExtension(String anExtension) {
        if (anExtension == null) {
            anExtension = "";
        } else if (anExtension.startsWith(".")) {
            anExtension = anExtension.substring(1);
        }
        return anExtension;
    }

    public void _simplePathsInDirectoryInJar(String startPath, String dirExtension, NSMutableArray dirs, String fileExtension, NSMutableArray files) {
        block5: {
            NSArray keyArray;
            NSDictionary filesDict;
            String aPath;
            block4: {
                if (startPath.length() != 0 && !startPath.equals(".") && !startPath.equals("/")) break block4;
                Enumeration e = this.jarFileLayout.keyEnumerator();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    NSDictionary value = (NSDictionary)this.jarFileLayout.objectForKey(key);
                    if (value == TheFileDict) {
                        if (!key.endsWith(fileExtension) || files == null) continue;
                        files.addObject(key);
                        continue;
                    }
                    if (!key.endsWith(dirExtension) || dirs == null) continue;
                    dirs.addObject(key);
                }
                break block5;
            }
            String string = aPath = !startPath.endsWith("/") ? startPath.concat("/") : startPath;
            if (this.jarFile.getEntry(aPath) == null || (filesDict = (NSDictionary)_NSUtilities.valueForKeyArray(this.jarFileLayout, keyArray = NSArray.componentsSeparatedByString(aPath.substring(0, aPath.length() - 1), "/"))) == null) break block5;
            Enumeration e = filesDict.keyEnumerator();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                NSDictionary value = (NSDictionary)filesDict.objectForKey(key);
                if (value == TheFileDict) {
                    if (!key.endsWith(fileExtension) || files == null) continue;
                    files.addObject(key);
                    continue;
                }
                if (!key.endsWith(dirExtension) || dirs == null) continue;
                dirs.addObject(key);
            }
        }
    }

    private NSArray resourcePathsForDirectoriesInDirectoryInJar(String startPath, String anExtension, boolean prependNonlocalizedLProj) {
        String dirName;
        int i;
        NSMutableArray returnList = new NSMutableArray();
        NSMutableArray dirNames = new NSMutableArray();
        this._simplePathsInDirectoryInJar(startPath, anExtension, dirNames, "", null);
        String prefix = this._prefixPathWithNonLocalizedPrefixJar(startPath) ? "" : startPath.substring(this._resourceLocation.concat("/").length());
        for (i = 0; i < dirNames.count(); ++i) {
            dirName = (String)dirNames.objectAtIndex(i);
            if (prefix.length() == 0) {
                if (dirName.endsWith(LPROJSUFFIX)) {
                    returnList.addObject(dirName);
                    continue;
                }
                returnList.addObject(_NSStringUtilities.concat(NONLOCALIZED_LOCALE, "/", dirName));
                continue;
            }
            if (prependNonlocalizedLProj) {
                returnList.addObject(_NSStringUtilities.concat(NONLOCALIZED_LOCALE, "/", prefix, "/", dirName));
                continue;
            }
            returnList.addObject(_NSStringUtilities.concat(prefix, "/", dirName));
        }
        for (i = 0; i < dirNames.count(); ++i) {
            dirName = (String)dirNames.objectAtIndex(i);
            if (prefix.length() == 0) {
                boolean endWithLPROJ = dirName.endsWith(LPROJSUFFIX);
                returnList.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectoryInJar(_NSStringUtilities.concat(startPath, "/", dirName), anExtension, !endWithLPROJ));
                continue;
            }
            returnList.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectoryInJar(_NSStringUtilities.concat(startPath, "/", dirName), anExtension, prependNonlocalizedLProj));
        }
        if (returnList.count() == 0) {
            return NSArray.EmptyArray;
        }
        return returnList;
    }

    private NSArray resourcePathsForDirectoriesInDirectory(String aPath, FilenameFilter aFilter, boolean prependNonlocalizedLProj) {
        int i;
        String[] dirNames = new File(aPath).list(aFilter);
        if (dirNames == null) {
            return NSArray.EmptyArray;
        }
        NSMutableArray list = new NSMutableArray();
        String prefix = this._prefixPathWithNonLocalizedPrefix(aPath) ? "" : aPath.substring(this.resourcePath.concat(File.separator).length());
        for (i = 0; i < dirNames.length; ++i) {
            if (prefix.length() == 0) {
                if (dirNames[i].endsWith(LPROJSUFFIX)) {
                    list.addObject(dirNames[i]);
                    continue;
                }
                list.addObject(NONLOCALIZED_LOCALE_PREFIX.concat(dirNames[i]));
                continue;
            }
            if (prependNonlocalizedLProj) {
                list.addObject(_NSStringUtilities.concat(NONLOCALIZED_LOCALE_PREFIX, prefix, File.separator, dirNames[i]));
                continue;
            }
            list.addObject(_NSStringUtilities.concat(prefix, File.separator, dirNames[i]));
        }
        for (i = 0; i < dirNames.length; ++i) {
            if (prefix.length() == 0) {
                boolean endWithLPROJ = dirNames[i].endsWith(LPROJSUFFIX);
                list.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectory(_NSStringUtilities.concat(aPath, File.separator, dirNames[i]), aFilter, !endWithLPROJ));
                continue;
            }
            list.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectory(_NSStringUtilities.concat(aPath, File.separator, dirNames[i]), aFilter, prependNonlocalizedLProj));
        }
        if (list.count() == 0) {
            return NSArray.EmptyArray;
        }
        return list;
    }

    private NSArray resourcePathsForResourcesInDirectoryInJar(String aPath, String anExtension, boolean prependNonlocalizedLProj) {
        int i;
        NSMutableArray returnList = new NSMutableArray();
        NSMutableArray fileNames = new NSMutableArray();
        NSMutableArray dirNames = new NSMutableArray();
        this._simplePathsInDirectoryInJar(aPath, "", dirNames, anExtension, fileNames);
        String prefix = this._prefixPathWithNonLocalizedPrefixJar(aPath) ? "" : aPath.substring(this._resourceLocation.concat("/").length());
        for (i = 0; i < fileNames.count(); ++i) {
            String fileName = (String)fileNames.objectAtIndex(i);
            if (prefix.length() == 0) {
                returnList.addObject(_NSStringUtilities.concat(NONLOCALIZED_LOCALE, "/", fileName));
                continue;
            }
            if (prependNonlocalizedLProj) {
                returnList.addObject(_NSStringUtilities.concat(NONLOCALIZED_LOCALE, "/", prefix, "/", fileName));
                continue;
            }
            returnList.addObject(_NSStringUtilities.concat(prefix, "/", fileName));
        }
        for (i = 0; i < dirNames.count(); ++i) {
            String dirName = (String)dirNames.objectAtIndex(i);
            boolean prepend = prefix.length() == 0 ? !dirName.endsWith(LPROJSUFFIX) : prependNonlocalizedLProj;
            returnList.addObjectsFromArray(this.resourcePathsForResourcesInDirectoryInJar(_NSStringUtilities.concat(aPath, "/", dirName), anExtension, prepend));
        }
        if (returnList.count() == 0) {
            return NSArray.EmptyArray;
        }
        return returnList;
    }

    private NSArray resourcePathsForResourcesInDirectory(String aPath, FilenameFilter aFilter, boolean prependNonlocalizedLProj) {
        File subdir = new File(aPath);
        String[] fileNames = subdir.list(aFilter);
        if (fileNames == null) {
            return NSArray.EmptyArray;
        }
        String prefix = this._prefixPathWithNonLocalizedPrefix(aPath) ? "" : aPath.substring(this.resourcePath.concat(File.separator).length());
        NSMutableArray list = new NSMutableArray();
        for (int i = 0; i < fileNames.length; ++i) {
            if (prefix.length() == 0) {
                list.addObject(NONLOCALIZED_LOCALE_PREFIX.concat(fileNames[i]));
                continue;
            }
            if (prependNonlocalizedLProj) {
                list.addObject(_NSStringUtilities.concat(NONLOCALIZED_LOCALE_PREFIX, prefix, File.separator, fileNames[i]));
                continue;
            }
            list.addObject(_NSStringUtilities.concat(prefix, File.separator, fileNames[i]));
        }
        String[] dirNames = subdir.list(TheDirectoryFilter);
        for (int i = 0; i < dirNames.length; ++i) {
            boolean prepend = prefix.length() == 0 ? !dirNames[i].endsWith(LPROJSUFFIX) : prependNonlocalizedLProj;
            list.addObjectsFromArray(this.resourcePathsForResourcesInDirectory(_NSStringUtilities.concat(aPath, File.separator, dirNames[i]), aFilter, prepend));
        }
        if (list.count() == 0) {
            return NSArray.EmptyArray;
        }
        return list;
    }

    private void setClassNames(NSArray classes) {
        if (classes != null) {
            Enumeration en = classes.objectEnumerator();
            while (en.hasMoreElements()) {
                String nextClassName = (String)en.nextElement();
                if (this.classNames.containsObject(nextClassName)) continue;
                ((NSMutableArray)this.classNames).addObject(nextClassName);
                NSBundle bundle = (NSBundle)BundlesClassesTable.objectForKey(nextClassName);
                if (bundle != null) continue;
                BundlesClassesTable.setObjectForKey(this, nextClassName);
            }
        }
    }

    static {
        JSUFFIX = File.separator + "Java";
        NONLOCALIZED_LOCALE_PREFIX = NONLOCALIZED_LOCALE + File.separator;
        RSUFFIX = File.separator + RESOURCES;
        RJSUFFIX = RSUFFIX + File.separator + "Java";
        RPSUFFIX = RSUFFIX + File.separator + "Properties";
        CSUFFIX = File.separator + CONTENTS;
        CRSUFFIX = CSUFFIX + RSUFFIX;
        CRJSUFFIX = CRSUFFIX + File.separator + "Java";
        CRPSUFFIX = CRSUFFIX + File.separator + "Properties";
        AllBundles = new NSMutableArray(64);
        AllBundlesReally = new NSMutableArray(64);
        AllFrameworks = new NSMutableArray(64);
        BundlesClassesTable = new NSMutableDictionary(2048);
        BundlesNamesTable = new NSMutableDictionary(16);
        AppBundlesNamesTable = new NSMutableDictionary(1);
        OldResourceFilters = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
        ResourceDirectoryFilters = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
        ResourceFilters = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
        TheDirectoryFilter = new DirectoryFilter();
        TheFilesFilter = new FilesFilter();
        TheInfoDictFilter = new InfoDictFilter();
        TheJavaArchiveFilter = new _NSUtilities.JavaArchiveFilter();
        TheJavaClassFilter = new _NSUtilities.JavaClassFilter();
        ResourcesInfoPlist = "Resources/Info.plist";
        JarResourcesInfoPlist = "!/" + ResourcesInfoPlist;
        ResourcesProperties = "Resources/Properties";
        TheFileDict = new NSMutableDictionary(1);
        safeInvokeDeprecatedJarBundleAPI = false;
        try {
            String component;
            int i;
            safeInvokeDeprecatedJarBundleAPI = NSProperties.booleanForKey("com.webobjects.safeInvokeDeprecatedJarBundleAPI");
            String woUserDir = NSProperties.getProperty("webobjects.user.dir");
            if (woUserDir == null) {
                woUserDir = System.getProperty("user.dir");
            }
            userDirPath = new File(woUserDir).getCanonicalPath();
            ClassLoader cl = _CLASS.getClassLoader();
            Enumeration<URL> e = cl.getResources(ResourcesInfoPlist);
            NSMutableArray urlArray = new NSMutableArray();
            String jarEndsWithString = ".jar".concat(JarResourcesInfoPlist);
            while (e.hasMoreElements()) {
                try {
                    URL url = e.nextElement();
                    String urlPath = url.getPath();
                    String url2Path = null;
                    if (urlPath.endsWith(jarEndsWithString)) {
                        url2Path = urlPath.substring(0, urlPath.length() - JarResourcesInfoPlist.length());
                        URL url2 = new URL(url2Path);
                        url2Path = url2.getPath();
                    }
                    if (url2Path == null) continue;
                    urlArray.addObject(url2Path);
                }
                catch (Exception urlException) {}
            }
            NSBundle.LoadBundlesFromJars(urlArray);
            NSMutableArray classpath = NSArray._mutableComponentsSeparatedByString(System.getProperty("java.class.path") + File.pathSeparator + NSProperties.getProperty("com.webobjects.classpath"), File.pathSeparator);
            for (i = classpath.count() - 1; i >= 0; --i) {
                component = (String)classpath.objectAtIndex(i);
                String fixedComponent = NSPathUtilities.stringByNormalizingExistingPath(component);
                if (fixedComponent == null || fixedComponent.length() == 0) {
                    classpath.removeObjectAtIndex(i);
                    continue;
                }
                classpath.replaceObjectAtIndex(fixedComponent, i);
            }
            for (i = classpath.count() - 1; i >= 0; --i) {
                component = (String)classpath.objectAtIndex(i);
                if (classpath.indexOfObject(component) == i) continue;
                classpath.removeObjectAtIndex(i);
            }
            ClassPath = classpath;
            NSBundle.LoadBundlesFromClassPath(ClassPath);
            NSBundle.InitMainBundle();
            NSBundle.LoadUserAndBundleProperties();
            NSBundle.InitPrincipalClasses();
            _NSUtilities._setResourceSearcher(new _NSUtilities._ResourceSearcher(){

                public Class _searchForClassWithName(String className) {
                    return NSBundle.searchAllBundlesForClassWithName(className);
                }

                public URL _searchPathURLForResourceWithName(Class resourceClass, String resourceName, String extension) {
                    URL url = null;
                    NSBundle bundle = NSBundle.bundleForClass(resourceClass);
                    if (bundle != null && resourceName != null) {
                        String fileName = null;
                        fileName = extension == null || extension.length() == 0 ? resourceName : (extension.startsWith(".") || resourceName.endsWith(".") ? resourceName.concat(extension) : _NSStringUtilities.concat(resourceName, ".", extension));
                        bundle.pathURLForResourcePath(bundle.resourcePathForLocalizedResourceNamed(fileName, ""));
                    }
                    return url;
                }
            });
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
    }

    private static class SpecificResourceFilter
    implements FilenameFilter {
        private String name;

        public SpecificResourceFilter(String aName) {
            this.name = aName + ".";
        }

        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && aName.startsWith(this.name)) {
                result = true;
            }
            return result;
        }
    }

    private static class ResourceFilter
    implements FilenameFilter {
        private String extension;

        public ResourceFilter(String anExtension) {
            this.extension = "." + anExtension;
        }

        public boolean accept(File dir, String aName) {
            File f;
            boolean result = false;
            if (aName != null && (f = new File(dir, aName)) != null && f.isFile() && aName.endsWith(this.extension)) {
                result = true;
            }
            return result;
        }
    }

    private static class ResourceDirectoryFilter
    implements FilenameFilter {
        private String extension;

        public ResourceDirectoryFilter(String anExtension) {
            this.extension = "." + anExtension;
        }

        public boolean accept(File dir, String aName) {
            File d;
            boolean result = false;
            if (aName != null && (d = new File(dir + File.separator + aName)) != null && d.isDirectory() && aName.endsWith(this.extension)) {
                result = true;
            }
            return result;
        }
    }

    private static class OldResourceFilter
    implements FilenameFilter {
        private String extension;

        public OldResourceFilter(String anExtension) {
            this.extension = "." + anExtension;
        }

        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && aName.endsWith(this.extension)) {
                result = true;
            }
            return result;
        }
    }

    private static class InfoDictFilter
    implements FilenameFilter {
        private static final String INFO_DICT_NAME = "Info.plist";

        private InfoDictFilter() {
        }

        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && aName.equals(INFO_DICT_NAME)) {
                result = true;
            }
            return result;
        }
    }

    private static class FilesFilter
    implements FilenameFilter {
        private FilesFilter() {
        }

        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null) {
                File namedFile = new File(dir, aName);
                result = namedFile.isFile();
            }
            return result;
        }
    }

    private static class DirectoryFilter
    implements FilenameFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null) {
                File namedFile = new File(dir, aName);
                result = namedFile.isDirectory();
            }
            return result;
        }
    }
}

