/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSUtilities;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public class NSDelayedCallbackCenter {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSDelayedCallbackCenter");
    private static volatile _Delegate _delegate;
    private static final WeakHashMap _centers;
    private static volatile WeakReference _lastThread;
    private static volatile NSDelayedCallbackCenter _lastCenter;
    private final NSMutableArray _queue = new NSMutableArray(32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSDelayedCallbackCenter defaultCenter() {
        NSDelayedCallbackCenter center;
        Thread currentThread = Thread.currentThread();
        WeakHashMap weakHashMap = _centers;
        synchronized (weakHashMap) {
            Thread last;
            Thread thread = last = _lastThread != null ? (Thread)_lastThread.get() : null;
            if (last == currentThread) {
                center = _lastCenter;
            } else {
                center = (NSDelayedCallbackCenter)_centers.get(currentThread);
                if (center == null) {
                    center = new NSDelayedCallbackCenter();
                    _centers.put(currentThread, center);
                }
                _lastThread = new WeakReference<Thread>(currentThread);
                _lastCenter = center;
            }
        }
        return center;
    }

    public static void _setDelegate(_Delegate newDelegate) {
        if (_delegate != null) {
            throw new IllegalStateException("_setDelegate can only be called once!");
        }
        _delegate = newDelegate;
    }

    public static _Delegate _delegate() {
        return _delegate;
    }

    private NSDelayedCallbackCenter() {
    }

    public void performSelector(NSSelector selector, Object target, Object argument, int order) {
        NSLightInvocation invocation;
        int i;
        int count = this._queue.count();
        for (i = 0; i < count && (invocation = (NSLightInvocation)this._queue.objectAtIndex(i)).order() <= order; ++i) {
        }
        invocation = new NSLightInvocation(selector, target, argument, order);
        this._queue.insertObjectAtIndex(invocation, i);
        if (_delegate != null) {
            _delegate._delayedCallbackCenterWillNeedEndOfEventNotification(this);
        }
    }

    public void cancelPerformSelector(NSSelector selector, Object target, Object argument) {
        if (this._queue.count() > 0) {
            NSLightInvocation invocation = new NSLightInvocation(selector, target, argument);
            this._queue.removeObject(invocation);
        }
    }

    public void _cancelAllActionsWithTarget(Object obj) {
        int i = 0;
        while (this._queue.count() > 0 && i < this._queue.count()) {
            NSLightInvocation nslightinvocation = (NSLightInvocation)this._queue.objectAtIndex(i);
            if (nslightinvocation.target().equals(obj)) {
                this._queue.removeObjectAtIndex(i);
                continue;
            }
            ++i;
        }
    }

    public void eventEnded() {
        if (_delegate == null || _delegate._delayedCallbackCenterShouldHandleEndOfEvent(this)) {
            this._eventEnded();
        }
    }

    public void _eventEnded() {
        NSMutableArray invocations = new NSMutableArray(32);
        int i = 0;
        int currentPriority = 0;
        int lastPriority = -1;
        if (_delegate != null) {
            _delegate._delayedCallbackCenterWillHandleEndOfEvent(this);
        }
        while (i < this._queue.count()) {
            NSLightInvocation inv;
            while (i < this._queue.count() && (currentPriority = ((NSLightInvocation)this._queue.objectAtIndex(i)).order()) <= lastPriority) {
                ++i;
            }
            while (i < this._queue.count() && (inv = (NSLightInvocation)this._queue.objectAtIndex(i)).order() == currentPriority) {
                this._queue.removeObjectAtIndex(i);
                invocations.addObject(inv);
            }
            for (int j = 0; j < invocations.count(); ++j) {
                ((NSLightInvocation)invocations.objectAtIndex(j)).invoke();
            }
            invocations.removeAllObjects();
            lastPriority = currentPriority;
        }
    }

    static {
        _centers = new WeakHashMap(8);
    }

    private static class NSLightInvocation {
        protected final Object _target;
        protected final NSSelector _selector;
        protected final Object _argument;
        protected final int _order;

        public NSLightInvocation(NSSelector newSelector, Object newTarget, Object newArgument, int newOrder) {
            this._target = newTarget;
            this._selector = newSelector;
            this._argument = newArgument;
            this._order = newOrder;
        }

        public NSLightInvocation(NSSelector newSelector, Object newTarget, Object newArgument) {
            this(newSelector, newTarget, newArgument, 0);
        }

        public Object target() {
            return this._target;
        }

        public boolean equals(Object other) {
            NSLightInvocation invocation = (NSLightInvocation)other;
            return this.target() == invocation.target() && (this._selector == invocation._selector || this._selector.equals(invocation._selector)) && this._argument == invocation._argument;
        }

        public void invoke() {
            NSSelector._safeInvokeSelector(this._selector, this.target(), new Object[]{this._argument});
        }

        public int order() {
            return this._order;
        }

        public int hashCode() {
            return this._selector != null ? this._selector.hashCode() : 0;
        }
    }

    public static interface _Delegate {
        public void _delayedCallbackCenterWillNeedEndOfEventNotification(NSDelayedCallbackCenter var1);

        public boolean _delayedCallbackCenterShouldHandleEndOfEvent(NSDelayedCallbackCenter var1);

        public void _delayedCallbackCenterWillHandleEndOfEvent(NSDelayedCallbackCenter var1);
    }
}

