/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSCollectionEnumerator;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSFoundationCollection;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NSDictionary
implements Cloneable,
Serializable,
NSCoding,
NSKeyValueCoding,
NSKeyValueCodingAdditions,
_NSFoundationCollection,
Map {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime("com.webobjects.foundation.NSDictionary");
    public static final Class _MAP_ENTRY_CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime("com.webobjects.foundation.NSDictionary$_JavaNSDictionaryMapEntry");
    public static final NSDictionary EmptyDictionary = new NSDictionary();
    static final long serialVersionUID = 2886170486405617806L;
    private static final String SerializationKeysFieldKey = "keys";
    private static final String SerializationValuesFieldKey = "objects";
    private static final Class _objectArrayClass = new Object[0].getClass();
    protected transient int _capacity;
    protected transient int _hashtableBuckets;
    protected transient int _count;
    protected Object[] _objects;
    protected transient Object[] _objectsCache;
    protected transient byte[] _flags;
    protected Object[] _keys;
    protected transient Object[] _keysCache;
    protected transient int _hashCache;
    protected transient int _deletionLimit;
    protected static int _NSDictionaryClassHashCode = _CLASS.hashCode();
    protected static int _NSDictionaryMapEntryHashCode = _MAP_ENTRY_CLASS.hashCode();
    protected NSSet _keySetCache;
    protected NSSet _entrySetCache;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("keys", _objectArrayClass), new ObjectStreamField("objects", _objectArrayClass)};

    private void _copyImmutableDictionary(NSDictionary otherDictionary) {
        this._capacity = otherDictionary._capacity;
        this._count = otherDictionary._count;
        this._hashtableBuckets = otherDictionary._hashtableBuckets;
        this._hashCache = otherDictionary._hashCache;
        this._objects = otherDictionary._objects;
        this._objectsCache = otherDictionary._objectsCache;
        this._flags = otherDictionary._flags;
        this._keys = otherDictionary._keys;
        this._keysCache = otherDictionary._keysCache;
        this._deletionLimit = otherDictionary._deletionLimit;
    }

    void _copyMutableDictionary(NSDictionary otherDictionary) {
        this._capacity = otherDictionary._capacity;
        this._count = otherDictionary._count;
        this._hashtableBuckets = otherDictionary._hashtableBuckets;
        this._hashCache = otherDictionary._hashCache;
        this._objects = _NSCollectionPrimitives.copyArray(otherDictionary._objects);
        this._objectsCache = null;
        this._flags = _NSCollectionPrimitives.copyArray(otherDictionary._flags);
        this._keys = _NSCollectionPrimitives.copyArray(otherDictionary._keys);
        this._keysCache = null;
        this._deletionLimit = otherDictionary._deletionLimit;
    }

    protected void _initializeDictionary() {
        this._count = 0;
        this._capacity = 0;
        this._objectsCache = null;
        this._objects = null;
        this._flags = null;
        this._keysCache = null;
        this._keys = null;
        this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity(this._capacity);
        this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(this._hashtableBuckets);
        this._keySetCache = null;
        this._entrySetCache = null;
    }

    protected void _ensureCapacity(int capacity) {
        int newCapacity;
        int currentCapacity = this._capacity;
        if (capacity > currentCapacity && (newCapacity = _NSCollectionPrimitives.hashTableCapacityForCapacity(capacity)) != currentCapacity) {
            int newSize;
            int oldSize = this._hashtableBuckets;
            this._hashtableBuckets = newSize = _NSCollectionPrimitives.hashTableBucketsForCapacity(newCapacity);
            if (newSize == 0) {
                this._objects = null;
                this._keys = null;
                this._flags = null;
            } else {
                Object[] oldObjects = this._objects;
                Object[] oldKeys = this._keys;
                byte[] oldFlags = this._flags;
                Object[] newObjects = new Object[newSize];
                Object[] newKeys = new Object[newSize];
                byte[] newFlags = new byte[newSize];
                for (int i = 0; i < oldSize; ++i) {
                    if ((oldFlags[i] & 0xFFFFFFC0) != -128) continue;
                    _NSCollectionPrimitives.addValueInHashTable(oldKeys[i], oldObjects[i], newKeys, newObjects, newFlags);
                }
                this._objects = newObjects;
                this._keys = newKeys;
                this._flags = newFlags;
            }
            this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(newSize);
            this._capacity = newCapacity;
        }
    }

    protected void _clearDeletionsAndCollisions() {
        int size = this._hashtableBuckets;
        if (this._count == 0) {
            this._flags = new byte[size];
        } else {
            Object[] oldObjects = this._objects;
            Object[] oldKeys = this._keys;
            byte[] oldFlags = this._flags;
            Object[] newObjects = new Object[size];
            Object[] newKeys = new Object[size];
            byte[] newFlags = new byte[size];
            int capacity = this._capacity;
            for (int i = 0; i < size; ++i) {
                if ((oldFlags[i] & 0xFFFFFFC0) != -128) continue;
                _NSCollectionPrimitives.addValueInHashTable(oldKeys[i], oldObjects[i], newKeys, newObjects, newFlags);
            }
        }
        this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(size);
    }

    public NSDictionary() {
        this._initializeDictionary();
    }

    public NSDictionary(Object object, Object key) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null object into an  " + this.getClass().getName() + ".");
        }
        if (key == null) {
            throw new IllegalArgumentException("Attempt to insert null key into an  " + this.getClass().getName() + ".");
        }
        this._initializeDictionary();
        this._ensureCapacity(1);
        if (_NSCollectionPrimitives.addValueInHashTable(key, object, this._keys, this._objects, this._flags)) {
            ++this._count;
        }
    }

    private void initFromKeyValues(Object[] objects, Object[] keys, boolean checkForNull) {
        if (objects != null && keys != null) {
            int i;
            if (objects.length != keys.length) {
                throw new IllegalArgumentException("Attempt to create an " + this.getClass().getName() + " with a different number of objects and keys.");
            }
            if (checkForNull) {
                for (i = 0; i < objects.length; ++i) {
                    if (objects[i] == null) {
                        throw new IllegalArgumentException("Attempt to insert null object into an  " + this.getClass().getName() + ".");
                    }
                    if (keys[i] != null) continue;
                    throw new IllegalArgumentException("Attempt to insert null key into an  " + this.getClass().getName() + ".");
                }
            }
            this._initializeDictionary();
            this._ensureCapacity(objects.length);
            for (i = 0; i < objects.length; ++i) {
                if (!_NSCollectionPrimitives.addValueInHashTable(keys[i], objects[i], this._keys, this._objects, this._flags)) continue;
                ++this._count;
            }
        } else if (objects == null && keys == null) {
            this._initializeDictionary();
        } else {
            throw new IllegalArgumentException("Both objects and keys cannot be null");
        }
    }

    private NSDictionary(Object[] objects, Object[] keys, boolean checkForNull) {
        this.initFromKeyValues(objects, keys, checkForNull);
    }

    public NSDictionary(Object[] objects, Object[] keys) {
        this(objects, keys, true);
    }

    public NSDictionary(NSArray objects, NSArray keys) {
        this(objects != null ? objects.objectsNoCopy() : null, keys != null ? keys.objectsNoCopy() : null, false);
    }

    public NSDictionary(NSDictionary otherDictionary) {
        if (otherDictionary.getClass() == _CLASS) {
            this._copyImmutableDictionary(otherDictionary);
        } else {
            this._copyMutableDictionary(otherDictionary);
        }
    }

    public NSDictionary(Map map, boolean ignoreNull) {
        this._initializeDictionary();
        if (map != null) {
            this._ensureCapacity(map.size());
            Set keySet = map.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object object = map.get(key);
                if (key == null) {
                    if (ignoreNull) continue;
                    throw new IllegalArgumentException("Attempt to insert null key into an  " + this.getClass().getName() + ".");
                }
                if (object == null) {
                    if (ignoreNull) continue;
                    throw new IllegalArgumentException("Attempt to insert null value into an  " + this.getClass().getName() + ".");
                }
                if (!_NSCollectionPrimitives.addValueInHashTable(key, object, this._keys, this._objects, this._flags)) continue;
                ++this._count;
            }
        }
    }

    public NSDictionary(Dictionary dictionary, boolean ignoreNull) {
        this._initializeDictionary();
        if (dictionary != null) {
            this._ensureCapacity(dictionary.size());
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                Object object = dictionary.get(key);
                if (key == null) {
                    if (ignoreNull) continue;
                    throw new IllegalArgumentException("Attempt to insert null key into an  " + this.getClass().getName() + ".");
                }
                if (object == null) {
                    if (ignoreNull) continue;
                    throw new IllegalArgumentException("Attempt to insert null value into an  " + this.getClass().getName() + ".");
                }
                if (!_NSCollectionPrimitives.addValueInHashTable(key, object, this._keys, this._objects, this._flags)) continue;
                ++this._count;
            }
        }
    }

    protected Object[] keysNoCopy() {
        if (this._keysCache == null) {
            this._keysCache = this._count == 0 ? _NSCollectionPrimitives.EmptyArray : _NSCollectionPrimitives.keysInHashTable(this._keys, this._objects, this._flags, this._capacity, this._hashtableBuckets);
        }
        return this._keysCache;
    }

    protected Object[] objectsNoCopy() {
        if (this._objectsCache == null) {
            this._objectsCache = this._count == 0 ? _NSCollectionPrimitives.EmptyArray : _NSCollectionPrimitives.valuesInHashTable(this._keys, this._objects, this._flags, this._capacity, this._hashtableBuckets);
        }
        return this._objectsCache;
    }

    public int count() {
        return this._count;
    }

    public Object objectForKey(Object key) {
        return this._count == 0 || key == null ? null : _NSCollectionPrimitives.findValueInHashTable(key, this._keys, this._objects, this._flags);
    }

    public Hashtable hashtable() {
        Object[] keys = this.keysNoCopy();
        int c = keys.length;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(c > 0 ? c : 1);
        for (int i = 0; i < c; ++i) {
            hashtable.put(keys[i], this.objectForKey(keys[i]));
        }
        return hashtable;
    }

    public HashMap hashMap() {
        Object[] keys = this.keysNoCopy();
        int c = keys.length;
        HashMap<Object, Object> map = new HashMap<Object, Object>(c > 0 ? c : 1);
        for (int i = 0; i < c; ++i) {
            map.put(keys[i], this.objectForKey(keys[i]));
        }
        return map;
    }

    public NSArray allKeysForObject(Object object) {
        if (object != null) {
            Object[] keys = this.keysNoCopy();
            NSMutableArray array = new NSMutableArray(keys.length);
            for (int i = 0; i < keys.length; ++i) {
                Object compareObject = this.objectForKey(keys[i]);
                if (object != compareObject && !object.equals(compareObject)) continue;
                array.addObject(keys[i]);
            }
            return array;
        }
        return NSArray.EmptyArray;
    }

    public NSArray objectsForKeys(NSArray keys, Object notFoundMarker) {
        if (keys != null) {
            Object[] keysArray = keys.objectsNoCopy();
            NSMutableArray array = new NSMutableArray(keysArray.length);
            for (int i = 0; i < keysArray.length; ++i) {
                Object object = this.objectForKey(keysArray[i]);
                if (object != null) {
                    array.addObject(object);
                    continue;
                }
                if (notFoundMarker == null) continue;
                array.addObject(notFoundMarker);
            }
            return array;
        }
        return NSArray.EmptyArray;
    }

    private boolean _equalsDictionary(NSDictionary otherDictionary) {
        int count = this.count();
        if (count != otherDictionary.count()) {
            return false;
        }
        Object[] keys = this.keysNoCopy();
        for (int i = 0; i < count; ++i) {
            Object value = this.objectForKey(keys[i]);
            Object otherValue = otherDictionary.objectForKey(keys[i]);
            if (otherValue != null && value.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualToDictionary(NSDictionary otherDictionary) {
        if (otherDictionary == null) {
            return false;
        }
        if (otherDictionary == this) {
            return true;
        }
        return this._equalsDictionary(otherDictionary);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NSDictionary) {
            return this._equalsDictionary((NSDictionary)object);
        }
        return false;
    }

    public NSArray allKeys() {
        return new NSArray(this.keysNoCopy());
    }

    public NSArray allValues() {
        return new NSArray(this.objectsNoCopy());
    }

    public Enumeration keyEnumerator() {
        return new _NSCollectionEnumerator(this._keys, this._flags, this._count);
    }

    public Enumeration objectEnumerator() {
        return new _NSCollectionEnumerator(this._objects, this._flags, this._count);
    }

    public Object valueForKey(String key) {
        Object value = this.objectForKey(key);
        if (value == null && key != null) {
            if (key.equals("allValues")) {
                return this.allValues();
            }
            if (key.equals("allKeys")) {
                return this.allKeys();
            }
            if (key.equals("count")) {
                return _NSUtilities.IntegerForInt(this.count());
            }
        }
        return value;
    }

    public void takeValueForKey(Object value, String key) {
        throw new IllegalStateException(this.getClass().getName() + " is immutable.");
    }

    public Object valueForKeyPath(String keyPath) {
        Object flattenedKeyPresent = this.objectForKey(keyPath);
        if (flattenedKeyPresent != null) {
            return flattenedKeyPresent;
        }
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath(this, keyPath);
    }

    public void takeValueForKeyPath(Object value, String keyPath) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath(this, value, keyPath);
    }

    public Class classForCoder() {
        return _CLASS;
    }

    public static Object decodeObject(NSCoder coder) {
        int count = coder.decodeInt();
        Object[] keys = new Object[count];
        Object[] objects = new Object[count];
        for (int i = 0; i < count; ++i) {
            keys[i] = coder.decodeObject();
            objects[i] = coder.decodeObject();
        }
        return new NSDictionary(objects, keys);
    }

    public void encodeWithCoder(NSCoder coder) {
        int count = this.count();
        coder.encodeInt(count);
        if (count > 0) {
            Object[] keys = this.keysNoCopy();
            for (int i = 0; i < keys.length; ++i) {
                coder.encodeObject(keys[i]);
                coder.encodeObject(this.objectForKey(keys[i]));
            }
        }
    }

    public int _shallowHashCode() {
        return _NSDictionaryClassHashCode;
    }

    public int hashCode() {
        return _NSDictionaryClassHashCode ^ this.count();
    }

    public Object clone() {
        return this;
    }

    public NSDictionary immutableClone() {
        return this;
    }

    public NSMutableDictionary mutableClone() {
        return new NSMutableDictionary(this);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("{");
        Object[] keys = this.keysNoCopy();
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Object object = this.objectForKey(key);
            buffer.append(key.toString());
            buffer.append(" = ");
            if (object instanceof String) {
                buffer.append('\"');
                buffer.append((String)object);
                buffer.append('\"');
            } else if (object instanceof Boolean) {
                buffer.append((Boolean)object != false ? "true" : "false");
            } else {
                buffer.append(object.toString());
            }
            buffer.append("; ");
        }
        buffer.append("}");
        return new String(buffer);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        Object[] keys = this.keysNoCopy();
        int c = keys.length;
        Object[] values = new Object[c];
        for (int i = 0; i < c; ++i) {
            values[i] = this.objectForKey(keys[i]);
        }
        fields.put(SerializationKeysFieldKey, keys);
        fields.put(SerializationValuesFieldKey, values);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] keys = (Object[])fields.get(SerializationKeysFieldKey, _NSUtilities._NoObjectArray);
        Object[] values = (Object[])fields.get(SerializationValuesFieldKey, _NSUtilities._NoObjectArray);
        keys = keys == null ? _NSUtilities._NoObjectArray : keys;
        values = values == null ? _NSUtilities._NoObjectArray : values;
        this.initFromKeyValues(values, keys, true);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == _CLASS && this.count() == 0) {
            return EmptyDictionary;
        }
        return this;
    }

    public int size() {
        return this._count;
    }

    public boolean isEmpty() {
        return this._count <= 0;
    }

    public boolean containsKey(Object key) {
        if (key != null) {
            Object[] keys = this.keysNoCopy();
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (value != null || this._count != 0) {
            Object[] values = _NSCollectionPrimitives.valuesInHashTable(this._keys, this._objects, this._flags, this._capacity, this._hashtableBuckets);
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public Object get(Object key) {
        return this.objectForKey(key);
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException("put is not a supported operation in com.webobjects.foundation.NSDictionary");
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("remove is not a supported operation in com.webobjects.foundation.NSDictionary");
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException("putAll is not a supported operation in com.webobjects.foundation.NSDictionary");
    }

    public void clear() {
        throw new UnsupportedOperationException("putAll is not a supported operation in com.webobjects.foundation.NSDictionary");
    }

    public Set keySet() {
        if (this._keySetCache == null) {
            Object[] currKeys = this.keysNoCopy();
            this._keySetCache = currKeys != null && currKeys.length > 0 ? new NSSet(currKeys) : NSSet.EmptySet;
        }
        return this._keySetCache;
    }

    public Collection values() {
        return this.allValues();
    }

    public Set entrySet() {
        if (this._entrySetCache == null) {
            return this._initMapEntrySet();
        }
        return this._entrySetCache;
    }

    private Set _initMapEntrySet() {
        Object[] keys = this.keysNoCopy();
        Object[] set = new _JavaNSDictionaryMapEntry[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Object object = this.valueForKey((String)key);
            _JavaNSDictionaryMapEntry current = new _JavaNSDictionaryMapEntry(key, object);
            set[i] = current;
        }
        return new NSSet(set);
    }

    public class _JavaNSDictionaryMapEntry
    implements Map.Entry {
        Object _entryValue;
        Object _entryKey;

        public _JavaNSDictionaryMapEntry(Object key, Object value) {
            this._entryKey = key;
            this._entryValue = value;
        }

        public Object getKey() {
            return this._entryKey;
        }

        public Object getValue() {
            return this._entryValue;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("setValue is not a supported operation in _JavaNSDictionaryMapEntry");
        }

        public boolean equals(Object o) {
            return this._entryKey == null && ((Map.Entry)o).getKey() == null && this.getKey().equals(((Map.Entry)o).getKey()) && this.getValue().equals(((Map.Entry)o).getValue());
        }

        public int hashCode() {
            return _NSDictionaryMapEntryHashCode;
        }
    }
}

