/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation._NSArrayUtilities;
import com.webobjects.foundation._NSStringUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;

public final class _NSDictionaryUtilities {
    public static NSDictionary extractObjectsForKeysWithPrefix(NSMutableDictionary self, String prefix, boolean removePrefix) {
        if (prefix == null) {
            return null;
        }
        String key = null;
        int prefixLength = prefix.length();
        NSArray keys = self.allKeys();
        NSMutableDictionary result = new NSMutableDictionary(8);
        int c = keys.count();
        for (int i = 0; i < c; ++i) {
            key = (String)keys.objectAtIndex(i);
            if (!key.startsWith(prefix)) continue;
            Object target = self.removeObjectForKey(key);
            result.setObjectForKey(target, removePrefix ? key.substring(prefixLength) : key);
        }
        return result;
    }

    public static NSMutableDictionary mutableValuesForKeys(NSDictionary object, NSArray keys) {
        if (keys == null) {
            return new NSMutableDictionary(0);
        }
        int count = keys.count();
        NSMutableDictionary values = new NSMutableDictionary(count);
        for (int i = 0; i < count; ++i) {
            String key = (String)keys.objectAtIndex(i);
            Object value = object.valueForKey(key);
            if (value == null) {
                value = NSKeyValueCoding.NullValue;
            }
            values.setObjectForKey(value, key);
        }
        return values;
    }

    public static void translateFromKeysToKeys(NSMutableDictionary dic, NSArray currentKeys, NSArray newKeys) {
        Object value;
        int i;
        int count = currentKeys.count();
        if (count != newKeys.count()) {
            throw new IllegalStateException("translateFromKeysToKeys: key arrays must contain equal number of keys");
        }
        Object nullPlaceholder = new Object();
        NSMutableArray holder = new NSMutableArray(count);
        for (i = 0; i < count; ++i) {
            Object key = currentKeys.objectAtIndex(i);
            value = dic.removeObjectForKey(key);
            if (value == null) {
                value = nullPlaceholder;
            }
            holder.addObject(value);
        }
        dic.removeAllObjects();
        for (i = 0; i < count; ++i) {
            value = holder.objectAtIndex(i);
            if (value == nullPlaceholder) continue;
            dic.setObjectForKey(value, newKeys.objectAtIndex(i));
        }
    }

    public static boolean boolValueForKeyDefault(NSDictionary dic, String key, boolean defaultBool) {
        String value = (String)dic.objectForKey(key);
        if (value == null) {
            return defaultBool;
        }
        return value.equals("YES");
    }

    public static NSMutableDictionary mutablePropertyList(NSDictionary dic) {
        int count = dic.count();
        Object[] objects = new Object[count];
        Object[] keys = new String[count];
        Enumeration keyEnumerator = dic.keyEnumerator();
        int k = 0;
        while (keyEnumerator.hasMoreElements()) {
            String key = (String)keyEnumerator.nextElement();
            keys[k] = key;
            objects[k] = dic.objectForKey(key);
            if (objects[k] instanceof NSDictionary) {
                objects[k] = _NSDictionaryUtilities.mutablePropertyList((NSDictionary)objects[k]);
            } else if (objects[k] instanceof NSArray) {
                objects[k] = _NSArrayUtilities.mutablePropertyList((NSArray)objects[k]);
            }
            ++k;
        }
        NSMutableDictionary dictionary = new NSMutableDictionary(objects, keys);
        return dictionary;
    }

    public static boolean writeToFile(NSDictionary dic, String path) {
        boolean returnValue;
        block2: {
            returnValue = true;
            try {
                File file = new File(path);
                _NSStringUtilities.writeToFile(file, NSPropertyListSerialization.stringFromPropertyList(dic));
            }
            catch (RuntimeException e) {
                NSLog._conditionallyLogPrivateException(e);
                if (!(NSForwardException._originalThrowable(e) instanceof IOException)) break block2;
                returnValue = false;
            }
        }
        return returnValue;
    }

    public static boolean containsOnlyNullObjects(NSDictionary dic) {
        NSArray values = dic.allValues();
        int c = values.count();
        for (int i = 0; i < c; ++i) {
            if (values.objectAtIndex(i) == NSKeyValueCoding.NullValue) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAnyNullObject(NSDictionary dic) {
        NSArray values = dic.allValues();
        int c = values.count();
        for (int i = 0; i < c; ++i) {
            if (values.objectAtIndex(i) != NSKeyValueCoding.NullValue) continue;
            return true;
        }
        return false;
    }

    public static void overrideEntriesWithObjectsFromDictionaryKeys(NSMutableDictionary self, NSDictionary other, NSArray keys) {
        for (int i = keys.count() - 1; i >= 0; --i) {
            Object key = keys.objectAtIndex(i);
            Object value = other.objectForKey(key);
            if (value == null) continue;
            self.setObjectForKey(value, key);
        }
    }

    public static NSDictionary dictionaryWithNullValuesForKeys(NSArray keys) {
        NSMutableDictionary dict = null;
        int count = keys.count();
        if (count > 0) {
            dict = new NSMutableDictionary(count);
            for (int i = 0; i < count; ++i) {
                String key = (String)keys.objectAtIndex(i);
                dict.setObjectForKey(NSKeyValueCoding.NullValue, key);
            }
        }
        return dict;
    }

    public static Object nullEnabledValueForKey(NSDictionary dic, String key) {
        if (dic == null) {
            throw new IllegalArgumentException("The dictionary must not be null.");
        }
        Object value = dic.objectForKey(key);
        return value != NSKeyValueCoding.NullValue ? value : null;
    }

    public static NSDictionary dictionaryWithContentsOfStringsFile(String path) {
        NSDictionary dictionary;
        String string = _NSStringUtilities.stringFromFile(path);
        if (string == null) {
            return null;
        }
        try {
            dictionary = string.startsWith("{") ? (NSDictionary)NSPropertyListSerialization._Utilities.propertyListFromString(string) : (NSDictionary)NSPropertyListSerialization._Utilities.propertyListFromString(string);
        }
        catch (Exception e) {
            NSLog._conditionallyLogPrivateException(e);
            dictionary = null;
        }
        if (dictionary == null || !(dictionary instanceof NSDictionary)) {
            return null;
        }
        return new NSDictionary(dictionary);
    }
}

