/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.foundation.ERXValueUtilities;
import java.math.BigDecimal;

public abstract class AjaxGridNavBar
extends WOComponent {
    public static final String CONTAINER_ID_BINDING = "containerID";
    public static final String DISPLAY_GROUP_BINDING = "displayGroup";
    public static final String CONFIGURATION_DATA_BINDING = "configurationData";

    public AjaxGridNavBar(WOContext context) {
        super(context);
    }

    public boolean isStateless() {
        return true;
    }

    public void nextBatch() {
        this.displayGroup().displayNextBatch();
        this.displayGroup().setSelectedObject(null);
    }

    public void previousBatch() {
        this.displayGroup().displayPreviousBatch();
        this.displayGroup().setSelectedObject(null);
    }

    public void setCurrentBatchIndex(Number newValue) {
        if (newValue instanceof BigDecimal) {
            int roundedIndex = new Float((double)((BigDecimal)newValue).floatValue() + 0.5).intValue();
            this.displayGroup().setCurrentBatchIndex(roundedIndex);
        } else {
            this.displayGroup().setCurrentBatchIndex(newValue.intValue());
        }
    }

    public int currentBatchIndex() {
        return this.displayGroup().currentBatchIndex();
    }

    public String updateGridContainer() {
        return this.gridContainerID() + "Update(); ";
    }

    public String updateBatchSizeOnChange() {
        return this.updateBatchSizeName() + "('batchSize=' + this.value);";
    }

    public String updateBatchSizeName() {
        return this.containerID() + "UpdateBatchSize";
    }

    public void batchSizeUpdated() {
        String batchSizeString = (String)this.context().request().formValueForKey("batchSize");
        int batchSizeIndex = Integer.parseInt(batchSizeString);
        this.configurationData().setObjectForKey(this.batchSizes().objectAtIndex(batchSizeIndex), (Object)"batchSize");
        this.displayGroup().setNumberOfObjectsPerBatch(ERXValueUtilities.intValue((Object)this.currentBatchSize()));
    }

    public abstract NSArray batchSizes();

    public String currentBatchSize() {
        return (String)this.configurationData().objectForKey((Object)"batchSize");
    }

    public String gridContainerID() {
        return (String)this.configurationData().objectForKey((Object)"updateContainerID");
    }

    public String tableID() {
        return (String)this.configurationData().objectForKey((Object)"tableID");
    }

    public WODisplayGroup displayGroup() {
        return (WODisplayGroup)this.valueForBinding(DISPLAY_GROUP_BINDING);
    }

    public NSMutableDictionary configurationData() {
        return (NSMutableDictionary)this.valueForBinding(CONFIGURATION_DATA_BINDING);
    }

    public String containerID() {
        return (String)this.valueForBinding(CONTAINER_ID_BINDING);
    }
}

