/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxDynamicElement;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUtils;

public class AjaxHyperlink
extends AjaxDynamicElement {
    public AjaxHyperlink(String name, NSDictionary associations, WOElement children) {
        super(name, associations, children);
    }

    public String onClick(WOContext context) {
        StringBuffer sb = new StringBuffer();
        String onClickBefore = (String)this.valueForBinding("onClickBefore", context.component());
        if (onClickBefore != null) {
            sb.append("if (");
            sb.append(onClickBefore);
            sb.append(") {");
        }
        NSDictionary options = this.createAjaxOptions(context.component());
        String actionUrl = AjaxUtils.ajaxComponentActionUrl(context);
        sb.append("new Ajax.Request('");
        sb.append(actionUrl);
        sb.append("', ");
        AjaxOptions.appendToBuffer(options, sb, context);
        sb.append(")");
        String onClick = (String)this.valueForBinding("onClick", context.component());
        if (onClick != null) {
            sb.append(";");
            sb.append(onClick);
        }
        if (onClickBefore != null) {
            sb.append("}");
        }
        return sb.toString();
    }

    protected NSDictionary createAjaxOptions(WOComponent component) {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("onSuccess", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onFailure", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onComplete", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onLoading", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("evalScripts", AjaxOption.BOOLEAN));
        NSMutableDictionary<String, String> options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, component, (NSDictionary<String, ? extends WOAssociation>)this.associations());
        options.setObjectForKey((Object)"'get'", (Object)"method");
        return options;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        boolean renderTags;
        WOComponent component = context.component();
        boolean disabled = this.booleanValueForBinding("disabled", false, component);
        String elementName = (String)this.valueForBinding("elementName", "a", component);
        String functionName = (String)this.valueForBinding("functionName", null, component);
        boolean isATag = "a".equalsIgnoreCase(elementName);
        boolean bl = renderTags = (!disabled || !isATag) && functionName == null;
        if (renderTags) {
            response.appendContentString("<");
            response.appendContentString(elementName);
            response.appendContentString(" ");
            if (isATag) {
                this.appendTagAttributeToResponse(response, "href", "javascript:void(0)");
            }
            this.appendTagAttributeToResponse(response, "title", this.valueForBinding("title", component));
            this.appendTagAttributeToResponse(response, "value", this.valueForBinding("value", component));
            this.appendTagAttributeToResponse(response, "class", this.valueForBinding("class", component));
            this.appendTagAttributeToResponse(response, "style", this.valueForBinding("style", component));
            this.appendTagAttributeToResponse(response, "id", this.valueForBinding("id", component));
            if (!disabled) {
                this.appendTagAttributeToResponse(response, "onclick", this.onClick(context));
            }
            response.appendContentString(">");
        }
        if (functionName != null) {
            AjaxUtils.appendScriptHeader(response);
            response.appendContentString(functionName + " = function() { " + this.onClick(context) + " }\n");
            AjaxUtils.appendScriptFooter(response);
        }
        if (!this.hasBinding("string")) {
            this.appendChildrenToResponse(response, context);
        } else {
            response.appendContentString((String)this.valueForBinding("string", component));
        }
        if (renderTags) {
            response.appendContentString("</");
            response.appendContentString(elementName);
            response.appendContentString(">");
        }
        super.appendToResponse(response, context);
    }

    protected void addRequiredWebResources(WOResponse res, WOContext context) {
        this.addScriptResourceInHead(context, res, "prototype.js");
        this.addScriptResourceInHead(context, res, "effects.js");
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        String script;
        WOComponent component = context.component();
        Object results = (WOActionResults)this.valueForBinding("action", component);
        if (results == null && (script = (String)this.valueForBinding("onClickServer", component)) != null) {
            AjaxResponse response = AjaxUtils.createResponse(request, context);
            AjaxUtils.appendScriptHeader((WOResponse)response);
            response.appendContentString(script);
            AjaxUtils.appendScriptFooter((WOResponse)response);
            results = response;
        }
        return results;
    }
}

