/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WOFormatterRepository;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSValidation;
import er.ajax.AjaxDynamicElement;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXWOContext;
import java.math.BigDecimal;
import java.text.Format;
import java.text.ParseException;

public class AjaxInPlaceEditor
extends AjaxDynamicElement {
    private WOAssociation _idAssociation;
    private WOAssociation _elementNameAssociation;
    private WOAssociation _classAssociation;
    private WOAssociation _valueAssociation;
    private WOAssociation _formatter;
    private WOAssociation _dateFormat;
    private WOAssociation _numberFormat;
    private WOAssociation _useDecimalNumber;
    private WOAssociation _escapeHTML;

    public AjaxInPlaceEditor(String name, NSDictionary associations, WOElement children) {
        super(name, associations, children);
        this._idAssociation = (WOAssociation)associations.objectForKey((Object)"id");
        this._elementNameAssociation = (WOAssociation)associations.objectForKey((Object)"elementName");
        if (this._elementNameAssociation == null) {
            this._elementNameAssociation = new WOConstantValueAssociation((Object)"div");
        }
        this._classAssociation = (WOAssociation)associations.objectForKey((Object)"class");
        this._valueAssociation = (WOAssociation)associations.objectForKey((Object)"value");
        this._formatter = (WOAssociation)associations.objectForKey((Object)"formatter");
        this._dateFormat = (WOAssociation)associations.objectForKey((Object)"dateformat");
        this._numberFormat = (WOAssociation)associations.objectForKey((Object)"numberformat");
        this._useDecimalNumber = (WOAssociation)associations.objectForKey((Object)"useDecimalNumber");
        this._escapeHTML = (WOAssociation)associations.objectForKey((Object)"escapeHTML");
        if (this._dateFormat != null && this._numberFormat != null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> Cannot have 'dateFormat' and 'numberFormat' attributes at the same time.");
        }
    }

    public NSDictionary createAjaxOptions(WOComponent component) {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("okButton", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("okText", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("cancelLink", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("cancelText", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("cancelControl", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("savingText", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("clickToEditText", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("formId", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("externalControl", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("rows", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onComplete", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onFailure", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("cols", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("size", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("highlightcolor", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("highlightendcolor", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("savingClassName", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("formClassName", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("loadTextURL", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("loadingText", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("callback", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("submitOnBlur", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("valueWhenEmpty", AjaxOption.STRING));
        NSMutableDictionary<String, String> options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, component, (NSDictionary<String, ? extends WOAssociation>)this.associations());
        return options;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        WOComponent component = context.component();
        String id = this._idAssociation == null ? ERXWOContext.safeIdentifierName((WOContext)context, (boolean)false) : (String)this._idAssociation.valueInComponent(component);
        String elementName = (String)this._elementNameAssociation.valueInComponent(component);
        String actionUrl = AjaxUtils.ajaxComponentActionUrl(context);
        super.appendToResponse(response, context);
        response.appendContentString("<");
        response.appendContentString(elementName);
        response.appendContentString(" id = \"");
        response.appendContentString(id);
        response.appendContentString("\"");
        if (this._classAssociation != null) {
            String className = (String)this._classAssociation.valueInComponent(component);
            response.appendContentString(" class = \"");
            response.appendContentString(className);
            response.appendContentString("\"");
        }
        response.appendContentString(">");
        this._appendValueAttributeToResponse(response, context);
        response.appendContentString("</");
        response.appendContentString(elementName);
        response.appendContentString(">");
        AjaxUtils.appendScriptHeader(response);
        response.appendContentString("new Ajax.InPlaceEditorWithEmptyText('");
        response.appendContentString(id);
        response.appendContentString("', '");
        response.appendContentString(actionUrl);
        response.appendContentString("',");
        NSDictionary options = this.createAjaxOptions(component);
        AjaxOptions.appendToResponse(options, response, context);
        response.appendContentString(");");
        AjaxUtils.appendScriptFooter(response);
    }

    protected void addRequiredWebResources(WOResponse response, WOContext context) {
        AjaxUtils.addScriptResourceInHead(context, response, "prototype.js");
        AjaxUtils.addScriptResourceInHead(context, response, "builder.js");
        AjaxUtils.addScriptResourceInHead(context, response, "effects.js");
        AjaxUtils.addScriptResourceInHead(context, response, "controls.js");
        AjaxUtils.addScriptResourceInHead(context, response, "wonder.js");
        AjaxUtils.addScriptResourceInHead(context, response, "wonder_inplace.js");
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        WOComponent component = context.component();
        String strValue = request.stringFormValueForKey("value");
        Object objValue = strValue;
        if (strValue != null) {
            Format format = null;
            if (strValue.length() != 0) {
                format = WOFormatterRepository.formatterForComponent((WOComponent)component, (WOAssociation)this._dateFormat, (WOAssociation)this._numberFormat, (WOAssociation)this._formatter);
            }
            if (format != null) {
                try {
                    Object parsedValue = format.parseObject(strValue);
                    String formattedValue = format.format(parsedValue);
                    objValue = format.parseObject(formattedValue);
                }
                catch (ParseException parseexception) {
                    String valueKeyPath = this._valueAssociation.keyPath();
                    NSValidation.ValidationException validationexception = new NSValidation.ValidationException(parseexception.getMessage(), (Object)strValue, valueKeyPath);
                    component.validationFailedWithException((Throwable)validationexception, (Object)strValue, valueKeyPath);
                    return null;
                }
                if (objValue != null && this._useDecimalNumber != null && this._useDecimalNumber.booleanValueInComponent(component)) {
                    objValue = new BigDecimal(objValue.toString());
                }
            } else if (objValue.toString().length() == 0) {
                objValue = null;
            }
        }
        this._valueAssociation.setValue(objValue, component);
        this.valueForBinding("action", component);
        AjaxResponse response = AjaxUtils.createResponse(request, context);
        this._appendValueAttributeToResponse((WOResponse)response, context);
        return response;
    }

    protected void _appendValueAttributeToResponse(WOResponse response, WOContext context) {
        WOComponent component = context.component();
        Object objValue = this._valueAssociation.valueInComponent(component);
        if (objValue != null) {
            String strValue = null;
            Format format = WOFormatterRepository.formatterForInstance((Object)objValue, (WOComponent)component, (WOAssociation)this._dateFormat, (WOAssociation)this._numberFormat, (WOAssociation)this._formatter);
            if (format != null) {
                try {
                    String formattedStrValue = format.format(objValue);
                    Object parsedValue = format.parseObject(formattedStrValue);
                    strValue = format.format(parsedValue);
                }
                catch (IllegalArgumentException illegalargumentexception) {
                    NSLog._conditionallyLogPrivateException((Throwable)illegalargumentexception);
                }
                catch (ParseException parseexception) {
                    NSLog._conditionallyLogPrivateException((Throwable)parseexception);
                }
            }
            if (strValue == null) {
                strValue = objValue.toString();
            }
            if (this._escapeHTML != null && this._escapeHTML.booleanValueInComponent(component)) {
                response.appendContentHTMLString(strValue);
            } else {
                response.appendContentString(strValue);
            }
        }
    }
}

