/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxDynamicElement;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ERXWOContext;
import er.extensions.foundation.ERXMutableURL;
import er.extensions.foundation.ERXStringUtilities;
import java.net.MalformedURLException;

public class AjaxModalContainer
extends AjaxDynamicElement {
    public AjaxModalContainer(String name, NSDictionary associations, WOElement children) {
        super(name, associations, children);
    }

    public boolean shouldHandle(WOContext context) {
        return context.elementID().equals(context.senderID());
    }

    public WOActionResults invokeAction(WORequest worequest, WOContext wocontext) {
        WOAssociation action;
        WOComponent component = wocontext.component();
        if (!this.booleanValueForBinding("ajax", false, component) && (action = (WOAssociation)this.associations().objectForKey((Object)"action")) != null && wocontext.elementID().equals(wocontext.senderID())) {
            return (WOActionResults)action.valueInComponent(component);
        }
        return super.invokeAction(worequest, wocontext);
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        NSMutableDictionary userInfo;
        String directActionName;
        WOComponent component = context.component();
        String linkID = (String)this.valueForBinding("id", component);
        if (linkID == null) {
            linkID = ERXWOContext.safeIdentifierName((WOContext)context, (boolean)false);
        }
        String containerID = (String)this.valueForBinding("containerID", linkID + "Container", component);
        response.appendContentString("<a");
        String href = (String)this.valueForBinding("href", component);
        if (href == null && (directActionName = this.stringValueForBinding("directActionName", component)) != null) {
            NSDictionary queryDictionary = (NSDictionary)this.valueForBinding("queryDictionary", component);
            boolean secure = this.booleanValueForBinding("secure", ERXRequest.isRequestSecure((WORequest)context.request()), component);
            if (secure) {
                boolean generatingCompleteURLs;
                boolean bl = generatingCompleteURLs = context instanceof ERXWOContext ? ((ERXWOContext)context)._generatingCompleteURLs() : false;
                if (!generatingCompleteURLs) {
                    context._generateCompleteURLs();
                }
                try {
                    href = context._directActionURL(directActionName, queryDictionary, secure);
                    ERXMutableURL u = new ERXMutableURL(href);
                    u.addQueryParameter(String.valueOf(System.currentTimeMillis()), null);
                    href = u.toExternalForm();
                }
                catch (MalformedURLException e) {
                    throw new NSForwardException((Throwable)e);
                }
                finally {
                    if (!generatingCompleteURLs) {
                        context._generateRelativeURLs();
                    }
                }
            } else {
                href = context.directActionURLForActionNamed(directActionName, queryDictionary);
            }
        }
        boolean isAjax = this.booleanValueForBinding("ajax", false, component);
        if (href == null) {
            if (isAjax) {
                if (this.valueForBinding("id", component) == null) {
                    throw new IllegalArgumentException("If ajax = 'true', you must also bind 'id'.");
                }
                href = AjaxUtils.ajaxComponentActionUrl(context);
            } else if (this.associations().objectForKey((Object)"action") != null) {
                href = context.componentActionURL();
            }
            if (href == null) {
                href = "#" + containerID;
            }
        }
        this.appendTagAttributeToResponse(response, "href", href);
        String relAttributeValue = "ibox";
        Object height = this.valueForBinding("height", component);
        Object width = this.valueForBinding("width", component);
        Object closeLabel = this.valueForBinding("closeLabel", component);
        if (height != null) {
            relAttributeValue = relAttributeValue + "&height=" + ERXStringUtilities.urlEncode((String)height.toString());
        }
        if (width != null) {
            relAttributeValue = relAttributeValue + "&width=" + ERXStringUtilities.urlEncode((String)width.toString());
        }
        if (closeLabel != null) {
            relAttributeValue = relAttributeValue + "&closeLabel=" + ERXStringUtilities.urlEncode((String)closeLabel.toString());
        }
        if (this.booleanValueForBinding("locked", false, component)) {
            relAttributeValue = relAttributeValue + "&locked=true";
        }
        response._appendTagAttributeAndValue("rel", relAttributeValue, false);
        this.appendTagAttributeToResponse(response, "title", this.valueForBinding("title", component));
        this.appendTagAttributeToResponse(response, "value", this.valueForBinding("value", component));
        this.appendTagAttributeToResponse(response, "class", this.valueForBinding("class", component));
        this.appendTagAttributeToResponse(response, "style", this.valueForBinding("style", component));
        this.appendTagAttributeToResponse(response, "id", linkID);
        response.appendContentString(">");
        if (!href.startsWith("#") && !isAjax && this.childrenElements() != null && this.childrenElements().count() > 0) {
            this.appendChildrenToResponse(response, context);
        } else {
            Object label = this.valueForBinding("label", "", component);
            response.appendContentString(label.toString());
        }
        response.appendContentString("</a>");
        if (AjaxUtils.isAjaxRequest(context.request()) && !(userInfo = AjaxUtils.mutableUserInfo((WOMessage)response)).containsKey((Object)"er.ajax.AjaxModalContainer.init")) {
            AjaxUtils.appendScriptHeader(response);
            response.appendContentString("iBox.init()");
            AjaxUtils.appendScriptFooter(response);
            userInfo.setObjectForKey((Object)Boolean.TRUE, (Object)"er.ajax.AjaxModalContainer.init");
        }
        if (this.booleanValueForBinding("open", false, component)) {
            if (AjaxUtils.isAjaxRequest(context.request())) {
                response.appendContentString("<script>iBox.handleTag.bind($wi('" + linkID + "'))()</script>");
            } else {
                response.appendContentString("<script>Event.observe(window, 'load', iBox.handleTag.bind($wi('" + linkID + "')))</script>");
            }
        }
        if (href.startsWith("#")) {
            response.appendContentString("<div");
            this.appendTagAttributeToResponse(response, "id", containerID);
            this.appendTagAttributeToResponse(response, "style", "display:none;");
            response.appendContentString(">");
            this.appendChildrenToResponse(response, context);
            response.appendContentString("</div>");
        }
        super.appendToResponse(response, context);
    }

    protected void addRequiredWebResources(WOResponse response, WOContext context) {
        this.addScriptResourceInHead(context, response, "prototype.js");
        this.addScriptResourceInHead(context, response, "ibox/ibox.js");
        String skinName = this.stringValueForBinding("skin", context.component());
        String skinCSS = skinName == null ? "ibox/ibox.css" : "ibox/skins/" + skinName + "/" + skinName + ".css";
        this.addStylesheetResourceInHead(context, response, skinCSS);
    }

    protected String _containerID(WOContext context) {
        String id = (String)this.valueForBinding("id", context.component());
        return id;
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        WOComponent component = context.component();
        AjaxResponse response = null;
        WOAssociation action = (WOAssociation)this.associations().objectForKey((Object)"action");
        if (action != null) {
            action.valueInComponent(component);
        }
        if (this.booleanValueForBinding("ajax", false, component) && this.hasChildrenElements()) {
            response = AjaxUtils.createResponse(request, context);
            AjaxUtils.setPageReplacementCacheKey(context, this._containerID(context));
            this.appendChildrenToResponse((WOResponse)response, context);
        }
        return response;
    }
}

