/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import er.ajax.AjaxTreeModel;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXWOContext;

public class AjaxTree
extends WOComponent {
    private AjaxTreeModel _treeModel;
    private NSArray _nodes;
    private int _level;
    private int _closeCount;
    private Object _lastParent;
    private Object _item;
    private String _id = null;
    private Object _lastRootNode;

    public AjaxTree(WOContext context) {
        super(context);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public NSArray nodes() {
        Object rootNode = this.treeModel().rootTreeNode();
        boolean useCache = AjaxUtils.booleanValueForBinding("cache", true, (NSDictionary)this._keyAssociations, this.parent());
        if (this._nodes == null || rootNode == null || !rootNode.equals(this._lastRootNode) || !useCache) {
            NSMutableArray nodes = new NSMutableArray();
            boolean showRoot = AjaxUtils.booleanValueForBinding("showRoot", true, (NSDictionary)this._keyAssociations, this.parent());
            this._fillInOpenNodes(this.treeModel().rootTreeNode(), nodes, showRoot);
            this._nodes = nodes;
            this._lastRootNode = rootNode;
        }
        return this._nodes;
    }

    protected void _fillInOpenNodes(Object node, NSMutableArray nodes, boolean showNode) {
        NSArray childrenTreeNodes;
        if (showNode) {
            nodes.addObject(node);
        }
        if (this.treeModel().isExpanded(node) && (childrenTreeNodes = this.treeModel().childrenTreeNodes(node)) != null) {
            int childTreeNodeCount = childrenTreeNodes.count();
            for (int childTreeNodeNum = 0; childTreeNodeNum < childTreeNodeCount; ++childTreeNodeNum) {
                Object childNode = childrenTreeNodes.objectAtIndex(childTreeNodeNum);
                this._fillInOpenNodes(childNode, nodes, true);
            }
        }
    }

    public void reset() {
        super.reset();
    }

    protected void resetTree() {
        this._level = 0;
        this._closeCount = 0;
        this._lastParent = null;
        this._item = null;
        this.treeModel().setDelegate(this.valueForBinding("delegate"));
        if (this.hasBinding("allExpanded")) {
            this.treeModel().setAllExpanded(AjaxUtils.booleanValueForBinding("allExpanded", false, (NSDictionary)this._keyAssociations, this.parent()));
        }
        if (this.hasBinding("rootExpanded") || this.hasBinding("showRoot")) {
            this.treeModel().setRootExpanded(AjaxUtils.booleanValueForBinding("rootExpanded", false, (NSDictionary)this._keyAssociations, this.parent()) || !AjaxUtils.booleanValueForBinding("showRoot", true, (NSDictionary)this._keyAssociations, this.parent()));
        }
        this.treeModel().setIsLeafKeyPath(this.stringValueForBinding("isLeafKeyPath", null));
        this.treeModel().setParentTreeNodeKeyPath(this.stringValueForBinding("parentKeyPath", null));
        this.treeModel().setChildrenTreeNodesKeyPath(this.stringValueForBinding("childrenKeyPath", null));
        this.treeModel().setRootTreeNode(this.valueForBinding("root"));
        this.setItem(this.treeModel().rootTreeNode());
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        this.resetTree();
        super.appendToResponse(aResponse, aContext);
        this.resetTree();
    }

    public void takeValuesFromRequest(WORequest aRequest, WOContext aContext) {
        this.resetTree();
        super.takeValuesFromRequest(aRequest, aContext);
        this.resetTree();
    }

    public WOActionResults invokeAction(WORequest aRequest, WOContext aContext) {
        this.resetTree();
        WOActionResults results = super.invokeAction(aRequest, aContext);
        this.resetTree();
        return results;
    }

    public void setItem(Object item) {
        if (item != this._item) {
            Object parent = this.treeModel().parentTreeNode(item);
            int level = parent == null ? 0 : (parent == this._item ? this._level + 1 : (parent != this._lastParent ? this.treeModel().level(item) : this._level));
            this._closeCount = this._level > level ? this._level - level : 0;
            this._lastParent = parent;
            this._level = level;
            this._item = item;
            this.setValueForBinding(item, "item");
        }
    }

    public Object item() {
        return this._item;
    }

    public boolean isLeaf() {
        return this.treeModel().isLeaf(this._item);
    }

    public boolean isExpanded() {
        return this.treeModel().isExpanded(this._item);
    }

    public int _closeCount() {
        return this._closeCount;
    }

    public void setTreeModel(AjaxTreeModel treeModel) {
        this._treeModel = treeModel;
    }

    public AjaxTreeModel treeModel() {
        if (this._treeModel == null) {
            if (this.canGetValueForBinding("treeModel") && this.valueForBinding("treeModel") != null) {
                this._treeModel = (AjaxTreeModel)this.valueForBinding("treeModel");
            } else {
                this._treeModel = new AjaxTreeModel();
                if (this.canSetValueForBinding("treeModel")) {
                    this.setValueForBinding(this._treeModel, "treeModel");
                }
            }
        }
        return this._treeModel;
    }

    public String id() {
        if (this._id == null) {
            this._id = this.hasBinding("id") ? (String)this.valueForBinding("id") : ERXWOContext.safeIdentifierName((WOContext)this.context(), (boolean)true);
        }
        return this._id;
    }

    protected String stringValueForBinding(String bindingName, String defaultValue) {
        String value = defaultValue;
        if (this.hasBinding(bindingName)) {
            value = (String)this.valueForBinding(bindingName);
        }
        return value;
    }

    public String collapsedImage() {
        return this.stringValueForBinding("collapsedImage", "collapsed.gif");
    }

    public String collapsedImageFramework() {
        return this.stringValueForBinding("collapsedImageFramework", "Ajax");
    }

    public String expandedImage() {
        return this.stringValueForBinding("expandedImage", "expanded.gif");
    }

    public String expandedImageFramework() {
        return this.stringValueForBinding("expandedImageFramework", "Ajax");
    }

    public String leafImage() {
        return this.stringValueForBinding("leafImage", "leaf.gif");
    }

    public String leafImageFramework() {
        return this.stringValueForBinding("leafImageFramework", "Ajax");
    }

    public String imageLinkClass() {
        return this.stringValueForBinding("imageLinkClass", "");
    }

    public String nodeItem() {
        String itemClass;
        String itemID;
        StringBuffer nodeItem = new StringBuffer();
        nodeItem.append("<li");
        if (this.hasBinding("itemID") && (itemID = (String)this.valueForBinding("itemID")) != null) {
            nodeItem.append(" id = \"");
            nodeItem.append(itemID);
            nodeItem.append("\"");
        }
        if (this.hasBinding("itemClass") && (itemClass = (String)this.valueForBinding("itemClass")) != null) {
            nodeItem.append(" class = \"");
            nodeItem.append(itemClass);
            nodeItem.append("\"");
        }
        nodeItem.append(">");
        return nodeItem.toString();
    }

    public String _toggleFunctionName() {
        return this.id() + "Toggle";
    }

    public WOActionResults expand() {
        this.treeModel().setExpanded(this._item, true);
        this._nodes = null;
        return null;
    }

    public WOActionResults collapse() {
        this.treeModel().setExpanded(this._item, false);
        this._nodes = null;
        return null;
    }
}

