/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.json.serializer;

import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSPropertyListSerialization;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NSDataSerializer
extends AbstractSerializer {
    private static Class[] _serializableClasses = new Class[]{NSData.class, NSMutableData.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONArray.class) && NSData.class.isAssignableFrom(clazz);
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        try {
            JSONObject jso = (JSONObject)o;
            String java_class = jso.getString("javaClass");
            if (java_class == null) {
                throw new UnmarshallException("no type hint");
            }
            String string = jso.getString("bytes");
            NSData data = (NSData)NSPropertyListSerialization.propertyListFromString((String)string);
            if (NSData.class.isAssignableFrom(clazz)) {
                return ObjectMatch.OKAY;
            }
            throw new UnmarshallException("invalid class " + clazz);
        }
        catch (JSONException e) {
            throw new UnmarshallException("Failed to unmarshall NSData.", (Throwable)e);
        }
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        try {
            JSONObject jso = (JSONObject)o;
            String java_class = jso.getString("javaClass");
            if (java_class == null) {
                throw new UnmarshallException("no type hint");
            }
            String string = jso.getString("bytes");
            NSData data = (NSData)NSPropertyListSerialization.propertyListFromString((String)string);
            if (NSMutableData.class.equals((Object)clazz)) {
                NSMutableData mutableData = new NSMutableData(data);
                state.setSerialized(o, (Object)mutableData);
                return mutableData;
            }
            if (NSData.class.equals((Object)clazz)) {
                state.setSerialized(o, (Object)data);
                return data;
            }
            throw new UnmarshallException("invalid class " + clazz);
        }
        catch (JSONException e) {
            throw new UnmarshallException("Failed to unmarshall NSData.", (Throwable)e);
        }
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        try {
            if (!(o instanceof NSData)) {
                throw new MarshallException("cannot marshall date using class " + o.getClass());
            }
            String bytes = NSPropertyListSerialization.stringFromPropertyList((Object)o);
            JSONObject obj = new JSONObject();
            if (this.ser.getMarshallClassHints()) {
                obj.put("javaClass", (Object)o.getClass().getName());
            }
            obj.put("bytes", (Object)bytes);
            return obj;
        }
        catch (JSONException e) {
            throw new MarshallException("Failed to marshall NSData.", (Throwable)e);
        }
    }
}

