/*
 * Decompiled with CFR 0.152.
 */
package er.ajax.json.serializer;

import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONException;
import org.json.JSONObject;

public class NSTimestampSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 1L;
    private static Class[] _serializableClasses = new Class[]{NSTimestamp.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        try {
            JSONObject jso = (JSONObject)o;
            String java_class = jso.getString("javaClass");
            if (java_class == null) {
                throw new UnmarshallException("no type hint");
            }
            if (!java_class.equals("com.webobjects.foundation.NSTimestamp")) {
                throw new UnmarshallException("not a NSTimestamp");
            }
            long time = jso.getLong("time");
            String tz = jso.getString("tz");
            return ObjectMatch.OKAY;
        }
        catch (JSONException e) {
            throw new UnmarshallException("Failed to unmarshall NSTimestamp.", (Throwable)e);
        }
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        try {
            JSONObject jso = (JSONObject)o;
            long time = jso.getLong("time");
            String tz = jso.getString("tz");
            if (jso.has("javaClass")) {
                try {
                    clazz = Class.forName(jso.getString("javaClass"));
                }
                catch (ClassNotFoundException cnfe) {
                    throw new UnmarshallException(cnfe.getMessage());
                }
            }
            if (NSTimestamp.class.equals((Object)clazz)) {
                NSTimestamp timestamp = new NSTimestamp(time, NSTimeZone.getTimeZone((String)tz));
                state.setSerialized(o, (Object)timestamp);
                return timestamp;
            }
            throw new UnmarshallException("invalid class " + clazz);
        }
        catch (JSONException e) {
            throw new UnmarshallException("Failed to unmarshall NSTimestamp.", (Throwable)e);
        }
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        try {
            if (!(o instanceof NSTimestamp)) {
                throw new MarshallException("cannot marshall date using class " + o.getClass());
            }
            long time = ((NSTimestamp)o).getTime();
            String tz = ((NSTimestamp)o).timeZone().getID();
            JSONObject obj = new JSONObject();
            if (this.ser.getMarshallClassHints()) {
                obj.put("javaClass", (Object)o.getClass().getName());
            }
            obj.put("time", time);
            obj.put("tz", (Object)tz);
            return obj;
        }
        catch (JSONException e) {
            throw new MarshallException("Failed to marshall NSTimestamp.", (Throwable)e);
        }
    }
}

