/*
 * Decompiled with CFR 0.152.
 */
package er.indexing.storage;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation.NSTimestamp;
import er.indexing.storage.ERIFileContent;
import er.indexing.storage._ERIFile;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class ERIFile
extends _ERIFile {
    private static final Logger log = Logger.getLogger(ERIFile.class);
    public static final ERIFileClazz clazz = new ERIFileClazz();

    public void didInsert() {
        super.didInsert();
        log.debug((Object)("Did create: " + this.name()));
    }

    public void didUpdate() {
        super.didUpdate();
        log.debug((Object)("Did update: " + this.name() + "->" + this.length()));
    }

    public void didDelete(EOEditingContext ec) {
        super.didUpdate();
        log.debug((Object)("Did delete: " + this.name() + "->" + this.length()));
    }

    public void init(EOEditingContext ec) {
        super.init(ec);
        ERIFileContent content = (ERIFileContent)ERIFileContent.clazz.createAndInsertObject(ec);
        this.setContent(content);
        this.setContentData(new NSData());
    }

    private void setContentData(NSData data) {
        this.setLastModified(new NSTimestamp());
        this.setLength(Long.valueOf(data.length()));
        this.content().setContent(data);
    }

    private NSData contentData() {
        return this.content().content();
    }

    public void touch() {
        this.setLastModified(new NSTimestamp());
        this.editingContext().saveChanges();
    }

    public IndexInput openInput() {
        return new EOFIndexInput(this.contentData());
    }

    public long timestamp() {
        return this.lastModified().getTime();
    }

    public IndexOutput createOutput() {
        return new EOFIndexOutput(this.contentData());
    }

    private class EOFIndexInput
    extends IndexInput {
        long filePointer = 0L;
        NSData data;

        public EOFIndexInput(NSData contentData) {
            this.data = contentData;
        }

        private NSData data() {
            return this.data;
        }

        public void close() throws IOException {
            this.filePointer = 0L;
        }

        public long getFilePointer() {
            return this.filePointer;
        }

        public long length() {
            return this.data().length();
        }

        private void assureLength(long len) throws IOException {
            if (len > this.length()) {
                throw new IOException("Not enough data: " + len + " vs " + this.length());
            }
        }

        public byte readByte() throws IOException {
            this.assureLength(this.filePointer + 1L);
            return this.data().bytes((int)this.filePointer++, 1)[0];
        }

        public void readBytes(byte[] abyte0, int offset, int len) throws IOException {
            this.assureLength(this.filePointer + (long)len);
            System.arraycopy(this.data().bytesNoCopy(new NSMutableRange((int)this.filePointer, len)), (int)this.filePointer, abyte0, offset, len);
            this.filePointer += (long)len;
        }

        public void seek(long l) throws IOException {
            this.assureLength(l);
            this.filePointer = l;
        }
    }

    private class EOFIndexOutput
    extends IndexOutput {
        long filePointer = 0L;
        long fileLength = 0L;
        NSMutableData data;
        boolean dirty = false;

        public EOFIndexOutput(NSData contentData) {
            this.data = new NSMutableData(contentData);
            this.fileLength = this.data.length();
        }

        private NSMutableData data() {
            return this.data;
        }

        public void close() throws IOException {
            this.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            if (this.dirty) {
                if (this.length() < (long)this.data().length()) {
                    this.data().setLength((int)this.length());
                }
                ERIFile.this.editingContext().lock();
                try {
                    ERIFile.this.setContentData((NSData)this.data());
                    ERIFile.this.editingContext().saveChanges();
                }
                finally {
                    ERIFile.this.editingContext().unlock();
                }
            }
            this.dirty = false;
        }

        public long getFilePointer() {
            return this.filePointer;
        }

        public long length() {
            return this.fileLength;
        }

        public void seek(long l) throws IOException {
            this.assureLength(l);
            this.filePointer = l;
        }

        private void assureLength(long len) {
            if (this.length() < len) {
                if ((long)this.data().length() < len) {
                    this.data().setLength((int)len + 128000);
                }
                this.fileLength = len;
                this.dirty = true;
            }
        }

        public void writeByte(byte byte0) throws IOException {
            this.assureLength(this.filePointer + 1L);
            NSMutableRange range = new NSMutableRange((int)this.filePointer, 1);
            byte[] bytes = this.data().bytesNoCopy(range);
            bytes[(int)this.filePointer] = byte0;
            ++this.filePointer;
            this.dirty = true;
        }

        public void writeBytes(byte[] abyte0, int offset, int len) throws IOException {
            this.assureLength(this.filePointer + (long)len);
            NSMutableRange range = new NSMutableRange((int)this.filePointer, len);
            byte[] bytes = this.data().bytesNoCopy(range);
            System.arraycopy(abyte0, offset, bytes, (int)this.filePointer, len);
            this.filePointer += (long)len;
            this.dirty = true;
        }
    }

    public static interface Key
    extends _ERIFile.Key {
    }

    public static class ERIFileClazz
    extends _ERIFile._ERIFileClazz {
    }
}

