/*
 * Decompiled with CFR 0.152.
 */
package er.restadaptorexample;

import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import er.extensions.appserver.ERXApplication;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXQ;
import se.caboo.beast.model.Forum;
import se.caboo.beast.model.Post;
import se.caboo.beast.model.Topic;
import se.caboo.beast.model.User;

public class Application
extends ERXApplication {
    public static void main(String[] argv) {
        ERXApplication.main((String[])argv, Application.class);
    }

    public Application() {
        NSLog.out.appendln((Object)("Welcome to " + this.name() + " !"));
        EOEditingContext editingContext = ERXEC.newEditingContext();
        NSArray<Forum> forums = Forum.fetchAllForums(editingContext);
        System.out.println("Application.Application: Fetching all forums");
        for (Forum forum : forums) {
            System.out.println("Application.Application:   " + forum.name() + ", " + forum.postsCount() + ", " + forum.topicsCount());
        }
        System.out.println("Application.Application: Fetching forum w/ PK");
        Forum singleForum = (Forum)EOUtilities.objectWithPrimaryKeyValue((EOEditingContext)editingContext, (String)"Forum", (Object)"3");
        System.out.println("Application.Application:   " + singleForum.name());
        System.out.println("Application.Application: Fetching topics for " + singleForum.name());
        NSArray<Topic> topics = singleForum.topics();
        for (Topic topic : topics) {
            System.out.println("Application.Application:   " + topic.title() + " created " + topic.createdAt());
        }
        System.out.println("Application.Application: Fetching posts for forum");
        NSArray<Post> forumPosts = singleForum.posts();
        for (Post post : forumPosts) {
            System.out.println("Application.Application:   " + post.createdAt());
        }
        System.out.println("Application.Application: Refetching single topic w/ PK");
        Topic singleTopic = Topic.fetchRequiredTopic(editingContext, (EOQualifier)Topic.FORUM.eq((Object)singleForum).and(new EOQualifier[]{ERXQ.equals((String)"id", (Object)633)}));
        System.out.println("Application.Application:   " + singleTopic.title());
        System.out.println("Application.Application: Fetching topic user");
        User user = singleTopic.user();
        System.out.println("Application.Application:   " + user.displayName());
        System.out.println("Application.Application: Fetching posts for topic (composite pk, which is kind of interesting)");
        NSArray<Post> topicPosts = singleTopic.posts();
        for (Post post : topicPosts) {
            System.out.println("Application.Application:   " + post.createdAt());
        }
        Post randomPost = (Post)((Object)topicPosts.lastObject());
        System.out.println("Application.Application: Fetching the topic for a post (this will break if topic is not already fetched)");
        System.out.println("Application.Application:   " + randomPost.topic().title());
        System.out.println("Application.Application: Fetch author of post");
        User postedByUser = randomPost.user();
        System.out.println("Application.Application:   " + postedByUser.displayName());
        System.out.println("Application.Application: Fetching posts by author");
        NSArray<Post> userPosts = postedByUser.posts();
        for (Post post : userPosts) {
            System.out.println("Application.Application:   " + post.createdAt());
        }
        System.out.println("Application.Application: This doesn't start an app right now -- it just runs a bunch of example fetches.");
        System.exit(0);
    }
}

