/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation._NSCollectionEnumerator;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSFoundationCollection;
import com.webobjects.foundation._NSJavaSetIterator;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSSet<E>
implements Cloneable,
Serializable,
NSCoding,
_NSFoundationCollection,
Set<E> {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.foundation.NSSet");
    protected static int _NSSetClassHashCode = _CLASS.hashCode();
    public static final NSSet EmptySet = new NSSet();
    private static final String SerializationValuesFieldKey = "objects";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("objects", _NSUtilities._NoObjectArray.getClass())};
    static final long serialVersionUID = -8833684352747517048L;
    protected transient int _capacity;
    protected transient int _count;
    protected transient int _deletionLimit;
    protected transient byte[] _flags;
    protected transient int _hashCache;
    protected transient int _hashtableBuckets;
    protected Object[] _objects;
    protected transient Object[] _objectsCache;

    public static Object decodeObject(NSCoder coder) {
        return new NSSet<Object>(coder.decodeObjects());
    }

    public NSSet() {
        this._initializeSet();
    }

    public NSSet(Collection<? extends E> collection) {
        Object[] objects = collection.toArray();
        this.initFromObjects(objects, true);
    }

    public NSSet(NSArray<? extends E> objects) {
        this(objects == null ? null : objects.objectsNoCopy(), false);
    }

    public NSSet(NSSet<? extends E> otherSet) {
        this(otherSet == null ? null : otherSet.objectsNoCopy(), false);
    }

    public NSSet(Set<? extends E> set, boolean ignoreNull) {
        if (set == null) {
            throw new IllegalArgumentException("Set cannot be null");
        }
        if (!ignoreNull && set.contains(null)) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        Object[] aSet = set.toArray();
        this.initFromObjects(aSet, !ignoreNull);
    }

    public NSSet(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        this._initializeSet();
        this._ensureCapacity(1);
        if (_NSCollectionPrimitives.addValueToSet(object, (Object[])this._objects, (byte[])this._flags)) {
            ++this._count;
        }
    }

    public NSSet(E[] objects) {
        this(objects, true);
    }

    public NSSet(E object, E ... objects) {
        this(objects, true);
        this._ensureCapacity(this._count + 1);
        if (_NSCollectionPrimitives.addValueToSet(object, (Object[])this._objects, (byte[])this._flags)) {
            ++this._count;
        }
    }

    private NSSet(E[] objects, boolean checkForNull) {
        this.initFromObjects(objects, checkForNull);
    }

    public Object[] _allObjects() {
        int count = this.count();
        Object[] objects = new Object[count];
        if (count > 0) {
            System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
        }
        return objects;
    }

    protected void _clearDeletionsAndCollisions() {
        int size = this._hashtableBuckets;
        if (this._count == 0) {
            this._flags = new byte[size];
        } else {
            Object[] oldObjects = this._objects;
            byte[] oldFlags = this._flags;
            this._objects = new Object[size];
            this._flags = new byte[size];
            for (int i = 0; i < size; ++i) {
                if ((oldFlags[i] & 0xFFFFFFC0) != -128) continue;
                _NSCollectionPrimitives.addValueToSet((Object)oldObjects[i], (Object[])this._objects, (byte[])this._flags);
            }
        }
        this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets((int)size);
    }

    protected void _ensureCapacity(int capacity) {
        int newCapacity;
        int currentCapacity = this._capacity;
        if (capacity > currentCapacity && (newCapacity = _NSCollectionPrimitives.hashTableCapacityForCapacity((int)capacity)) != currentCapacity) {
            int oldSize = this._hashtableBuckets;
            this._capacity = newCapacity;
            this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity((int)newCapacity);
            int newSize = this._hashtableBuckets;
            if (newSize == 0) {
                this._objects = null;
                this._flags = null;
            } else {
                Object[] oldObjects = this._objects;
                byte[] oldFlags = this._flags;
                this._objects = new Object[newSize];
                this._flags = new byte[newSize];
                for (int i = 0; i < oldSize; ++i) {
                    if ((oldFlags[i] & 0xFFFFFFC0) != -128) continue;
                    _NSCollectionPrimitives.addValueToSet((Object)oldObjects[i], (Object[])this._objects, (byte[])this._flags);
                }
            }
            this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets((int)newSize);
        }
    }

    private boolean _equalsSet(NSSet<?> otherSet) {
        int count = this.count();
        if (count != otherSet.count()) {
            return false;
        }
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < count; ++i) {
            if (otherSet.member(objects[i]) != null) continue;
            return false;
        }
        return true;
    }

    protected void _initializeSet() {
        this._count = 0;
        this._capacity = 0;
        this._objectsCache = null;
        this._objects = null;
        this._flags = null;
        this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity((int)this._capacity);
        this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets((int)this._hashtableBuckets);
    }

    public int _shallowHashCode() {
        return _NSSetClassHashCode;
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException("add is not a supported operation in com.webobjects.foundation.NSSet");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("addAll is not a supported operation in com.webobjects.foundation.NSSet");
    }

    public NSArray<E> allObjects() {
        return new NSArray<Object>(this.objectsNoCopy());
    }

    public E anyObject() {
        return (E)(this.count() <= 0 ? null : this.objectsNoCopy()[0]);
    }

    public Class classForCoder() {
        return _CLASS;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear is not a supported operation in com.webobjects.foundation.NSSet");
    }

    public Object clone() {
        return this;
    }

    @Override
    public boolean contains(Object o) {
        return this.containsObject(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException("Collection passed into containsAll() cannot be null");
        }
        Object[] objects = c.toArray();
        if (objects.length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null) {
                    return false;
                }
                if (this.member(objects[i]) != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean containsObject(Object object) {
        return object == null ? false : this.member(object) != null;
    }

    public int count() {
        return this._count;
    }

    public void encodeWithCoder(NSCoder coder) {
        coder.encodeObjects(this.objectsNoCopy());
    }

    public static <T> NSSet<T> emptySet() {
        return EmptySet;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NSSet) {
            return this._equalsSet((NSSet)object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return _NSSetClassHashCode ^ this.count();
    }

    public HashSet<E> hashSet() {
        Object[] objects = this.objectsNoCopy();
        HashSet<Object> set = new HashSet<Object>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            set.add(objects[i]);
        }
        return set;
    }

    public NSSet<E> immutableClone() {
        return this;
    }

    private void initFromObjects(Object[] objects, boolean checkForNull) {
        this._initializeSet();
        this._ensureCapacity(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null) {
                if (!checkForNull) continue;
                throw new IllegalArgumentException("Attempt to insert null object into an  " + this.getClass().getName() + ".");
            }
            if (!_NSCollectionPrimitives.addValueToSet((Object)objects[i], (Object[])this._objects, (byte[])this._flags)) continue;
            ++this._count;
        }
    }

    public boolean intersectsSet(NSSet<?> otherSet) {
        if (this.count() != 0 && otherSet != null && otherSet.count() != 0) {
            Object[] objects = this.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                if (otherSet.member(objects[i]) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    public boolean isEqualToSet(NSSet<?> otherSet) {
        if (otherSet == null) {
            return false;
        }
        if (otherSet == this) {
            return true;
        }
        return this._equalsSet(otherSet);
    }

    public boolean isSubsetOfSet(NSSet<?> otherSet) {
        int count = this.count();
        if (otherSet == null || otherSet.count() < count) {
            return false;
        }
        if (count == 0) {
            return true;
        }
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            if (otherSet.member(objects[i]) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new _NSJavaSetIterator(this.objectsNoCopy());
    }

    public E member(Object object) {
        return (E)(this._count != 0 && object != null ? _NSCollectionPrimitives.findValueInHashTable((Object)object, (Object[])this._objects, (Object[])this._objects, (byte[])this._flags) : null);
    }

    public NSMutableSet<E> mutableClone() {
        return new NSMutableSet(this);
    }

    public Enumeration<E> objectEnumerator() {
        return new _NSCollectionEnumerator(this._objects, this._flags, this._count);
    }

    protected Object[] objectsNoCopy() {
        if (this._objectsCache == null) {
            this._objectsCache = this._count != 0 ? _NSCollectionPrimitives.valuesInHashTable((Object[])this._objects, (Object[])this._objects, (byte[])this._flags, (int)this._capacity, (int)this._hashtableBuckets) : _NSCollectionPrimitives.EmptyArray;
        }
        return this._objectsCache;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] keys = (Object[])fields.get(SerializationValuesFieldKey, _NSUtilities._NoObjectArray);
        keys = keys != null ? keys : _NSUtilities._NoObjectArray;
        this.initFromObjects(keys, true);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == _CLASS && this.count() == 0) {
            return EmptySet;
        }
        return this;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove is not a supported operation in com.webobjects.foundation.NSSet");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll is not a supported operation in com.webobjects.foundation.NSSet");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll is not a supported operation in com.webobjects.foundation.NSSet");
    }

    public NSSet<E> setByIntersectingSet(NSSet<?> otherSet) {
        NSMutableSet set = new NSMutableSet(this);
        set.intersectSet(otherSet);
        return set;
    }

    public NSSet<E> setBySubtractingSet(NSSet<?> otherSet) {
        NSMutableSet set = new NSMutableSet(this);
        set.subtractSet(otherSet);
        return set;
    }

    public NSSet<E> setByUnioningSet(NSSet<? extends E> otherSet) {
        NSMutableSet<? extends E> set = new NSMutableSet<E>(this);
        set.unionSet(otherSet);
        return set;
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public Object[] toArray() {
        Object[] currObjects = this.objectsNoCopy();
        Object[] objects = new Object[currObjects.length];
        if (currObjects.length > 0) {
            System.arraycopy(currObjects, 0, objects, 0, currObjects.length);
        }
        return objects;
    }

    @Override
    public <T> T[] toArray(T[] objects) {
        if (objects == null) {
            throw new NullPointerException("Cannot pass null as parameter");
        }
        Object[] currObjects = this.objectsNoCopy();
        if (objects.length < currObjects.length) {
            objects = (Object[])Array.newInstance(objects.getClass().getComponentType(), currObjects.length);
        }
        System.arraycopy(currObjects, 0, objects, 0, currObjects.length);
        return objects;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("(");
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (i > 0) {
                buffer.append(", ");
            }
            if (object instanceof String) {
                buffer.append('\"');
                buffer.append((String)object);
                buffer.append('\"');
                continue;
            }
            if (object instanceof Boolean) {
                buffer.append((Boolean)object != false ? "true" : "false");
                continue;
            }
            buffer.append(object.toString());
        }
        buffer.append(")");
        return new String(buffer);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationValuesFieldKey, this._allObjects());
        s.writeFields();
    }
}

