/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.appserver.ERXApplication;
import er.extensions.foundation.ERXExpiringCache;
import er.extensions.foundation.ERXRandomGUID;
import er.extensions.foundation.ERXRuntimeUtilities;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXDelayedRequestHandler
extends WORequestHandler {
    protected static final Logger log = Logger.getLogger(ERXDelayedRequestHandler.class);
    public static String KEY = "_edr_";
    private ERXExpiringCache<String, DelayedRequest> _futures;
    private ERXExpiringCache<String, String> _urls;
    private ExecutorService _executor;
    private String _cssUrl;
    private int _refreshTimeSeconds;
    private int _maxRequestTimeMillis;

    public ERXDelayedRequestHandler(int refreshTimeSeconds, int maxRequestTimeSeconds, int cancelRequestAfterSeconds, String cssUrl) {
        this._cssUrl = cssUrl;
        this._refreshTimeSeconds = refreshTimeSeconds;
        this._maxRequestTimeMillis = maxRequestTimeSeconds * 1000;
        this._executor = Executors.newCachedThreadPool();
        this._futures = new ERXExpiringCache<String, DelayedRequest>((long)cancelRequestAfterSeconds){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected synchronized void removeEntryForKey(ERXExpiringCache.Entry<DelayedRequest> entry, String key) {
                DelayedRequest request;
                DelayedRequest delayedRequest = request = entry.object();
                synchronized (delayedRequest) {
                    if (!request.isDone()) {
                        if (!request.cancel()) {
                            log.error((Object)("Delayed was running, but couldn't be cancelled: " + request));
                        } else {
                            log.info((Object)("Stopped delayed request that was still running: " + request));
                        }
                    }
                }
                super.removeEntryForKey(entry, key);
            }
        };
        this._urls = new ERXExpiringCache(this.refresh() * 50);
    }

    public ERXDelayedRequestHandler(int refreshTimeSeconds, int maxRequestTimeSeconds, int cancelRequestAfterSeconds) {
        this(refreshTimeSeconds, maxRequestTimeSeconds, cancelRequestAfterSeconds, null);
    }

    public ERXDelayedRequestHandler(int refreshTimeSeconds, int maxRequestTimeSeconds) {
        this(refreshTimeSeconds, maxRequestTimeSeconds, maxRequestTimeSeconds * 5, null);
    }

    public ERXDelayedRequestHandler() {
        this(5, 5);
    }

    public WOResponse handleRequest(WORequest request) {
        ERXApplication app = ERXApplication.erxApplication();
        WOResponse response = null;
        if (this.canHandleRequest(request)) {
            DelayedRequest delayedRequest;
            String id;
            String uri = request.uri();
            log.debug((Object)("Handling: " + uri));
            String key = request.requestHandlerKey();
            if (KEY.equals(key)) {
                id = request.stringFormValueForKey("id");
                delayedRequest = this._futures.objectForKey(id);
                if (delayedRequest == null) {
                    String url = this._urls.objectForKey(id);
                    if (url == null) {
                        return this.createErrorResponse(request);
                    }
                    response = new WOResponse();
                    response.setStatus(302);
                    response.setHeader(url, "location");
                    this._urls.setObjectForKey(url, id);
                    return response;
                }
                this._futures.setObjectForKey(delayedRequest, id);
            } else {
                delayedRequest = new DelayedRequest(request);
                id = delayedRequest.id();
                this._futures.setObjectForKey(delayedRequest, id);
            }
            response = this.handle(request, delayedRequest, id);
        } else {
            response = app.dispatchRequestImmediately(request);
        }
        return response;
    }

    protected boolean canHandleRequest(WORequest request) {
        String contentType = request.headerForKey((Object)"content-type");
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            return false;
        }
        ERXApplication app = ERXApplication.erxApplication();
        String key = request.requestHandlerKey();
        return key == null || KEY.equals(key) || app.componentRequestHandlerKey().equals(key) || app.directActionRequestHandlerKey().equals(key);
    }

    protected WOResponse handle(WORequest request, DelayedRequest delayedRequest, String id) {
        ERXApplication app = ERXApplication.erxApplication();
        WOResponse response = null;
        try {
            String action = request.stringFormValueForKey("action");
            if (!delayedRequest.isDone()) {
                if ("stop".equals(action)) {
                    if (delayedRequest.cancel()) {
                        this._futures.removeObjectForKey(id);
                        this._urls.setObjectForKey(delayedRequest.request().uri(), id);
                        response = this.createStoppedResponse(request);
                        return response;
                    }
                } else {
                    String url = request.uri();
                    if (!KEY.equals(request.requestHandlerKey())) {
                        String args = "id=" + id;
                        String sessionID = request.sessionID();
                        if (sessionID != null) {
                            args = args + "&wosid=" + sessionID;
                        }
                        args = args + "&__start=" + delayedRequest.start().getTime();
                        args = args + "&__time=" + System.currentTimeMillis();
                        url = app.createContextForRequest((WORequest)request.clone()).urlWithRequestHandlerKey(KEY, "wait", args);
                    } else {
                        url = url.replaceAll("__time=(.*)", "__time=" + System.currentTimeMillis());
                    }
                    log.debug((Object)("Delaying: " + request.uri()));
                    response = this.createRefreshResponse(request, url);
                }
            }
            response = delayedRequest.response(this.maxRequestTimeMillis());
            this._futures.removeObjectForKey(id);
            this._urls.setObjectForKey(delayedRequest.request().uri(), id);
        }
        catch (InterruptedException e1) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e1.getCause());
        }
        catch (ExecutionException e1) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e1.getCause());
        }
        catch (CancellationException e) {
            log.info((Object)("Cancelled, redirecting: " + request.uri()));
            response = this.createStoppedResponse(request);
        }
        catch (TimeoutException e) {
            log.debug((Object)("Timed out, redirecting: " + request.uri()));
        }
        return response;
    }

    protected WOResponse createErrorResponse(WORequest request) {
        ERXApplication app = ERXApplication.erxApplication();
        String args = request.sessionID() != null ? "/" + request.sessionID() : "";
        String url = request.applicationURLPrefix() + "/wo" + args + "/9999999999.0";
        WORequest expired = app.createRequest("GET", url, "HTTP/1.0", (Map<String, ? extends List<String>>)request.headers(), null, null);
        WOResponse result = app.dispatchRequestImmediately(expired);
        return result;
    }

    protected WOResponse createStoppedResponse(WORequest request) {
        ERXApplication app = ERXApplication.erxApplication();
        String args = request.sessionID() != null ? "wosid=" + request.sessionID() : "";
        String url = request.applicationURLPrefix() + "?" + args;
        WOResponse result = new WOResponse();
        result.setHeader(url, "location");
        result.setStatus(302);
        return result;
    }

    protected String cssUrl(WORequest request) {
        return this._cssUrl;
    }

    protected WOResponse createRefreshResponse(WORequest request, String url) {
        WOResponse result = new WOResponse();
        result.setHeader(this.refresh() + "; url=" + url + "\"", "refresh");
        result.appendContentString("<html>\n<head>\n<meta http-equiv=\"refresh\" content=\"" + this.refresh() + "; url=" + url + "\">\n");
        result.appendContentString("<title>Please stand by...</title>\n");
        String cssUrl = this.cssUrl(request);
        if (cssUrl != null) {
            result.appendContentString("<link rel=\"stylesheet\" href=\"" + cssUrl + "\"></link>\n");
        }
        result.appendContentString("</head>\n<body id=\"ERXDelayedRefreshPage\">");
        result.appendContentString("<h1>Please stand by...</h1>\n");
        result.appendContentString("<p class=\"busyMessage\">The action you selected is taking longer than " + this.maxRequestTimeMillis() / 1000 + " seconds. The result will be shown as soon as it is ready.</p>\n");
        result.appendContentString("<p class=\"refreshMessage\">This page will refresh automatically in " + this.refresh() + " seconds.</p>\n");
        result.appendContentString("<p class=\"actions\">");
        result.appendContentString("<a href=\"" + url + "\" class=\"refreshLink\">Refresh now</a> ");
        result.appendContentString("<a href=\"" + url + "&action=stop\" class=\"stopLink\">Stop now</a>");
        result.appendContentString("</p>\n</body>\n</html>");
        return result;
    }

    protected int refresh() {
        return this._refreshTimeSeconds;
    }

    protected int maxRequestTimeMillis() {
        return this._maxRequestTimeMillis;
    }

    public NSArray<DelayedRequest> activeRequests() {
        NSMutableArray<DelayedRequest> result = new NSMutableArray<DelayedRequest>();
        for (String id : this._futures.allKeys()) {
            DelayedRequest request = this._futures.objectForKey(id);
            if (request == null) continue;
            result.addObject(request);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DelayedRequest
    implements Callable<WOResponse> {
        protected WORequest _request;
        protected Future<WOResponse> _future;
        protected String _id;
        protected NSTimestamp _start;
        private volatile Thread _currentThread;

        public DelayedRequest(WORequest request) {
            this._request = WOApplication.application().createRequest(request.method(), request.uri(), request.httpVersion(), request.headers(), request.content(), request.userInfo());
            this._future = ERXDelayedRequestHandler.this._executor.submit(this);
            this._id = ERXRandomGUID.newGid();
            this._start = new NSTimestamp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WOResponse call() throws Exception {
            DelayedRequest delayedRequest;
            WOResponse wOResponse;
            DelayedRequest delayedRequest2 = this;
            synchronized (delayedRequest2) {
                this._currentThread = Thread.currentThread();
            }
            try {
                WOResponse response;
                ERXApplication app = ERXApplication.erxApplication();
                wOResponse = response = app.dispatchRequestImmediately(this.request());
                Object var5_5 = null;
                delayedRequest = this;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                DelayedRequest delayedRequest3 = this;
                synchronized (delayedRequest3) {
                    ERXRuntimeUtilities.clearThreadInterrupt(this._currentThread);
                    this._currentThread = null;
                }
                throw throwable;
            }
            synchronized (delayedRequest) {
                ERXRuntimeUtilities.clearThreadInterrupt(this._currentThread);
                this._currentThread = null;
            }
            return wOResponse;
        }

        public WORequest request() {
            return this._request;
        }

        public WOResponse response(long millis) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future().get(millis, TimeUnit.MILLISECONDS);
        }

        public String id() {
            return this._id;
        }

        public NSTimestamp start() {
            return this._start;
        }

        public Future<WOResponse> future() {
            return this._future;
        }

        public boolean isDone() {
            return this._currentThread == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            long start = System.currentTimeMillis();
            DelayedRequest delayedRequest = this;
            synchronized (delayedRequest) {
                if (this._currentThread != null) {
                    ERXRuntimeUtilities.addThreadInterrupt(this._currentThread, "ERXDelayedRequestHandler: stop requested " + this);
                    if (this.future().cancel(true)) {
                        log.info((Object)("Cancelled: " + this._currentThread + ": " + this.isDone()));
                    }
                    log.info((Object)("Thread done after cancel: " + this.isDone()));
                }
            }
            return this.isDone();
        }

        public String toString() {
            return "<DelayedRequest: " + this.request().uri() + " id: " + this.id() + " isDone: " + this.future().isDone() + " start: " + this.start() + ">";
        }
    }
}

