/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.batching.ERXBatchingDisplayGroup;
import er.extensions.batching.IBatchingList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXListDisplayGroup<T>
extends WODisplayGroup {
    private List<T> _objectList;
    private NSArray<T> _displayedObjects;

    public List<T> getObjectList() {
        return this._objectList;
    }

    protected int size() {
        int size = this._objectList instanceof NSArray ? ((NSArray)this._objectList).count() : this._objectList.size();
        return size;
    }

    public void setObjectList(List<T> objectList) {
        this._objectList = objectList;
        if (objectList instanceof IBatchingList) {
            ((IBatchingList)objectList).setSortOrderings(this.sortOrderings());
            ((IBatchingList)objectList).setPageIndex(this.currentBatchIndex());
            ((IBatchingList)objectList).setPageSize(this.numberOfObjectsPerBatch());
        }
        ERXBatchingDisplayGroup.FakeArray fa = new ERXBatchingDisplayGroup.FakeArray(this.size());
        this.setObjectArray(fa);
    }

    public int batchCount() {
        if (this.numberOfObjectsPerBatch() == 0) {
            return 0;
        }
        int size = this.size();
        if (size == 0) {
            return 1;
        }
        return (size - 1) / this.numberOfObjectsPerBatch() + 1;
    }

    public void setCurrentBatchIndex(int index) {
        if (this.currentBatchIndex() != index) {
            this._displayedObjects = null;
        }
        super.setCurrentBatchIndex(index);
        if (this._objectList instanceof IBatchingList) {
            ((IBatchingList)this._objectList).setPageIndex(this.currentBatchIndex());
        }
    }

    public void setNumberOfObjectsPerBatch(int count) {
        if (this.numberOfObjectsPerBatch() != count) {
            this._displayedObjects = null;
        }
        super.setNumberOfObjectsPerBatch(count);
        if (this._objectList instanceof IBatchingList) {
            ((IBatchingList)this._objectList).setPageSize(this.numberOfObjectsPerBatch());
        }
    }

    public NSArray<T> displayedObjects() {
        NSMutableArray<int> displayedObjects = new NSMutableArray<int>(this.numberOfObjectsPerBatch());
        if (this._displayedObjects == null) {
            int numberOfObjectsPerBatch = this.numberOfObjectsPerBatch();
            int startIndex = (this.currentBatchIndex() - 1) * numberOfObjectsPerBatch;
            int size = this._objectList == null ? 0 : this.size();
            int endIndex = Math.min(startIndex + numberOfObjectsPerBatch, size);
            for (int i = startIndex; i < endIndex; ++i) {
                displayedObjects.addObject((int)this._objectList.get(i));
            }
        }
        return displayedObjects;
    }

    public void setSortOrderings(NSArray sortOrderings) {
        if (this._objectList instanceof IBatchingList) {
            ((IBatchingList)this._objectList).setSortOrderings(this.sortOrderings());
        }
        super.setSortOrderings(sortOrderings);
    }
}

