/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSDictionary;
import er.extensions.appserver.ERXWOContext;
import er.extensions.foundation.ERXProperties;

public abstract class ERXAjaxApplication
extends WOApplication {
    public static final String KEY_AJAX_SUBMIT_BUTTON = "AJAX_SUBMIT_BUTTON_NAME";
    public static final String KEY_PARTIAL_FORM_SENDER_ID = "_partialSenderID";
    public static final String KEY_UPDATE_CONTAINER_ID = "_u";
    public static final String KEY_REPLACED = "_r";
    private ERXAjaxResponseDelegate _responseDelegate;
    private Boolean _allowContextPageResponse;

    public void setResponseDelegate(ERXAjaxResponseDelegate responseDelegate) {
        this._responseDelegate = responseDelegate;
    }

    public static boolean shouldIgnoreResults(WORequest request, WOContext context, WOActionResults results) {
        boolean shouldIgnoreResults = false;
        if (results == context.page() && !ERXAjaxApplication.isAjaxReplacement(request)) {
            WOApplication application = WOApplication.application();
            shouldIgnoreResults = application instanceof ERXAjaxApplication ? !((ERXAjaxApplication)application).allowContextPageResponse() : true;
        }
        return shouldIgnoreResults;
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        NSDictionary formValues;
        int formValuesCount;
        boolean shouldTakeValuesFromRequest = true;
        if (!request.isMultipartFormData() && ERXAjaxApplication.isAjaxRequest(request) && (formValuesCount = (formValues = request.formValues()).count()) == 2 && (formValues.containsKey(KEY_UPDATE_CONTAINER_ID) || formValues.containsKey(KEY_REPLACED)) && formValues.containsKey("WOIsmapCoords")) {
            shouldTakeValuesFromRequest = false;
        }
        if (shouldTakeValuesFromRequest) {
            super.takeValuesFromRequest(request, context);
        }
    }

    public WOActionResults invokeAction(WORequest request, WOContext context) {
        WOActionResults results = super.invokeAction(request, context);
        if (ERXAjaxApplication.shouldNotStorePage(context)) {
            if (ERXAjaxApplication.shouldIgnoreResults(request, context, results)) {
                results = null;
            }
            if (results == null && !ERXAjaxApplication.isAjaxReplacement(request)) {
                WOResponse response = context.response();
                if (this._responseDelegate != null) {
                    results = this._responseDelegate.handleNullActionResults(request, response, context);
                    response = context.response();
                }
                results = response;
            }
        }
        return results;
    }

    private boolean allowContextPageResponse() {
        if (this._allowContextPageResponse == null) {
            this._allowContextPageResponse = ERXProperties.booleanForKey("er.extensions.ERXAjaxApplication.allowContextPageResponse");
        }
        return this._allowContextPageResponse;
    }

    public static void setForceStorePage(WOMessage message) {
        ERXWOContext.contextDictionary().setObjectForKey(Boolean.TRUE, "erxsession.force_store_page");
    }

    public static boolean forceStorePage(WOMessage message) {
        NSDictionary userInfo = NSDictionary.EmptyDictionary;
        if (message != null) {
            userInfo = ERXWOContext.contextDictionary();
        }
        return message != null && (message.headerForKey((Object)"erxsession.force_store_page") != null || userInfo.objectForKey("erxsession.force_store_page") != null);
    }

    public static boolean shouldNotStorePage(WOMessage message) {
        NSDictionary userInfo = NSDictionary.EmptyDictionary;
        if (message != null) {
            userInfo = ERXWOContext.contextDictionary();
        }
        return message != null && (message.headerForKey((Object)"erxsession.dont_store_page") != null || userInfo.objectForKey("erxsession.dont_store_page") != null);
    }

    public static void cleanUpHeaders(WOResponse response) {
        if (response != null) {
            response.removeHeadersForKey((Object)"erxsession.dont_store_page");
            response.removeHeadersForKey((Object)"page_cache_key");
        }
    }

    public static boolean shouldNotStorePage(WOContext context) {
        WORequest request = context.request();
        WOResponse response = context.response();
        boolean shouldNotStorePage = (ERXAjaxApplication.shouldNotStorePage((WOMessage)response) || ERXAjaxApplication.shouldNotStorePage((WOMessage)request) || ERXAjaxApplication.isAjaxSubmit(request)) && !ERXAjaxApplication.forceStorePage((WOMessage)response);
        return shouldNotStorePage;
    }

    public static boolean isAjaxRequest(WORequest request) {
        String requestedWith = request.headerForKey((Object)"x-requested-with");
        return "XMLHttpRequest".equals(requestedWith);
    }

    public static String partialFormSenderID(WORequest request) {
        return request.stringFormValueForKey(KEY_PARTIAL_FORM_SENDER_ID);
    }

    public static String ajaxSubmitButtonName(WORequest request) {
        return request.stringFormValueForKey(KEY_AJAX_SUBMIT_BUTTON);
    }

    public static boolean isAjaxSubmit(WORequest request) {
        return ERXAjaxApplication.ajaxSubmitButtonName(request) != null;
    }

    public static boolean isAjaxReplacement(WORequest request) {
        return request.formValueForKey(KEY_REPLACED) != null;
    }

    public static boolean isAjaxUpdate(WORequest request) {
        return request.formValueForKey(KEY_UPDATE_CONTAINER_ID) != null;
    }

    public static interface ERXAjaxResponseDelegate {
        public WOActionResults handleNullActionResults(WORequest var1, WOResponse var2, WOContext var3);
    }
}

