/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver.navigation;

import com.webobjects.appserver.WOComponent;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.appserver.navigation.ERXNavigationManager;
import er.extensions.foundation.ERXValueUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXNavigationItem {
    private static int counter = 0;
    public static final Logger log = Logger.getLogger(ERXNavigationItem.class);
    public String _uniqueID = new String("id" + counter);
    protected String _action;
    protected NSArray _conditions;
    protected EOQualifier _qualifier;
    protected String _directActionName;
    protected String _directActionClass;
    protected String _name;
    protected String _pageName;
    protected String _displayName;
    protected String _hasActivity;
    protected NSArray _children;
    protected NSArray _childrenConditions;
    protected String _childrenBinding;
    protected NSDictionary _childrenChoices;
    protected NSDictionary _queryBindings;
    protected String _href;
    protected int _height;
    protected int _width;

    public ERXNavigationItem(NSDictionary values) {
        ++counter;
        if (values != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ERXNavigationItem " + this.uniqueID() + "assigned these values at creation:\n" + values));
            }
            this._action = (String)values.valueForKey("action");
            this._conditions = NSArray.EmptyArray;
            Object o = values.valueForKey("conditions");
            if (o != null) {
                if (o instanceof NSArray) {
                    this._conditions = (NSArray)o;
                } else if (o instanceof String) {
                    this._conditions = NSArray.componentsSeparatedByString((String)o, ",");
                }
            }
            if ((o = values.valueForKey("qualifier")) instanceof String && ((String)o).trim().length() > 0) {
                this._qualifier = EOQualifier.qualifierWithQualifierFormat((String)((String)o), null);
            }
            this._href = (String)values.valueForKey("href");
            this._directActionName = (String)values.valueForKey("directActionName");
            this._directActionClass = (String)values.valueForKey("directActionClass");
            if (values.valueForKey("height") != null) {
                this._height = Integer.valueOf((String)values.valueForKey("height"));
            }
            if (values.valueForKey("width") != null) {
                this._width = Integer.valueOf((String)values.valueForKey("width"));
            }
            this._name = (String)values.valueForKey("name");
            this._displayName = (String)values.valueForKey("displayName");
            if (this._displayName == null || this._displayName.length() == 0) {
                this._displayName = this._name;
            }
            this._pageName = (String)values.valueForKey("pageName");
            this._hasActivity = (String)values.valueForKey("hasActivity");
            if (values.valueForKey("children") != null && values.valueForKey("children") instanceof NSArray) {
                this._children = (NSArray)values.valueForKey("children");
            } else if (values.valueForKey("children") != null && values.valueForKey("children") instanceof String) {
                this._childrenBinding = (String)values.valueForKey("children");
            } else {
                this._children = NSArray.EmptyArray;
            }
            this._childrenChoices = values.valueForKey("childrenChoices") != null ? (NSDictionary)values.valueForKey("childrenChoices") : NSDictionary.EmptyDictionary;
            this._queryBindings = values.valueForKey("queryBindings") != null ? (NSDictionary)values.valueForKey("queryBindings") : NSDictionary.EmptyDictionary;
            this._childrenConditions = values.valueForKey("childrenConditions") == null || ((String)values.valueForKey("childrenConditions")).equals("") ? NSArray.EmptyArray : NSArray.componentsSeparatedByString((String)values.valueForKey("childrenConditions"), ",");
        } else {
            log.warn((Object)"Constructing a ERXNavigationItem with a null dictionary!");
        }
    }

    public boolean meetsDisplayConditionsInComponent(WOComponent component) {
        Boolean meetsDisplayConditions = Boolean.TRUE;
        if (this.conditions().count() != 0) {
            Enumeration enumerator = this.conditions().objectEnumerator();
            while (enumerator.hasMoreElements()) {
                String key;
                Object value;
                Object possibleKey = enumerator.nextElement();
                if (possibleKey instanceof String) {
                    String anObject = (String)possibleKey;
                    Object value2 = component.valueForKeyPath(anObject);
                    Boolean bl = meetsDisplayConditions = ERXValueUtilities.booleanValue(value2) ? Boolean.TRUE : Boolean.FALSE;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.name() + " testing display condition: " + anObject + " --> " + value2 + ":" + meetsDisplayConditions));
                    }
                    if (meetsDisplayConditions.booleanValue()) continue;
                    break;
                }
                boolean temp = false;
                Enumeration e2 = ((NSArray)possibleKey).objectEnumerator();
                while (e2.hasMoreElements() && !(temp |= ERXValueUtilities.booleanValue(value = component.valueForKeyPath(key = (String)e2.nextElement())))) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(this.name() + " testing display condition: " + key + " --> " + value + ":" + meetsDisplayConditions));
                }
                meetsDisplayConditions = temp ? Boolean.TRUE : Boolean.FALSE;
                if (meetsDisplayConditions.booleanValue()) continue;
                break;
            }
            if (meetsDisplayConditions.booleanValue() && this.qualifier() != null) {
                meetsDisplayConditions = this.qualifier().evaluateWithObject((Object)this) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return meetsDisplayConditions;
    }

    public NSArray childItemsInContext(NSKeyValueCodingAdditions context) {
        NSArray children = null;
        NSArray childrenConditions = this.childrenConditions();
        boolean hasChildrenConditions = childrenConditions.count() != 0;
        boolean meetsChildrenConditions = true;
        if (hasChildrenConditions) {
            String aCondition;
            Enumeration e = childrenConditions.objectEnumerator();
            while (e.hasMoreElements() && (meetsChildrenConditions = ERXValueUtilities.booleanValue(context.valueForKeyPath(aCondition = (String)e.nextElement())))) {
            }
        }
        if (meetsChildrenConditions) {
            if (this.children() != null) {
                children = this.children();
            } else if (this.childrenBinding() != null) {
                Object o = context.valueForKeyPath(this.childrenBinding());
                if (o != null && o instanceof NSArray) {
                    children = (NSArray)o;
                } else if (o != null && o instanceof String) {
                    children = (NSArray)this.childrenChoices().objectForKey((String)o);
                    if (children == null) {
                        log.warn((Object)("For nav core object: " + this + " and child binding: " + this.childrenBinding() + " couldn't find children for choice key: " + o));
                    }
                } else {
                    log.warn((Object)("For nav core object: " + this + " and child binding: " + this.childrenBinding() + " recieved binding object: " + o));
                }
            }
        }
        if (children == null) {
            children = NSArray.EmptyArray;
        }
        if (((NSArray)children).count() > 0) {
            NSMutableArray<ERXNavigationItem> childNavItems = new NSMutableArray<ERXNavigationItem>();
            Enumeration e = children.objectEnumerator();
            while (e.hasMoreElements()) {
                String childName = (String)e.nextElement();
                ERXNavigationItem item = ERXNavigationManager.manager().navigationItemForName(childName);
                if (item != null) {
                    childNavItems.addObject(item);
                    continue;
                }
                log.warn((Object)("Unable to find navigation item for name: " + childName));
            }
            children = childNavItems;
        }
        return children;
    }

    public boolean isRootNode() {
        return this == ERXNavigationManager.manager().rootNavigationItem();
    }

    public NSArray children() {
        return this._children;
    }

    public EOQualifier qualifier() {
        return this._qualifier;
    }

    public String childrenBinding() {
        return this._childrenBinding;
    }

    public NSArray childrenConditions() {
        return this._childrenConditions;
    }

    public NSDictionary childrenChoices() {
        return this._childrenChoices;
    }

    public NSDictionary queryBindings() {
        return this._queryBindings;
    }

    public String action() {
        return this._action;
    }

    public NSArray conditions() {
        return this._conditions;
    }

    public String href() {
        return this._href;
    }

    public String directActionName() {
        return this.directActionClass() == null ? this._directActionName : this.directActionClass() + "/" + this._directActionName;
    }

    public String directActionClass() {
        return this._directActionClass;
    }

    public int height() {
        return this._height;
    }

    public int width() {
        return this._width;
    }

    public String name() {
        return this._name;
    }

    public String pageName() {
        return this._pageName;
    }

    public String uniqueID() {
        return this._uniqueID;
    }

    public String displayName() {
        return this._displayName;
    }

    public String hasActivity() {
        return this._hasActivity;
    }

    public String toString() {
        return "< " + this.name() + " >";
    }
}

