/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.batching;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.appserver.ERXDisplayGroup;
import er.extensions.components.ERXComponent;
import er.extensions.components.ERXComponentUtilities;
import er.extensions.localization.ERXLocalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXFlickrBatchNavigation
extends ERXComponent {
    private int _lastPageCount = -1;
    private int _lastPageSize = -1;
    private int _lastCurrentPageNumber = -1;
    private NSMutableArray<PageNumber> _pageNumbers;
    private PageNumber _repetitionPageNumber;
    public Integer currentBatchSize;
    private String _parentActionName;

    public ERXFlickrBatchNavigation(WOContext context) {
        super(context);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public NSArray objects() {
        NSArray objects = null;
        if (this.displayGroup() != null) {
            if (this.displayGroup() instanceof ERXDisplayGroup) {
                ERXDisplayGroup dg = (ERXDisplayGroup)this.displayGroup();
                objects = dg.filteredObjects();
            } else {
                objects = this.displayGroup().allObjects();
            }
        }
        return objects;
    }

    public WODisplayGroup displayGroup() {
        return (WODisplayGroup)this.valueForBinding("displayGroup");
    }

    public void setRepetitionPageNumber(PageNumber repetitionPageNumber) {
        this._repetitionPageNumber = repetitionPageNumber;
    }

    public PageNumber repetitionPageNumber() {
        return this._repetitionPageNumber;
    }

    public boolean hasMultiplePages() {
        if (this.batchCount() > 1) {
            return true;
        }
        return this.showBatchSizes() && this.possibleBatchSizes().objectAtIndex(0).intValue() < this.displayNameCount();
    }

    public boolean showLabels() {
        if (this.batchCount() > 1) {
            return true;
        }
        if (this.showBatchSizes()) {
            return this.batchSize() != 0;
        }
        return false;
    }

    public boolean hasPreviousPage() {
        return this.currentBatchIndex() > 1;
    }

    public WOActionResults previousPage() {
        WOActionResults previousPage = null;
        if (this.displayGroup() != null) {
            WODisplayGroup displayGroup = this.displayGroup();
            displayGroup.displayPreviousBatch();
        } else if (this.parentActionName() != null) {
            Integer previousBatchIndex = new Integer(this.currentBatchIndex() - 1);
            if (previousBatchIndex <= 0) {
                previousBatchIndex = new Integer(1);
            }
            this.setValueForBinding(previousBatchIndex, "currentBatchIndex");
            previousPage = this.performParentAction(this.parentActionName());
        }
        return previousPage;
    }

    public boolean hasNextPage() {
        return this.currentBatchIndex() < this.batchCount();
    }

    public WOActionResults nextPage() {
        WOActionResults nextPage = null;
        if (this.displayGroup() != null) {
            WODisplayGroup displayGroup = this.displayGroup();
            displayGroup.displayNextBatch();
        } else if (this.parentActionName() != null) {
            Integer nextBatchIndex = new Integer(this.currentBatchIndex() + 1);
            int pageCount = this.batchCount();
            if (nextBatchIndex > pageCount) {
                nextBatchIndex = new Integer(pageCount);
            }
            this.setValueForBinding(nextBatchIndex, "currentBatchIndex");
            nextPage = this.performParentAction(this.parentActionName());
        }
        return nextPage;
    }

    public WOActionResults selectPage() {
        WOActionResults selectPage = null;
        Integer pageNumber = this._repetitionPageNumber.pageNumber();
        if (pageNumber != null) {
            if (this.displayGroup() != null) {
                this.displayGroup().setCurrentBatchIndex(pageNumber.intValue());
            } else {
                this.setValueForBinding(pageNumber, "currentBatchIndex");
                selectPage = this.performParentAction(this.parentActionName());
            }
        }
        return selectPage;
    }

    public String displayName() {
        String displayName = (String)this.valueForBinding("displayName");
        if (displayName == null) {
            displayName = (String)this.valueForBinding("objectName");
        }
        if (displayName == null) {
            displayName = ERXLocalizer.currentLocalizer().localizedStringForKey("ERXFlickrBatchNavigation.item");
        }
        return displayName;
    }

    public Integer displayNameCount() {
        Integer displayNameCount = new Integer(0);
        if (this.displayGroup() != null) {
            NSArray objects = this.objects();
            if (objects != null && objects.count() > 0) {
                displayNameCount = new Integer(objects.count());
            }
        } else {
            displayNameCount = new Integer(this.maxNumberOfObjects());
        }
        return displayNameCount;
    }

    public boolean isCurrentPageNumber() {
        Integer pageNumber = this._repetitionPageNumber.pageNumber();
        return pageNumber != null && pageNumber == this._lastCurrentPageNumber;
    }

    public NSArray<PageNumber> pageNumbers() {
        int pageCount = this.batchCount();
        int currentPageNumber = this.currentBatchIndex();
        int pageSize = this.numberOfObjectsPerBatch();
        if (this._lastPageCount != pageCount || this._lastCurrentPageNumber != currentPageNumber || this._lastPageSize != pageSize) {
            int minimumCount;
            int nearCount;
            int endCount;
            int nearEdgeCount;
            this._pageNumbers = new NSMutableArray();
            if (ERXComponentUtilities.booleanValueForBinding(this, "small", false)) {
                nearEdgeCount = 1;
                endCount = 1;
                nearCount = 0;
                minimumCount = 5;
            } else {
                nearEdgeCount = 8;
                endCount = 2;
                nearCount = 3;
                minimumCount = 15;
            }
            if (pageCount <= minimumCount) {
                this.addPageNumbers(1, pageCount);
            } else if (currentPageNumber <= nearEdgeCount) {
                this.addPageNumbers(1, Math.max(nearEdgeCount - 1, currentPageNumber + nearCount));
                this.addEllipsis();
                this.addPageNumbers(pageCount - endCount + 1, pageCount);
            } else if (currentPageNumber > pageCount - nearEdgeCount) {
                this.addPageNumbers(1, endCount);
                this.addEllipsis();
                this.addPageNumbers(Math.min(pageCount - nearEdgeCount + 2, currentPageNumber - nearCount), pageCount);
            } else {
                this.addPageNumbers(1, endCount);
                if (currentPageNumber - nearCount > endCount + 1) {
                    this.addEllipsis();
                }
                this.addPageNumbers(Math.max(endCount + 1, currentPageNumber - nearCount), Math.min(currentPageNumber + nearCount, pageCount - endCount));
                if (currentPageNumber + nearCount < pageCount - endCount) {
                    this.addEllipsis();
                }
                this.addPageNumbers(pageCount - endCount + 1, pageCount);
            }
            this._lastPageCount = pageCount;
            this._lastCurrentPageNumber = currentPageNumber;
            this._lastPageSize = pageSize;
        }
        return this._pageNumbers;
    }

    protected void addEllipsis() {
        this._pageNumbers.addObject(new PageNumber(null, true));
    }

    protected void addPageNumbers(int startIndex, int endIndex) {
        for (int pageNumber = startIndex; pageNumber <= endIndex; ++pageNumber) {
            this._pageNumbers.addObject(new PageNumber(pageNumber, false));
        }
    }

    public int batchCount() {
        int batchCount = 0;
        if (this.displayGroup() != null) {
            batchCount = this.displayGroup().batchCount();
        } else {
            int numberOfObjectsPerBatch = this.numberOfObjectsPerBatch();
            int maxNumberOfObjects = this.maxNumberOfObjects();
            if (numberOfObjectsPerBatch != 0) {
                batchCount = maxNumberOfObjects == 0 ? 1 : (maxNumberOfObjects - 1) / numberOfObjectsPerBatch + 1;
            }
        }
        return batchCount;
    }

    public int numberOfObjectsPerBatch() {
        Integer numberOfObjectsPerBatch;
        int numberOfObjects = 0;
        if (this.displayGroup() != null) {
            numberOfObjects = this.displayGroup().numberOfObjectsPerBatch();
        } else if (this.hasBinding("numberOfObjectsPerBatch") && (numberOfObjectsPerBatch = (Integer)this.valueForBinding("numberOfObjectsPerBatch")) != null && numberOfObjectsPerBatch > 0) {
            numberOfObjects = numberOfObjectsPerBatch;
        }
        return numberOfObjects;
    }

    public int maxNumberOfObjects() {
        Integer maxNumberOfObjects;
        int maxNumber = 0;
        if (this.hasBinding("maxNumberOfObjects") && (maxNumberOfObjects = (Integer)this.valueForBinding("maxNumberOfObjects")) != null && maxNumberOfObjects > 0) {
            maxNumber = maxNumberOfObjects;
        }
        return maxNumber;
    }

    public int currentBatchIndex() {
        Integer currentBatchIndex;
        int index = 1;
        if (this.displayGroup() != null) {
            index = this.displayGroup().currentBatchIndex();
        } else if (this.hasBinding("currentBatchIndex") && (currentBatchIndex = (Integer)this.valueForBinding("currentBatchIndex")) != null && currentBatchIndex > 1) {
            index = currentBatchIndex;
        }
        return index;
    }

    public String parentActionName() {
        if (this._parentActionName == null) {
            this._parentActionName = (String)this.valueForBinding("parentActionName");
        }
        return this._parentActionName;
    }

    public int firstIndex() {
        int firstIndex = 0;
        if (this.displayGroup() != null) {
            firstIndex = this.displayGroup().indexOfFirstDisplayedObject();
        } else {
            int currentBatchIndex = this.currentBatchIndex();
            int numberOfObjectsPerBatch = this.numberOfObjectsPerBatch();
            firstIndex = currentBatchIndex * numberOfObjectsPerBatch - (numberOfObjectsPerBatch - 1);
        }
        return firstIndex;
    }

    public int lastIndex() {
        int lastIndex = 0;
        if (this.displayGroup() != null) {
            lastIndex = this.displayGroup().indexOfLastDisplayedObject();
        } else {
            int currentBatchIndex = this.currentBatchIndex();
            int numberOfObjectsPerBatch = this.numberOfObjectsPerBatch();
            lastIndex = currentBatchIndex * numberOfObjectsPerBatch;
        }
        return lastIndex;
    }

    public boolean showBatchSizes() {
        return this.booleanValueForBinding("showBatchSizes") || this.valueForBinding("batchSizes") != null;
    }

    public NSArray<Number> possibleBatchSizes() {
        Object value = this.valueForBinding("batchSizes");
        if (value == null) {
            return new NSArray<Object>(new Object[]{10, 50, 100, 0});
        }
        NSMutableArray<Number> result = new NSMutableArray<Number>();
        if (value instanceof String) {
            String[] parts = value.toString().split("\\s*,");
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                result.addObject(Integer.valueOf(part));
            }
        } else if (value instanceof NSArray) {
            result.addObjectsFromArray((NSArray)value);
        }
        return result;
    }

    public int batchSize() {
        if (this.displayGroup() == null) {
            return 0;
        }
        return this.displayGroup().numberOfObjectsPerBatch();
    }

    public String currentBatchSizeString() {
        return this.currentBatchSize == 0 ? ERXLocalizer.currentLocalizer().localizedStringForKeyWithDefault("ERXFlickrBatchNavigation.all") : this.currentBatchSize + "";
    }

    public boolean isCurrentBatchSizeSelected() {
        if (this.currentBatchSize == null) {
            return this.batchSize() == 0;
        }
        return this.currentBatchSize.equals(this.batchSize());
    }

    public WOActionResults selectBatchSize() {
        this.displayGroup().setNumberOfObjectsPerBatch(this.currentBatchSize.intValue());
        return this.context().page();
    }

    public static class PageNumber {
        private Integer _pageNumber;
        private boolean _ellipsis;

        public PageNumber(Integer pageNumber, boolean ellipsis) {
            this._pageNumber = pageNumber;
            this._ellipsis = ellipsis;
        }

        public Integer pageNumber() {
            return this._pageNumber;
        }

        public boolean isEllipsis() {
            return this._ellipsis;
        }
    }
}

