/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.components._private.ERXSubmitButton;
import er.extensions.foundation.ERXStringUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXAccessibleSubmitButton
extends ERXSubmitButton {
    protected WOAssociation _accesskey;
    protected WOAssociation _accesskeyElement;

    public ERXAccessibleSubmitButton(String name, NSDictionary<String, WOAssociation> associations, WOElement template) {
        super(name, associations, template);
        this._accesskey = (WOAssociation)this._associations.removeObjectForKey("accesskey");
        this._accesskeyElement = (WOAssociation)this._associations.removeObjectForKey("accesskeyElement");
        if (this._accesskeyElement == null) {
            this._accesskeyElement = new WOConstantValueAssociation((Object)"u");
        }
    }

    protected String accesskey(WOComponent component) {
        String accessKey = null;
        if (this._accesskey == null || this._accesskey.valueInComponent(component) == null) {
            String value = (String)this._value.valueInComponent(component);
            if (!ERXStringUtilities.stringIsNullOrEmpty(value) && this.hasUsedHotKey(component, accessKey = value.substring(0, 1))) {
                int i;
                accessKey = null;
                for (i = 1; accessKey == null && i < value.length(); ++i) {
                    if (!Character.isUpperCase(value.charAt(i)) || this.hasUsedHotKey(component, value.substring(i, i + 1))) continue;
                    accessKey = value.substring(i, i + 1);
                }
                for (i = 1; accessKey == null && i < value.length(); ++i) {
                    if (this.hasUsedHotKey(component, value.substring(i, i + 1))) continue;
                    accessKey = value.substring(i, i + 1);
                }
            }
        } else {
            accessKey = (String)this._accesskey.valueInComponent(component);
            accessKey = "".equals(accessKey) ? null : accessKey;
        }
        return accessKey;
    }

    protected String accesskeyElement(WOComponent component) {
        return (String)this._accesskeyElement.valueInComponent(component);
    }

    protected boolean isDisabled(WOComponent component) {
        return this.accesskey(component) == null;
    }

    protected String styledValue(WOComponent component) {
        String value = (String)this._value.valueInComponent(component);
        String accessKey = this.accesskey(component);
        if (accessKey == null) {
            return value;
        }
        String accesskeyElement = this.accesskeyElement(component);
        int index = value.indexOf(accessKey);
        if (index != -1) {
            StringBuffer sb = new StringBuffer();
            sb.append(value.substring(0, index));
            sb.append("<");
            sb.append(accesskeyElement);
            sb.append(">");
            sb.append(accessKey);
            sb.append("</");
            int coIndex = accesskeyElement.indexOf(32);
            sb.append(coIndex == -1 ? accesskeyElement : accesskeyElement.substring(0, coIndex));
            sb.append(">");
            sb.append(value.substring(index + 1));
            value = sb.toString();
        }
        return value;
    }

    @Override
    public void appendToResponse(WOResponse response, WOContext context) {
        super.appendToResponse(response, context);
        if (this.accesskey(context.component()) != null) {
            this.recordUsedHotKey(context.component(), this.accesskey(context.component()));
        }
    }

    @Override
    public void appendAttributesToResponse(WOResponse response, WOContext context) {
        super.appendAttributesToResponse(response, context);
        response._appendTagAttributeAndValue("accesskey", this.accesskey(context.component()), false);
    }

    @Override
    public void appendChildrenToResponse(WOResponse response, WOContext context) {
        if (this.hasChildrenElements()) {
            super.appendChildrenToResponse(response, context);
        } else {
            response.appendContentString(this.styledValue(context.component()));
        }
    }

    protected boolean hasUsedHotKey(WOComponent component, String hotKey) {
        return this.usedHotKeys(component).containsObject(hotKey);
    }

    protected void recordUsedHotKey(WOComponent component, String hotKey) {
        this.usedHotKeys(component).addObject(hotKey);
    }

    protected NSMutableArray usedHotKeys(WOComponent component) {
        NSMutableArray usedHotKeys;
        WOResponse response = component.context().response();
        NSMutableDictionary<String, NSMutableArray<Object>> userInfo = response.userInfo();
        if (userInfo == null) {
            userInfo = new NSMutableDictionary(new NSMutableArray(), ERXAccessibleSubmitButton.class.getName());
            response.setUserInfo(userInfo);
        }
        if ((usedHotKeys = (NSMutableArray)userInfo.objectForKey(ERXAccessibleSubmitButton.class.getName())) == null) {
            userInfo = ((NSDictionary)userInfo).mutableClone();
            usedHotKeys = new NSMutableArray();
            userInfo.setObjectForKey(usedHotKeys, ERXAccessibleSubmitButton.class.getName());
            response.setUserInfo(userInfo);
        }
        return (NSMutableArray)userInfo.objectForKey(ERXAccessibleSubmitButton.class.getName());
    }
}

