/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import er.extensions.ERXExtensions;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

public class ERXLocalizationEditor
extends WOComponent {
    public String currentLanguage;
    public String currentFilename;
    public String currentFramework;
    public NSMutableArray data;
    public NSMutableDictionary currentEntry;
    public String selectedFramework;
    public String selectedFilename;
    public String UNSET = new String("***UNSET***");
    public WODisplayGroup displayGroup = new WODisplayGroup();
    public String keyToAdd;

    public ERXLocalizationEditor(WOContext context) {
        super(context);
        this.displayGroup.setSortOrderings(new NSArray<EOSortOrdering>(new EOSortOrdering("key", EOSortOrdering.CompareCaseInsensitiveAscending)));
        this.displayGroup.setNumberOfObjectsPerBatch(20);
        this.displayGroup.setDefaultStringMatchFormat("*%@*");
        this.displayGroup.setDefaultStringMatchOperator(EOQualifier.QualifierOperatorCaseInsensitiveLike.name());
    }

    public void awake() {
        super.awake();
        this.keyToAdd = null;
        if (this.displayGroup != null) {
            this.displayGroup.setSelectedObject(null);
        }
    }

    public NSArray availableLanguages() {
        return ERXLocalizer.availableLanguages();
    }

    public NSArray frameworkSearchPath() {
        return ERXLocalizer.frameworkSearchPath();
    }

    public NSArray fileNamesToWatch() {
        return ERXLocalizer.fileNamesToWatch();
    }

    public URL urlForCurrentFile() {
        return ERXFileUtilities.pathURLForResourceNamed(this.currentFilename, this.currentFramework, new NSArray<String>(this.currentLanguage));
    }

    public URL urlForSelectedFile() {
        return ERXFileUtilities.pathURLForResourceNamed(this.selectedFilename, this.selectedFramework, new NSArray<String>(this.currentLanguage));
    }

    public boolean fileExistsInLanguage() {
        return this.urlForCurrentFile() != null;
    }

    public void editFramework() {
        this.data = new NSMutableArray();
        NSMutableDictionary dataDictionary = new NSMutableDictionary();
        this.selectedFilename = this.currentFilename;
        this.selectedFramework = this.currentFramework;
        NSMutableSet allKeys = new NSMutableSet();
        Enumeration languages = this.availableLanguages().objectEnumerator();
        while (languages.hasMoreElements()) {
            String language = (String)languages.nextElement();
            NSArray<String> languageArray = new NSArray<String>(language);
            URL url = ERXFileUtilities.pathURLForResourceNamed(this.currentFilename, this.currentFramework, languageArray);
            if (url == null) continue;
            NSDictionary dict = (NSDictionary)ERXExtensions.readPropertyListFromFileInFramework(this.currentFilename, this.currentFramework, languageArray);
            allKeys.addObjectsFromArray(dict.allKeys());
            Enumeration keys = dict.allKeys().objectEnumerator();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                NSMutableDictionary<String, String> entry = (NSMutableDictionary<String, String>)dataDictionary.objectForKey(key);
                if (entry == null) {
                    entry = new NSMutableDictionary<String, String>();
                    entry.setObjectForKey(key, "key");
                    dataDictionary.setObjectForKey(entry, key);
                    this.data.addObject(entry);
                }
                entry.setObjectForKey((String)dict.objectForKey(key), language);
            }
        }
        Enumeration keys = allKeys.objectEnumerator();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            NSMutableDictionary entry = (NSMutableDictionary)dataDictionary.objectForKey(key);
            Enumeration languages2 = this.availableLanguages().objectEnumerator();
            while (languages2.hasMoreElements()) {
                String language = (String)languages2.nextElement();
                if (entry.objectForKey(language) != null) continue;
                entry.setObjectForKey(this.UNSET, language);
            }
        }
        this.displayGroup.setObjectArray((NSArray)this.data);
    }

    public boolean isLargeEntry() {
        String language = this.currentLanguage;
        Object object = this.currentEntry.objectForKey(language);
        return object != null && (object.toString().length() > 25 || object.toString().indexOf(10) >= 0 || !(object instanceof String));
    }

    public String highlightClass() {
        if (!this.hasCurrentValue()) {
            return "unset";
        }
        return "inputfield";
    }

    public String valueCellWidth() {
        int width = 100 / this.availableLanguages().count();
        return "" + width + "%";
    }

    public int colspanForBatchNavigation() {
        if (this.availableLanguages() != null && this.availableLanguages().count() > 1) {
            return this.availableLanguages().count() - 1;
        }
        return 1;
    }

    public String valueComponentName() {
        return this.isLargeEntry() ? "WOText" : "WOTextField";
    }

    public void saveFramework() throws IOException {
        Enumeration languages = this.availableLanguages().objectEnumerator();
        while (languages.hasMoreElements()) {
            String language = (String)languages.nextElement();
            NSArray<String> languageArray = new NSArray<String>(language);
            URL url = ERXFileUtilities.pathURLForResourceNamed(this.selectedFilename, this.selectedFramework, languageArray);
            NSMutableDictionary dict = new NSMutableDictionary();
            Enumeration entries = this.data.objectEnumerator();
            while (entries.hasMoreElements()) {
                NSDictionary entry = (NSDictionary)entries.nextElement();
                String key = (String)entry.objectForKey("key");
                Object value = entry.objectForKey(language);
                if (value == null || value.equals(this.UNSET)) continue;
                dict.setObjectForKey(value, key);
            }
            String result = ERXStringUtilities.stringFromDictionary(dict);
            NSDictionary newDict = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)result);
            if (!newDict.equals(dict)) {
                throw new IllegalStateException("Data wasn't equal when comparing before save");
            }
            if (url == null) continue;
            ERXFileUtilities.stringToFile(result, new File(url.getFile()));
        }
    }

    private Object currentValueObject() {
        Object result = null;
        if (this.currentEntry != null) {
            result = this.currentEntry.objectForKey(this.currentLanguage);
        }
        return result;
    }

    public boolean hasCurrentValue() {
        return this.currentValueObject() != this.UNSET;
    }

    public String currentValue() {
        String result = null;
        if (this.currentEntry != null) {
            Object item = this.currentEntry.objectForKey(this.currentLanguage);
            result = item instanceof String ? (String)item : NSPropertyListSerialization.stringFromPropertyList(item);
        }
        return result;
    }

    public void setCurrentValue(String value) {
        if (this.currentEntry != null) {
            Object item = this.currentEntry.objectForKey(this.currentLanguage);
            Object newValue = item instanceof String ? value : NSPropertyListSerialization.propertyListFromString((String)value);
            if (newValue == null) {
                newValue = this.UNSET;
            }
            this.currentEntry.setObjectForKey(newValue, this.currentLanguage);
        }
    }

    public WOComponent sortEntries() {
        EOSortOrdering sortOrdering = EOSortOrdering.sortOrderingWithKey((String)this.currentLanguage, (NSSelector)EOSortOrdering.CompareAscending);
        this.displayGroup.setSortOrderings(new NSArray<EOSortOrdering>(sortOrdering));
        this.displayGroup.qualifyDisplayGroup();
        return this.context().page();
    }

    public WOComponent addEntry() {
        if (this.keyToAdd != null && this.data != null && this.displayGroup != null) {
            NSMutableDictionary<String, String> entry = new NSMutableDictionary<String, String>();
            entry.setObjectForKey(this.keyToAdd, "key");
            for (int i = 0; i < this.availableLanguages().count(); ++i) {
                entry.setObjectForKey(this.UNSET, (String)this.availableLanguages().objectAtIndex(i));
            }
            this.data.addObject(entry);
            this.displayGroup.setObjectArray((NSArray)this.data);
            this.displayGroup.qualifyDataSource();
            this.displayGroup.setSelectedObject(entry);
            this.displayGroup.displayBatchContainingSelectedObject();
        }
        return this.context().page();
    }

    public WOComponent removeEntry() {
        if (this.currentEntry != null) {
            this.data.removeObject(this.currentEntry);
            this.displayGroup.setObjectArray((NSArray)this.data);
            this.displayGroup.qualifyDisplayGroup();
        }
        return this.context().page();
    }
}

