/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components.javascript;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.components._private.ERXWOForm;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXStringUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXJSPopUpRelationPicker
extends ERXStatelessComponent {
    public static final Logger log = Logger.getLogger(ERXJSPopUpRelationPicker.class);
    public static final Logger jsLog = Logger.getLogger((String)"er.extensions.ERXJSPopUpRelationPicker.script");
    protected Integer _size;
    protected String _childDisplayValueName;
    protected String _parentDisplayValueName;
    protected NSArray _parentEntitiesList;
    protected String _parentToChildrenRelationshipName;
    protected NSArray _parentSelection;
    protected NSArray _childrenSelection;
    protected String _parentPopUpStringForAll;
    protected String _childPopUpStringForAll;
    protected String _parentLabel;
    protected String _childLabel;
    protected String _childrenSortKey;
    protected String _defaultChildKey;
    protected Boolean _multiple;
    protected NSArray _possibleChildren;
    protected String parentSelectName;
    protected String childSelectName;
    protected String pickerName;
    protected String objectsArrayName;
    private static final int NOT_FOUND = -1;
    private static final NSArray UNSET = new NSArray();

    public ERXJSPopUpRelationPicker(WOContext aContext) {
        super(aContext);
    }

    public void awake() {
        super.awake();
        this.updateVarNames();
    }

    protected void updateVarNames() {
        String elementID = this.context().elementID();
        elementID = ERXStringUtilities.replaceStringByStringInString(".", "_", elementID);
        this.pickerName = "picker_" + elementID;
        this.parentSelectName = "parent_" + elementID;
        this.childSelectName = "child_" + elementID;
        this.objectsArrayName = "parents_children_" + elementID;
    }

    protected int offsetForID(String id) {
        if (id != null && id.trim().length() != 0 && !"WONoSelectionString".equals(id)) {
            try {
                return Integer.parseInt(id);
            }
            catch (Exception e) {
                log.info((Object)"Exception while parsing ID", (Throwable)e);
            }
        }
        return -1;
    }

    protected Object parentFromID(String id) {
        int offset = this.offsetForID(id);
        if (offset != -1) {
            return this.parentEntitiesList().objectAtIndex(offset);
        }
        return null;
    }

    protected Object idForParent(Object parent) {
        if (parent != null) {
            return new Integer(this.parentEntitiesList().indexOfObject(parent));
        }
        return null;
    }

    protected Object childFromID(Object parent, String id) {
        if (id != null) {
            NSArray<String> ids = NSArray.componentsSeparatedByString(id, "|");
            if (ids.count() == 2) {
                int offset;
                if (parent == null) {
                    parent = this.parentFromID(ids.objectAtIndex(0));
                }
                if ((offset = this.offsetForID(ids.objectAtIndex(1))) != -1 && parent != null) {
                    return this.sortedChildren(parent).objectAtIndex(offset);
                }
            } else {
                log.info((Object)("Child ID not valid: " + id));
            }
        }
        return null;
    }

    protected int offsetForChild(Object parent, Object child) {
        return parent != null ? this.sortedChildren(parent).indexOfObject(child) : -1;
    }

    protected Object idForChild(Object parent, Object child) {
        if (parent != null) {
            int offset = this.sortedChildren(parent).indexOfObject(child);
            if (offset != -1) {
                return this.idForParent(parent) + "|" + offset;
            }
        } else {
            Enumeration parents = this.parentEntitiesList().objectEnumerator();
            while (parents.hasMoreElements()) {
                Object aParent = parents.nextElement();
                int offset = this.sortedChildren(aParent).indexOfObject(child);
                if (offset == -1) continue;
                return this.idForParent(aParent) + "|" + offset;
            }
        }
        return null;
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        NSArray parentFormValues = request.formValuesForKey(this.parentSelectName);
        NSArray childFormValues = request.formValuesForKey(this.childSelectName);
        if (parentFormValues != null && childFormValues != null) {
            NSArray children;
            Enumeration ids;
            if (parentFormValues.containsObject("WONoSelectionString")) {
                this.setSelectedParents(null);
            } else {
                NSMutableArray<Object> parents = new NSMutableArray<Object>();
                ids = parentFormValues.objectEnumerator();
                while (ids.hasMoreElements()) {
                    Object parent = this.parentFromID((String)ids.nextElement());
                    if (parent == null) continue;
                    parents.addObject(parent);
                }
                this.setSelectedParents(parents);
            }
            if (childFormValues.containsObject("WONoSelectionString")) {
                children = (NSArray)this.parentSelection().valueForKeyPath(this.parentToChildrenRelationshipName());
                if (parentFormValues.containsObject("WONoSelectionString")) {
                    this.setChildrenSelection(null);
                } else if (!this.multiple()) {
                    this.setChildrenSelection(null);
                } else {
                    this.setChildrenSelection(ERXArrayUtilities.flatten(children));
                }
            } else {
                children = new NSMutableArray();
                ids = childFormValues.objectEnumerator();
                while (ids.hasMoreElements()) {
                    Object child = this.childFromID(null, (String)ids.nextElement());
                    if (child == null) continue;
                    ((NSMutableArray)children).addObject(child);
                }
                this.setChildrenSelection(children);
            }
        }
        super.takeValuesFromRequest(request, context);
    }

    protected NSArray possibleChildren() {
        if (this._possibleChildren != null) {
            this._possibleChildren = (NSArray)this.valueForBinding("possibleChildren");
            if (this._possibleChildren == null) {
                this._possibleChildren = UNSET;
            }
        }
        return this._possibleChildren == UNSET ? null : this._possibleChildren;
    }

    protected NSArray unsortedChildren(Object parent) {
        NSArray result = (NSArray)NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)parent, (String)(this.parentToChildrenRelationshipName() + (parent instanceof NSArray ? ".@flatten.@removeNullValues" : "")));
        NSArray restrictedChoices = this.possibleChildren();
        if (restrictedChoices != null) {
            result = ERXArrayUtilities.intersectingElements(result, restrictedChoices);
        }
        return result;
    }

    protected NSArray sortedChildren(Object parent) {
        EOSortOrdering sortOrdering = new EOSortOrdering(this.childrenSortKey(), EOSortOrdering.CompareAscending);
        NSMutableArray<EOSortOrdering> sortArray = new NSMutableArray<EOSortOrdering>(sortOrdering);
        NSArray result = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)this.unsortedChildren(parent), sortArray);
        return result != null ? result : NSArray.EmptyArray;
    }

    public String jsString() {
        StringBuffer returnString = new StringBuffer(2000);
        returnString.append("\n");
        returnString.append("" + this.objectArrayCreationString() + "\n");
        if (jsLog.isDebugEnabled()) {
            jsLog.debug((Object)("JSPopUpRelationPicker jsString  returnString is " + returnString));
        }
        return returnString.toString();
    }

    public String hiddenFormElementStrings() {
        int childToSelectInt;
        StringBuffer returnString = new StringBuffer(500);
        returnString.append("\n<script language=\"JavaScript\">");
        String childToSelect = "";
        if (!this.multiple() && this.childrenSelection() != null && this.childrenSelection().count() == 1 && this.parentSelection() != null && this.parentSelection().count() == 1 && (childToSelectInt = this.offsetForChild(this.parentSelection().objectAtIndex(0), this.childrenSelection().objectAtIndex(0))) != -1) {
            childToSelect = "" + childToSelectInt;
        }
        returnString.append("\nvar " + this.pickerName + " = new ERXJSPopupRelationshipPicker(" + this.objectsArrayName + "," + "window.document." + this.formName() + "." + this.parentSelectName + "," + (this.parentPopUpStringForAll() != null ? "\"" + this.parentPopUpStringForAll().replace('\n', ' ') + "\"" : "null") + "," + "window.document." + this.formName() + "." + this.childSelectName + "," + (this.childPopUpStringForAll() != null ? "\"" + this.childPopUpStringForAll() + "\"" : "null") + ");\n" + (this.parentPopUpStringForAll() == null ? this.pickerName + ".parentChanged(" + childToSelect + ");" : "") + "\n</script>");
        log.debug((Object)returnString);
        return returnString.toString();
    }

    public String parentPopUpString() {
        StringBuffer returnString = this.selectHeader(this.parentSelectName, this.pickerName + ".parentChanged();");
        if (this.parentSelection().count() == 0 && this.parentPopUpStringForAll() == null) {
            this.setSelectedParents(new NSArray(this.parentEntitiesList().objectAtIndex(0)));
        }
        int iCount = this.parentEntitiesList().count();
        for (int i = 0; i < iCount; ++i) {
            Object aEntity = this.parentEntitiesList().objectAtIndex(i);
            returnString.append("\t<option ");
            if (this.isSelectedParent(aEntity)) {
                returnString.append("selected=\"selected\" ");
            }
            returnString.append("value=\"" + this.idForParent(aEntity) + "\">");
            returnString.append(NSKeyValueCodingAdditions.Utility.valueForKeyPath(aEntity, (String)this.parentDisplayValueName()));
            returnString.append("</option>\n");
        }
        returnString.append("</select>\n");
        return returnString.toString();
    }

    public String formName() {
        return ERXWOForm.formName(this.context(), "forms[0]");
    }

    public String childPopUpString() {
        StringBuffer returnString = this.selectHeader(this.childSelectName, this.pickerName + ".childChanged();");
        if (this.parentSelection().count() != 0) {
            if (this.childrenSelection().count() == 0 && this.defaultChildKey() != null) {
                this.setChildrenSelection((NSArray)NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)this.parentSelection(), (String)(this.defaultChildKey() + ".@flatten")));
            }
            this.appendChildPopupStringWithParent(returnString, this.parentSelection());
        } else if (this.parentPopUpStringForAll() != null) {
            this.appendChildPopupStringWithParent(returnString, this.parentEntitiesList());
        } else {
            Object aParent = this.parentEntitiesList().objectAtIndex(0);
            this.setChildrenSelection(this.defaultChildKey() != null ? (NSArray)NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)this.parentSelection(), (String)(this.defaultChildKey() + ".@flatten")) : NSArray.EmptyArray);
            this.appendChildPopupStringWithParent(returnString, new NSArray(aParent));
        }
        returnString.append("</select>\n");
        if (jsLog.isDebugEnabled()) {
            jsLog.debug((Object)("JSPopUpRelationPicker childPopUpString  returnString is " + returnString));
        }
        return returnString.toString();
    }

    private void appendChildPopupStringWithParent(StringBuffer returnString, NSArray aParents) {
        NSArray children = this.sortedChildren(aParents);
        int iCount = children.count();
        for (int i = 0; i < iCount; ++i) {
            Object aChild = children.objectAtIndex(i);
            returnString.append("\t<option ");
            if (i == iCount - 1 && this.childrenSelection().count() == 0 && this.childPopUpStringForAll() == null || this.isSelectedChild(aChild)) {
                returnString.append("selected=\"selected\" ");
            }
            returnString.append("value=\"" + this.idForChild(null, aChild) + "\">");
            returnString.append(NSKeyValueCodingAdditions.Utility.valueForKeyPath(aChild, (String)this.childDisplayValueName()));
            returnString.append("</option>\n");
        }
    }

    protected StringBuffer selectHeader(String nm, String onChange) {
        StringBuffer returnString = new StringBuffer(1000);
        returnString.append("<select name=\"" + nm + "\"" + " size=\"" + this.size() + "\"");
        if (onChange != null) {
            returnString.append(" onChange=\"" + onChange + "\"");
        }
        if (this.multiple()) {
            returnString.append(" multiple=\"multiple\"");
        }
        returnString.append(">\n");
        return returnString;
    }

    public String objectArrayCreationString() {
        StringBuffer returnString = new StringBuffer(1000);
        returnString.append("var " + this.objectsArrayName + " = new Array(");
        int iCount = this.parentEntitiesList().count();
        for (int i = 0; i < iCount; ++i) {
            Object aParent = this.parentEntitiesList().objectAtIndex(i);
            returnString.append("\n\tnew Entity(");
            returnString.append(" \"" + NSKeyValueCodingAdditions.Utility.valueForKeyPath(aParent, (String)this.parentDisplayValueName()) + "\",");
            returnString.append(" \"" + this.idForParent(aParent) + "\",");
            returnString.append(" \"" + System.identityHashCode(aParent) + "\",");
            returnString.append(" new Array(");
            NSArray childrenOfAParent = this.sortedChildren(aParent);
            int jCount = childrenOfAParent.count();
            Object defaultChild = this.defaultChildKey() != null ? NSKeyValueCodingAdditions.Utility.valueForKeyPath(aParent, (String)this.defaultChildKey()) : null;
            int defaultChildIndex = -1;
            for (int j = 0; j < jCount; ++j) {
                Object aChild = childrenOfAParent.objectAtIndex(j);
                returnString.append("\n\t\t new Entity(");
                returnString.append(" \"" + NSKeyValueCodingAdditions.Utility.valueForKeyPath(aChild, (String)this.childDisplayValueName()) + "\",");
                returnString.append(" \"" + this.idForChild(aParent, aChild) + "\",");
                returnString.append(" \"" + System.identityHashCode(aChild) + "\",");
                returnString.append(" null,");
                if (this.isSelectedChild(aChild)) {
                    returnString.append(" true");
                } else {
                    returnString.append(" false");
                }
                returnString.append(", null");
                returnString.append(")");
                if (j != jCount - 1) {
                    returnString.append(", ");
                }
                if (aChild != defaultChild) continue;
                defaultChildIndex = j;
            }
            returnString.append("),");
            if (this.isSelectedParent(aParent)) {
                returnString.append(" true");
            } else {
                returnString.append(" false");
            }
            returnString.append(", ");
            returnString.append(defaultChild != null ? "\"" + defaultChildIndex + "\"" : "-1");
            returnString.append(")");
            if (i == iCount - 1) continue;
            returnString.append(", ");
        }
        returnString.append(");");
        return returnString.toString();
    }

    private boolean isSelectedParent(Object aParent) {
        return this.parentSelection().containsObject(aParent);
    }

    private boolean isSelectedChild(Object aChild) {
        return this.childrenSelection().containsObject(aChild);
    }

    public NSArray parentEntitiesList() {
        if (this._parentEntitiesList == null) {
            this._parentEntitiesList = (NSArray)this.valueForBinding("parentEntitiesList");
        }
        return this._parentEntitiesList;
    }

    public NSArray parentSelection() {
        if (this._parentSelection == null) {
            if (this.multiple()) {
                this._parentSelection = (NSArray)this.valueForBinding("parentSelection");
            } else {
                Object parent = this.valueForBinding("parentSelection");
                if (parent != null) {
                    this._parentSelection = new NSArray<Object>(parent);
                }
            }
            if (this._parentSelection == null) {
                this._parentSelection = NSArray.EmptyArray;
            }
        }
        return this._parentSelection;
    }

    public void setSelectedParents(NSArray value) {
        if (!this.multiple() && this.canSetValueForBinding("parentSelection")) {
            this.setValueForBinding(value == null ? null : value.lastObject(), "parentSelection");
        } else if (this.multiple() && this.canSetValueForBinding("parentSelection")) {
            this.setValueForBinding(value, "parentSelection");
        }
        this._parentSelection = value;
    }

    public NSArray childrenSelection() {
        if (this._childrenSelection == null) {
            if (this.multiple()) {
                this._childrenSelection = (NSArray)this.valueForBinding("childrenSelection");
            } else {
                Object child = this.valueForBinding("childrenSelection");
                if (child != null) {
                    this._childrenSelection = new NSArray<Object>(child);
                }
            }
            if (this._childrenSelection == null) {
                this._childrenSelection = NSArray.EmptyArray;
            }
        }
        return this._childrenSelection;
    }

    public void setChildrenSelection(NSArray value) {
        if (!this.multiple() && this.canSetValueForBinding("childrenSelection")) {
            this.setValueForBinding(value == null ? null : value.lastObject(), "childrenSelection");
        } else if (this.multiple() && this.canSetValueForBinding("childrenSelection")) {
            this.setValueForBinding(value, "childrenSelection");
        }
        this._childrenSelection = value;
    }

    public String defaultChildKey() {
        if (this._defaultChildKey == null) {
            this._defaultChildKey = (String)this.valueForBinding("defaultChildKey");
        }
        return this._defaultChildKey;
    }

    public String childrenSortKey() {
        if (this._childrenSortKey == null) {
            this._childrenSortKey = (String)this.valueForBinding("childrenSortKey");
        }
        return this._childrenSortKey;
    }

    public String childLabel() {
        if (this._childLabel == null) {
            this._childLabel = (String)this.valueForBinding("childLabel");
            if (this._childLabel == null) {
                this._childLabel = "Types";
            }
        }
        return this._childLabel;
    }

    public String parentLabel() {
        if (this._parentLabel == null) {
            this._parentLabel = (String)this.valueForBinding("parentLabel");
            if (this._parentLabel == null) {
                this._parentLabel = "Categories";
            }
        }
        return this._parentLabel;
    }

    public String childDisplayValueName() {
        if (this._childDisplayValueName == null) {
            this._childDisplayValueName = (String)this.valueForBinding("childDisplayValueName");
        }
        return this._childDisplayValueName;
    }

    public String parentDisplayValueName() {
        if (this._parentDisplayValueName == null) {
            this._parentDisplayValueName = (String)this.valueForBinding("parentDisplayValueName");
        }
        return this._parentDisplayValueName;
    }

    public String parentToChildrenRelationshipName() {
        if (this._parentToChildrenRelationshipName == null) {
            this._parentToChildrenRelationshipName = (String)this.valueForBinding("parentToChildrenRelationshipName");
        }
        return this._parentToChildrenRelationshipName;
    }

    public String parentPopUpStringForAll() {
        if (this._parentPopUpStringForAll == null) {
            this._parentPopUpStringForAll = (String)this.valueForBinding("parentPopUpStringForAll");
        }
        return this._parentPopUpStringForAll;
    }

    public String childPopUpStringForAll() {
        if (this._childPopUpStringForAll == null) {
            this._childPopUpStringForAll = (String)this.valueForBinding("childPopUpStringForAll");
        }
        return this._childPopUpStringForAll;
    }

    public int size() {
        if (this._size == null) {
            this._size = new Integer(this.intValueForBinding("size", this.multiple() ? 5 : 1));
        }
        return this._size;
    }

    public boolean multiple() {
        if (this._multiple == null) {
            this._multiple = this.booleanValueForBinding("multiple") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._multiple;
    }

    public void reset() {
        super.reset();
        this._childrenSelection = null;
        this._parentSelection = null;
        this._parentEntitiesList = null;
        this._childLabel = null;
        this._parentLabel = null;
        this._defaultChildKey = null;
        this._childrenSortKey = null;
        this._multiple = null;
        this._childDisplayValueName = null;
        this._parentDisplayValueName = null;
        this._parentToChildrenRelationshipName = null;
        this._parentPopUpStringForAll = null;
        this._childPopUpStringForAll = null;
        this._possibleChildren = null;
        this._size = null;
    }
}

