/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.appserver.WOSession;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorOperation;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseChannel;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EODatabaseOperation;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOEntityClassDescription;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOObjectNotAvailableException;
import com.webobjects.eoaccess.EOProperty;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSQLExpressionFactory;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFaultHandler;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSDelegate;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import er.extensions.appserver.ERXSession;
import er.extensions.eof.ERXDatabaseContextDelegate;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOGlobalIDUtilities;
import er.extensions.eof.ERXEntityClassDescription;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXThreadStorage;
import er.extensions.foundation.ERXUtilities;
import er.extensions.jdbc.ERXSQLHelper;
import er.extensions.statistics.ERXStats;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXEOAccessUtilities {
    public static final Logger log = Logger.getLogger(ERXEOAccessUtilities.class);
    private static Logger sqlLoggingLogger = null;
    private static Set _keysWithWarning = Collections.synchronizedSet(new HashSet());

    public static EOEntity entityMatchingString(EOEditingContext ec, String string) {
        EOEntity result = null;
        if (string != null) {
            NSArray entityNames = null;
            String lowerCaseName = string.toLowerCase();
            if (entityNames == null) {
                EOModelGroup group = ERXEOAccessUtilities.modelGroup(ec);
                entityNames = (NSArray)ERXUtilities.entitiesForModelGroup(group).valueForKeyPath("name.toLowerCase");
            }
            NSMutableArray<String> possibleEntities = new NSMutableArray<String>();
            Enumeration e = entityNames.objectEnumerator();
            while (e.hasMoreElements()) {
                String lowercaseEntityName = (String)e.nextElement();
                if (lowerCaseName.indexOf(lowercaseEntityName) == -1) continue;
                possibleEntities.addObject(lowercaseEntityName);
            }
            if (possibleEntities.count() == 1) {
                result = ERXUtilities.caseInsensitiveEntityNamed((String)possibleEntities.lastObject());
            } else if (possibleEntities.count() > 1) {
                ERXArrayUtilities.sortArrayWithKey(possibleEntities, "length");
                if (((String)possibleEntities.objectAtIndex(0)).length() == ((String)possibleEntities.lastObject()).length()) {
                    log.warn((Object)("Found multiple entities of the same length for string: " + string + " possible entities: " + possibleEntities));
                }
                result = ERXUtilities.caseInsensitiveEntityNamed((String)possibleEntities.lastObject());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found possible entities: " + possibleEntities + " for string: " + string + " result: " + result));
            }
        }
        return result;
    }

    public static EOEntity entityUsingTable(EOEditingContext ec, String tableName) {
        EOEntity result = null;
        NSMutableArray<EOEntity> possibleEntities = new NSMutableArray<EOEntity>();
        if (tableName != null) {
            NSArray entities = ERXUtilities.entitiesForModelGroup(ERXEOAccessUtilities.modelGroup(ec));
            tableName = tableName.toLowerCase();
            Enumeration e = entities.objectEnumerator();
            while (e.hasMoreElements()) {
                String lowercaseTableName;
                EOEntity entity = (EOEntity)e.nextElement();
                if (entity.externalName() == null || !tableName.equals(lowercaseTableName = entity.externalName().toLowerCase())) continue;
                EOEntity root = entity;
                while (root.parentEntity() != null && lowercaseTableName.equalsIgnoreCase(root.parentEntity().externalName())) {
                    root = root.parentEntity();
                }
                if (possibleEntities.containsObject(root)) continue;
                possibleEntities.addObject(root);
            }
            if (possibleEntities.count() > 0) {
                result = (EOEntity)possibleEntities.lastObject();
            }
            if (log.isEnabledFor((Priority)Level.WARN) && possibleEntities.count() > 1) {
                log.warn((Object)("Found multiple entities: " + possibleEntities.valueForKey("name") + " for table name: " + tableName));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found possible entities: " + possibleEntities.valueForKey("name") + " for table name: " + tableName + " result: " + result));
            }
        }
        return result;
    }

    public static boolean entityWithNamedIsShared(EOEditingContext ec, String entityName) {
        if (entityName == null) {
            throw new IllegalStateException("Entity name argument is null for method: entityWithNamedIsShared");
        }
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        return entity != null && entity.sharedObjectFetchSpecificationNames().count() > 0;
    }

    public static Number getNextValFromSequenceNamed(EOEditingContext ec, String modelName, String sequenceName) {
        EODatabaseContext dbContext = EOUtilities.databaseContextForModelNamed((EOEditingContext)ec, (String)modelName);
        return ERXSQLHelper.newSQLHelper(dbContext).getNextValFromSequenceNamed(ec, modelName, sequenceName);
    }

    public static void evaluateSQLWithEntityNamed(EOEditingContext ec, String entityName, String exp) {
        EOEntity entity = EOUtilities.entityNamed((EOEditingContext)ec, (String)entityName);
        ERXEOAccessUtilities.evaluateSQLWithEntity(ec, entity, exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evaluateSQLWithEntity(EOEditingContext ec, EOEntity entity, String exp) {
        EODatabaseContext dbContext = EODatabaseContext.registeredDatabaseContextForModel((EOModel)entity.model(), (EOEditingContext)ec);
        dbContext.lock();
        try {
            EOAdaptorChannel adaptorChannel = dbContext.availableChannel().adaptorChannel();
            if (!adaptorChannel.isOpen()) {
                adaptorChannel.openChannel();
            }
            EOSQLExpressionFactory factory = adaptorChannel.adaptorContext().adaptor().expressionFactory();
            if (log.isInfoEnabled()) {
                log.info((Object)("Executing " + exp));
            }
            boolean contextHadOpenTransaction = adaptorChannel.adaptorContext().hasOpenTransaction();
            try {
                adaptorChannel.evaluateExpression(factory.expressionForString(exp));
            }
            catch (EOGeneralAdaptorException e) {
                if (adaptorChannel.adaptorContext().hasOpenTransaction() && !contextHadOpenTransaction) {
                    adaptorChannel.adaptorContext().rollbackTransaction();
                }
                throw e;
            }
        }
        finally {
            dbContext.unlock();
        }
    }

    public static String sqlForFetchSpecification(EOEditingContext ec, EOFetchSpecification spec) {
        return ERXEOAccessUtilities.sqlExpressionForFetchSpecification(ec, spec, 0L, -1L).statement();
    }

    public static NSArray<NSDictionary> rawRowsForSQLExpression(EOEditingContext ec, String modelName, EOSQLExpression expression) {
        EOModelGroup modelGroup = EOUtilities.modelGroup((EOEditingContext)ec);
        EOModel model = modelGroup.modelNamed(modelName);
        return ERXEOAccessUtilities.rawRowsForSQLExpression(ec, model, expression, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray rawRowsForSQLExpression(EOEditingContext ec, EOModel model, EOSQLExpression expression, NSArray<EOAttribute> attributes) {
        NSArray results;
        block8: {
            results = NSArray.EmptyArray;
            EODatabaseContext dbc = EODatabaseContext.registeredDatabaseContextForModel((EOModel)model, (EOEditingContext)ec);
            dbc.lock();
            try {
                results = ERXEOAccessUtilities._rawRowsForSQLExpression(dbc, expression, attributes);
            }
            catch (Exception localException) {
                if (dbc._isDroppedConnectionException(localException)) {
                    try {
                        dbc.database().handleDroppedConnection();
                        results = ERXEOAccessUtilities._rawRowsForSQLExpression(dbc, expression, attributes);
                        break block8;
                    }
                    catch (Exception ex) {
                        throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
                    }
                }
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
            }
            finally {
                dbc.unlock();
            }
        }
        return results;
    }

    private static NSArray _rawRowsForSQLExpression(EODatabaseContext dbc, EOSQLExpression expression, NSArray<EOAttribute> attributes) {
        NSMutableArray<NSMutableDictionary> results = null;
        EOAdaptorChannel channel = dbc.availableChannel().adaptorChannel();
        if (!channel.isOpen()) {
            channel.openChannel();
        }
        boolean contextHadOpenTransaction = channel.adaptorContext().hasOpenTransaction();
        try {
            channel.evaluateExpression(expression);
        }
        catch (EOGeneralAdaptorException e) {
            if (channel.adaptorContext().hasOpenTransaction() && !contextHadOpenTransaction) {
                channel.adaptorContext().rollbackTransaction();
            }
            throw e;
        }
        if (attributes == null) {
            channel.setAttributesToFetch(channel.describeResults());
        } else {
            channel.setAttributesToFetch(attributes);
        }
        try {
            NSMutableDictionary row;
            results = new NSMutableArray<NSMutableDictionary>();
            while ((row = channel.fetchRow()) != null) {
                results.addObject(row);
            }
        }
        catch (EOGeneralAdaptorException ex) {
            channel.cancelFetch();
            throw ex;
        }
        return results;
    }

    public static EOSQLExpression sqlExpressionForFetchSpecification(EOEditingContext ec, EOFetchSpecification spec, long start, long end) {
        EOSQLExpression expression = null;
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, spec.entityName());
        EOModel model = entity.model();
        EODatabaseContext dbc = EODatabaseContext.registeredDatabaseContextForModel((EOModel)model, (EOEditingContext)ec);
        dbc.lock();
        try {
            ERXSQLHelper sqlHelper = ERXSQLHelper.newSQLHelper(ec, model.name());
            expression = sqlHelper.sqlExpressionForFetchSpecification(ec, spec, start, end);
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        finally {
            dbc.unlock();
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int rowCountForFetchSpecification(EOEditingContext ec, EOFetchSpecification spec) {
        int results;
        block9: {
            EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, spec.entityName());
            if (entity == null) {
                throw new IllegalStateException("entity could not be found for name \"" + spec.entityName() + "\". Checked EOModelGroup for loaded models.");
            }
            EOModel model = entity.model();
            EODatabaseContext dbc = EODatabaseContext.registeredDatabaseContextForModel((EOModel)model, (EOEditingContext)ec);
            results = 0;
            dbc.lock();
            try {
                results = ERXSQLHelper.newSQLHelper(ec, model.name()).rowCountForFetchSpecification(ec, spec);
            }
            catch (Exception localException) {
                if (dbc._isDroppedConnectionException(localException)) {
                    try {
                        dbc.database().handleDroppedConnection();
                        results = ERXSQLHelper.newSQLHelper(ec, model.name()).rowCountForFetchSpecification(ec, spec);
                        break block9;
                    }
                    catch (Exception ex) {
                        throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
                    }
                }
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
            }
            finally {
                dbc.unlock();
            }
        }
        return results;
    }

    public static EOModelGroup modelGroup(EOEditingContext ec) {
        WOSession s;
        if (ec == null && !ERXThreadStorage.wasInheritedFromParentThread() && (s = ERXSession.anySession()) != null) {
            ec = s.defaultEditingContext();
        }
        EOModelGroup group = ec == null ? EOModelGroup.defaultGroup() : EOModelGroup.modelGroupForObjectStoreCoordinator((EOObjectStoreCoordinator)((EOObjectStoreCoordinator)ec.rootObjectStore()));
        return group;
    }

    public static EOEntity entityNamed(EOEditingContext ec, String entityName) {
        EOModelGroup modelGroup = ERXEOAccessUtilities.modelGroup(ec);
        return modelGroup.entityNamed(entityName);
    }

    public static EOAttribute createAggregateAttribute(EOEditingContext ec, String function, String attributeName, String entityName) {
        return ERXEOAccessUtilities.createAggregateAttribute(ec, function, attributeName, entityName, Number.class, "i");
    }

    public static EOAttribute createAggregateAttribute(EOEditingContext ec, String function, String attributeName, String entityName, Class valueClass, String valueType) {
        return ERXEOAccessUtilities.createAggregateAttribute(ec, function, attributeName, entityName, valueClass, valueType, null, null);
    }

    public static EOAttribute createAggregateAttribute(EOEditingContext ec, String function, String attributeName, String entityName, Class valueClass, String valueType, String aggregateName) {
        return ERXEOAccessUtilities.createAggregateAttribute(ec, function, attributeName, entityName, valueClass, valueType, aggregateName, null);
    }

    public static EOAttribute createAggregateAttribute(EOEditingContext ec, String function, String attributeName, String entityName, Class valueClass, String valueType, String aggregateName, String entityTableAlias) {
        if (function == null) {
            throw new IllegalStateException("Function is null.");
        }
        if (attributeName == null) {
            throw new IllegalStateException("Attribute name is null.");
        }
        if (entityName == null) {
            throw new IllegalStateException("Entity name is null.");
        }
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        if (entity == null) {
            throw new IllegalStateException("Unable find entity named: " + entityName);
        }
        EOAttribute attribute = entity.attributeNamed(attributeName);
        if (attribute == null) {
            throw new IllegalStateException("Unable find attribute named: " + attributeName + " for entity: " + entityName);
        }
        EOAttribute aggregate = new EOAttribute();
        if (aggregateName != null) {
            aggregate.setName(aggregateName);
            aggregate.setColumnName(aggregateName);
        } else {
            aggregate.setName("p_object" + function + "Attribute");
            aggregate.setColumnName("p_object" + function + "Attribute");
        }
        aggregate.setClassName(valueClass.getName());
        if (valueType != null) {
            aggregate.setValueType(valueType);
        } else {
            aggregate.setValueType(attribute.valueType());
        }
        if (entityTableAlias == null) {
            entityTableAlias = "t0";
        }
        aggregate.setReadFormat(ERXSQLHelper.newSQLHelper(entity.model()).readFormatForAggregateFunction(function, entityTableAlias + "." + attribute.columnName(), aggregateName));
        return aggregate;
    }

    public static String createSchemaSQLForEntitiesInModelWithNameAndOptionsForOracle9(NSArray entities, String modelName, NSDictionary optionsCreate) {
        EODatabaseContext dc = EOUtilities.databaseContextForModelNamed((EOEditingContext)ERXEC.newEditingContext(), (String)modelName);
        return ERXSQLHelper.newSQLHelper(dc).createSchemaSQLForEntitiesInModelWithNameAndOptions(entities, modelName, optionsCreate);
    }

    public static String createSchemaSQLForEntitiesInModelWithNameAndOptions(NSArray entities, String modelName, NSDictionary optionsCreate) {
        EODatabaseContext dc = EOUtilities.databaseContextForModelNamed((EOEditingContext)ERXEC.newEditingContext(), (String)modelName);
        return ERXSQLHelper.newSQLHelper(dc).createSchemaSQLForEntitiesInModelWithNameAndOptions(entities, modelName, optionsCreate);
    }

    public static String createSchemaSQLForEntitiesWithOptions(NSArray entities, EODatabaseContext databaseContext, NSDictionary optionsCreate) {
        return ERXSQLHelper.newSQLHelper(databaseContext).createSchemaSQLForEntitiesWithOptions((NSArray<EOEntity>)entities, databaseContext, (NSDictionary<String, String>)optionsCreate);
    }

    public static String createSchemaSQLForEntitiesInModelWithName(NSArray entities, String modelName) {
        EODatabaseContext databaseContext = EOUtilities.databaseContextForModelNamed((EOEditingContext)ERXEC.newEditingContext(), (String)modelName);
        return ERXSQLHelper.newSQLHelper(databaseContext).createSchemaSQLForEntitiesInModelWithName(entities, modelName);
    }

    public static String createSchemaSQLForEntitiesInDatabaseContext(NSArray entities, EODatabaseContext databaseContext, boolean create, boolean drop) {
        return ERXSQLHelper.newSQLHelper(databaseContext).createSchemaSQLForEntitiesInDatabaseContext(entities, databaseContext, create, drop);
    }

    public static String createIndexSQLForEntitiesForOracle(NSArray entities) {
        NSMutableArray<String> a = new NSMutableArray<String>();
        a.addObject("BLOB");
        a.addObject("CLOB");
        return ERXEOAccessUtilities.createIndexSQLForEntities(entities, a);
    }

    public static String createIndexSQLForEntities(NSArray entities) {
        return ERXEOAccessUtilities.createIndexSQLForEntities(entities, null);
    }

    public static String createIndexSQLForEntities(NSArray entities, NSArray externalTypesToIgnore) {
        EOEntity ent = (EOEntity)entities.objectAtIndex(0);
        String modelName = ent.model().name();
        return ERXSQLHelper.newSQLHelper(ERXEC.newEditingContext(), modelName).createIndexSQLForEntities(entities, externalTypesToIgnore);
    }

    public static boolean entityUsesSeparateTable(EOEntity entity) {
        if (entity.parentEntity() == null) {
            return true;
        }
        EOEntity parent = entity.parentEntity();
        while (parent != null) {
            if (!entity.externalName().equals(parent.externalName())) {
                return true;
            }
            entity = parent;
            parent = entity.parentEntity();
        }
        return false;
    }

    public static EOAttribute attributeWithColumnNameFromEntity(String columnName, EOEntity entity) {
        Enumeration e = entity.attributes().objectEnumerator();
        while (e.hasMoreElements()) {
            EOAttribute att = (EOAttribute)e.nextElement();
            if (!columnName.equalsIgnoreCase(att.columnName())) continue;
            return att;
        }
        return null;
    }

    public static boolean isOptimisticLockingFailure(EOGeneralAdaptorException e) {
        boolean wasHandled = false;
        NSDictionary userInfo = e.userInfo();
        if (userInfo != null) {
            String eType = (String)userInfo.objectForKey("EOAdaptorFailureKey");
            if ("EOAdaptorOptimisticLockingFailure".equals(eType)) {
                EOAdaptorOperation adaptorOp = (EOAdaptorOperation)userInfo.objectForKey("EOFailedAdaptorOperationKey");
                EODatabaseOperation databaseOp = (EODatabaseOperation)userInfo.objectForKey("EOFailedDatabaseOperationKey");
                wasHandled = adaptorOp != null && databaseOp != null;
            } else {
                log.error((Object)("Missing EOFailedAdaptorOperationKey or EOFailedDatabaseOperationKey in " + (Object)((Object)e) + ": " + userInfo));
            }
        }
        return wasHandled;
    }

    public static NSArray snapshotsForObjectsFromRelationshipNamed(NSArray eos, String relKey) {
        NSMutableArray<Object> result = new NSMutableArray<Object>();
        if (eos.count() > 0) {
            EOEnterpriseObject eo = (EOEnterpriseObject)eos.lastObject();
            String entityName = eo.entityName();
            EOEditingContext ec = eo.editingContext();
            EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
            EORelationship relationship = entity.relationshipNamed(relKey);
            if (relationship.sourceAttributes().count() == 1) {
                EOAttribute attribute = (EOAttribute)relationship.sourceAttributes().lastObject();
                EODatabaseContext context = EOUtilities.databaseContextForModelNamed((EOEditingContext)ec, (String)entity.model().name());
                String name = attribute.name();
                Enumeration e = eos.objectEnumerator();
                while (e.hasMoreElements()) {
                    EOEnterpriseObject target = (EOEnterpriseObject)e.nextElement();
                    Object value = context.snapshotForGlobalID(ec.globalIDForObject(target)).valueForKey(name);
                    result.addObject(value);
                }
            } else {
                throw new IllegalArgumentException("Has more than one relationship attribute: " + relKey);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSDictionary primaryKeyDictionaryForEntity(EOEditingContext ec, String entityName) {
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        EODatabaseContext dbContext = EODatabaseContext.registeredDatabaseContextForModel((EOModel)entity.model(), (EOEditingContext)ec);
        NSDictionary primaryKey = null;
        dbContext.lock();
        try {
            NSArray arr;
            EOAdaptorChannel adaptorChannel = dbContext.availableChannel().adaptorChannel();
            if (!adaptorChannel.isOpen()) {
                adaptorChannel.openChannel();
            }
            if ((arr = adaptorChannel.primaryKeysForNewRowsWithEntity(1, entity)) != null) {
                primaryKey = (NSDictionary)arr.lastObject();
            } else {
                log.warn((Object)("Could not get primary key for entity: " + entityName + " exception"));
            }
        }
        catch (Exception e) {
            log.error((Object)("Caught exception when generating primary key for entity: " + entityName + " exception: " + e), (Throwable)e);
        }
        finally {
            dbContext.unlock();
        }
        return primaryKey;
    }

    public static NSArray primaryKeysForObjects(NSArray eos) {
        NSMutableArray result = new NSMutableArray();
        if (eos.count() > 0) {
            Enumeration e = eos.objectEnumerator();
            while (e.hasMoreElements()) {
                EOEnterpriseObject target = (EOEnterpriseObject)e.nextElement();
                NSDictionary pKey = EOUtilities.primaryKeyForObject((EOEditingContext)target.editingContext(), (EOEnterpriseObject)target);
                result.addObject(pKey.allValues().objectAtIndex(0));
            }
        }
        return result;
    }

    public static EORelationship lastRelationship(EORelationship relationship) {
        return (EORelationship)NSKeyValueCoding.Utility.valueForKey((Object)relationship, (String)"lastRelationship");
    }

    public static NSArray attributePathForKeyPath(EOEntity entity, String keyPath) {
        EORelationship relationship;
        String part;
        NSMutableArray<Object> result = new NSMutableArray<Object>();
        String[] parts = keyPath.split("\\.");
        for (int i = 0; i < parts.length - 1; ++i) {
            part = parts[i];
            relationship = entity.anyRelationshipNamed(part);
            if (relationship == null) {
                return NSArray.EmptyArray;
            }
            entity = relationship.destinationEntity();
            result.addObject(relationship);
        }
        part = parts[parts.length - 1];
        EOAttribute attribute = entity.anyAttributeNamed(part);
        if (attribute == null) {
            relationship = entity.anyRelationshipNamed(part);
            if (relationship == null) {
                throw new IllegalArgumentException("Last element is not an attribute nor a relationship: " + keyPath);
            }
            if (relationship.isFlattened()) {
                NSArray path = ERXEOAccessUtilities.attributePathForKeyPath(entity, relationship.definition());
                result.addObjectsFromArray(path);
                return result;
            }
            attribute = ((EOJoin)relationship.joins().lastObject()).sourceAttribute();
        }
        result.addObject(attribute);
        return result;
    }

    public static String sqlWhereClauseStringForKey(EOSQLExpression e, String key, NSArray valueArray) {
        return ERXSQLHelper.newSQLHelper(e).sqlWhereClauseStringForKey(e, key, valueArray);
    }

    public static EODatabaseContext databaseContextForObject(EOEnterpriseObject eo) {
        EOEditingContext editingContext = eo.editingContext();
        EOObjectStoreCoordinator osc = (EOObjectStoreCoordinator)editingContext.rootObjectStore();
        EODatabaseContext databaseContext = (EODatabaseContext)osc.objectStoreForObject(eo);
        return databaseContext;
    }

    public static EODatabaseContext databaseContextForEntityNamed(EOObjectStoreCoordinator osc, String entityName) {
        EOModel model = EOModelGroup.modelGroupForObjectStoreCoordinator((EOObjectStoreCoordinator)osc).entityNamed(entityName).model();
        EODatabaseContext dbc = EODatabaseContext.registeredDatabaseContextForModel((EOModel)model, (EOObjectStoreCoordinator)osc);
        return dbc;
    }

    public static boolean closeDatabaseConnections(EOObjectStoreCoordinator osc) {
        boolean couldClose = true;
        try {
            int contextCount;
            NSArray databaseContexts = osc.cooperatingObjectStores();
            int i = contextCount = databaseContexts.count();
            while (i-- > 0) {
                int channelCount;
                NSArray channels = ((EODatabaseContext)databaseContexts.objectAtIndex(i)).registeredChannels();
                int j = channelCount = channels.count();
                while (j-- > 0) {
                    EODatabaseChannel dbch = (EODatabaseChannel)channels.objectAtIndex(j);
                    if (!dbch.adaptorChannel().adaptorContext().hasOpenTransaction()) {
                        dbch.adaptorChannel().closeChannel();
                        continue;
                    }
                    log.warn((Object)("could not close Connection from " + dbch + " because its EOAdaptorContext " + dbch.adaptorChannel().adaptorContext() + " had open Transactions"));
                    couldClose = false;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"could not close all Connections, reason:", (Throwable)e);
            couldClose = false;
        }
        return couldClose;
    }

    public static EOEntity destinationEntityForKeyPath(EOEntity entity, String keyPath) {
        if (keyPath == null || keyPath.length() == 0) {
            return entity;
        }
        NSArray<String> keyArray = NSArray.componentsSeparatedByString(keyPath, ".");
        Enumeration<String> keys = keyArray.objectEnumerator();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            EORelationship rel = entity.anyRelationshipNamed(key);
            if (rel == null) {
                if (entity.anyAttributeNamed(key) == null && key.indexOf("@") != 0 && !_keysWithWarning.contains(key + "-" + entity)) {
                    _keysWithWarning.add(key + "-" + entity);
                    log.warn((Object)("No relationship or attribute <" + key + "> in entity: " + entity));
                }
                return null;
            }
            entity = rel.destinationEntity();
        }
        return entity;
    }

    public static EOEntity entityForEo(EOEnterpriseObject eo) {
        EOClassDescription classDesc = eo.classDescription();
        if (classDesc instanceof EOEntityClassDescription) {
            return ((EOEntityClassDescription)classDesc).entity();
        }
        return null;
    }

    public static NSArray classPropertiesNotInParent(EOEntity entity, boolean includeAttributes, boolean includeToOneRelationships, boolean includeToManyRelationships) {
        EOEntity parent = entity.parentEntity();
        if (parent == null) {
            return NSArray.EmptyArray;
        }
        NSMutableArray<Object> ret = new NSMutableArray<Object>();
        NSArray parentAttributeNames = (NSArray)entity.parentEntity().attributes().valueForKey("name");
        NSArray attributes = entity.attributes();
        NSArray cpNames = entity.classPropertyNames();
        if (includeAttributes) {
            int i = attributes.count();
            while (i-- > 0) {
                EOAttribute att = (EOAttribute)attributes.objectAtIndex(i);
                String name = att.name();
                if (!cpNames.containsObject(name) || parentAttributeNames.containsObject(name)) continue;
                ret.addObject(att);
            }
        }
        NSArray parentRelationships = (NSArray)entity.parentEntity().relationships().valueForKey("name");
        NSArray relationships = entity.relationships();
        int i = relationships.count();
        while (i-- > 0) {
            String name;
            EORelationship element = (EORelationship)relationships.objectAtIndex(i);
            if ((!element.isToMany() || !includeToManyRelationships) && (element.isToMany() || !includeToOneRelationships) || !cpNames.containsObject(name = element.name()) || parentRelationships.containsObject(name)) continue;
            ret.addObject(element);
        }
        return ret;
    }

    public static NSArray externalNamesForEntity(EOEntity entity, boolean includeParentEntities) {
        if (includeParentEntities) {
            entity = ERXEOAccessUtilities.rootEntityForEntity(entity);
        }
        NSMutableArray<String> entityNames = new NSMutableArray<String>();
        if (entity.subEntities().count() > 0) {
            Enumeration it = entity.subEntities().objectEnumerator();
            while (it.hasMoreElements()) {
                EOEntity entity1 = (EOEntity)it.nextElement();
                NSArray names = ERXEOAccessUtilities.externalNamesForEntity(entity1, includeParentEntities);
                entityNames.addObjectsFromArray(names);
            }
        }
        entityNames.addObject(entity.externalName());
        return ERXArrayUtilities.arrayWithoutDuplicates(entityNames);
    }

    public static NSArray externalNamesForEntityNamed(String entityName, boolean includeParentEntities) {
        return ERXEOAccessUtilities.externalNamesForEntity(EOModelGroup.defaultGroup().entityNamed(entityName), includeParentEntities);
    }

    public static EOEntity rootEntityForEntity(EOEntity entity) {
        while (entity.parentEntity() != null) {
            entity = entity.parentEntity();
        }
        return entity;
    }

    public static EOEntity rootEntityForEntityNamed(String entityName) {
        return ERXEOAccessUtilities.rootEntityForEntity(EOModelGroup.defaultGroup().entityNamed(entityName));
    }

    public static void logExpression(EOAdaptorChannel channel, EOSQLExpression expression, long startTime) {
        String entityName;
        if (sqlLoggingLogger == null) {
            sqlLoggingLogger = Logger.getLogger((String)"er.extensions.ERXAdaptorChannelDelegate.sqlLogging");
        }
        String entityMatchPattern = ERXProperties.stringForKeyWithDefault("er.extensions.ERXAdaptorChannelDelegate.trace.entityMatchPattern", ".*");
        long millisecondsNeeded = System.currentTimeMillis() - startTime;
        String string = entityName = expression.entity() != null ? expression.entity().name() : "Unknown";
        if (entityName.matches(entityMatchPattern)) {
            long debugMilliseconds = ERXProperties.longForKeyWithDefault("er.extensions.ERXAdaptorChannelDelegate.trace.milliSeconds.debug", 0L);
            long infoMilliseconds = ERXProperties.longForKeyWithDefault("er.extensions.ERXAdaptorChannelDelegate.trace.milliSeconds.info", 100L);
            long warnMilliseconds = ERXProperties.longForKeyWithDefault("er.extensions.ERXAdaptorChannelDelegate.trace.milliSeconds.warn", 1000L);
            long errorMilliseconds = ERXProperties.longForKeyWithDefault("er.extensions.ERXAdaptorChannelDelegate.trace.milliSeconds.error", 5000L);
            int maxLength = ERXProperties.intForKeyWithDefault("er.extensions.ERXAdaptorChannelDelegate.trace.maxLength", 3000);
            boolean needsLog = false;
            if (millisecondsNeeded > errorMilliseconds) {
                needsLog = true;
            } else if (millisecondsNeeded > warnMilliseconds) {
                needsLog = true;
            } else if (millisecondsNeeded > infoMilliseconds) {
                if (sqlLoggingLogger.isInfoEnabled()) {
                    needsLog = true;
                }
            } else if (millisecondsNeeded > debugMilliseconds && sqlLoggingLogger.isDebugEnabled()) {
                needsLog = true;
            }
            if (ERXStats.isTrackingStatistics()) {
                String statement = expression.statement();
                statement = statement.replaceAll("decode\\(.*?\\)", "?");
                statement = statement.replaceAll(" IN \\(.*?\\)", " IN ([removed])");
                statement = statement.replaceAll("([a-zA-Z0-9_\\.]+)\\s+IN \\(.*?\\)(\\s+OR\\s+\\1\\s+IN \\(.*?\\))+", " IN ([multi removed])");
                statement = statement.replaceAll("((t0|T0)\\.[a-zA-Z0-9_]+\\,\\s*)*(t0|T0)\\.[a-zA-Z0-9_\\.]+\\s+FROM\\s+", "t0.* FROM ");
                ERXStats.addDurationForKey(millisecondsNeeded, "SQL", entityName + ": " + statement);
            }
            if (needsLog) {
                String logString = ERXEOAccessUtilities.createLogString(channel, expression, millisecondsNeeded);
                if (logString.length() > maxLength) {
                    logString = logString.substring(0, maxLength);
                }
                if (millisecondsNeeded > errorMilliseconds) {
                    sqlLoggingLogger.error((Object)logString, (Throwable)new RuntimeException("Statement running too long"));
                } else if (millisecondsNeeded > warnMilliseconds) {
                    sqlLoggingLogger.warn((Object)logString);
                } else if (millisecondsNeeded > infoMilliseconds) {
                    if (sqlLoggingLogger.isInfoEnabled()) {
                        sqlLoggingLogger.info((Object)logString);
                    }
                } else if (millisecondsNeeded > debugMilliseconds && sqlLoggingLogger.isDebugEnabled()) {
                    sqlLoggingLogger.debug((Object)logString);
                }
            }
        }
    }

    public static String createLogString(EOAdaptorChannel channel, EOSQLExpression expression, long millisecondsNeeded) {
        int cnt;
        String entityName = expression.entity() != null ? expression.entity().name() : "Unknown";
        String description = "\"" + entityName + "\"@" + channel.adaptorContext().hashCode() + " expression took " + millisecondsNeeded + " ms: " + expression.statement();
        StringBuffer sb = new StringBuffer();
        NSArray variables = expression.bindVariableDictionaries();
        int n = cnt = variables != null ? variables.count() : 0;
        if (cnt > 0) {
            sb.append(" withBindings: ");
            for (int i = 0; i < cnt; ++i) {
                EOAttribute attribute;
                NSDictionary nsdictionary = (NSDictionary)variables.objectAtIndex(i);
                Object obj = nsdictionary.valueForKey("BindVariableValue");
                String attributeName = (String)nsdictionary.valueForKey("BindVariableName");
                if (obj instanceof String) {
                    obj = EOSQLExpression.sqlStringForString((String)((String)obj));
                } else if (obj instanceof Number) {
                    obj = EOSQLExpression.sqlStringForNumber((Number)((Number)obj));
                } else if (obj instanceof NSData) {
                    try {
                        if (((NSData)obj).length() < 50) {
                            obj = expression.sqlStringForData((NSData)obj);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                    if (obj instanceof NSData) {
                        obj = obj.toString();
                    }
                } else if (expression.entity() != null && (attribute = expression.entity().anyAttributeNamed(attributeName)) != null) {
                    obj = expression.formatValueForAttribute(obj, attribute);
                }
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(i + 1);
                sb.append(":");
                sb.append(obj);
                sb.append("[");
                sb.append(attributeName);
                sb.append("]");
            }
        }
        description = description + sb.toString();
        return description;
    }

    public static EOQualifier qualifierFromAttributes(NSArray attributes, NSDictionary values) {
        NSMutableArray<EOKeyValueQualifier> qualifiers = new NSMutableArray<EOKeyValueQualifier>();
        EOAndQualifier result = null;
        if (attributes.count() > 0) {
            Enumeration i = attributes.objectEnumerator();
            while (i.hasMoreElements()) {
                EOAttribute key = (EOAttribute)i.nextElement();
                Object value = values.objectForKey(key.name());
                qualifiers.addObject(new EOKeyValueQualifier(key.name(), EOQualifier.QualifierOperatorEqual, value));
            }
            result = new EOAndQualifier(qualifiers);
        }
        return result;
    }

    public static NSArray relationshipsForAttribute(EOEntity entity, EOAttribute attrib) {
        NSMutableArray<EORelationship> arr = new NSMutableArray<EORelationship>();
        int cnt = entity.relationships().count();
        for (int i = 0; i < cnt; ++i) {
            EORelationship rel = (EORelationship)entity.relationships().objectAtIndex(i);
            NSArray attribs = rel.sourceAttributes();
            if (!attribs.containsObject(attrib)) continue;
            arr.addObject(rel);
        }
        return arr;
    }

    public static EOAttribute sourceAttributeForRelationship(EOEntity entity, String relationshipName) {
        EORelationship relationship = entity.relationshipNamed(relationshipName);
        return ERXEOAccessUtilities.sourceAttributeForRelationship(relationship);
    }

    public static EOAttribute sourceAttributeForRelationship(EORelationship relationship) {
        EOJoin join = (EOJoin)relationship.joins().objectAtIndex(0);
        return join.sourceAttribute();
    }

    public static String sourceColumnForRelationship(EOEntity entity, String relationshipName) {
        EORelationship relationship = entity.relationshipNamed(relationshipName);
        return ERXEOAccessUtilities.sourceColumnForRelationship(relationship);
    }

    public static String sourceColumnForRelationship(EORelationship relationship) {
        return ERXEOAccessUtilities.sourceAttributeForRelationship(relationship).columnName();
    }

    public static EOEnterpriseObject refetchFailedObject(EOEditingContext ec, EOGeneralAdaptorException e) {
        EOAdaptorOperation adaptorOp = (EOAdaptorOperation)e.userInfo().objectForKey("EOFailedAdaptorOperationKey");
        EODatabaseOperation databaseOp = (EODatabaseOperation)e.userInfo().objectForKey("EOFailedDatabaseOperationKey");
        NSDictionary dbSnapshot = databaseOp.dbSnapshot();
        EOEntity entity = adaptorOp.entity();
        String entityName = entity.name();
        EOGlobalID gid = entity.globalIDForRow(dbSnapshot);
        EOEnterpriseObject eo = ec.faultForGlobalID(gid, ec);
        ec.refaultObject(eo);
        NSArray primaryKeyAttributes = entity.primaryKeyAttributes();
        EOQualifier qualifier = ERXEOAccessUtilities.qualifierFromAttributes(primaryKeyAttributes, dbSnapshot);
        EOFetchSpecification fs = new EOFetchSpecification(entityName, qualifier, null);
        fs.setRefreshesRefetchedObjects(true);
        NSArray objs = ec.objectsWithFetchSpecification(fs);
        eo = null;
        if (objs.count() == 1) {
            eo = (EOEnterpriseObject)objs.objectAtIndex(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("failedEO: " + eo));
            }
        } else {
            if (objs.count() == 0) {
                throw new EOObjectNotAvailableException("Can't recover: Object was deleted: " + fs);
            }
            throw new EOUtilities.MoreThanOneException("Can't recover: More than one object found: " + objs);
        }
        return eo;
    }

    public static void reapplyChanges(EOEnterpriseObject eo, EOGeneralAdaptorException e) {
        EOAdaptorOperation adaptorOp = (EOAdaptorOperation)e.userInfo().objectForKey("EOFailedAdaptorOperationKey");
        NSDictionary changedValues = adaptorOp.changedValues();
        EOEntity entity = ERXEOAccessUtilities.entityForEo(eo);
        EOEditingContext ec = eo.editingContext();
        NSArray keys = changedValues.allKeys();
        NSMutableSet relationships = new NSMutableSet();
        for (int i = 0; i < keys.count(); ++i) {
            String key = (String)keys.objectAtIndex(i);
            EOAttribute attrib = entity.attributeNamed(key);
            if (attrib != null) {
                Object val = changedValues.objectForKey(key);
                if (entity.classProperties().containsObject(attrib)) {
                    eo.takeValueForKey(val, key);
                }
                NSArray relsUsingAttrib = ERXEOAccessUtilities.relationshipsForAttribute(entity, attrib);
                relationships.addObjectsFromArray(relsUsingAttrib);
                continue;
            }
            log.error((Object)("Changed value found that isn't an attribute: " + key + "->" + changedValues.objectForKey(key)));
        }
        Enumeration enumerator = relationships.objectEnumerator();
        while (enumerator.hasMoreElements()) {
            EORelationship relationship = (EORelationship)enumerator.nextElement();
            NSMutableDictionary pk = EOUtilities.destinationKeyForSourceObject((EOEditingContext)ec, (EOEnterpriseObject)eo, (String)relationship.name()).mutableClone();
            for (int i = 0; i < keys.count(); ++i) {
                String key = (String)keys.objectAtIndex(i);
                if (pk.objectForKey(key) == null) continue;
                Object val = changedValues.objectForKey(key);
                pk.setObjectForKey(val, key);
            }
            EOEntity destEnt = relationship.destinationEntity();
            EOGlobalID gid = destEnt.globalIDForRow(pk);
            if (gid != null) {
                EOEnterpriseObject destEO = ec.faultForGlobalID(gid, ec);
                eo.takeValueForKey((Object)destEO, relationship.name());
                continue;
            }
            throw new NullPointerException("Gid is null: " + pk);
        }
    }

    public static int deleteRowsDescribedByQualifier(EOEditingContext ec, String entityName, final EOQualifier qualifier) {
        final EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        ChannelAction action = new ChannelAction(){

            protected int doPerform(EOAdaptorChannel channel) {
                return channel.deleteRowsDescribedByQualifier(qualifier, entity);
            }
        };
        return action.perform(ec, entity.model().name());
    }

    public static int updateRowsDescribedByQualifier(EOEditingContext ec, String entityName, final EOQualifier qualifier, final NSDictionary newValues) {
        final EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        ChannelAction action = new ChannelAction(){

            protected int doPerform(EOAdaptorChannel channel) {
                return channel.updateValuesInRowsDescribedByQualifier(newValues, qualifier, entity);
            }
        };
        return action.perform(ec, entity.model().name());
    }

    public static int insertRow(EOEditingContext ec, String entityName, final NSDictionary newValues) {
        final EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        ChannelAction action = new ChannelAction(){

            protected int doPerform(EOAdaptorChannel channel) {
                channel.insertRow(newValues, entity);
                return 1;
            }
        };
        return action.perform(ec, entity.model().name());
    }

    public static int insertRows(EOEditingContext ec, String entityName, final Collection<? extends NSDictionary<String, ?>> newValues) {
        final EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        ChannelAction action = new ChannelAction(){

            protected int doPerform(EOAdaptorChannel channel) {
                int insert = 0;
                for (NSDictionary dictionary : newValues) {
                    channel.insertRow(dictionary, entity);
                    ++insert;
                }
                return insert;
            }
        };
        return action.perform(ec, entity.model().name());
    }

    public static NSArray primaryKeysForNewRows(EOEditingContext ec, String entityName, final int count) {
        final NSMutableArray result = new NSMutableArray();
        final EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        ChannelAction action = new ChannelAction(){

            protected int doPerform(EOAdaptorChannel channel) {
                NSArray keys = channel.primaryKeysForNewRowsWithEntity(count, entity);
                result.addObjectsFromArray(keys);
                return count;
            }
        };
        action.perform(ec, entity.model().name());
        return result;
    }

    public static String guessPluginName(EOModel model) {
        NSDictionary connectionDictionary;
        String pluginName = null;
        if ("JDBC".equals(model.adaptorName()) && (connectionDictionary = model.connectionDictionary()) != null) {
            pluginName = ERXEOAccessUtilities.guessPluginNameForConnectionDictionary(connectionDictionary);
        }
        return pluginName;
    }

    public static String guessPluginNameForConnectionDictionary(NSDictionary connectionDictionary) {
        String pluginName = null;
        String jdbcUrl = (String)connectionDictionary.objectForKey("URL");
        if (jdbcUrl != null && ((pluginName = (String)connectionDictionary.objectForKey("plugin")) == null || pluginName.trim().length() == 0)) {
            pluginName = JDBCPlugIn.plugInNameForURL((String)jdbcUrl);
            if (pluginName == null) {
                int firstColon = jdbcUrl.indexOf(58);
                int secondColon = jdbcUrl.indexOf(58, firstColon + 1);
                if (firstColon != -1 && secondColon != -1) {
                    pluginName = jdbcUrl.substring(firstColon + 1, secondColon);
                }
            } else {
                pluginName = ERXStringUtilities.lastPropertyKeyInKeyPath(pluginName);
                if ((pluginName = pluginName.replaceFirst("PlugIn", "")).startsWith("_")) {
                    pluginName = pluginName.substring(1);
                }
            }
        }
        if (pluginName != null && pluginName.trim().length() == 0) {
            pluginName = null;
        }
        return pluginName;
    }

    public static EOFetchSpecification localizeFetchSpecification(EOEditingContext ec, EOFetchSpecification fetchSpecification) {
        if (fetchSpecification != null && fetchSpecification.sortOrderings().count() > 0) {
            fetchSpecification = (EOFetchSpecification)fetchSpecification.clone();
            NSMutableArray<int> sortOrderings = new NSMutableArray<int>(fetchSpecification.sortOrderings().count());
            Enumeration enumerator = fetchSpecification.sortOrderings().objectEnumerator();
            while (enumerator.hasMoreElements()) {
                String localizedKey;
                EOClassDescription cd;
                EOSortOrdering item = (EOSortOrdering)enumerator.nextElement();
                String key = item.key();
                NSArray<String> path = NSArray.componentsSeparatedByString(key, ".");
                EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, fetchSpecification.entityName());
                String attributeName = path.lastObject();
                String prefix = "";
                if (path.count() > 1) {
                    for (int i = 0; i < path.count() - 1; ++i) {
                        String part = path.objectAtIndex(i);
                        EORelationship rel = entity.anyRelationshipNamed(part);
                        entity = rel.destinationEntity();
                        prefix = prefix + part + ".";
                    }
                }
                if (entity.attributeNamed(attributeName) == null && (cd = entity.classDescriptionForInstances()) instanceof ERXEntityClassDescription && (localizedKey = ((ERXEntityClassDescription)cd).localizedKey(attributeName)) != null) {
                    item = new EOSortOrdering(prefix + localizedKey, item.selector());
                }
                sortOrderings.addObject((int)item);
            }
            fetchSpecification.setSortOrderings(sortOrderings);
        }
        return fetchSpecification;
    }

    public static void batchFetchRelationship(EODatabaseContext databaseContext, String entityName, String relationshipName, NSArray objects, EOEditingContext editingContext, boolean skipFaultedRelationships) {
        EOEntity entity = ERXEOAccessUtilities.entityNamed(editingContext, entityName);
        EORelationship relationship = entity.relationshipNamed(relationshipName);
        ERXEOAccessUtilities.batchFetchRelationship(databaseContext, relationship, objects, editingContext, skipFaultedRelationships);
    }

    public static void batchFetchRelationship(EODatabaseContext databaseContext, EORelationship relationship, NSArray objects, EOEditingContext editingContext, boolean skipFaultedRelationships) {
        NSMutableArray<EOEnterpriseObject> objectsToBatchFetch;
        if (relationship.isToMany()) {
            if (skipFaultedRelationships) {
                NSMutableArray<EOEnterpriseObject> objectsWithUnfaultedRelationships = new NSMutableArray<EOEnterpriseObject>();
                String relationshipName = relationship.name();
                Enumeration objectsEnum = objects.objectEnumerator();
                while (objectsEnum.hasMoreElements()) {
                    EOEnterpriseObject object = (EOEnterpriseObject)objectsEnum.nextElement();
                    Object relationshipValue = object.storedValueForKey(relationshipName);
                    if (!EOFaultHandler.isFault((Object)relationshipValue)) continue;
                    objectsWithUnfaultedRelationships.addObject(object);
                }
                objectsToBatchFetch = objectsWithUnfaultedRelationships;
            } else {
                objectsToBatchFetch = objects;
            }
        } else {
            NSMutableArray<EOGlobalID> gids = new NSMutableArray<EOGlobalID>();
            NSMutableArray<EOEnterpriseObject> objectsWithUnfaultedRelationships = new NSMutableArray<EOEnterpriseObject>();
            EOEntity destinationEntity = relationship.destinationEntity();
            String relationshipName = relationship.name();
            Enumeration objectsEnum = objects.objectEnumerator();
            while (objectsEnum.hasMoreElements()) {
                NSDictionary destinationSnapshot;
                EOEnterpriseObject object = (EOEnterpriseObject)objectsEnum.nextElement();
                NSDictionary sourceSnapshot = databaseContext.snapshotForGlobalID(editingContext.globalIDForObject(object));
                if (sourceSnapshot == null) {
                    objectsWithUnfaultedRelationships.addObject(object);
                    continue;
                }
                NSMutableDictionary destinationPK = relationship._foreignKeyForSourceRow(sourceSnapshot);
                EOGlobalID destinationGID = destinationEntity.globalIDForRow((NSDictionary)destinationPK);
                if (destinationGID == null || (destinationSnapshot = databaseContext.snapshotForGlobalID(destinationGID, editingContext.fetchTimestamp())) != null && skipFaultedRelationships) continue;
                gids.addObject(destinationGID);
                object.storedValueForKey(relationshipName);
            }
            objectsToBatchFetch = objectsWithUnfaultedRelationships;
            if (gids.count() > 0) {
                ERXEOGlobalIDUtilities.fetchObjectsWithGlobalIDs(editingContext, gids, !skipFaultedRelationships);
            }
        }
        if (((NSArray)objectsToBatchFetch).count() > 0) {
            databaseContext.batchFetchRelationship(relationship, (NSArray)objectsToBatchFetch, editingContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSSet verifyAllSnapshots() {
        NSMutableSet<String> mismatches = new NSMutableSet<String>();
        NSMutableSet<EODatabase> verifiedDatabases = new NSMutableSet<EODatabase>();
        EOEditingContext editingContext = ERXEC.newEditingContext();
        EOModelGroup modelGroup = EOModelGroup.defaultGroup();
        Enumeration modelsEnum = modelGroup.models().objectEnumerator();
        while (modelsEnum.hasMoreElements()) {
            EOModel model = (EOModel)modelsEnum.nextElement();
            EODatabaseContext databaseContext = null;
            try {
                databaseContext = EODatabaseContext.registeredDatabaseContextForModel((EOModel)model, (EOEditingContext)editingContext);
            }
            catch (IllegalStateException e) {
                log.warn((Object)("Model " + model.name() + " failed: " + e.getMessage()));
            }
            if (databaseContext == null) continue;
            databaseContext.lock();
            try {
                EODatabase database = databaseContext.database();
                if (verifiedDatabases.containsObject(database)) continue;
                Enumeration gidEnum = database.snapshots().keyEnumerator();
                while (gidEnum.hasMoreElements()) {
                    EOGlobalID gid = (EOGlobalID)gidEnum.nextElement();
                    if (!(gid instanceof EOKeyGlobalID)) continue;
                    EOEnterpriseObject eo = null;
                    EOKeyGlobalID keyGID = (EOKeyGlobalID)gid;
                    String entityName = keyGID.entityName();
                    EOEntity entity = modelGroup.entityNamed(entityName);
                    NSDictionary snapshot = database.snapshotForGlobalID(gid);
                    if (snapshot != null) {
                        NSMutableDictionary databaseSnapshotClone;
                        EOQualifier gidQualifier = entity.qualifierForPrimaryKey(entity.primaryKeyForGlobalID(gid));
                        EOFetchSpecification gidFetchSpec = new EOFetchSpecification(entityName, gidQualifier, null);
                        NSMutableDictionary memorySnapshotClone = snapshot.mutableClone();
                        EOAdaptorChannel channel = databaseContext.availableChannel().adaptorChannel();
                        channel.openChannel();
                        channel.selectAttributes(entity.attributesToFetch(), gidFetchSpec, false, entity);
                        try {
                            databaseSnapshotClone = channel.fetchRow().mutableClone();
                        }
                        finally {
                            channel.cancelFetch();
                        }
                        if (databaseSnapshotClone == null) {
                            mismatches.addObject(gid + " was deleted in the database, but the snapshot still exists: " + memorySnapshotClone);
                        } else {
                            ERXDictionaryUtilities.removeMatchingEntries(memorySnapshotClone, databaseSnapshotClone);
                            if (databaseSnapshotClone.count() > 0 || memorySnapshotClone.count() > 0) {
                                mismatches.addObject(gid + " doesn't match the database: original = " + memorySnapshotClone + "; database = " + databaseSnapshotClone);
                            }
                            eo = (EOEnterpriseObject)editingContext.objectsWithFetchSpecification(gidFetchSpec).objectAtIndex(0);
                        }
                    }
                    if (eo == null) continue;
                    Enumeration relationshipsEnum = entity.relationships().objectEnumerator();
                    while (relationshipsEnum.hasMoreElements()) {
                        NSArray objectsNotInMemory;
                        EORelationship relationship = (EORelationship)relationshipsEnum.nextElement();
                        String relationshipName = relationship.name();
                        NSArray originalDestinationGIDs = database.snapshotForSourceGlobalID((EOGlobalID)keyGID, relationshipName);
                        if (originalDestinationGIDs == null) continue;
                        NSMutableArray<EOGlobalID> newDestinationGIDs = new NSMutableArray<EOGlobalID>();
                        EOQualifier qualifier = relationship.qualifierWithSourceRow(database.snapshotForGlobalID((EOGlobalID)keyGID));
                        EOFetchSpecification relationshipFetchSpec = new EOFetchSpecification(entityName, qualifier, null);
                        EOAdaptorChannel channel = databaseContext.availableChannel().adaptorChannel();
                        channel.openChannel();
                        try {
                            channel.selectAttributes(relationship.destinationEntity().attributesToFetch(), relationshipFetchSpec, false, relationship.destinationEntity());
                            NSMutableDictionary destinationSnapshot = null;
                            do {
                                if ((destinationSnapshot = channel.fetchRow()) != null) {
                                    EOGlobalID destinationGID = relationship.destinationEntity().globalIDForRow((NSDictionary)destinationSnapshot);
                                    newDestinationGIDs.addObject(destinationGID);
                                    continue;
                                }
                                destinationSnapshot = null;
                            } while (destinationSnapshot != null);
                        }
                        finally {
                            channel.cancelFetch();
                        }
                        NSArray objectsNotInDatabase = ERXArrayUtilities.arrayMinusArray(originalDestinationGIDs, newDestinationGIDs);
                        if (objectsNotInDatabase.count() > 0) {
                            mismatches.addObject(gid + "." + relationshipName + " has entries not in the database: " + objectsNotInDatabase);
                        }
                        if ((objectsNotInMemory = ERXArrayUtilities.arrayMinusArray(newDestinationGIDs, originalDestinationGIDs)).count() <= 0) continue;
                        mismatches.addObject(gid + "." + relationshipName + " is missing entries in the database: " + objectsNotInMemory);
                    }
                }
                verifiedDatabases.addObject(database);
            }
            finally {
                databaseContext.unlock();
            }
        }
        return mismatches;
    }

    public static void makeEditableSharedEntityNamed(String entityName) {
        EOEntity e = ERXEOAccessUtilities.entityNamed(null, entityName);
        if (e != null && e.isReadOnly()) {
            e.setReadOnly(false);
            e.setCachesObjects(false);
            Enumeration fetchSpecNameObjectEnumerator = e.sharedObjectFetchSpecificationNames().objectEnumerator();
            while (fetchSpecNameObjectEnumerator.hasMoreElements()) {
                e.removeSharedObjectFetchSpecificationByName((String)fetchSpecNameObjectEnumerator.nextElement());
            }
        } else if (e == null) {
            log.warn((Object)("makeEditableSharedEntityNamed: unable to find entity named: " + entityName));
        } else {
            log.warn((Object)("makeEditableSharedEntityNamed: entity already editable: " + entityName));
        }
    }

    public static EORelationship createRelationship(String relationshipName, String sourceEntityName, String sourceAttributeName, String destinationEntityName, String destinationAttributeName, boolean toMany, int deleteRule, boolean isMandatory, boolean isClassProperty, boolean shouldPropagatePrimaryKey) {
        EOEntity sourceEntity = EOModelGroup.defaultGroup().entityNamed(sourceEntityName);
        if (sourceEntity.isAbstractEntity()) {
            log.warn((Object)"If you programatically add relationships to an abstract entity, make sure you also add it to child entities");
        }
        EOEntity destinationEntity = EOModelGroup.defaultGroup().entityNamed(destinationEntityName);
        EOAttribute sourceAttribute = sourceEntity.attributeNamed(sourceAttributeName);
        EOAttribute destinationAttribute = destinationEntity.attributeNamed(destinationAttributeName);
        EOJoin join = new EOJoin(sourceAttribute, destinationAttribute);
        EORelationship relationship = new EORelationship();
        relationship.setName(relationshipName);
        sourceEntity.addRelationship(relationship);
        relationship.addJoin(join);
        relationship.setToMany(toMany);
        relationship.setJoinSemantic(0);
        relationship.setDeleteRule(deleteRule);
        relationship.setIsMandatory(isMandatory);
        relationship.setPropagatesPrimaryKey(shouldPropagatePrimaryKey);
        if (isClassProperty) {
            NSMutableArray<EORelationship> classProperties = sourceEntity.classProperties().mutableClone();
            classProperties.addObject(relationship);
            sourceEntity.setClassProperties(classProperties);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)relationship);
        }
        return relationship;
    }

    public static EORelationship createFlattenedRelationship(String relationshipName, String sourceEntityName, String definition, int deleteRule, boolean isMandatory, boolean isClassProperty) {
        EOEntity sourceEntity = EOModelGroup.defaultGroup().entityNamed(sourceEntityName);
        if (sourceEntity.isAbstractEntity()) {
            log.warn((Object)"If you programatically add relationships to an abstract entity, make sure you also add it to child entities");
        }
        EORelationship relationship = new EORelationship();
        relationship.setName(relationshipName);
        sourceEntity.addRelationship(relationship);
        relationship.setDeleteRule(deleteRule);
        relationship.setIsMandatory(isMandatory);
        relationship.setDefinition(definition);
        if (isClassProperty) {
            NSMutableArray<EORelationship> classProperties = sourceEntity.classProperties().mutableClone();
            classProperties.addObject(relationship);
            sourceEntity.setClassProperties(classProperties);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(relationship + ", flattened:" + relationship.isFlattened() + ", definition:" + relationship.definition() + ", relationshipPath:" + relationship.relationshipPath()));
        }
        return relationship;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeDatabaseContextOperation(EODatabaseContext databaseContext, int maxAttempts, DatabaseContextOperation<T> operation) {
        T results = null;
        boolean succeeded = false;
        for (int attempt = 0; !succeeded && attempt < maxAttempts; ++attempt) {
            databaseContext.lock();
            try {
                results = operation.execute(databaseContext);
                succeeded = true;
                continue;
            }
            catch (Exception e) {
                boolean didHandleException = false;
                Object delegate = databaseContext.delegate();
                if (delegate instanceof _NSDelegate) {
                    if (((_NSDelegate)delegate).respondsTo("databaseContextShouldHandleDatabaseException")) {
                        didHandleException = (Boolean)((_NSDelegate)delegate).perform("databaseContextShouldHandleDatabaseException", new Object[]{databaseContext, e}) == false;
                    }
                } else if (delegate instanceof ERXDatabaseContextDelegate) {
                    try {
                        didHandleException = !((ERXDatabaseContextDelegate)delegate).databaseContextShouldHandleDatabaseException(databaseContext, e);
                    }
                    catch (Throwable t) {
                        log.error((Object)"caught an exception while trying to handle a database exception.", t);
                    }
                }
                if (didHandleException) {
                    succeeded = false;
                } else if (databaseContext._isDroppedConnectionException(e)) {
                    try {
                        databaseContext.database().handleDroppedConnection();
                        succeeded = false;
                    }
                    catch (Exception ex) {
                        throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
                    }
                } else {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                NSLog._conditionallyLogPrivateException((Throwable)e);
                continue;
            }
            finally {
                databaseContext.unlock();
            }
        }
        return results;
    }

    public static <T> T executeAdaptorChannelOperation(EODatabaseContext databaseContext, int maxAttempts, final AdaptorChannelOperation<T> operation) {
        return ERXEOAccessUtilities.executeDatabaseContextOperation(databaseContext, maxAttempts, new DatabaseContextOperation<T>(){

            @Override
            public T execute(EODatabaseContext databaseContext) throws Exception {
                EOAdaptorChannel adaptorChannel = databaseContext.availableChannel().adaptorChannel();
                if (!adaptorChannel.isOpen()) {
                    adaptorChannel.openChannel();
                }
                return operation.execute(databaseContext, adaptorChannel);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeAdaptorChannelOperation(String modelName, int maxAttempts, AdaptorChannelOperation<T> operation) {
        EODatabaseContext databaseContext;
        EOEditingContext editingContext = ERXEC.newEditingContext();
        try {
            databaseContext = EOUtilities.databaseContextForModelNamed((EOEditingContext)editingContext, (String)modelName);
        }
        finally {
            editingContext.dispose();
        }
        return ERXEOAccessUtilities.executeAdaptorChannelOperation(databaseContext, maxAttempts, operation);
    }

    public static void setIsClassProperty(EOProperty property, boolean isClassProperty) {
        EOEntity entity = null;
        if (property instanceof EOAttribute) {
            entity = ((EOAttribute)property).entity();
        } else if (property instanceof EORelationship) {
            entity = ((EORelationship)property).entity();
        } else {
            throw new IllegalArgumentException("property must be an EOAttribute or an EORelationship.");
        }
        NSArray<EOProperty> classProperties = entity.classProperties();
        if (isClassProperty && !classProperties.contains(property)) {
            classProperties = classProperties.arrayByAddingObject(property);
            entity.setClassProperties(classProperties);
        } else if (!isClassProperty && classProperties.contains(property)) {
            classProperties = ERXArrayUtilities.arrayMinusObject(classProperties, property);
            entity.setClassProperties(classProperties);
        }
    }

    public static void setIsAttributeUsedForLocking(EOAttribute attr, boolean isUsedForLocking) {
        EOEntity entity = attr.entity();
        NSArray<EOAttribute> atts = entity.attributesUsedForLocking();
        if (isUsedForLocking && !atts.contains(attr)) {
            atts = atts.arrayByAddingObject(attr);
            entity.setAttributesUsedForLocking(atts);
        } else if (!isUsedForLocking && atts.contains(attr)) {
            atts = ERXArrayUtilities.arrayMinusObject(atts, attr);
            entity.setAttributesUsedForLocking(atts);
        }
    }

    public static NSArray<String> entityHierarchyNamesForEntityNamed(EOEditingContext ec, String rootEntityName) {
        NSMutableArray<String> names = new NSMutableArray<String>();
        EOEntity rootEntity = ERXEOAccessUtilities.entityNamed(ec, rootEntityName);
        NSArray<EOEntity> entities = ERXEOAccessUtilities.entityHierarchyForEntity(ec, rootEntity);
        for (EOEntity entity : entities) {
            names.add(entity.name());
        }
        return names.immutableClone();
    }

    public static NSArray<EOEntity> entityHierarchyForEntity(EOEditingContext ec, EOEntity rootEntity) {
        NSMutableArray<EOEntity> entities = new NSMutableArray<EOEntity>();
        if (!rootEntity.isAbstractEntity()) {
            entities.add(rootEntity);
        }
        NSArray subEntities = rootEntity.subEntities();
        for (EOEntity subEntity : subEntities) {
            entities.addAll(ERXEOAccessUtilities.entityHierarchyForEntity(ec, subEntity));
        }
        return entities.immutableClone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AdaptorChannelOperation<T> {
        public T execute(EODatabaseContext var1, EOAdaptorChannel var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DatabaseContextOperation<T> {
        public T execute(EODatabaseContext var1) throws Exception;
    }

    public static abstract class ChannelAction {
        protected abstract int doPerform(EOAdaptorChannel var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int perform(EOEditingContext ec, String modelName) {
            boolean wasOpen = true;
            EOAdaptorChannel channel = null;
            int rows = 0;
            ec.lock();
            try {
                EODatabaseContext dbc = EOUtilities.databaseContextForModelNamed((EOEditingContext)ec, (String)modelName);
                dbc.lock();
                try {
                    channel = dbc.availableChannel().adaptorChannel();
                    wasOpen = channel.isOpen();
                    if (!wasOpen) {
                        channel.openChannel();
                    }
                    channel.adaptorContext().beginTransaction();
                    try {
                        rows = this.doPerform(channel);
                        channel.adaptorContext().commitTransaction();
                    }
                    catch (RuntimeException ex) {
                        channel.adaptorContext().rollbackTransaction();
                        throw ex;
                    }
                }
                finally {
                    if (!wasOpen) {
                        channel.closeChannel();
                    }
                    dbc.unlock();
                }
            }
            finally {
                ec.unlock();
            }
            return rows;
        }
    }
}

