/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSet;
import er.extensions.eof.ERXModelGroup;
import er.extensions.foundation.ERXArrayUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public abstract class ERXEntityOrder {
    private static Logger logger = Logger.getLogger(ERXEntityOrder.class);
    protected NSMutableDictionary groupedEntities = new NSMutableDictionary();
    protected NSArray allEntities = null;

    public ERXEntityOrder(EOModelGroup modelGroup) {
        this.createListOfEntities(modelGroup);
        this.generateOrdering();
    }

    public ERXEntityOrder() {
        this(EOModelGroup.defaultGroup());
    }

    public NSMutableDictionary groupedEntities() {
        return this.groupedEntities;
    }

    protected abstract NSDictionary dependenciesByEntity();

    protected void generateOrdering() {
        NSDictionary dependencies = this.dependenciesByEntity();
        NSMutableArray entities = this.allEntities().mutableClone();
        int groupNum = 1;
        while (entities.count() > 0) {
            NSMutableDictionary<String, Integer> groupDictionary = new NSMutableDictionary<String, Integer>();
            Integer group = new Integer(groupNum++);
            logger.trace((Object)("Building group " + group));
            int index = 0;
            while (index < entities.count()) {
                EOEntity entity = (EOEntity)entities.objectAtIndex(index);
                logger.trace((Object)("Processing entity " + entity.name()));
                if (this.hasDependenciesForEntity(dependencies, entity)) {
                    logger.trace((Object)("Adding entity " + entity.name() + " to group " + group));
                    groupDictionary.setObjectForKey(group, entity.name());
                    entities.removeObjectAtIndex(index);
                    continue;
                }
                ++index;
            }
            if (groupDictionary.count() == 0) {
                logger.error((Object)("Stopping, circular relationships found for " + entities.valueForKey("name")));
                NSSet<NSArray> remainingEntities = new NSSet<NSArray>((NSArray)entities.valueForKey("name"));
                for (int i = 0; i < entities.count(); ++i) {
                    EOEntity entity = (EOEntity)entities.objectAtIndex(i);
                    NSSet remainingDependencies = this.dependentEntities(dependencies, entity).setByIntersectingSet(remainingEntities);
                    logger.error((Object)(entity.name() + " has dependencies on " + remainingDependencies));
                }
                throw new RuntimeException("Circular relationships found for " + entities.valueForKey("name"));
            }
            this.groupedEntities().addEntriesFromDictionary(groupDictionary);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Entity groups in dependency order:");
            for (int i = 1; i < groupNum; ++i) {
                logger.trace((Object)("Group " + i + ": " + this.groupedEntities().allKeysForObject(new Integer(i))));
                logger.trace((Object)"");
            }
        }
    }

    protected boolean hasDependenciesForEntity(NSDictionary dependencies, EOEntity entity) {
        if (this.dependentEntities(dependencies, entity) == null) {
            return true;
        }
        for (String entityName : this.dependentEntities(dependencies, entity)) {
            if (this.groupedEntities().objectForKey(entityName) != null) continue;
            return false;
        }
        return true;
    }

    protected NSSet dependentEntities(NSDictionary dependencies, EOEntity entity) {
        return (NSSet)dependencies.objectForKey(this.dependencyKeyFor(entity));
    }

    protected String dependencyKeyFor(EOEntity entity) {
        return entity.name();
    }

    public void createListOfEntities(EOModelGroup modelGroup) {
        NSArray arrayOfArrayOfEntites = (NSArray)modelGroup.models().valueForKey("entities");
        NSArray entities = ERXArrayUtilities.flatten(arrayOfArrayOfEntites);
        NSMutableArray<int> filteredEntities = new NSMutableArray<int>(entities.count());
        Enumeration entityEnum = entities.objectEnumerator();
        while (entityEnum.hasMoreElements()) {
            EOEntity entity = (EOEntity)entityEnum.nextElement();
            if (ERXModelGroup.isPrototypeEntity(entity)) continue;
            filteredEntities.addObject((int)entity);
        }
        this.allEntities = filteredEntities.immutableClone();
    }

    public NSArray allEntities() {
        return this.allEntities;
    }

    public static class EntityInsertOrderComparator
    extends NSComparator {
        protected ERXEntityOrder eRXEntityOrder;

        public EntityInsertOrderComparator(ERXEntityOrder ordering) {
            this.eRXEntityOrder = ordering;
        }

        public int compare(Object object1, Object object2) throws NSComparator.ComparisonException {
            EOEntity entity1 = (EOEntity)object1;
            EOEntity entity2 = (EOEntity)object2;
            Number group1 = (Number)this.eRXEntityOrder.groupedEntities().objectForKey(entity1.name());
            Number group2 = (Number)this.eRXEntityOrder.groupedEntities().objectForKey(entity2.name());
            return NSComparator.DescendingNumberComparator.compare((Object)group1, (Object)group2);
        }
    }

    public static class EntityDeleteOrderComparator
    extends NSComparator {
        protected ERXEntityOrder eRXEntityOrder;

        public EntityDeleteOrderComparator(ERXEntityOrder ordering) {
            this.eRXEntityOrder = ordering;
        }

        public int compare(Object object1, Object object2) throws NSComparator.ComparisonException {
            EOEntity entity1 = (EOEntity)object1;
            EOEntity entity2 = (EOEntity)object2;
            Number group1 = (Number)this.eRXEntityOrder.groupedEntities().objectForKey(entity1.name());
            Number group2 = (Number)this.eRXEntityOrder.groupedEntities().objectForKey(entity2.name());
            return NSComparator.AscendingNumberComparator.compare((Object)group1, (Object)group2);
        }
    }
}

