/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXKey;
import er.extensions.eof.qualifiers.ERXInQualifier;
import er.extensions.eof.qualifiers.ERXRegExQualifier;
import er.extensions.eof.qualifiers.ERXToManyQualifier;
import er.extensions.qualifiers.ERXAndQualifier;
import er.extensions.qualifiers.ERXFalseQualifier;
import er.extensions.qualifiers.ERXKeyComparisonQualifier;
import er.extensions.qualifiers.ERXKeyValueQualifier;
import er.extensions.qualifiers.ERXNotQualifier;
import er.extensions.qualifiers.ERXOrQualifier;
import java.util.Enumeration;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXQ {
    public static final NSSelector EQ = EOQualifier.QualifierOperatorEqual;
    public static final NSSelector NE = EOQualifier.QualifierOperatorNotEqual;
    public static final NSSelector LT = EOQualifier.QualifierOperatorLessThan;
    public static final NSSelector GT = EOQualifier.QualifierOperatorGreaterThan;
    public static final NSSelector LTEQ = EOQualifier.QualifierOperatorLessThanOrEqualTo;
    public static final NSSelector GTEQ = EOQualifier.QualifierOperatorGreaterThanOrEqualTo;
    public static final NSSelector CONTAINS = EOQualifier.QualifierOperatorContains;
    public static final NSSelector LIKE = EOQualifier.QualifierOperatorLike;
    public static final NSSelector ILIKE = EOQualifier.QualifierOperatorCaseInsensitiveLike;

    public static <T> NSArray<T> filtered(NSArray<T> array, EOQualifier qualifier) {
        return EOQualifier.filteredArrayWithQualifier(array, (EOQualifier)qualifier);
    }

    public static void filter(NSMutableArray<?> array, EOQualifier qualifier) {
        EOQualifier.filterArrayWithQualifier(array, (EOQualifier)qualifier);
    }

    public static <T> T one(NSArray<T> array, EOQualifier qualifier) {
        Object object;
        if (array == null) {
            object = null;
        } else {
            NSArray<T> objects = ERXQ.filtered(array, qualifier);
            int count = objects.count();
            if (count == 0) {
                object = null;
            } else if (count == 1) {
                object = objects.lastObject();
            } else {
                throw new IllegalStateException("There was more than one object that matched the qualifier '" + qualifier + "'.");
            }
        }
        return object;
    }

    public static <T> T first(NSArray<T> array, EOQualifier qualifier) {
        NSArray<T> objects;
        int count;
        Object object = array == null ? null : ((count = (objects = ERXQ.filtered(array, qualifier)).count()) == 0 ? null : objects.objectAtIndex(0));
        return object;
    }

    public static <T> T requiredOne(NSArray<T> array, EOQualifier qualifier) {
        T object = ERXQ.one(array, qualifier);
        if (object == null) {
            throw new NoSuchElementException("There was no object that matched the qualifier '" + qualifier + "'.");
        }
        return object;
    }

    public static ERXOrQualifier or(EOQualifier ... qualifiersArray) {
        NSMutableArray<EOQualifier> qualifiers = new NSMutableArray<EOQualifier>();
        for (EOQualifier qualifier : qualifiersArray) {
            if (qualifier == null) continue;
            qualifiers.addObject(qualifier);
        }
        return new ERXOrQualifier(qualifiers);
    }

    public static ERXOrQualifier or(NSArray<? extends EOQualifier> qualifiers) {
        return new ERXOrQualifier(qualifiers);
    }

    public static ERXAndQualifier and(EOQualifier ... qualifiersArray) {
        NSMutableArray<EOQualifier> qualifiers = new NSMutableArray<EOQualifier>();
        for (EOQualifier qualifier : qualifiersArray) {
            if (qualifier == null) continue;
            qualifiers.addObject(qualifier);
        }
        return new ERXAndQualifier(qualifiers);
    }

    public static ERXAndQualifier and(NSArray<? extends EOQualifier> qualifiers) {
        return new ERXAndQualifier(qualifiers);
    }

    public static ERXKeyValueQualifier like(String key, Object value) {
        return new ERXKeyValueQualifier(key, LIKE, value);
    }

    public static ERXKeyValueQualifier likeInsensitive(String key, Object value) {
        return new ERXKeyValueQualifier(key, ILIKE, value);
    }

    public static ERXKeyValueQualifier matches(String key, String value) {
        return new ERXRegExQualifier(key, value);
    }

    public static ERXKeyValueQualifier hasValues(String key, NSArray values) {
        return new ERXInQualifier(key, values);
    }

    public static ERXKeyValueQualifier has(String key, NSArray values) {
        return ERXQ.hasAtLeast(key, values, 0);
    }

    public static ERXKeyValueQualifier hasAtLeast(String key, NSArray values, int min) {
        return new ERXToManyQualifier(key, values, min);
    }

    public static ERXKeyValueQualifier equals(String key, Object value) {
        return new ERXKeyValueQualifier(key, EQ, value);
    }

    public static <T> ERXKeyComparisonQualifier equals(ERXKey<T> key, ERXKey<T> value) {
        return new ERXKeyComparisonQualifier(key.key(), EQ, value.key());
    }

    public static ERXKeyValueQualifier is(String key, Object value) {
        return ERXQ.equals(key, value);
    }

    public static ERXKeyValueQualifier isNull(String key, boolean yesOrNo) {
        return yesOrNo ? ERXQ.isNull(key) : ERXQ.isNotNull(key);
    }

    public static ERXKeyValueQualifier isNull(String key) {
        return new ERXKeyValueQualifier(key, EQ, null);
    }

    public static ERXKeyValueQualifier isNotNull(String key) {
        return new ERXKeyValueQualifier(key, NE, null);
    }

    public static ERXKeyValueQualifier isTrue(String key) {
        return new ERXKeyValueQualifier(key, EQ, Boolean.TRUE);
    }

    public static ERXKeyValueQualifier isFalse(String key) {
        return new ERXKeyValueQualifier(key, EQ, Boolean.FALSE);
    }

    public static ERXKeyValueQualifier notEquals(String key, Object value) {
        return new ERXKeyValueQualifier(key, NE, value);
    }

    public static <T> ERXKeyComparisonQualifier notEquals(ERXKey<T> key, ERXKey<T> value) {
        return new ERXKeyComparisonQualifier(key.key(), NE, value.key());
    }

    public static ERXKeyValueQualifier lessThan(String key, Object value) {
        return new ERXKeyValueQualifier(key, LT, value);
    }

    public static <T> ERXKeyComparisonQualifier lessThan(ERXKey<T> key, ERXKey<T> value) {
        return new ERXKeyComparisonQualifier(key.key(), LT, value.key());
    }

    public static ERXKeyValueQualifier greaterThan(String key, Object value) {
        return new ERXKeyValueQualifier(key, GT, value);
    }

    public static <T> ERXKeyComparisonQualifier greaterThan(ERXKey<T> key, ERXKey<T> value) {
        return new ERXKeyComparisonQualifier(key.key(), GT, value.key());
    }

    public static ERXKeyValueQualifier lessThanOrEqualTo(String key, Object value) {
        return new ERXKeyValueQualifier(key, LTEQ, value);
    }

    public static <T> ERXKeyComparisonQualifier lessThanOrEqualTo(ERXKey<T> key, ERXKey<T> value) {
        return new ERXKeyComparisonQualifier(key.key(), LTEQ, value.key());
    }

    public static ERXKeyValueQualifier greaterThanOrEqualTo(String key, Object value) {
        return new ERXKeyValueQualifier(key, GTEQ, value);
    }

    public static <T> ERXKeyComparisonQualifier greaterThanOrEqualTo(ERXKey<T> key, ERXKey<T> value) {
        return new ERXKeyComparisonQualifier(key.key(), GTEQ, value.key());
    }

    public static ERXNotQualifier not(EOQualifier qualifier) {
        return new ERXNotQualifier(qualifier);
    }

    public static ERXKeyValueQualifier compare(String key, NSSelector operator, Object value) {
        return new ERXKeyValueQualifier(key, operator, value);
    }

    public static ERXOrQualifier inObjects(String key, Object ... values) {
        NSMutableArray<ERXKeyValueQualifier> qualifiers = new NSMutableArray<ERXKeyValueQualifier>();
        for (Object value : values) {
            qualifiers.addObject(ERXQ.equals(key, value));
        }
        return new ERXOrQualifier(qualifiers);
    }

    public static ERXOrQualifier in(String key, NSArray<?> values) {
        if (values.count() == 0) {
            return new ERXOrQualifier(new NSArray<ERXFalseQualifier>(new ERXFalseQualifier()));
        }
        NSMutableArray<ERXKeyValueQualifier> qualifiers = new NSMutableArray<ERXKeyValueQualifier>();
        Enumeration<?> valuesEnum = values.objectEnumerator();
        while (valuesEnum.hasMoreElements()) {
            Object value = valuesEnum.nextElement();
            qualifiers.addObject(ERXQ.equals(key, value));
        }
        return new ERXOrQualifier(qualifiers);
    }

    public static ERXAndQualifier notIn(String key, NSArray values) {
        NSMutableArray<ERXKeyValueQualifier> qualifiers = new NSMutableArray<ERXKeyValueQualifier>();
        Enumeration valuesEnum = values.objectEnumerator();
        while (valuesEnum.hasMoreElements()) {
            Object value = valuesEnum.nextElement();
            qualifiers.addObject(ERXQ.notEquals(key, value));
        }
        return new ERXAndQualifier(qualifiers);
    }

    public static EOQualifier between(String key, Object lowerBound, Object upperBound) {
        return ERXQ.between(key, lowerBound, upperBound, false);
    }

    public static EOQualifier between(String key, Object lowerBound, Object upperBound, boolean inclusive) {
        ERXKeyValueQualifier lowerQ = null;
        ERXKeyValueQualifier upperQ = null;
        if (inclusive) {
            if (lowerBound != null) {
                lowerQ = ERXQ.greaterThanOrEqualTo(key, lowerBound);
            }
            if (upperBound != null) {
                upperQ = ERXQ.lessThanOrEqualTo(key, upperBound);
            }
        } else {
            if (lowerBound != null) {
                lowerQ = ERXQ.greaterThan(key, lowerBound);
            }
            if (upperBound != null) {
                upperQ = ERXQ.lessThan(key, upperBound);
            }
        }
        if (lowerQ == null && upperQ == null) {
            return null;
        }
        if (lowerQ == null) {
            return upperQ;
        }
        if (upperQ == null) {
            return lowerQ;
        }
        return ERXQ.and(new EOQualifier[]{lowerQ, upperQ});
    }

    public static ERXKeyValueQualifier startsWith(String key, String value) {
        value = value + "*";
        return ERXQ.like(key, value);
    }

    public static ERXKeyValueQualifier startsWithInsensitive(String key, String value) {
        value = value + "*";
        return ERXQ.likeInsensitive(key, value);
    }

    public static ERXKeyValueQualifier endsWith(String key, String value) {
        value = "*" + value;
        return ERXQ.like(key, value);
    }

    public static ERXKeyValueQualifier endsWithInsensitive(String key, String value) {
        value = "*" + value;
        return ERXQ.likeInsensitive(key, value);
    }

    public static ERXKeyValueQualifier containsObject(String key, Object value) {
        return new ERXKeyValueQualifier(key, CONTAINS, value);
    }

    public static ERXKeyValueQualifier contains(String key, String value) {
        value = "*" + value + "*";
        return ERXQ.likeInsensitive(key, value);
    }

    public static ERXOrQualifier containsAny(NSArray<String> keys, String tokensWithWhitespace) {
        NSMutableArray<ERXOrQualifier> qualifiers = new NSMutableArray<ERXOrQualifier>();
        for (String key : keys) {
            qualifiers.addObject(ERXQ.containsAny(key, tokensWithWhitespace));
        }
        return new ERXOrQualifier(qualifiers);
    }

    public static ERXOrQualifier containsAny(String key, String tokensWithWhitespace) {
        String[] searchStrings = tokensWithWhitespace == null ? new String[]{} : tokensWithWhitespace.split("\\s+");
        return ERXQ.containsAny(key, searchStrings);
    }

    public static ERXOrQualifier containsAny(String key, String[] tokens) {
        ERXOrQualifier qualifier;
        if (tokens.length == 0) {
            qualifier = null;
        } else {
            NSMutableArray<ERXKeyValueQualifier> searchQualifiers = new NSMutableArray<ERXKeyValueQualifier>();
            for (String token : tokens) {
                searchQualifiers.addObject(ERXQ.contains(key, token));
            }
            qualifier = new ERXOrQualifier(searchQualifiers);
        }
        return qualifier;
    }

    public static ERXOrQualifier containsAll(NSArray<String> keys, String tokensWithWhitespace) {
        NSMutableArray<ERXAndQualifier> qualifiers = new NSMutableArray<ERXAndQualifier>();
        for (String key : keys) {
            qualifiers.addObject(ERXQ.containsAll(key, tokensWithWhitespace));
        }
        return new ERXOrQualifier(qualifiers);
    }

    public static ERXAndQualifier containsAll(String key, String tokensWithWhitespace) {
        String[] searchStrings = tokensWithWhitespace == null ? new String[]{} : tokensWithWhitespace.split("\\s+");
        return ERXQ.containsAll(key, searchStrings);
    }

    public static ERXAndQualifier containsAll(String key, String[] tokens) {
        ERXAndQualifier qualifier;
        if (tokens.length == 0) {
            qualifier = null;
        } else {
            NSMutableArray<ERXKeyValueQualifier> searchQualifiers = new NSMutableArray<ERXKeyValueQualifier>();
            for (String token : tokens) {
                searchQualifiers.addObject(ERXQ.contains(key, token));
            }
            qualifier = new ERXAndQualifier(searchQualifiers);
        }
        return qualifier;
    }

    public static ERXAndQualifier containsAllInAny(String[] keys, String tokensWithWhitespace) {
        String[] searchStrings = tokensWithWhitespace == null ? new String[]{} : tokensWithWhitespace.split("\\s+");
        return ERXQ.containsAllInAny(keys, searchStrings);
    }

    public static ERXAndQualifier containsAllInAny(String[] keys, String[] tokens) {
        ERXAndQualifier qualifier;
        if (tokens.length == 0) {
            qualifier = null;
        } else {
            NSMutableArray<ERXOrQualifier> searchQualifiers = new NSMutableArray<ERXOrQualifier>();
            for (String token : tokens) {
                NSMutableArray<ERXKeyValueQualifier> tokenQualifiers = new NSMutableArray<ERXKeyValueQualifier>();
                for (String key : keys) {
                    tokenQualifiers.addObject(ERXQ.contains(key, token));
                }
                searchQualifiers.addObject(new ERXOrQualifier(tokenQualifiers));
            }
            qualifier = new ERXAndQualifier(searchQualifiers);
        }
        return qualifier;
    }

    public static String keyPath(String ... elements) {
        return new NSArray<String>(elements).componentsJoinedByString(".");
    }
}

