/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof.qualifiers;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOQualifierSQLGeneration;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierEvaluation;
import com.webobjects.eocontrol.EOQualifierVariable;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSStringUtilities;
import er.extensions.qualifiers.ERXKeyValueQualifier;
import java.math.BigDecimal;

public class ERXBetweenQualifier
extends ERXKeyValueQualifier
implements EOQualifierEvaluation,
Cloneable {
    private static final String BetweenStatement = " BETWEEN ";
    private static final String Separator = " AND ";
    private String _key = null;
    private Object _minimumValue = null;
    private Object _maximumValue = null;

    public ERXBetweenQualifier(String aKey, Object aMinimumValue, Object aMaximumValue) {
        super(aKey, EOQualifier.QualifierOperatorEqual, aMinimumValue);
        this.setKey(aKey);
        this.setMinimumValue(aMinimumValue);
        this.setMaximumValue(aMaximumValue);
    }

    public String key() {
        return this._key;
    }

    public void setKey(String aValue) {
        this._key = aValue;
    }

    public Object minimumValue() {
        return this._minimumValue;
    }

    public void setMinimumValue(Object aValue) {
        this._minimumValue = aValue;
    }

    public Object maximumValue() {
        return this._maximumValue;
    }

    public void setMaximumValue(Object aValue) {
        this._maximumValue = aValue;
    }

    public void addQualifierKeysToSet(NSMutableSet aSet) {
        String aKey;
        if (aSet != null && (aKey = this.key()) != null) {
            aSet.addObject(aKey);
        }
    }

    public EOQualifier qualifierWithBindings(NSDictionary someBindings, boolean requiresAll) {
        return (EOQualifier)this.clone();
    }

    public void validateKeysWithRootClassDescription(EOClassDescription aClassDescription) {
    }

    protected NSComparator comparatorForObject(Object anObject) {
        if (anObject != null) {
            Class<?> anObjectClass = anObject.getClass();
            Class[] someClasses = new Class[]{String.class, Number.class, NSTimestamp.class};
            NSComparator[] someComparators = new NSComparator[]{NSComparator.AscendingStringComparator, NSComparator.AscendingNumberComparator, NSComparator.AscendingTimestampComparator};
            int count = someClasses.length;
            for (int index = 0; index < count; ++index) {
                Class aClass = someClasses[index];
                if (!aClass.isAssignableFrom(anObjectClass)) continue;
                return someComparators[index];
            }
        }
        return null;
    }

    public boolean evaluateWithObject(Object anObject) {
        if (anObject != null && anObject instanceof NSKeyValueCoding) {
            NSComparator aComparator;
            Object aValue;
            String aKey = this.key();
            Object aMinimumValue = this.minimumValue();
            Object aMaximumValue = this.maximumValue();
            if (aKey != null && aMinimumValue != null && aMaximumValue != null && (aValue = ((NSKeyValueCoding)anObject).valueForKey(aKey)) != null && (aComparator = this.comparatorForObject(aValue)) != null) {
                boolean containsObject = false;
                try {
                    int anOrder = aComparator.compare(aMinimumValue, aValue);
                    if (!(anOrder != 0 && anOrder != -1 || (anOrder = aComparator.compare(aMaximumValue, aValue)) != 0 && anOrder != 1)) {
                        containsObject = true;
                    }
                }
                catch (NSComparator.ComparisonException anException) {
                    // empty catch block
                }
                return containsObject;
            }
        }
        return false;
    }

    public Object clone() {
        return new ERXBetweenQualifier(this.key(), this.minimumValue(), this.maximumValue());
    }

    public String toString() {
        return "(" + this._key + " between " + this.valueStringForValue(this._minimumValue) + " and " + this.valueStringForValue(this._maximumValue) + ")";
    }

    private String valueStringForValue(Object aValue) {
        String valueString = aValue == NSKeyValueCoding.NullValue ? "null" : (aValue instanceof String ? "'" + (String)aValue + "'" : (aValue instanceof Number && !(aValue instanceof BigDecimal) ? aValue.toString() : (aValue instanceof EOQualifierVariable ? "$" + ((EOQualifierVariable)aValue).key() : "(" + (aValue == null ? "null" : aValue.getClass().getName()) + ")" + _NSStringUtilities.quotedStringWithQuote((String)(aValue == null ? "null" : aValue.toString()), (char)'\''))));
        return valueString;
    }

    static {
        EOQualifierSQLGeneration.Support.setSupportForClass((EOQualifierSQLGeneration.Support)new BetweenQualifierSQLGenerationSupport(), ERXBetweenQualifier.class);
    }

    public static class BetweenQualifierSQLGenerationSupport
    extends EOQualifierSQLGeneration.Support {
        public String sqlStringForSQLExpression(EOQualifier eoqualifier, EOSQLExpression aSQLExpression) {
            if (aSQLExpression != null && aSQLExpression.entity() != null) {
                ERXBetweenQualifier betweenQualifier = (ERXBetweenQualifier)eoqualifier;
                EOEntity anEntity = aSQLExpression.entity();
                String aKey = betweenQualifier.key();
                Object aMinimumValue = betweenQualifier.minimumValue();
                Object aMaximumValue = betweenQualifier.maximumValue();
                if (aKey != null && aMinimumValue != null && aMaximumValue != null) {
                    StringBuffer aBuffer = new StringBuffer();
                    EOKeyValueQualifier aMinimumQualifier = new EOKeyValueQualifier(aKey, EOQualifier.QualifierOperatorEqual, aMinimumValue);
                    EOKeyValueQualifier aMaximumQualifier = new EOKeyValueQualifier(aKey, EOQualifier.QualifierOperatorEqual, aMaximumValue);
                    aMinimumQualifier = (EOKeyValueQualifier)anEntity.schemaBasedQualifier((EOQualifier)aMinimumQualifier);
                    aMaximumQualifier = (EOKeyValueQualifier)anEntity.schemaBasedQualifier((EOQualifier)aMaximumQualifier);
                    aBuffer.append(aSQLExpression.sqlStringForAttributeNamed(aMinimumQualifier.key()));
                    aBuffer.append(ERXBetweenQualifier.BetweenStatement);
                    aBuffer.append(aSQLExpression.sqlStringForValue(aMinimumQualifier.value(), aMinimumQualifier.key()));
                    aBuffer.append(ERXBetweenQualifier.Separator);
                    aBuffer.append(aSQLExpression.sqlStringForValue(aMaximumQualifier.value(), aMaximumQualifier.key()));
                    return aBuffer.toString();
                }
            }
            return null;
        }

        public EOQualifier schemaBasedQualifierWithRootEntity(EOQualifier eoqualifier, EOEntity eoentity) {
            return (EOQualifier)eoqualifier.clone();
        }

        public EOQualifier qualifierMigratedFromEntityRelationshipPath(EOQualifier eoqualifier, EOEntity eoentity, String s) {
            ERXBetweenQualifier betweenQualifier = (ERXBetweenQualifier)eoqualifier;
            return new ERXBetweenQualifier(BetweenQualifierSQLGenerationSupport._translateKeyAcrossRelationshipPath((String)betweenQualifier.key(), (String)s, (EOEntity)eoentity), betweenQualifier.minimumValue(), betweenQualifier.maximumValue());
        }
    }
}

