/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof.qualifiers;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOQualifierSQLGeneration;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOKeyValueArchiver;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierVariable;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSet;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.jdbc.ERXSQLHelper;
import er.extensions.qualifiers.ERXKeyValueQualifier;
import java.util.Enumeration;

public class ERXInQualifier
extends ERXKeyValueQualifier
implements Cloneable {
    private static final int DefaultPadToSize = ERXProperties.intForKeyWithDefault("er.extensions.ERXInQualifier.DefaultPadToSize", 8);

    public ERXInQualifier(String key, NSArray values) {
        this(key, values, DefaultPadToSize);
    }

    public ERXInQualifier(String key, NSArray values, int padToSize) {
        super(key, EOQualifier.QualifierOperatorEqual, ERXInQualifier.paddedValues(values, padToSize));
    }

    private static NSArray paddedValues(NSArray values, int padToSize) {
        int count = ((NSArray)values).count();
        if (count > 1) {
            int paddedSize = ((count - 1) / padToSize + 1) * padToSize;
            NSMutableArray paddedValues = new NSMutableArray(values);
            Object padElement = values.lastObject();
            for (int padCount = paddedSize - count; padCount > 0; --padCount) {
                paddedValues.addObject(padElement);
            }
            values = paddedValues;
        }
        return values;
    }

    public String toString() {
        return " <" + this.getClass().getName() + " key: " + this.key() + " > IN '" + this.value() + "'";
    }

    public NSArray values() {
        return (NSArray)this.value();
    }

    public boolean evaluateWithObject(Object object) {
        Object value = null;
        String key = this.key();
        if (object instanceof EOEnterpriseObject) {
            EOEnterpriseObject eo = (EOEnterpriseObject)object;
            EOEditingContext ec = eo.editingContext();
            EOClassDescription cd = eo.classDescription();
            if (cd.attributeKeys().containsObject(key)) {
                value = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)eo, (String)key);
            } else if (cd.toOneRelationshipKeys().containsObject(key)) {
                value = eo.valueForKeyPath(key);
            } else if (EOUtilities.entityNamed((EOEditingContext)ec, (String)eo.entityName()).primaryKeyAttributeNames().containsObject(key)) {
                value = EOUtilities.primaryKeyForObject((EOEditingContext)ec, (EOEnterpriseObject)eo).objectForKey(key);
            } else {
                value = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)eo, (String)key);
                if (value instanceof NSArray) {
                    NSSet<NSArray> vs = new NSSet<NSArray>((NSArray)value);
                    NSSet<NSArray> vss = new NSSet<NSArray>(this.values());
                    return vs.intersectsSet(vss);
                }
            }
        } else {
            value = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)object, (String)key);
        }
        return value != null && this.values().containsObject(value);
    }

    public Object clone() {
        return new ERXInQualifier(this.key(), this.values());
    }

    public Class classForCoder() {
        return this.getClass();
    }

    public static Object decodeObject(NSCoder coder) {
        String key = (String)coder.decodeObject();
        NSArray values = (NSArray)coder.decodeObject();
        return new ERXInQualifier(key, values);
    }

    public void encodeWithCoder(NSCoder coder) {
        coder.encodeObject((Object)this.key());
        coder.encodeObject((Object)this.values());
    }

    public void encodeWithKeyValueArchiver(EOKeyValueArchiver archiver) {
        archiver.encodeObject((Object)this.key(), "key");
        archiver.encodeObject((Object)this.values(), "values");
    }

    public static Object decodeWithKeyValueUnarchiver(EOKeyValueUnarchiver unarchiver) {
        return new ERXInQualifier((String)unarchiver.decodeObjectForKey("key"), (NSArray)unarchiver.decodeObjectForKey("values"));
    }

    static {
        EOQualifierSQLGeneration.Support.setSupportForClass((EOQualifierSQLGeneration.Support)new InQualifierSQLGenerationSupport(), ERXInQualifier.class);
    }

    public static class InQualifierSQLGenerationSupport
    extends EOQualifierSQLGeneration._KeyValueQualifierSupport {
        public String sqlStringForSQLExpression(EOQualifier eoqualifier, EOSQLExpression e) {
            ERXInQualifier inqualifier = (ERXInQualifier)eoqualifier;
            if (!(inqualifier.value() instanceof NSArray)) {
                throw new RuntimeException("Unsupported value type: " + inqualifier.value().getClass().getName());
            }
            String key = inqualifier.key();
            String result = ERXSQLHelper.newSQLHelper(e).sqlWhereClauseStringForKey(e, key, (NSArray)inqualifier.value());
            return result;
        }

        public EOQualifier schemaBasedQualifierWithRootEntity(EOQualifier eoqualifier, EOEntity eoentity) {
            NSMutableDictionary obj;
            int j;
            NSMutableDictionary mapping;
            EOKeyValueQualifier eokeyvaluequalifier = (EOKeyValueQualifier)eoqualifier;
            String key = eokeyvaluequalifier.key();
            EORelationship eorelationship = eoentity._relationshipForPath(key);
            if (eorelationship == null) {
                if (!(eokeyvaluequalifier instanceof ERXInQualifier)) {
                    eokeyvaluequalifier = new ERXInQualifier(key, (NSArray)eokeyvaluequalifier.value());
                }
                return eokeyvaluequalifier;
            }
            if (eorelationship.isFlattened()) {
                eorelationship = ERXEOAccessUtilities.lastRelationship(eorelationship);
            }
            NSArray joins = eorelationship.joins();
            int l = joins.count();
            NSMutableArray<int> destinationAttibuteNames = new NSMutableArray<int>(l);
            for (int i = l - 1; i >= 0; --i) {
                destinationAttibuteNames.addObject((int)((EOJoin)joins.objectAtIndex(i)).destinationAttribute().name());
            }
            Object value = eokeyvaluequalifier.value();
            if (value == NSKeyValueCoding.NullValue || value instanceof EOQualifierVariable) {
                mapping = new NSMutableDictionary(l);
                for (j = 0; j < l; ++j) {
                    mapping.setObjectForKey(value, destinationAttibuteNames.objectAtIndex(j));
                }
                obj = mapping;
            } else {
                mapping = new NSMutableDictionary(l);
                for (j = 0; j < l; ++j) {
                    NSMutableArray realValues = new NSMutableArray();
                    Enumeration e = ((NSArray)value).objectEnumerator();
                    while (e.hasMoreElements()) {
                        Object v;
                        Object o = e.nextElement();
                        NSDictionary dict = null;
                        String currentKey = (String)destinationAttibuteNames.objectAtIndex(j);
                        if (o instanceof EOEnterpriseObject) {
                            EOEnterpriseObject eoenterpriseobject = (EOEnterpriseObject)o;
                            EOObjectStoreCoordinator osc = (EOObjectStoreCoordinator)eoenterpriseobject.editingContext().rootObjectStore();
                            dict = osc.valuesForKeys(new NSArray<String>(currentKey), eoenterpriseobject);
                            v = dict.objectForKey(currentKey);
                        } else {
                            v = o;
                        }
                        realValues.addObject(v);
                    }
                    mapping.setObjectForKey(realValues, destinationAttibuteNames.objectAtIndex(j));
                }
                obj = mapping;
            }
            NSMutableArray<ERXInQualifier> qualifiers = null;
            ERXInQualifier result = null;
            l = destinationAttibuteNames.count();
            for (int k = 0; k < l; ++k) {
                String s1 = (String)destinationAttibuteNames.objectAtIndex(k);
                String s2 = InQualifierSQLGenerationSupport._optimizeQualifierKeyPath((EOEntity)eoentity, (String)key, (String)s1);
                Object o = ((NSDictionary)obj).objectForKey(s1);
                result = new ERXInQualifier(s2, (NSArray)o);
                if (l <= 1 || qualifiers != null) continue;
                qualifiers = new NSMutableArray<ERXInQualifier>();
                qualifiers.addObject(result);
            }
            if (qualifiers == null) {
                return result;
            }
            return new EOAndQualifier(qualifiers);
        }

        public EOQualifier qualifierMigratedFromEntityRelationshipPath(EOQualifier eoqualifier, EOEntity eoentity, String s) {
            ERXInQualifier inQualifier = (ERXInQualifier)eoqualifier;
            String newPath = EOQualifierSQLGeneration.Support._translateKeyAcrossRelationshipPath((String)inQualifier.key(), (String)s, (EOEntity)eoentity);
            return new ERXInQualifier(newPath, inQualifier.values());
        }
    }
}

