/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.formatters;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.concurrent.TimeUnit;

public class ERXTimeDurationFormatter
extends NumberFormat {
    private final TimeUnit _timeUnit;
    private final boolean _showLargestUnitOnly;
    private final boolean _omitSecondsPart;

    public ERXTimeDurationFormatter() {
        this(TimeUnit.SECONDS, false, false);
    }

    public ERXTimeDurationFormatter(TimeUnit timeUnit) {
        this(timeUnit, false, false);
    }

    public ERXTimeDurationFormatter(TimeUnit timeUnit, boolean showLargestUnitOnly, boolean omitSecondsPart) {
        this._timeUnit = timeUnit;
        this._showLargestUnitOnly = showLargestUnitOnly;
        this._omitSecondsPart = omitSecondsPart;
    }

    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((long)number, toAppendTo, pos);
    }

    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        long seconds = TimeUnit.SECONDS.convert(number, this._timeUnit);
        return toAppendTo.append(this.timePeriodDescription(seconds, this._showLargestUnitOnly, this._omitSecondsPart));
    }

    private String timePeriodDescription(long value, boolean showLargestUnitOnly, boolean omitSecondsPart) {
        boolean isNegative;
        boolean shouldStopAddingComponents = false;
        if (value == 0L) {
            StringBuilder b = new StringBuilder();
            b.append("less than 1 ");
            if (omitSecondsPart) {
                b.append("minute");
            } else {
                b.append("second");
            }
            return b.toString();
        }
        boolean bl = isNegative = value < 0L;
        if (isNegative) {
            value = -value;
        }
        long secondsPart = value % 60L;
        value = (value - secondsPart) / 60L;
        long minutesPart = value % 60L;
        value = (value - minutesPart) / 60L;
        long hoursPart = value % 24L;
        value = (value - hoursPart) / 24L;
        StringBuilder b = new StringBuilder();
        if (value > 0L) {
            b.append(value);
            if (value > 1L) {
                b.append(" days");
            } else {
                b.append(" day");
            }
            if (showLargestUnitOnly) {
                shouldStopAddingComponents = true;
            }
        }
        if (hoursPart > 0L && !shouldStopAddingComponents) {
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(hoursPart);
            if (hoursPart > 1L) {
                b.append(" hours");
            } else {
                b.append(" hour");
            }
            if (showLargestUnitOnly) {
                shouldStopAddingComponents = true;
            }
        }
        if (minutesPart > 0L && !shouldStopAddingComponents) {
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(minutesPart);
            if (minutesPart > 1L) {
                b.append(" minutes");
            } else {
                b.append(" minute");
            }
            if (showLargestUnitOnly) {
                shouldStopAddingComponents = true;
            }
        }
        if (secondsPart > 0L && !shouldStopAddingComponents && !omitSecondsPart) {
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(secondsPart);
            if (secondsPart > 1L) {
                b.append(" seconds");
            } else {
                b.append(" second");
            }
            if (showLargestUnitOnly) {
                shouldStopAddingComponents = true;
            }
        }
        if (isNegative) {
            b.insert(0, "- ");
        }
        return b.toString();
    }

    public Number parse(String source, ParsePosition parsePosition) {
        throw new UnsupportedOperationException("This class does not support parsing.");
    }
}

