/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableDictionary;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXAssert {
    private static final NSMutableDictionary _instances = new NSMutableDictionary();
    private static final NSMutableDictionary _handlersForKey = new NSMutableDictionary();
    private static final Logger log = Logger.getLogger(ERXAssert.class);
    public static final ERXAssert DURING;
    public static final ERXAssert PRE;
    public static final ERXAssert POST;
    protected String _name;
    protected FailureHandler _failureHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ERXAssert getAssert(String name) {
        NSMutableDictionary nSMutableDictionary = _instances;
        synchronized (nSMutableDictionary) {
            ERXAssert value = (ERXAssert)_instances.objectForKey(name);
            if (value == null) {
                value = new ERXAssert(name);
                _instances.setObjectForKey(value, name);
            }
            ERXAssert.setLevel(value);
            return value;
        }
    }

    protected static String getLevel(ERXAssert value) {
        NSArray<String> arr = NSArray.componentsSeparatedByString(value.name(), ".");
        String prefix = "ERXAssert.instances";
        String level = System.getProperty(prefix);
        if (level == null) {
            level = "LOG";
        }
        Enumeration<String> e = arr.objectEnumerator();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            String possibleLevel = System.getProperty(prefix + "." + s);
            if (possibleLevel != null) {
                level = possibleLevel;
            }
            prefix = prefix + "." + s;
        }
        return level;
    }

    public static void setHandlerForLevel(FailureHandler object, String level) {
        _handlersForKey.setObjectForKey(object, level);
    }

    protected static void setLevel(ERXAssert value) {
        String level = ERXAssert.getLevel(value);
        FailureHandler handler = (FailureHandler)_handlersForKey.objectForKey(level);
        if (handler == null) {
            throw new IllegalStateException("Can't find handler for level \"" + level + "\" for assert: " + value.name());
        }
        value.setFailureHandler(handler);
    }

    public static ERXAssert getAssert(Class c) {
        return ERXAssert.getAssert(c.getName());
    }

    public static ERXAssert getAssert(String prefix, Class c) {
        return ERXAssert.getAssert(prefix + "." + c.getName());
    }

    private ERXAssert(String value) {
        this._name = value;
    }

    public void isTrue(boolean value) {
        if (!value) {
            this.fail("expected true");
        }
    }

    public void isTrue(String message, boolean value) {
        if (!value) {
            this.fail(message, "expected true");
        }
    }

    public void isFalse(boolean value) {
        if (value) {
            this.fail("expected false");
        }
    }

    public void isFalse(String message, boolean value) {
        if (value) {
            this.fail(message, "expected false");
        }
    }

    public void isNull(Object value) {
        if (value != null) {
            this.fail("expected null object, got " + value);
        }
    }

    public void isNull(String message, Object value) {
        if (value != null) {
            this.fail(message, "expected null, got " + value);
        }
    }

    public void notNull(Object value) {
        if (value == null) {
            this.fail("expected non-null object");
        }
    }

    public void notNull(String message, Object value) {
        if (value == null) {
            this.fail(message, "expected non-null object");
        }
    }

    public void isEmpty(String value) {
        if (value != null && !value.equals("")) {
            this.fail("expected empty String, got " + value);
        }
    }

    public void notEmpty(String value) {
        if (value == null) {
            this.fail("expected non-empty String, got null");
        } else if (value.equals("")) {
            this.fail("expected non-empty String, got empty string");
        }
    }

    public void isZero(int value) {
        if (value != 0) {
            this.fail("expected zero int, got " + value);
        }
    }

    public void isZero(long value) {
        if (value != 0L) {
            this.fail("expected zero long, got " + value);
        }
    }

    public void isZero(double value) {
        if (value != 0.0) {
            this.fail("expected zero double, got " + value);
        }
    }

    public void notZero(int value) {
        if (value == 0) {
            this.fail("expected non-zero int, got " + value);
        }
    }

    public void notZero(long value) {
        if (value == 0L) {
            this.fail("expected non-zero long, got " + value);
        }
    }

    public void notZero(double value) {
        if (value == 0.0) {
            this.fail("expected non-zero double, got " + value);
        }
    }

    public void isNegative(int value) {
        if (value >= 0) {
            this.fail("expected negative int, got " + value);
        }
    }

    public void isNegative(long value) {
        if (value >= 0L) {
            this.fail("expected negative long, got " + value);
        }
    }

    public void isNegative(double value) {
        if (value >= 0.0) {
            this.fail("expected negative double, got " + value);
        }
    }

    public void notNegative(int value) {
        if (value < 0) {
            this.fail("expected non-negative int, got " + value);
        }
    }

    public void notNegative(long value) {
        if (value < 0L) {
            this.fail("expected non-negative long, got " + value);
        }
    }

    public void notNegative(double value) {
        if (value < 0.0) {
            this.fail("expected non-negative double, got " + value);
        }
    }

    public void isPositive(int value) {
        if (value < 0) {
            this.fail("expected positive int, got " + value);
        }
    }

    public void isPositive(long value) {
        if (value < 0L) {
            this.fail("expected positive long, got " + value);
        }
    }

    public void isPositive(double value) {
        if (value < 0.0) {
            this.fail("expected positive double, got " + value);
        }
    }

    public void notPositive(int value) {
        if (value >= 0) {
            this.fail("expected non-positive int, got " + value);
        }
    }

    public void notPositive(long value) {
        if (value >= 0L) {
            this.fail("expected non-positive long, got " + value);
        }
    }

    public void notPositive(double value) {
        if (value >= 0.0) {
            this.fail("expected non-positive double, got " + value);
        }
    }

    public void isEqual(int value1, int value2) {
        if (value1 != value2) {
            this.fail("expected equal integers, got " + value1 + " & " + value2);
        }
    }

    public void isEqual(String message, int value1, int value2) {
        if (value1 != value2) {
            this.fail(message, "expected equal integers, got " + value1 + " & " + value2);
        }
    }

    public void isEqual(long value1, long value2) {
        if (value1 != value2) {
            this.fail("expected equal longs, got " + value1 + " & " + value2);
        }
    }

    public void isEqual(double value1, double value2) {
        if (value1 != value2) {
            this.fail("expected equal doubles, got " + value1 + " & " + value2);
        }
    }

    public void isEqual(Object value1, Object value2) {
        if (value1 != null && !value1.equals(value2) || value2 == null) {
            this.fail("expected equal objects, got " + value1 + " & " + value2);
        }
    }

    public void isEqual(String message, Object value1, Object value2) {
        if (value1 != null && !value1.equals(value2) || value2 == null) {
            this.fail(message, "expected equal objects, got " + value1 + " & " + value2);
        }
    }

    public void notEqual(int value1, int value2) {
        if (value1 == value2) {
            this.fail("expected unequal integers, got " + value1 + " & " + value2);
        }
    }

    public void notEqual(long value1, long value2) {
        if (value1 == value2) {
            this.fail("expected unequal longs, got " + value1 + " & " + value2);
        }
    }

    public void notEqual(double value1, double value2) {
        if (value1 == value2) {
            this.fail("expected unequal doubles, got " + value1 + " & " + value2);
        }
    }

    public void notEqual(Object value1, Object value2) {
        if (value1 != null && value1.equals(value2) || value2 == null) {
            this.fail("expected unequal objects, got " + value1 + " & " + value2);
        }
    }

    public void lessThan(int value1, int value2) {
        if (value1 >= value2) {
            this.fail("expected " + value1 + " to be less than " + value2);
        }
    }

    public void lessThan(long value1, long value2) {
        if (value1 >= value2) {
            this.fail("expected " + value1 + " to be less than " + value2);
        }
    }

    public void lessThan(double value1, double value2) {
        if (value1 >= value2) {
            this.fail("expected " + value1 + " to be less than " + value2);
        }
    }

    public void lessThanOrEqual(int value1, int value2) {
        if (value1 > value2) {
            this.fail("expected " + value1 + " to be less than or equal to " + value2);
        }
    }

    public void lessThanOrEqual(long value1, long value2) {
        if (value1 > value2) {
            this.fail("expected " + value1 + " to be less than or equal to " + value2);
        }
    }

    public void lessThanOrEqual(double value1, double value2) {
        if (value1 > value2) {
            this.fail("expected " + value1 + " to be less than or equal to " + value2);
        }
    }

    public void greaterThan(int value1, int value2) {
        if (value1 <= value2) {
            this.fail("expected " + value1 + " to be greater than " + value2);
        }
    }

    public void greaterThan(long value1, long value2) {
        if (value1 <= value2) {
            this.fail("expected " + value1 + " to be greater than " + value2);
        }
    }

    public void greaterThan(double value1, double value2) {
        if (value1 <= value2) {
            this.fail("expected " + value1 + " to be greater than " + value2);
        }
    }

    public void greaterThanOrEqual(int value1, int value2) {
        if (value1 < value2) {
            this.fail("expected " + value1 + " to be greater than or equal to " + value2);
        }
    }

    public void greaterThanOrEqual(long value1, long value2) {
        if (value1 < value2) {
            this.fail("expected " + value1 + " to be greater than or equal to " + value2);
        }
    }

    public void greaterThanOrEqual(double value1, double value2) {
        if (value1 < value2) {
            this.fail("expected " + value1 + " to be greater than or equal to " + value2);
        }
    }

    public void unknownSwitchCase(int value) {
        this.fail("unknown switch case: " + value);
    }

    public String name() {
        return this._name;
    }

    public FailureHandler failureHandler() {
        return this._failureHandler;
    }

    public void setFailureHandler(FailureHandler handler) {
        this._failureHandler = handler;
    }

    public void fail(String message) {
        this._failureHandler.handleFailure(this, message);
    }

    public void fail(String message, String supplement) {
        this._failureHandler.handleFailure(this, message + ": " + supplement);
    }

    static {
        _handlersForKey.setObjectForKey(new EmptyHandler(), "NONE");
        _handlersForKey.setObjectForKey(new LoggingHandler(), "LOG");
        _handlersForKey.setObjectForKey(new ThrowingHandler(), "RAISE");
        PRE = ERXAssert.getAssert("PRE");
        POST = ERXAssert.getAssert("POST");
        DURING = ERXAssert.getAssert("DURING");
        PRE.setFailureHandler(new IllegalArgumentHandler());
        POST.setFailureHandler(new IllegalStateHandler());
        DURING.setFailureHandler(new IllegalStateHandler());
    }

    protected static class IllegalStateHandler
    extends ThrowingHandler {
        protected IllegalStateHandler() {
        }

        protected void raise(String message) {
            throw new IllegalStateException(message);
        }
    }

    protected static class IllegalArgumentHandler
    extends ThrowingHandler {
        protected IllegalArgumentHandler() {
        }

        protected void raise(String message) {
            throw new IllegalArgumentException(message);
        }
    }

    protected static class ThrowingHandler
    implements FailureHandler {
        protected ThrowingHandler() {
        }

        protected void raise(String message) {
            throw new RuntimeException(message);
        }

        public void handleFailure(ERXAssert instance, String message) {
            String output = "Assertion failed (" + instance.name() + "): ";
            if (message != null) {
                output = output + message;
            }
            this.raise(output);
        }
    }

    protected static class LoggingHandler
    implements FailureHandler {
        protected LoggingHandler() {
        }

        public void handleFailure(ERXAssert instance, String message) {
            String output = "Assertion failed (" + instance.name() + "): ";
            if (message != null) {
                output = output + message;
            }
            log.error((Object)output, new Throwable());
        }
    }

    protected static class EmptyHandler
    implements FailureHandler {
        protected EmptyHandler() {
        }

        public void handleFailure(ERXAssert instance, String message) {
        }
    }

    public static interface FailureHandler {
        public void handleFailure(ERXAssert var1, String var2);
    }
}

