/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import er.extensions.foundation.ERXMappingObjectStream;
import er.extensions.foundation.ERXValueUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXMutableDictionary<K, V>
extends NSMutableDictionary<K, V> {
    public static final long serialVersionUID = 8091318522043166356L;

    public static NSData toBlob(NSDictionary<?, ?> d) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bout);
            oos.writeObject(d);
            oos.close();
            NSData sp = new NSData(bout.toByteArray());
            return sp;
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public static NSData toBlob(ERXMutableDictionary<?, ?> dict) {
        return ERXMutableDictionary.toBlob(dict);
    }

    public static NSDictionary fromBlob(NSData d) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(d.bytes());
            ERXMappingObjectStream ois = new ERXMappingObjectStream(bis);
            NSDictionary dd = (NSDictionary)ois.readObject();
            ois.close();
            return dd;
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public static NSDictionary fromPropertyList(String plist) {
        NSDictionary dict = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)plist);
        return new ERXMutableDictionary(dict);
    }

    public static String toPropertyList(NSDictionary<?, ?> dict) {
        String plist = NSPropertyListSerialization.stringFromPropertyList(dict);
        return plist;
    }

    public String toPropertyList() {
        String plist = NSPropertyListSerialization.stringFromPropertyList((Object)this);
        return plist;
    }

    public NSData toBlob() {
        return ERXMutableDictionary.toBlob(this);
    }

    public ERXMutableDictionary(NSDictionary<? extends K, ? extends V> d) {
        super(d);
    }

    public ERXMutableDictionary() {
    }

    @Override
    public Object clone() {
        return new ERXMutableDictionary<K, V>(this);
    }

    public String stringObjectForKey(K key) {
        Object o = this.objectForKey(key);
        return o == null ? null : o.toString();
    }

    public Boolean booleanObjectForKey(K key) {
        Object o = this.objectForKey(key);
        return o == null ? null : (ERXValueUtilities.booleanValue(o) ? Boolean.TRUE : Boolean.FALSE);
    }

    public static <T, U> NSMutableDictionary<T, U> synchronizedDictionary(NSMutableDictionary<? extends T, ? extends U> dict) {
        return new ThreadSafeDictionary<T, U>(dict);
    }

    public static <T, U> NSMutableDictionary<T, U> synchronizedDictionary() {
        return ERXMutableDictionary.synchronizedDictionary(new ERXMutableDictionary());
    }

    public static <T, U> NSDictionary<T, U> synchronizedDictionary(NSDictionary<? extends T, ? extends U> dict) {
        if (!(dict instanceof NSMutableDictionary)) {
            return dict;
        }
        return ERXMutableDictionary.synchronizedDictionary((NSMutableDictionary)dict);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadSafeDictionary<K, V>
    extends ERXMutableDictionary<K, V> {
        public ThreadSafeDictionary(NSMutableDictionary<? extends K, ? extends V> dictionary) {
            super(dictionary);
        }

        @Override
        public synchronized void addEntriesFromDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
            super.addEntriesFromDictionary(otherDictionary);
        }

        @Override
        public synchronized NSDictionary<K, V> immutableClone() {
            return super.immutableClone();
        }

        @Override
        public synchronized NSMutableDictionary<K, V> mutableClone() {
            return super.mutableClone();
        }

        @Override
        public synchronized void removeAllObjects() {
            super.removeAllObjects();
        }

        @Override
        public synchronized V removeObjectForKey(Object key) {
            return super.removeObjectForKey(key);
        }

        @Override
        public synchronized void removeObjectsForKeys(NSArray<?> keys) {
            super.removeObjectsForKeys(keys);
        }

        @Override
        public synchronized void setDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
            super.setDictionary(otherDictionary);
        }

        @Override
        public synchronized void setObjectForKey(V object, K key) {
            super.setObjectForKey(object, key);
        }

        @Override
        public synchronized void takeValueForKey(Object value, String key) {
            super.takeValueForKey(value, key);
        }

        @Override
        protected synchronized void _clearDeletionsAndCollisions() {
            super._clearDeletionsAndCollisions();
        }

        @Override
        protected synchronized void _ensureCapacity(int capacity) {
            super._ensureCapacity(capacity);
        }

        @Override
        protected synchronized void _initializeDictionary() {
            super._initializeDictionary();
        }

        @Override
        public synchronized int _shallowHashCode() {
            return super._shallowHashCode();
        }

        @Override
        public synchronized NSArray<K> allKeys() {
            return super.allKeys();
        }

        @Override
        public synchronized NSArray<K> allKeysForObject(Object object) {
            return super.allKeysForObject(object);
        }

        @Override
        public synchronized Class classForCoder() {
            return super.classForCoder();
        }

        @Override
        public synchronized int count() {
            return super.count();
        }

        @Override
        public synchronized void encodeWithCoder(NSCoder coder) {
            super.encodeWithCoder(coder);
        }

        @Override
        public synchronized boolean equals(Object object) {
            return super.equals(object);
        }

        @Override
        public synchronized int hashCode() {
            return super.hashCode();
        }

        @Override
        public synchronized HashMap<K, V> hashMap() {
            Object[] keys = this.keysNoCopy();
            int c = keys.length;
            HashMap<Object, V> map = new HashMap<Object, V>(c <= 0 ? 1 : c);
            for (int i = 0; i < c; ++i) {
                map.put(keys[i], this.objectForKey(keys[i]));
            }
            return map;
        }

        @Override
        public synchronized Hashtable<K, V> hashtable() {
            return super.hashtable();
        }

        @Override
        public synchronized boolean isEqualToDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
            return super.isEqualToDictionary(otherDictionary);
        }

        @Override
        public synchronized Enumeration<K> keyEnumerator() {
            return super.keyEnumerator();
        }

        @Override
        public synchronized Object[] keysNoCopy() {
            return super.keysNoCopy();
        }

        @Override
        public synchronized Enumeration<V> objectEnumerator() {
            return super.objectEnumerator();
        }

        @Override
        public synchronized V objectForKey(Object key) {
            return super.objectForKey(key);
        }

        @Override
        public synchronized NSArray<V> objectsForKeys(NSArray<? extends K> keys, V notFoundMarker) {
            return super.objectsForKeys(keys, notFoundMarker);
        }

        @Override
        public synchronized Object[] objectsNoCopy() {
            return super.objectsNoCopy();
        }

        @Override
        public synchronized void takeValueForKeyPath(Object value, String keyPath) {
            super.takeValueForKeyPath(value, keyPath);
        }

        @Override
        public synchronized String toString() {
            return super.toString();
        }

        @Override
        public synchronized Object valueForKey(String key) {
            return super.valueForKey(key);
        }

        @Override
        public synchronized Object valueForKeyPath(String keyPath) {
            return super.valueForKeyPath(keyPath);
        }
    }
}

