/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public abstract class ERXRemoteNotificationCenter
extends NSNotificationCenter {
    private static final Logger log = Logger.getLogger(ERXRemoteNotificationCenter.class);
    private static ERXRemoteNotificationCenter _sharedInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ERXRemoteNotificationCenter defaultCenter() {
        if (_sharedInstance != null) return _sharedInstance;
        Class<ERXRemoteNotificationCenter> clazz = ERXRemoteNotificationCenter.class;
        synchronized (ERXRemoteNotificationCenter.class) {
            if (_sharedInstance != null) return _sharedInstance;
            try {
                _sharedInstance = new SimpleCenter();
            }
            catch (IOException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            return _sharedInstance;
        }
    }

    public static void setDefaultCenter(ERXRemoteNotificationCenter center) {
        _sharedInstance = center;
    }

    public void postLocalNotification(NSNotification notification) {
        super.postNotification(notification);
    }

    protected abstract void postRemoteNotification(NSNotification var1);

    public void postNotification(NSNotification notification) {
        this.postRemoteNotification(notification);
    }

    private static class SimpleCenter
    extends ERXRemoteNotificationCenter {
        public static final int IDENTIFIER_LENGTH = 6;
        private static final int JOIN = 1;
        private static final int LEAVE = 2;
        private static final int POST = 3;
        private boolean _postLocal;
        private byte[] _identifier;
        private InetAddress _localBindAddress;
        private NetworkInterface _localNetworkInterface;
        private InetSocketAddress _multicastGroup;
        private int _multicastPort;
        private MulticastSocket _multicastSocket;
        private boolean _listening;
        private int _maxPacketSize;

        protected SimpleCenter() throws IOException {
            this.init();
        }

        protected void init() throws UnknownHostException, SocketException, IOException {
            String localBindAddressStr = ERXProperties.stringForKey("er.extensions.ERXRemoteNotificationsCenter.localBindAddress");
            this._localBindAddress = localBindAddressStr == null ? WOApplication.application().hostAddress() : InetAddress.getByName(localBindAddressStr);
            String multicastGroup = ERXProperties.stringForKeyWithDefault("er.extensions.ERXRemoteNotificationsCenter.group", "230.0.0.1");
            this._multicastPort = ERXProperties.intForKeyWithDefault("er.extensions.ERXRemoteNotificationsCenter.port", 9754);
            int maxPacketSize = ERXProperties.intForKeyWithDefault("er.extensions.ERXRemoteNotificationsCenter.maxPacketSize", 1024);
            this._maxPacketSize = 2 * maxPacketSize;
            String multicastIdentifierStr = ERXProperties.stringForKey("er.extensions.ERXRemoteNotificationsCenter.identifier");
            if (multicastIdentifierStr == null) {
                this._identifier = new byte[6];
                byte[] hostAddressBytes = this._localBindAddress.getAddress();
                System.arraycopy(hostAddressBytes, 0, this._identifier, 0, hostAddressBytes.length);
                short multicastInstance = WOApplication.application().port().shortValue();
                this._identifier[4] = (byte)(multicastInstance & 0xFF);
                this._identifier[5] = (byte)(multicastInstance >>> 8 & 0xFF);
            } else {
                this._identifier = ERXStringUtilities.hexStringToByteArray(multicastIdentifierStr);
            }
            this._localNetworkInterface = NetworkInterface.getByInetAddress(this._localBindAddress);
            this._multicastGroup = new InetSocketAddress(InetAddress.getByName(multicastGroup), this._multicastPort);
            this._multicastSocket = new MulticastSocket(null);
            this._multicastSocket.setInterface(this._localBindAddress);
            this._multicastSocket.setTimeToLive(4);
            this._multicastSocket.setReuseAddress(true);
            this._multicastSocket.bind(new InetSocketAddress(this._multicastPort));
            this.join();
        }

        public void join() throws IOException {
            if (log.isInfoEnabled()) {
                log.info((Object)("Multicast instance " + ERXStringUtilities.byteArrayToHexString(this._identifier) + " joining."));
            }
            this._multicastSocket.joinGroup(this._multicastGroup, this._localNetworkInterface);
            MulticastByteArrayOutputStream baos = new MulticastByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.write(this._identifier);
            dos.writeByte(1);
            dos.flush();
            this._multicastSocket.send(baos.createDatagramPacket());
            this.listen();
        }

        public void leave() throws IOException {
            if (log.isInfoEnabled()) {
                log.info((Object)("Multicast instance " + ERXStringUtilities.byteArrayToHexString(this._identifier) + " leaving."));
            }
            MulticastByteArrayOutputStream baos = new MulticastByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.write(this._identifier);
            dos.writeByte(2);
            dos.flush();
            this._multicastSocket.send(baos.createDatagramPacket());
            this._multicastSocket.leaveGroup(this._multicastGroup, this._localNetworkInterface);
            this._listening = false;
        }

        protected void postRemoteNotification(NSNotification notification) {
            try {
                MulticastByteArrayOutputStream baos = new MulticastByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.write(this._identifier);
                dos.writeByte(3);
                this.writeNotification(notification, dos);
                this._multicastSocket.send(baos.createDatagramPacket());
                if (log.isDebugEnabled()) {
                    log.info((Object)("Multicast instance " + ERXStringUtilities.byteArrayToHexString(this._identifier) + ": Writing " + notification));
                }
                dos.close();
                if (this._postLocal) {
                    this.postLocalNotification(notification);
                }
            }
            catch (Exception e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }

        public void listen() throws IOException {
            Thread listenThread = new Thread(new Runnable(){

                public void run() {
                    SimpleCenter.this._listening = true;
                    byte[] buffer = new byte[SimpleCenter.this._maxPacketSize];
                    while (SimpleCenter.this._listening) {
                        DatagramPacket receivePacket = new DatagramPacket(buffer, 0, buffer.length);
                        try {
                            SimpleCenter.this._multicastSocket.receive(receivePacket);
                            this.handlePacket(receivePacket);
                        }
                        catch (Throwable t) {
                            log.error((Object)"Failed to read multicast notification.", t);
                        }
                    }
                }

                private void handlePacket(DatagramPacket receivePacket) throws IOException {
                    ByteArrayInputStream bais = new ByteArrayInputStream(receivePacket.getData(), 0, receivePacket.getLength());
                    DataInputStream dis = new DataInputStream(bais);
                    byte[] identifier = new byte[6];
                    dis.readFully(identifier);
                    String remote = ERXStringUtilities.byteArrayToHexString(identifier);
                    byte code = dis.readByte();
                    if (code == 1) {
                        if (log.isDebugEnabled()) {
                            log.info((Object)("Received JOIN from " + remote));
                        }
                    } else if (code == 2) {
                        if (log.isDebugEnabled()) {
                            log.info((Object)("Received LEAVE from " + remote));
                        }
                    } else if (code == 3) {
                        String self = ERXStringUtilities.byteArrayToHexString(SimpleCenter.this._identifier);
                        if (log.isDebugEnabled()) {
                            log.info((Object)("Received POST from " + remote));
                        }
                        if (log.isDebugEnabled()) {
                            log.info((Object)("Received POST from " + ERXStringUtilities.byteArrayToHexString(identifier)));
                        }
                        if (!self.equals(remote)) {
                            NSNotification notification = SimpleCenter.this.readNotification(dis);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Received notification: " + notification));
                            } else if (log.isInfoEnabled()) {
                                log.info((Object)("Received " + notification.name() + " notification from " + remote));
                            }
                            SimpleCenter.this.postLocalNotification(notification);
                        }
                    }
                }
            });
            listenThread.start();
        }

        private NSNotification readNotification(DataInputStream dis) throws IOException {
            short nameLen = dis.readShort();
            byte[] nameBytes = new byte[nameLen];
            dis.readFully(nameBytes);
            short objectLen = dis.readShort();
            byte[] objectBytes = new byte[objectLen];
            dis.readFully(objectBytes);
            int userInfoLen = dis.readShort();
            NSMutableDictionary<String, String> userInfo = new NSMutableDictionary<String, String>();
            for (int i = 0; i < userInfoLen; ++i) {
                short keyLen = dis.readShort();
                byte[] keyBytes = new byte[keyLen];
                dis.readFully(keyBytes);
                short valueLen = dis.readShort();
                byte[] valueBytes = new byte[valueLen];
                dis.readFully(valueBytes);
                userInfo.setObjectForKey(new String(valueBytes), new String(keyBytes));
            }
            NSNotification notification = new NSNotification(new String(nameBytes), null, userInfo);
            return notification;
        }

        private void writeNotification(NSNotification notification, DataOutputStream dos) throws IOException {
            byte[] name = notification.name().getBytes();
            dos.writeShort(name.length);
            dos.write(name);
            byte[] object = new byte[]{};
            dos.writeShort(object.length);
            dos.write(object);
            NSDictionary userInfo = notification.userInfo();
            if (userInfo == null) {
                userInfo = NSDictionary.EmptyDictionary;
            }
            dos.writeShort(userInfo.count());
            for (Object key : userInfo.allKeys()) {
                byte[] keyBytes = key.toString().getBytes();
                byte[] valueBytes = userInfo.objectForKey(key).toString().getBytes();
                dos.writeShort(keyBytes.length);
                dos.write(keyBytes);
                dos.writeShort(valueBytes.length);
                dos.write(valueBytes);
            }
            dos.flush();
            if (dos.size() > this._maxPacketSize) {
                throw new IllegalArgumentException("More than " + this._maxPacketSize + " bytes");
            }
        }

        protected class MulticastByteArrayOutputStream
        extends ByteArrayOutputStream {
            protected MulticastByteArrayOutputStream() {
            }

            public byte[] buffer() {
                return this.buf;
            }

            public DatagramPacket createDatagramPacket() throws SocketException {
                return new DatagramPacket(this.buf, 0, this.count, SimpleCenter.this._multicastGroup);
            }
        }
    }
}

