/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ERXSignalHandler
implements SignalHandler {
    static ERXSignalHandler _handler;
    private NSMutableDictionary<String, NSMutableArray<SignalHandler>> signals = new NSMutableDictionary();

    public static synchronized void register(String signalName, SignalHandler handler) {
        NSMutableArray<SignalHandler> listeners;
        signalName = ERXSignalHandler.normalize(signalName);
        if (_handler == null) {
            _handler = new ERXSignalHandler();
        }
        if ((listeners = (NSMutableArray<SignalHandler>)ERXSignalHandler._handler.signals.objectForKey(signalName)) == null) {
            listeners = new NSMutableArray<SignalHandler>();
            Signal signal = new Signal(signalName);
            Signal.handle(signal, _handler);
            ERXSignalHandler._handler.signals.setObjectForKey(listeners, signalName);
        }
        listeners.addObject(handler);
    }

    public static synchronized void unregister(String signalName, SignalHandler handler) {
        NSMutableArray listeners = (NSMutableArray)ERXSignalHandler._handler.signals.objectForKey(signalName = ERXSignalHandler.normalize(signalName));
        if (listeners == null) {
            listeners = new NSMutableArray();
        }
        listeners.removeObject(handler);
    }

    public void handle(Signal signal) {
        NSMutableArray listeners = (NSMutableArray)this.signals.objectForKey(ERXSignalHandler.normalize(signal.getName()));
        if (listeners != null) {
            for (SignalHandler handler : listeners) {
                handler.handle(signal);
            }
        }
    }

    private static String normalize(String signalName) {
        return signalName.toUpperCase();
    }
}

